/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.nio.FloatBuffer;
import javax.sound.sampled.SourceDataLine;
import xtrememp.player.dsp.DssContext;
import xtrememp.visualization.Visualization;
import xtrememp.visualization.spectrum.Band;
import xtrememp.visualization.spectrum.BandDistribution;
import xtrememp.visualization.spectrum.BandGain;
import xtrememp.visualization.spectrum.FFT;
import xtrememp.visualization.spectrum.FlatBandGain;
import xtrememp.visualization.spectrum.FrequencyBandGain;
import xtrememp.visualization.spectrum.LinearBandDistribution;
import xtrememp.visualization.spectrum.LogBandDistribution;

public final class Spectrogram
extends Visualization {
    public static final String NAME = "Spectrogram";
    public static final BandDistribution BAND_DISTRIBUTION_LINEAR = new LinearBandDistribution();
    public static final BandDistribution BAND_DISTRIBUTION_LOG = new LogBandDistribution(4, 20.0);
    public static final BandGain BAND_GAIN_FLAT = new FlatBandGain(4.0f);
    public static final BandGain BAND_GAIN_FREQUENCY = new FrequencyBandGain(4.0f);
    public static final BandDistribution DEFAULT_SPECTROGRAM_BAND_DISTRIBUTION = BAND_DISTRIBUTION_LINEAR;
    public static final BandGain DEFAULT_SPECTROGRAM_BAND_GAIN = BAND_GAIN_FREQUENCY;
    public static final float DEFAULT_SPECTRUM_ANALYSER_GAIN = 5.0f;
    private BandDistribution bandDistribution = DEFAULT_SPECTROGRAM_BAND_DISTRIBUTION;
    private BandGain bandGain = DEFAULT_SPECTROGRAM_BAND_GAIN;
    private Band[] bdTable;
    private float[] bgTable;
    private int bands;
    private int fftSampleSize;
    private float fftSampleRate;
    private FFT fft;
    private float gain = 5.0f;
    private float bandWidth;
    private float[] brgb = new float[3];
    private float[] frgb = new float[3];

    public Spectrogram() {
        this.setBandCount(1024);
    }

    public synchronized void setBandCount(int count) {
        this.bands = count;
        this.computeBandTables();
    }

    private void computeBandTables() {
        if (this.bands > 0 && this.fftSampleSize > 0 & this.fft != null) {
            this.bdTable = this.bandDistribution.create(this.bands, this.fft, this.fftSampleRate);
            this.bands = this.bdTable.length;
            this.bgTable = this.bandGain.create(this.fft, this.fftSampleRate);
        }
    }

    @Override
    public void init(int sampleSize, SourceDataLine sourceDataLine) {
        this.fftSampleSize = sampleSize;
        this.fftSampleRate = sourceDataLine.getFormat().getFrameRate();
        this.fft = new FFT(this.fftSampleSize);
        this.computeBandTables();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        super.setBackgroundColor(backgroundColor);
        this.freeImage();
    }

    @Override
    public void setForegroundColor(Color foregroundColor) {
        super.setForegroundColor(foregroundColor);
        this.freeImage();
    }

    @Override
    public synchronized void render(DssContext dssContext, Graphics2D g2d, int width, int height) {
        FloatBuffer[] channelsBuffer = dssContext.getDataNormalized();
        float[] _fft = this.fft.calculate(this.channelsMerge(channelsBuffer));
        this.bandWidth = (float)height / (float)this.bands;
        float y = height;
        int width2 = width - 1;
        int li = 0;
        for (int bd = 0; bd < this.bands; ++bd) {
            int i = this.bdTable[bd].distribution;
            float m = 0.0f;
            int mi = 0;
            for (int b = li; b < i; ++b) {
                float lf = _fft[b];
                if (!(lf > m)) continue;
                m = lf;
                mi = b;
            }
            li = i;
            float fs = m * this.bgTable[mi] * this.gain;
            if (fs > 1.0f) {
                fs = 1.0f;
            }
            float _fs = 1.0f - fs;
            this.backgroundColor.getColorComponents(this.brgb);
            this.foregroundColor.getColorComponents(this.frgb);
            Color color = new Color(this.frgb[0] * fs + this.brgb[0] * _fs, this.frgb[1] * fs + this.brgb[1] * _fs, this.frgb[2] * fs + this.brgb[2] * _fs);
            g2d.setColor(color);
            g2d.drawLine(width2, Math.round(y), width2, Math.round(y - this.bandWidth));
            y -= this.bandWidth;
        }
        g2d.drawImage((Image)this.buffImage, -1, 0, null);
    }
}

