/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.SkinChangeListener;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.Settings;
import xtrememp.XtremeMP;
import xtrememp.player.dsp.DigitalSignalProcessor;
import xtrememp.player.dsp.DssContext;
import xtrememp.visualization.Spectrogram;
import xtrememp.visualization.SpectrumBars;
import xtrememp.visualization.Visualization;
import xtrememp.visualization.VisualizationChangeListener;
import xtrememp.visualization.VisualizationEvent;
import xtrememp.visualization.VolumeMeter;
import xtrememp.visualization.Waveform;

public class VisualizationPanel
extends JPanel
implements DigitalSignalProcessor,
Runnable,
SkinChangeListener {
    private static Logger logger = LoggerFactory.getLogger(VisualizationPanel.class);
    protected final GraphicsConfiguration gc;
    protected final List<VisualizationChangeListener> listeners;
    private Visualization currentVis;
    private TreeSet<Visualization> visSet;
    private Frame fullscreenWindow;
    private GraphicsDevice device;
    private DisplayMode displayMode;
    private BufferStrategy bufferStrategy;
    private int numBuffers = 2;
    private volatile boolean isFullScreen = false;

    public VisualizationPanel() {
        this.setOpaque(false);
        this.setBorder((Border)new SubstanceBorder());
        this.gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.listeners = new ArrayList<VisualizationChangeListener>();
        this.initVisualizations();
        this.initFullScreenWindow();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VisualizationPanel.this.setFullScreen(true);
                }
            }
        });
        this.skinChanged();
        SubstanceLookAndFeel.registerSkinChangeListener((SkinChangeListener)this);
    }

    private void initVisualizations() {
        this.visSet = new TreeSet();
        this.visSet.add(new Spectrogram());
        this.visSet.add(new SpectrumBars());
        this.visSet.add(new VolumeMeter());
        this.visSet.add(new Waveform());
        String visDisplayName = Settings.getVisualization();
        for (Visualization vis : this.visSet) {
            if (!vis.getDisplayName().equals(visDisplayName)) continue;
            this.showVisualization(vis, false);
            break;
        }
    }

    private void initFullScreenWindow() {
        this.fullscreenWindow = new Frame();
        this.fullscreenWindow.setUndecorated(true);
        this.fullscreenWindow.setIgnoreRepaint(true);
        this.fullscreenWindow.setResizable(false);
        this.fullscreenWindow.setBackground(Color.black);
        this.fullscreenWindow.setAlwaysOnTop(true);
        this.fullscreenWindow.setFocusable(true);
        this.fullscreenWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        VisualizationPanel.this.setFullScreen(false);
                        break;
                    }
                    case 37: {
                        VisualizationPanel.this.prevVisualization();
                        break;
                    }
                    case 39: {
                        VisualizationPanel.this.nextVisualization();
                        break;
                    }
                }
            }
        });
        this.fullscreenWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VisualizationPanel.this.setFullScreen(false);
                }
            }
        });
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = env.getDefaultScreenDevice();
        this.displayMode = this.device.getDisplayMode();
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public void setFullScreen(boolean flag) {
        XtremeMP.getInstance().getMainFrame().setVisible(!flag);
        if (flag && this.device.isFullScreenSupported()) {
            this.device.setFullScreenWindow(this.fullscreenWindow);
            this.validate();
            this.fullscreenWindow.createBufferStrategy(this.numBuffers);
            if (this.device.isDisplayChangeSupported()) {
                this.device.setDisplayMode(this.displayMode);
                this.setSize(new Dimension(this.displayMode.getWidth(), this.displayMode.getHeight()));
            }
            this.isFullScreen = true;
        } else {
            this.isFullScreen = false;
            this.device.setFullScreenWindow(null);
            this.fullscreenWindow.dispose();
        }
    }

    public Set<Visualization> getVisualizationSet() {
        return this.visSet;
    }

    public void showVisualization(Visualization newVis, boolean fireEvent) {
        if (newVis == null) {
            throw new IllegalArgumentException("Visualization is null.");
        }
        this.currentVis = newVis;
        this.repaint();
        Settings.setVisualization(this.currentVis.getDisplayName());
        if (fireEvent) {
            this.fireVisualizationChangedEvent();
        }
    }

    public Visualization prevVisualization() {
        Visualization prevVis = this.visSet.lower(this.currentVis);
        if (prevVis == null && !this.visSet.isEmpty()) {
            prevVis = this.visSet.last();
        }
        this.showVisualization(prevVis, true);
        return prevVis;
    }

    public Visualization nextVisualization() {
        Visualization nextVis = this.visSet.higher(this.currentVis);
        if (nextVis == null && !this.visSet.isEmpty()) {
            nextVis = this.visSet.first();
        }
        this.showVisualization(nextVis, true);
        return nextVis;
    }

    public void addVisualizationChangeListener(VisualizationChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
        logger.info("Visualization change listener added");
    }

    public void removeVisualizationChangedListener(VisualizationChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
        logger.info("Visualization change listener removed");
    }

    private void fireVisualizationChangedEvent() {
        VisualizationEvent event = new VisualizationEvent(this, this.currentVis);
        for (VisualizationChangeListener listener : this.listeners) {
            listener.visualizationChanged(event);
        }
        logger.info("Visualization changed: {}", (Object)this.currentVis);
    }

    @Override
    public void init(int sampleSize, SourceDataLine sourceDataLine) {
        for (Visualization vis : this.visSet) {
            vis.init(sampleSize, sourceDataLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DssContext dssContext) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.currentVis.checkBuffImage(this.gc, width, height);
        this.currentVis.render(dssContext, this.currentVis.getBuffGraphics(), width, height);
        if (this.isFullScreen) {
            this.bufferStrategy = this.fullscreenWindow.getBufferStrategy();
            Graphics2D g2d = null;
            try {
                g2d = (Graphics2D)this.bufferStrategy.getDrawGraphics();
                for (int i = 0; i < this.numBuffers; ++i) {
                    if (!this.bufferStrategy.contentsLost() && this.currentVis != null) {
                        g2d.drawImage((Image)this.currentVis.getBuffImage(), 0, 0, this);
                    }
                    this.bufferStrategy.show();
                }
            }
            finally {
                if (g2d != null) {
                    g2d.dispose();
                }
            }
        } else {
            EventQueue.invokeLater(this);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.currentVis.checkBuffImage(this.gc, width, height);
        g.drawImage(this.currentVis.getBuffImage(), 0, 0, this);
    }

    @Override
    public void run() {
        this.repaint();
    }

    public final void skinChanged() {
        SubstanceColorScheme colorScheme = SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)this, ComponentState.ENABLED);
        for (Visualization v : this.visSet) {
            v.setBackgroundColor(colorScheme.getBackgroundFillColor());
            v.setForegroundColor(colorScheme.getForegroundColor());
            this.repaint();
        }
    }
}

