/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization.spectrum;

import java.util.ArrayList;
import xtrememp.visualization.spectrum.Band;
import xtrememp.visualization.spectrum.BandDistribution;
import xtrememp.visualization.spectrum.FFT;

public class LogBandDistribution
implements BandDistribution {
    private double lso;
    private int sso;

    public LogBandDistribution(int subSonicOffset, double logScaleOffset) {
        this.sso = subSonicOffset;
        this.lso = logScaleOffset;
    }

    @Override
    public Band[] create(int bandCount, FFT fft, float sampleRate) {
        int hss = fft.getOutputSampleSize() - this.sso;
        double o = Math.log(this.lso);
        double r = (double)(bandCount - 1) / (Math.log((double)hss + this.lso) - o);
        float[] fqt = fft.calculateFrequencyTable(sampleRate);
        float lfq = fqt[this.sso];
        int lcb = 1;
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(new Band(this.sso, 0.0f, lfq));
        for (int b = 0; b < hss; ++b) {
            double cb = (Math.log((double)b + this.lso) - o) * r + 1.0;
            if (Math.round(cb) == (long)lcb) continue;
            bands.add(new Band(b + this.sso, lfq, fqt[b + this.sso]));
            lfq = fqt[b + this.sso];
            lcb = (int)Math.round(cb);
        }
        if (bands.size() < bandCount) {
            bands.add(new Band(hss - 1 + this.sso, lfq, fqt[hss - 1 + this.sso]));
        }
        return bands.toArray(new Band[bands.size()]);
    }
}

