/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.PCMProcessor;
import org.kc7bfi.jflac.PropertiesContainer;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.util.ByteData;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class Flac2PcmAudioInputStream
extends TAsynchronousFilteredAudioInputStream
implements PropertiesContainer,
PCMProcessor {
    private InputStream in;
    private FLACDecoder decoder;
    private ByteData pcmData;
    private StreamInfo streamInfo;
    private Metadata[] metaData;

    public Flac2PcmAudioInputStream(InputStream in, AudioFormat format) {
        super(format, -1L);
        this.in = in;
    }

    protected void initDecoder() throws IOException {
        this.decoder = new FLACDecoder(this.in);
        this.decoder.addPCMProcessor(this);
        this.metaData = this.decoder.readMetadata();
    }

    public void processStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    public void processPCM(ByteData pcm) {
        this.getCircularBuffer().write(pcm.getData(), 0, pcm.getLen());
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public Metadata[] getMetaData() {
        return this.metaData;
    }

    public long skip(long bytes) throws IOException {
        if (this.decoder == null) {
            this.initDecoder();
        }
        if (!this.decoder.isEOF()) {
            long bytesRead = 0L;
            bytes -= this.decoder.getTotalBytesRead();
            while (bytesRead < bytes) {
                Frame frame = this.decoder.readNextFrame();
                if (frame == null) continue;
                bytesRead = this.decoder.getTotalBytesRead();
            }
            return bytesRead;
        }
        this.getCircularBuffer().close();
        return -1L;
    }

    public void execute() {
        try {
            if (this.decoder == null) {
                this.initDecoder();
            }
            if (this.decoder.isEOF()) {
                this.getCircularBuffer().close();
                return;
            }
            Frame frame = this.decoder.readNextFrame();
            if (frame != null) {
                this.pcmData = this.decoder.decodeFrame(frame, this.pcmData);
                this.processPCM(this.pcmData);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

