/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.tools.ByteArrayReader;
import davaguine.jmac.tools.ByteArrayWriter;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEDescriptor {
    public String cID;
    public int nVersion;
    public long nDescriptorBytes;
    public long nHeaderBytes;
    public long nSeekTableBytes;
    public long nHeaderDataBytes;
    public long nAPEFrameDataBytes;
    public long nAPEFrameDataBytesHigh;
    public long nTerminatingDataBytes;
    public byte[] cFileMD5 = new byte[16];
    public static final int APE_DESCRIPTOR_BYTES = 52;

    public static APEDescriptor read(File file) throws IOException {
        try {
            APEDescriptor header = new APEDescriptor();
            ByteArrayReader reader = new ByteArrayReader(file, 36);
            header.cID = reader.readString(4, "US-ASCII");
            header.nVersion = reader.readUnsignedShort();
            reader.skipBytes(2L);
            header.nDescriptorBytes = reader.readUnsignedInt();
            header.nHeaderBytes = reader.readUnsignedInt();
            header.nSeekTableBytes = reader.readUnsignedInt();
            header.nHeaderDataBytes = reader.readUnsignedInt();
            header.nAPEFrameDataBytes = reader.readUnsignedInt();
            header.nAPEFrameDataBytesHigh = reader.readUnsignedInt();
            header.nTerminatingDataBytes = reader.readUnsignedInt();
            file.readFully(header.cFileMD5);
            return header;
        }
        catch (EOFException e) {
            throw new JMACException("Unsupported Format");
        }
    }

    public void write(ByteArrayWriter writer) {
        writer.writeString(this.cID, 4, "US-ASCII");
        writer.writeUnsignedShort(this.nVersion);
        writer.writeUnsignedShort(0);
        writer.writeUnsignedInt(this.nDescriptorBytes);
        writer.writeUnsignedInt(this.nHeaderBytes);
        writer.writeUnsignedInt(this.nSeekTableBytes);
        writer.writeUnsignedInt(this.nHeaderDataBytes);
        writer.writeUnsignedInt(this.nAPEFrameDataBytes);
        writer.writeUnsignedInt(this.nAPEFrameDataBytesHigh);
        writer.writeUnsignedInt(this.nTerminatingDataBytes);
        writer.writeBytes(this.cFileMD5);
    }
}

