/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.info.APEFileInfo;
import davaguine.jmac.info.APEHeader;
import davaguine.jmac.info.APETag;
import davaguine.jmac.info.WaveFormat;
import davaguine.jmac.info.WaveHeader;
import davaguine.jmac.tools.InputStreamFile;
import davaguine.jmac.tools.JMACException;
import davaguine.jmac.tools.RandomAccessFile;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class APEInfo {
    private boolean m_bHasFileInformationLoaded;
    private davaguine.jmac.tools.File m_spIO;
    private APETag m_spAPETag;
    private APEFileInfo m_APEFileInfo = new APEFileInfo();

    public APEInfo(URL url) throws IOException {
        this(url, null);
    }

    public APEInfo(URL url, APETag pTag) throws IOException {
        this(url.openStream(), pTag);
    }

    public APEInfo(File file) throws IOException {
        this(file, null);
    }

    public APEInfo(File file, APETag pTag) throws IOException {
        this(new RandomAccessFile(file, "r"), pTag);
    }

    public APEInfo(InputStream pIO) throws IOException {
        this(pIO, null);
    }

    public APEInfo(InputStream pIO, APETag pTag) throws IOException {
        this(new InputStreamFile(pIO), pTag);
    }

    public APEInfo(davaguine.jmac.tools.File pIO) throws IOException {
        this(pIO, null);
    }

    public APEInfo(davaguine.jmac.tools.File pIO, APETag pTag) throws IOException {
        this.m_spIO = pIO;
        this.GetFileInformation();
        this.m_spAPETag = pTag == null ? new APETag(this.m_spIO, pIO.isLocal()) : pTag;
    }

    public void close() throws IOException {
        this.m_APEFileInfo.spWaveHeaderData = null;
        this.m_APEFileInfo.spSeekBitTable = null;
        this.m_APEFileInfo.spSeekByteTable = null;
        this.m_APEFileInfo.spAPEDescriptor = null;
        this.m_spAPETag = null;
        this.m_APEFileInfo.nSeekTableElements = 0;
        this.m_bHasFileInformationLoaded = false;
    }

    public int getApeInfoFileVersion() {
        return this.m_APEFileInfo.nVersion;
    }

    public int getApeInfoCompressionLevel() {
        return this.m_APEFileInfo.nCompressionLevel;
    }

    public int getApeInfoFormatFlags() {
        return this.m_APEFileInfo.nFormatFlags;
    }

    public int getApeInfoSampleRate() {
        return this.m_APEFileInfo.nSampleRate;
    }

    public int getApeInfoBitsPerSample() {
        return this.m_APEFileInfo.nBitsPerSample;
    }

    public int getApeInfoBytesPerSample() {
        return this.m_APEFileInfo.nBytesPerSample;
    }

    public int getApeInfoChannels() {
        return this.m_APEFileInfo.nChannels;
    }

    public int getApeInfoBlockAlign() {
        return this.m_APEFileInfo.nBlockAlign;
    }

    public int getApeInfoBlocksPerFrame() {
        return this.m_APEFileInfo.nBlocksPerFrame;
    }

    public int getApeInfoFinalFrameBlocks() {
        return this.m_APEFileInfo.nFinalFrameBlocks;
    }

    public int getApeInfoTotalFrames() {
        return this.m_APEFileInfo.nTotalFrames;
    }

    public int getApeInfoWavHeaderBytes() {
        return this.m_APEFileInfo.nWAVHeaderBytes;
    }

    public int getApeInfoWavTerminatingBytes() {
        return this.m_APEFileInfo.nWAVTerminatingBytes;
    }

    public int getApeInfoWavDataBytes() {
        return this.m_APEFileInfo.nWAVDataBytes;
    }

    public int getApeInfoWavTotalBytes() {
        return this.m_APEFileInfo.nWAVTotalBytes;
    }

    public int getApeInfoApeTotalBytes() {
        return this.m_APEFileInfo.nAPETotalBytes;
    }

    public int getApeInfoTotalBlocks() {
        return this.m_APEFileInfo.nTotalBlocks;
    }

    public int getApeInfoLengthMs() {
        return this.m_APEFileInfo.nLengthMS;
    }

    public int getApeInfoAverageBitrate() {
        return this.m_APEFileInfo.nAverageBitrate;
    }

    public int getApeInfoSeekByte(int nFrame) {
        return nFrame < 0 || nFrame >= this.m_APEFileInfo.nTotalFrames ? 0 : this.m_APEFileInfo.spSeekByteTable[nFrame] + this.m_APEFileInfo.nJunkHeaderBytes;
    }

    public int getApeInfoFrameBytes(int nFrame) throws IOException {
        if (nFrame < 0 || nFrame >= this.m_APEFileInfo.nTotalFrames) {
            return -1;
        }
        if (nFrame != this.m_APEFileInfo.nTotalFrames - 1) {
            return this.getApeInfoSeekByte(nFrame + 1) - this.getApeInfoSeekByte(nFrame);
        }
        if (this.m_spIO.isLocal()) {
            return (int)this.m_spIO.length() - this.m_spAPETag.GetTagBytes() - this.m_APEFileInfo.nWAVTerminatingBytes - this.getApeInfoSeekByte(nFrame);
        }
        if (nFrame > 0) {
            return this.getApeInfoSeekByte(nFrame) - this.getApeInfoSeekByte(nFrame - 1);
        }
        return -1;
    }

    public int getApeInfoFrameBlocks(int nFrame) {
        if (nFrame < 0 || nFrame >= this.m_APEFileInfo.nTotalFrames) {
            return -1;
        }
        if (nFrame != this.m_APEFileInfo.nTotalFrames - 1) {
            return this.m_APEFileInfo.nBlocksPerFrame;
        }
        return this.m_APEFileInfo.nFinalFrameBlocks;
    }

    public int getApeInfoFrameBitrate(int nFrame) throws IOException {
        int nFrameMS;
        int nFrameBytes = this.getApeInfoFrameBytes(nFrame);
        int nFrameBlocks = this.getApeInfoFrameBlocks(nFrame);
        if (nFrameBytes > 0 && nFrameBlocks > 0 && this.m_APEFileInfo.nSampleRate > 0 && (nFrameMS = nFrameBlocks * 1000 / this.m_APEFileInfo.nSampleRate) != 0) {
            return nFrameBytes * 8 / nFrameMS;
        }
        return this.m_APEFileInfo.nAverageBitrate;
    }

    public int getApeInfoDecompressedBitrate() {
        return this.m_APEFileInfo.nDecompressedBitrate;
    }

    public int getApeInfoPeakLevel() {
        return this.m_APEFileInfo.nPeakLevel;
    }

    public int getApeInfoSeekBit(int nFrame) {
        if (this.getApeInfoFileVersion() > 3800) {
            return 0;
        }
        if (nFrame < 0 || nFrame >= this.m_APEFileInfo.nTotalFrames) {
            return 0;
        }
        return this.m_APEFileInfo.spSeekBitTable[nFrame];
    }

    public WaveFormat getApeInfoWaveFormatEx() {
        WaveFormat pWaveFormatEx = new WaveFormat();
        WaveFormat.FillWaveFormatEx(pWaveFormatEx, this.m_APEFileInfo.nSampleRate, this.m_APEFileInfo.nBitsPerSample, this.m_APEFileInfo.nChannels);
        return pWaveFormatEx;
    }

    public byte[] getApeInfoWavHeaderData(int nMaxBytes) {
        if ((this.m_APEFileInfo.nFormatFlags & 0x20) > 0) {
            if (44 > nMaxBytes) {
                return null;
            }
            WaveFormat wfeFormat = this.getApeInfoWaveFormatEx();
            WaveHeader WAVHeader = new WaveHeader();
            WaveHeader.FillWaveHeader(WAVHeader, this.m_APEFileInfo.nWAVDataBytes, wfeFormat, this.m_APEFileInfo.nWAVTerminatingBytes);
            return WAVHeader.write();
        }
        if (this.m_APEFileInfo.nWAVHeaderBytes > nMaxBytes) {
            return null;
        }
        byte[] pBuffer = new byte[this.m_APEFileInfo.nWAVHeaderBytes];
        System.arraycopy(this.m_APEFileInfo.spWaveHeaderData, 0, pBuffer, 0, this.m_APEFileInfo.nWAVHeaderBytes);
        return pBuffer;
    }

    public davaguine.jmac.tools.File getApeInfoIoSource() {
        return this.m_spIO;
    }

    public APETag getApeInfoTag() {
        return this.m_spAPETag;
    }

    public byte[] getApeInfoWavTerminatingData(int nMaxBytes) throws IOException {
        if (this.m_APEFileInfo.nWAVTerminatingBytes > nMaxBytes) {
            return null;
        }
        if (this.m_APEFileInfo.nWAVTerminatingBytes > 0) {
            long nOriginalFileLocation = this.m_spIO.getFilePointer();
            this.m_spIO.seek(this.m_spIO.length() - (long)(this.m_spAPETag.GetTagBytes() + this.m_APEFileInfo.nWAVTerminatingBytes));
            byte[] pBuffer = new byte[this.m_APEFileInfo.nWAVTerminatingBytes];
            try {
                this.m_spIO.readFully(pBuffer);
            }
            catch (EOFException e) {
                throw new JMACException("Can't Read WAV Terminating Bytes");
            }
            this.m_spIO.seek(nOriginalFileLocation);
            return pBuffer;
        }
        return null;
    }

    public APEFileInfo getApeInfoInternalInfo() {
        return this.m_APEFileInfo;
    }

    private void GetFileInformation() throws IOException {
        if (this.m_bHasFileInformationLoaded) {
            return;
        }
        APEHeader APEHeader2 = new APEHeader(this.m_spIO);
        APEHeader2.Analyze(this.m_APEFileInfo);
        this.m_bHasFileInformationLoaded = true;
    }
}

