/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.prediction;

import davaguine.jmac.prediction.IPredictorCompress;
import davaguine.jmac.prediction.NNFilter;
import davaguine.jmac.prediction.NNFilter1280;
import davaguine.jmac.prediction.NNFilter16;
import davaguine.jmac.prediction.NNFilter256;
import davaguine.jmac.prediction.NNFilter32;
import davaguine.jmac.prediction.NNFilter64;
import davaguine.jmac.tools.JMACException;
import davaguine.jmac.tools.RollBufferFastInt;
import davaguine.jmac.tools.ScaledFirstOrderFilter;
import java.util.Arrays;

public class PredictorCompressNormal
extends IPredictorCompress {
    private static final int WINDOW_BLOCKS = 512;
    protected RollBufferFastInt m_rbPrediction = new RollBufferFastInt(512, 10);
    protected RollBufferFastInt m_rbAdapt = new RollBufferFastInt(512, 9);
    protected ScaledFirstOrderFilter m_Stage1FilterA = new ScaledFirstOrderFilter(31, 5);
    protected ScaledFirstOrderFilter m_Stage1FilterB = new ScaledFirstOrderFilter(31, 5);
    protected int[] m_aryM = new int[9];
    protected int m_nCurrentIndex;
    protected NNFilter m_pNNFilter;
    protected NNFilter m_pNNFilter1;
    protected NNFilter m_pNNFilter2;

    public PredictorCompressNormal(int nCompressionLevel) {
        super(nCompressionLevel);
        if (nCompressionLevel == 1000) {
            this.m_pNNFilter = null;
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 2000) {
            this.m_pNNFilter = new NNFilter16(11, 3990);
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 3000) {
            this.m_pNNFilter = new NNFilter64(11, 3990);
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 4000) {
            this.m_pNNFilter = new NNFilter256(13, 3990);
            this.m_pNNFilter1 = new NNFilter32(10, 3990);
            this.m_pNNFilter2 = null;
        } else if (nCompressionLevel == 5000) {
            this.m_pNNFilter = new NNFilter1280(15, 3990);
            this.m_pNNFilter1 = new NNFilter256(13, 3990);
            this.m_pNNFilter2 = new NNFilter16(11, 3990);
        } else {
            throw new JMACException("Unknown Compression Type");
        }
    }

    public int CompressValue(int nA, int nB) {
        if (this.m_nCurrentIndex == 512) {
            this.m_rbPrediction.Roll();
            this.m_rbAdapt.Roll();
            this.m_nCurrentIndex = 0;
        }
        nA = this.m_Stage1FilterA.Compress(nA);
        nB = this.m_Stage1FilterB.Compress(nB);
        int predictIndex = this.m_rbPrediction.index;
        this.m_rbPrediction.m_pData[predictIndex] = nA;
        this.m_rbPrediction.m_pData[predictIndex - 2] = this.m_rbPrediction.m_pData[predictIndex - 1] - this.m_rbPrediction.m_pData[predictIndex - 2];
        this.m_rbPrediction.m_pData[predictIndex - 5] = nB;
        this.m_rbPrediction.m_pData[predictIndex - 6] = this.m_rbPrediction.m_pData[predictIndex - 5] - this.m_rbPrediction.m_pData[predictIndex - 6];
        int nPredictionA = this.m_rbPrediction.m_pData[predictIndex - 1] * this.m_aryM[8] + this.m_rbPrediction.m_pData[predictIndex - 2] * this.m_aryM[7] + this.m_rbPrediction.m_pData[predictIndex - 3] * this.m_aryM[6] + this.m_rbPrediction.m_pData[predictIndex - 4] * this.m_aryM[5];
        int nPredictionB = this.m_rbPrediction.m_pData[predictIndex - 5] * this.m_aryM[4] + this.m_rbPrediction.m_pData[predictIndex - 6] * this.m_aryM[3] + this.m_rbPrediction.m_pData[predictIndex - 7] * this.m_aryM[2] + this.m_rbPrediction.m_pData[predictIndex - 8] * this.m_aryM[1] + this.m_rbPrediction.m_pData[predictIndex - 9] * this.m_aryM[0];
        int nOutput = nA - (nPredictionA + (nPredictionB >> 1) >> 10);
        int adaptIndex = this.m_rbAdapt.index;
        this.m_rbAdapt.m_pData[adaptIndex] = this.m_rbPrediction.m_pData[predictIndex - 1] != 0 ? (this.m_rbPrediction.m_pData[predictIndex - 1] >> 30 & 2) - 1 : 0;
        this.m_rbAdapt.m_pData[adaptIndex - 1] = this.m_rbPrediction.m_pData[predictIndex - 2] != 0 ? (this.m_rbPrediction.m_pData[predictIndex - 2] >> 30 & 2) - 1 : 0;
        this.m_rbAdapt.m_pData[adaptIndex - 4] = this.m_rbPrediction.m_pData[predictIndex - 5] != 0 ? (this.m_rbPrediction.m_pData[predictIndex - 5] >> 30 & 2) - 1 : 0;
        int n = this.m_rbAdapt.m_pData[adaptIndex - 5] = this.m_rbPrediction.m_pData[predictIndex - 6] != 0 ? (this.m_rbPrediction.m_pData[predictIndex - 6] >> 30 & 2) - 1 : 0;
        if (nOutput > 0) {
            int indexM = 0;
            int indexA = adaptIndex - 8;
            int n2 = indexM++;
            this.m_aryM[n2] = this.m_aryM[n2] - this.m_rbAdapt.m_pData[indexA++];
            int n3 = indexM++;
            this.m_aryM[n3] = this.m_aryM[n3] - this.m_rbAdapt.m_pData[indexA++];
            int n4 = indexM++;
            this.m_aryM[n4] = this.m_aryM[n4] - this.m_rbAdapt.m_pData[indexA++];
            int n5 = indexM++;
            this.m_aryM[n5] = this.m_aryM[n5] - this.m_rbAdapt.m_pData[indexA++];
            int n6 = indexM++;
            this.m_aryM[n6] = this.m_aryM[n6] - this.m_rbAdapt.m_pData[indexA++];
            int n7 = indexM++;
            this.m_aryM[n7] = this.m_aryM[n7] - this.m_rbAdapt.m_pData[indexA++];
            int n8 = indexM++;
            this.m_aryM[n8] = this.m_aryM[n8] - this.m_rbAdapt.m_pData[indexA++];
            int n9 = indexM++;
            this.m_aryM[n9] = this.m_aryM[n9] - this.m_rbAdapt.m_pData[indexA++];
            int n10 = indexM++;
            this.m_aryM[n10] = this.m_aryM[n10] - this.m_rbAdapt.m_pData[indexA++];
        } else if (nOutput < 0) {
            int indexM = 0;
            int indexA = adaptIndex - 8;
            int n11 = indexM++;
            this.m_aryM[n11] = this.m_aryM[n11] + this.m_rbAdapt.m_pData[indexA++];
            int n12 = indexM++;
            this.m_aryM[n12] = this.m_aryM[n12] + this.m_rbAdapt.m_pData[indexA++];
            int n13 = indexM++;
            this.m_aryM[n13] = this.m_aryM[n13] + this.m_rbAdapt.m_pData[indexA++];
            int n14 = indexM++;
            this.m_aryM[n14] = this.m_aryM[n14] + this.m_rbAdapt.m_pData[indexA++];
            int n15 = indexM++;
            this.m_aryM[n15] = this.m_aryM[n15] + this.m_rbAdapt.m_pData[indexA++];
            int n16 = indexM++;
            this.m_aryM[n16] = this.m_aryM[n16] + this.m_rbAdapt.m_pData[indexA++];
            int n17 = indexM++;
            this.m_aryM[n17] = this.m_aryM[n17] + this.m_rbAdapt.m_pData[indexA++];
            int n18 = indexM++;
            this.m_aryM[n18] = this.m_aryM[n18] + this.m_rbAdapt.m_pData[indexA++];
            int n19 = indexM++;
            this.m_aryM[n19] = this.m_aryM[n19] + this.m_rbAdapt.m_pData[indexA++];
        }
        if (this.m_pNNFilter != null) {
            nOutput = this.m_pNNFilter.Compress(nOutput);
            if (this.m_pNNFilter1 != null) {
                nOutput = this.m_pNNFilter1.Compress(nOutput);
                if (this.m_pNNFilter2 != null) {
                    nOutput = this.m_pNNFilter2.Compress(nOutput);
                }
            }
        }
        ++this.m_rbPrediction.index;
        ++this.m_rbAdapt.index;
        ++this.m_nCurrentIndex;
        return nOutput;
    }

    public void Flush() {
        if (this.m_pNNFilter != null) {
            this.m_pNNFilter.Flush();
        }
        if (this.m_pNNFilter1 != null) {
            this.m_pNNFilter1.Flush();
        }
        if (this.m_pNNFilter2 != null) {
            this.m_pNNFilter2.Flush();
        }
        this.m_rbPrediction.Flush();
        this.m_rbAdapt.Flush();
        this.m_Stage1FilterA.Flush();
        this.m_Stage1FilterB.Flush();
        Arrays.fill(this.m_aryM, 0);
        this.m_aryM[8] = 360;
        this.m_aryM[7] = 317;
        this.m_aryM[6] = -109;
        this.m_aryM[5] = 98;
        this.m_nCurrentIndex = 0;
    }
}

