/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.tools;

import davaguine.jmac.tools.JMACException;
import java.io.UnsupportedEncodingException;

public class ByteArrayWriter {
    private byte[] data = null;
    private int index = 0;

    public ByteArrayWriter() {
    }

    public ByteArrayWriter(int size) {
        this.data = new byte[size];
    }

    public ByteArrayWriter(byte[] data) {
        this.data = data;
    }

    public void reset(int size) {
        this.data = new byte[size];
        this.index = 0;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void writeUnsignedByte(short value) {
        if (value < 0 || value > 255) {
            throw new JMACException("Wrong Value");
        }
        this.data[this.index++] = (byte)value;
    }

    public void writeUnsignedShort(int value) {
        if (value < 0 || value > 65535) {
            throw new JMACException("Wrong Value");
        }
        this.data[this.index++] = (byte)(value & 0xFF);
        this.data[this.index++] = (byte)(value >> 8);
    }

    public void writeUnsignedInt(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new JMACException("Wrong Value");
        }
        this.data[this.index++] = (byte)(value & 0xFFL);
        this.data[this.index++] = (byte)(value >> 8 & 0xFFL);
        this.data[this.index++] = (byte)(value >> 16 & 0xFFL);
        this.data[this.index++] = (byte)(value >> 24 & 0xFFL);
    }

    public void writeByte(byte value) {
        this.data[this.index++] = value;
    }

    public void writeShort(short value) {
        this.data[this.index++] = (byte)(value & 0xFF);
        this.data[this.index++] = (byte)(value >> 8);
    }

    public void writeInt(int value) {
        this.data[this.index++] = (byte)(value & 0xFF);
        this.data[this.index++] = (byte)(value >> 8 & 0xFF);
        this.data[this.index++] = (byte)(value >> 16 & 0xFF);
        this.data[this.index++] = (byte)(value >> 24 & 0xFF);
    }

    public void writeBytes(byte[] buf) {
        this.writeBytes(buf, 0, buf.length);
    }

    public void writeBytes(byte[] buf, int off, int len) {
        System.arraycopy(buf, off, this.data, this.index, len);
        this.index += len;
    }

    public void writeString(String value, int size, String encoding) {
        try {
            byte[] bytes = value.getBytes(encoding);
            if (bytes.length != size) {
                throw new JMACException("Wrong Value");
            }
            System.arraycopy(bytes, 0, this.data, this.index, size);
        }
        catch (UnsupportedEncodingException e) {
            throw new JMACException("Unsupported Encoding", e);
        }
        this.index += size;
    }

    public void writeZString(String value, String encoding) {
        try {
            byte[] bytes = value.getBytes(encoding);
            System.arraycopy(bytes, 0, this.data, this.index, bytes.length);
            this.index += bytes.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new JMACException("Unsupported Encoding", e);
        }
        this.data[this.index++] = 0;
    }
}

