/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.equalizer.ui;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javazoom.jlgui.player.amp.PlayerUI;
import javazoom.jlgui.player.amp.skin.AbsoluteLayout;
import javazoom.jlgui.player.amp.skin.DropTargetAdapter;
import javazoom.jlgui.player.amp.skin.ImageBorder;
import javazoom.jlgui.player.amp.skin.Skin;
import javazoom.jlgui.player.amp.util.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EqualizerUI
extends JPanel
implements ActionListener,
ChangeListener {
    private static Log log = LogFactory.getLog((Class)EqualizerUI.class);
    private int minGain = 0;
    private int maxGain = 100;
    private int[] gainValue = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50};
    private int[] PRESET_NORMAL = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50};
    private int[] PRESET_CLASSICAL = new int[]{50, 50, 50, 50, 50, 50, 70, 70, 70, 76};
    private int[] PRESET_CLUB = new int[]{50, 50, 42, 34, 34, 34, 42, 50, 50, 50};
    private int[] PRESET_DANCE = new int[]{26, 34, 46, 50, 50, 66, 70, 70, 50, 50};
    private int[] PRESET_FULLBASS = new int[]{26, 26, 26, 36, 46, 62, 76, 78, 78, 78};
    private int[] PRESET_FULLBASSTREBLE = new int[]{34, 34, 50, 68, 62, 46, 28, 22, 18, 18};
    private int[] PRESET_FULLTREBLE = new int[]{78, 78, 78, 62, 42, 24, 8, 8, 8, 8};
    private int[] PRESET_LAPTOP = new int[]{38, 22, 36, 60, 58, 46, 38, 24, 16, 14};
    private int[] PRESET_LIVE = new int[]{66, 50, 40, 36, 34, 34, 40, 42, 42, 42};
    private int[] PRESET_PARTY = new int[]{32, 32, 50, 50, 50, 50, 50, 50, 32, 32};
    private int[] PRESET_POP = new int[]{56, 38, 32, 30, 38, 54, 56, 56, 54, 54};
    private int[] PRESET_REGGAE = new int[]{48, 48, 50, 66, 48, 34, 34, 48, 48, 48};
    private int[] PRESET_ROCK = new int[]{32, 38, 64, 72, 56, 40, 28, 24, 24, 24};
    private int[] PRESET_TECHNO = new int[]{30, 34, 48, 66, 64, 48, 30, 24, 24, 28};
    private Config config = null;
    private PlayerUI player = null;
    private Skin ui = null;
    private JPopupMenu mainpopup = null;
    public static final int LINEARDIST = 1;
    public static final int OVERDIST = 2;
    private float[] bands = null;
    private int[] eqgains = null;
    private int eqdist = 2;

    public EqualizerUI() {
        this.setDoubleBuffered(true);
        this.config = Config.getInstance();
        this.eqgains = new int[10];
        this.setLayout(new AbsoluteLayout());
        int[] nArray = this.config.getLastEqualizer();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.gainValue[i] = nArray[i];
            }
        }
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){

            public void processDrop(Object object) {
            }
        };
        DropTarget dropTarget = new DropTarget(this, 1, dropTargetAdapter, false);
    }

    public Skin getSkin() {
        return this.ui;
    }

    public void setSkin(Skin skin) {
        this.ui = skin;
    }

    public void setPlayer(PlayerUI playerUI) {
        this.player = playerUI;
    }

    public void loadUI() {
        log.info((Object)("Load EqualizerUI (EDT=" + SwingUtilities.isEventDispatchThread() + ")"));
        this.removeAll();
        ImageBorder imageBorder = new ImageBorder();
        imageBorder.setImage(this.ui.getEqualizerImage());
        this.setBorder(imageBorder);
        this.add((Component)this.ui.getAcEqOnOff(), this.ui.getAcEqOnOff().getConstraints());
        this.ui.getAcEqOnOff().removeActionListener(this);
        this.ui.getAcEqOnOff().addActionListener(this);
        this.add((Component)this.ui.getAcEqAuto(), this.ui.getAcEqAuto().getConstraints());
        this.ui.getAcEqAuto().removeActionListener(this);
        this.ui.getAcEqAuto().addActionListener(this);
        this.add((Component)this.ui.getAcEqPresets(), this.ui.getAcEqPresets().getConstraints());
        for (int i = 0; i < this.ui.getAcEqSliders().length; ++i) {
            this.add((Component)this.ui.getAcEqSliders()[i], this.ui.getAcEqSliders()[i].getConstraints());
            this.ui.getAcEqSliders()[i].setValue(this.maxGain - this.gainValue[i]);
            this.ui.getAcEqSliders()[i].removeChangeListener(this);
            this.ui.getAcEqSliders()[i].addChangeListener(this);
        }
        if (this.ui.getSpline() != null) {
            this.ui.getSpline().setValues(this.gainValue);
            this.add((Component)this.ui.getSpline(), this.ui.getSpline().getConstraints());
        }
        this.mainpopup = new JPopupMenu();
        String[] stringArray = new String[]{"Normal", "Classical", "Club", "Dance", "Full Bass", "Full Bass & Treble", "Full Treble", "Laptop", "Live", "Party", "Pop", "Reggae", "Rock", "Techno"};
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.removeActionListener(this);
            jMenuItem.addActionListener(this);
            this.mainpopup.add(jMenuItem);
        }
        this.ui.getAcEqPresets().removeActionListener(this);
        this.ui.getAcEqPresets().addActionListener(this);
        this.validate();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        for (int i = 0; i < this.ui.getAcEqSliders().length; ++i) {
            this.gainValue[i] = this.maxGain - this.ui.getAcEqSliders()[i].getValue();
        }
        if (this.ui.getSpline() != null) {
            this.ui.getSpline().repaint();
        }
        this.synchronizeEqualizer();
    }

    public void setBands(float[] fArray) {
        this.bands = fArray;
    }

    public void updateBands(int[] nArray, int n, int n2) {
        block3: {
            block4: {
                if (nArray == null || this.bands == null) break block3;
                int n3 = 0;
                float f = (float)nArray[n3] * 2.0f / (float)(n2 - n) * 1.0f - 1.0f;
                float f2 = (float)nArray[n3 + 1] * 2.0f / (float)(n2 - n) * 1.0f - 1.0f;
                if (this.eqdist != 1) break block4;
                float f3 = (f2 - f) * 1.0f;
                float f4 = f * 1.0f - (f2 - f) * (float)n3;
                float f5 = (float)(nArray.length - 1) * 1.0f / (float)(this.bands.length - 1) * 1.0f;
                for (int i = 0; i < this.bands.length; ++i) {
                    float f6 = f5 * (float)i;
                    if (f6 > (float)(n3 + 1)) {
                        f = (float)nArray[++n3] * 2.0f / (float)(n2 - n) * 1.0f - 1.0f;
                        f2 = (float)nArray[n3 + 1] * 2.0f / (float)(n2 - n) * 1.0f - 1.0f;
                        f3 = (f2 - f) * 1.0f;
                        f4 = f * 1.0f - (f2 - f) * (float)n3;
                    }
                    this.bands[i] = f3 * (float)i * 1.0f * f5 + f4;
                }
                break block3;
            }
            if (this.eqdist != 2) break block3;
            for (int i = 0; i < nArray.length; ++i) {
                this.bands[i] = (float)nArray[i] * 2.0f / (float)(n2 - n) * 1.0f - 1.0f;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        log.debug((Object)("Action=" + string + " (EDT=" + SwingUtilities.isEventDispatchThread() + ")"));
        if (string.equals("OnOffEQ")) {
            if (this.ui.getAcEqOnOff().isSelected()) {
                this.config.setEqualizerOn(true);
            } else {
                this.config.setEqualizerOn(false);
            }
            this.synchronizeEqualizer();
        } else if (string.equals("AutoEQ")) {
            if (this.ui.getAcEqAuto().isSelected()) {
                this.config.setEqualizerAuto(true);
            } else {
                this.config.setEqualizerAuto(false);
            }
        } else if (string.equals("PresetsEQ")) {
            if (actionEvent.getModifiers() == 16) {
                this.mainpopup.show(this, this.ui.getAcEqPresets().getLocation().x, this.ui.getAcEqPresets().getLocation().y);
            }
        } else if (string.equals("Normal")) {
            this.updateSliders(this.PRESET_NORMAL);
            this.synchronizeEqualizer();
        } else if (string.equals("Classical")) {
            this.updateSliders(this.PRESET_CLASSICAL);
            this.synchronizeEqualizer();
        } else if (string.equals("Club")) {
            this.updateSliders(this.PRESET_CLUB);
            this.synchronizeEqualizer();
        } else if (string.equals("Dance")) {
            this.updateSliders(this.PRESET_DANCE);
            this.synchronizeEqualizer();
        } else if (string.equals("Full Bass")) {
            this.updateSliders(this.PRESET_FULLBASS);
            this.synchronizeEqualizer();
        } else if (string.equals("Full Bass & Treble")) {
            this.updateSliders(this.PRESET_FULLBASSTREBLE);
            this.synchronizeEqualizer();
        } else if (string.equals("Full Treble")) {
            this.updateSliders(this.PRESET_FULLTREBLE);
            this.synchronizeEqualizer();
        } else if (string.equals("Laptop")) {
            this.updateSliders(this.PRESET_LAPTOP);
            this.synchronizeEqualizer();
        } else if (string.equals("Live")) {
            this.updateSliders(this.PRESET_LIVE);
            this.synchronizeEqualizer();
        } else if (string.equals("Party")) {
            this.updateSliders(this.PRESET_PARTY);
            this.synchronizeEqualizer();
        } else if (string.equals("Pop")) {
            this.updateSliders(this.PRESET_POP);
            this.synchronizeEqualizer();
        } else if (string.equals("Reggae")) {
            this.updateSliders(this.PRESET_REGGAE);
            this.synchronizeEqualizer();
        } else if (string.equals("Rock")) {
            this.updateSliders(this.PRESET_ROCK);
            this.synchronizeEqualizer();
        } else if (string.equals("Techno")) {
            this.updateSliders(this.PRESET_TECHNO);
            this.synchronizeEqualizer();
        }
    }

    public void updateSliders(int[] nArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.gainValue[i + 1] = nArray[i];
                this.ui.getAcEqSliders()[i + 1].setValue(this.maxGain - this.gainValue[i + 1]);
            }
        }
    }

    public void synchronizeEqualizer() {
        this.config.setLastEqualizer(this.gainValue);
        if (this.config.isEqualizerOn()) {
            for (int i = 0; i < this.eqgains.length; ++i) {
                this.eqgains[i] = -this.gainValue[i + 1] + this.maxGain;
            }
            this.updateBands(this.eqgains, this.minGain, this.maxGain);
        } else {
            for (int i = 0; i < this.eqgains.length; ++i) {
                this.eqgains[i] = (this.maxGain - this.minGain) / 2;
            }
            this.updateBands(this.eqgains, this.minGain, this.maxGain);
        }
    }

    public int getEqdist() {
        return this.eqdist;
    }

    public void setEqdist(int n) {
        this.eqdist = n;
    }

    public void pressOnOff() {
        this.ui.getAcEqOnOff().doClick();
    }

    public void pressAuto() {
        this.ui.getAcEqAuto().doClick();
    }
}

