/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.skin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class ActiveSliderUI
extends BasicSliderUI {
    private Image thumbImage = null;
    private Image thumbPressedImage = null;
    private Image[] backgroundImages = null;
    private JSlider parentSlider = null;
    private Dimension thumbDim = null;
    private int newThumbHeight = -1;
    private int thumbXOffset = 0;
    private int thumbYOffset = 0;
    private boolean hideThumb = false;

    public ActiveSliderUI(JSlider jSlider) {
        super(jSlider);
        this.parentSlider = jSlider;
    }

    public void setThumbImage(Image image) {
        this.thumbImage = image;
        this.thumbDim = new Dimension(this.thumbImage.getWidth(null), this.thumbImage.getHeight(null));
    }

    public void setThumbPressedImage(Image image) {
        this.thumbPressedImage = image;
    }

    protected Dimension getThumbSize() {
        return this.thumbDim;
    }

    public void forceThumbHeight(int n) {
        this.newThumbHeight = n;
    }

    public void setThumbXOffset(int n) {
        this.thumbXOffset = n;
    }

    public void setThumbYOffset(int n) {
        this.thumbYOffset = n;
    }

    public void setHideThumb(boolean bl) {
        this.hideThumb = bl;
    }

    public void setBackgroundImages(Image[] imageArray) {
        this.backgroundImages = imageArray;
    }

    public void paintFocus(Graphics graphics) {
    }

    public void paintThumb(Graphics graphics) {
        if (this.hideThumb) {
            return;
        }
        Image image = this.thumbImage;
        if (image != null) {
            if (this.thumbPressedImage != null && this.parentSlider.getValueIsAdjusting()) {
                image = this.thumbPressedImage;
            }
            if (this.newThumbHeight >= 0) {
                if (this.parentSlider.getOrientation() == 0) {
                    graphics.drawImage(image, this.thumbRect.x + this.thumbXOffset, this.thumbYOffset, image.getWidth(null), this.newThumbHeight, null);
                } else {
                    graphics.drawImage(image, this.thumbXOffset, this.thumbRect.y + this.thumbYOffset, image.getWidth(null), this.newThumbHeight, null);
                }
            } else if (this.parentSlider.getOrientation() == 0) {
                graphics.drawImage(image, this.thumbRect.x + this.thumbXOffset, this.thumbYOffset, image.getWidth(null), image.getHeight(null), null);
            } else {
                graphics.drawImage(image, this.thumbXOffset, this.thumbRect.y + this.thumbYOffset, image.getWidth(null), image.getHeight(null), null);
            }
        }
    }

    public void paintTrack(Graphics graphics) {
        if (this.backgroundImages != null) {
            int n = (int)Math.round((double)Math.abs(this.parentSlider.getValue()) / (double)this.parentSlider.getMaximum() * (double)(this.backgroundImages.length - 1));
            graphics.drawImage(this.backgroundImages[n], 0, 0, this.backgroundImages[n].getWidth(null), this.backgroundImages[n].getHeight(null), null);
        }
    }

    public void setThumbLocation(int n, int n2) {
        super.setThumbLocation(n, n2);
        this.parentSlider.repaint();
    }
}

