/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javazoom.jlgui.player.amp.PlayerUI;
import javazoom.jlgui.player.amp.playlist.Playlist;
import javazoom.jlgui.player.amp.playlist.PlaylistItem;
import javazoom.jlgui.player.amp.tag.TagInfo;

public class TagSearch
extends JFrame {
    private static String sep = System.getProperty("file.separator");
    private JTextField searchField;
    private JList list;
    private DefaultListModel m;
    private PlayerUI player;
    private Vector _playlist;
    private Vector restrictedPlaylist;
    private String lastSearch = null;
    private JScrollPane scroll;
    private ResourceBundle bundle;
    private JRadioButton all;
    private JRadioButton artist;
    private JRadioButton album;
    private JRadioButton title;

    public TagSearch(PlayerUI playerUI) {
        this.player = playerUI;
        this._playlist = null;
        this.restrictedPlaylist = null;
        this.bundle = ResourceBundle.getBundle("javazoom/jlgui/player/amp/tag/ui/tag");
        this.initComponents();
    }

    public void display() {
        if (this.list.getModel().getSize() != 0) {
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.player.getParent(), this.bundle.getString("emptyPlaylistMsg"), this.bundle.getString("emptyPlaylistTitle"), 0);
        }
    }

    private void initComponents() {
        this.setLayout(new GridLayout(1, 1));
        this.setDefaultCloseOperation(2);
        this.setTitle(this.bundle.getString("title"));
        this.setLocation(this.player.getX() + this.player.getWidth(), this.player.getY());
        JPanel jPanel = new JPanel(new BorderLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.setPreferredSize(new Dimension(300, 400));
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1, 10, 2));
        JLabel jLabel = new JLabel(this.bundle.getString("searchLabel"));
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyboardListener());
        jPanel2.add(jLabel);
        jPanel2.add(this.searchField);
        this.all = new JRadioButton(this.bundle.getString("radioAll"), true);
        this.artist = new JRadioButton(this.bundle.getString("radioArtist"), false);
        this.album = new JRadioButton(this.bundle.getString("radioAlbum"), false);
        this.title = new JRadioButton(this.bundle.getString("radioTitle"), false);
        this.all.addChangeListener(new RadioListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.all);
        buttonGroup.add(this.artist);
        buttonGroup.add(this.album);
        buttonGroup.add(this.title);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(this.all);
        jPanel3.add(this.artist);
        jPanel4.add(this.album);
        jPanel4.add(this.title);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.initList();
        this.list.addMouseListener(new ClickListener());
        this.list.addKeyListener(new KeyboardListener());
        this.scroll = new JScrollPane(this.list);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.scroll, "Center");
        this.add(jPanel);
        this.pack();
    }

    private void initList() {
        int n;
        Playlist playlist = this.player.getPlaylist();
        int n2 = this.player.getPlaylist().getPlaylistSize();
        this._playlist = new Vector();
        for (n = 0; n < n2; ++n) {
            this._playlist.addElement(playlist.getItemAt(n));
        }
        this.restrictedPlaylist = this._playlist;
        this.m = new DefaultListModel();
        for (n = 0; n < this._playlist.size(); ++n) {
            PlaylistItem playlistItem = (PlaylistItem)this._playlist.get(n);
            if (!playlistItem.isFile()) continue;
            this.m.addElement(this.getDisplayString(playlistItem));
        }
        this.list.setModel(this.m);
    }

    public String getDisplayString(PlaylistItem playlistItem) {
        String string;
        TagInfo tagInfo = playlistItem.getTagInfo();
        String string2 = playlistItem.getLocation();
        string2 = string2.substring(string2.lastIndexOf(sep) + 1, string2.lastIndexOf("."));
        if (tagInfo == null) {
            string = string2;
        } else if (tagInfo.getArtist() == null || tagInfo.getArtist().equals("")) {
            string = string2;
        } else {
            string = tagInfo.getArtist().trim();
            string = tagInfo.getTitle() == null || tagInfo.getTitle().equals("") ? string + " - " + string2 : string + " - " + tagInfo.getTitle().trim();
        }
        return string;
    }

    private void searchList(String string) {
        String[] stringArray = string.split(" ");
        String string2 = "";
        if (stringArray.length > 0) {
            string2 = stringArray[stringArray.length - 1];
        }
        if (string2.equals("")) {
            this.list.setModel(this.m);
            this.restrictedPlaylist = this._playlist;
        } else {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            if (!(this.lastSearch == null || string.length() > 1 && string.substring(string.length() - 2).equals(this.lastSearch))) {
                this.list.setModel(this.m);
                this.restrictedPlaylist = this._playlist;
            }
            Vector vector = this.restrictedPlaylist;
            this.restrictedPlaylist = new Vector();
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string3 = stringArray[i];
                int n2 = this.list.getModel().getSize();
                boolean[] blArray = new boolean[n2];
                for (n = 0; n < n2; ++n) {
                    TagInfo tagInfo = ((PlaylistItem)vector.get(n)).getTagInfo();
                    blArray[n] = false;
                    boolean bl = false;
                    int n3 = this.artist.isSelected() ? 1 : (this.album.isSelected() ? 2 : (this.title.isSelected() ? 0 : -1));
                    for (int j = 0; j <= 3; ++j) {
                        String string4 = "";
                        if (tagInfo == null) {
                            if (n3 != -1) break;
                            j = 3;
                        } else if (n3 != -1) {
                            j = n3;
                        }
                        switch (j) {
                            case 0: {
                                if (tagInfo.getTitle() == null) break;
                                string4 = tagInfo.getTitle().toLowerCase();
                                break;
                            }
                            case 1: {
                                if (tagInfo.getArtist() == null) break;
                                string4 = tagInfo.getArtist().toLowerCase();
                                break;
                            }
                            case 2: {
                                if (tagInfo.getAlbum() == null) break;
                                string4 = tagInfo.getAlbum().toLowerCase();
                                break;
                            }
                            case 3: {
                                String string5 = ((PlaylistItem)vector.get(n)).getLocation().toLowerCase();
                                string4 = string5.substring(string5.lastIndexOf(sep) + 1, string5.lastIndexOf("."));
                            }
                        }
                        string3 = string3.toLowerCase();
                        bl = this.search(string3, string4);
                        if (bl || n3 != -1) break;
                    }
                    if (bl && i == 0) {
                        defaultListModel.addElement(this.getDisplayString((PlaylistItem)vector.get(n)));
                        this.restrictedPlaylist.add(vector.get(n));
                    }
                    if (bl || i == 0) continue;
                    blArray[n] = true;
                }
                for (n = n2 - 1; n >= 0; --n) {
                    if (!blArray[n]) continue;
                    defaultListModel.remove(n);
                    this.restrictedPlaylist.remove(n);
                }
                vector = this.restrictedPlaylist;
                this.list.setModel(defaultListModel);
            }
            this.list.setModel(defaultListModel);
            this.lastSearch = this.searchField.getText();
        }
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    private boolean search(String string, String string2) {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        while (n < cArray.length && n2 < cArray2.length) {
            if (cArray[n] == cArray2[n2]) {
                ++n;
                ++n2;
                continue;
            }
            n = 0;
            if (cArray[n] == cArray2[n2]) continue;
            ++n2;
        }
        return n == cArray.length;
    }

    private void playSong() {
        Playlist playlist = this.player.getPlaylist();
        this.player.pressStop();
        this.player.setCurrentSong((PlaylistItem)this.restrictedPlaylist.get(this.list.getSelectedIndex()));
        playlist.setCursor(playlist.getIndex((PlaylistItem)this.restrictedPlaylist.get(this.list.getSelectedIndex())));
        this.player.pressStart();
        this.dispose();
    }

    class RadioListener
    implements ChangeListener {
        RadioListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            TagSearch.this.searchList(TagSearch.this.searchField.getText());
        }
    }

    class ClickListener
    extends MouseAdapter {
        ClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && TagSearch.this.list.getSelectedIndex() != -1) {
                TagSearch.this.playSong();
            }
        }
    }

    class KeyboardListener
    implements KeyListener {
        KeyboardListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource().equals(TagSearch.this.searchField) && keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 38) {
                TagSearch.this.searchList(TagSearch.this.searchField.getText());
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (TagSearch.this.list.getSelectedIndex() != -1 && keyEvent.getKeyChar() == '\n') {
                TagSearch.this.playSong();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = TagSearch.this.list.getSelectedIndex();
            if (keyEvent.getKeyCode() == 40 && n < TagSearch.this.list.getModel().getSize() - 1) {
                JScrollBar jScrollBar = TagSearch.this.scroll.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement() * 5);
            } else if (keyEvent.getKeyCode() == 38 && n >= 0) {
                JScrollBar jScrollBar = TagSearch.this.scroll.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement() * 5);
            }
        }
    }
}

