/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.basicplayer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayerEventLauncher;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;
import javazoom.spi.PropertiesContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class BasicPlayer
implements BasicController,
Runnable {
    public static int EXTERNAL_BUFFER_SIZE = 16000;
    public static int SKIP_INACCURACY_SIZE = 1200;
    protected Thread m_thread = null;
    protected Object m_dataSource = null;
    protected AudioInputStream m_encodedaudioInputStream;
    protected int encodedLength = -1;
    protected AudioInputStream m_audioInputStream;
    protected AudioFileFormat m_audioFileFormat;
    protected SourceDataLine m_line;
    protected FloatControl m_gainControl;
    protected FloatControl m_panControl;
    protected String m_mixerName = null;
    private int m_lineCurrentBufferSize = -1;
    private int lineBufferSize = -1;
    private long threadSleep = -1L;
    private static Log log = LogFactory.getLog((Class)(class$javazoom$jlgui$basicplayer$BasicPlayer == null ? (class$javazoom$jlgui$basicplayer$BasicPlayer = BasicPlayer.class$("javazoom.jlgui.basicplayer.BasicPlayer")) : class$javazoom$jlgui$basicplayer$BasicPlayer));
    public static final int UNKNOWN = -1;
    public static final int PLAYING = 0;
    public static final int PAUSED = 1;
    public static final int STOPPED = 2;
    public static final int OPENED = 3;
    public static final int SEEKING = 4;
    private int m_status = -1;
    private Collection m_listeners = null;
    private Map empty_map = new HashMap();
    static /* synthetic */ Class class$javazoom$jlgui$basicplayer$BasicPlayer;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public BasicPlayer() {
        this.m_listeners = new ArrayList();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        this.m_status = -1;
        if (this.m_audioInputStream != null) {
            AudioInputStream audioInputStream = this.m_audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
        }
        this.m_audioInputStream = null;
        this.m_audioFileFormat = null;
        this.m_encodedaudioInputStream = null;
        this.encodedLength = -1;
        if (this.m_line != null) {
            this.m_line.stop();
            this.m_line.close();
            this.m_line = null;
        }
        this.m_gainControl = null;
        this.m_panControl = null;
    }

    public void addBasicPlayerListener(BasicPlayerListener basicPlayerListener) {
        this.m_listeners.add(basicPlayerListener);
    }

    public Collection getListeners() {
        return this.m_listeners;
    }

    public void removeBasicPlayerListener(BasicPlayerListener basicPlayerListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(basicPlayerListener);
        }
    }

    public void setLineBufferSize(int n) {
        this.lineBufferSize = n;
    }

    public int getLineBufferSize() {
        return this.lineBufferSize;
    }

    public int getLineCurrentBufferSize() {
        return this.m_lineCurrentBufferSize;
    }

    public void setSleepTime(long l) {
        this.threadSleep = l;
    }

    public long getSleepTime() {
        return this.threadSleep;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void open(File file) throws BasicPlayerException {
        log.info((Object)("open(" + file + ")"));
        if (file != null) {
            this.m_dataSource = file;
            this.initAudioInputStream();
        }
    }

    public void open(URL uRL) throws BasicPlayerException {
        log.info((Object)("open(" + uRL + ")"));
        if (uRL != null) {
            this.m_dataSource = uRL;
            this.initAudioInputStream();
        }
    }

    public void open(InputStream inputStream) throws BasicPlayerException {
        log.info((Object)("open(" + inputStream + ")"));
        if (inputStream != null) {
            this.m_dataSource = inputStream;
            this.initAudioInputStream();
        }
    }

    protected void initAudioInputStream() throws BasicPlayerException {
        try {
            Object object;
            AudioFormat audioFormat;
            this.reset();
            this.notifyEvent(0, this.getEncodedStreamPosition(), -1.0, this.m_dataSource);
            if (this.m_dataSource instanceof URL) {
                this.initAudioInputStream((URL)this.m_dataSource);
            } else if (this.m_dataSource instanceof File) {
                this.initAudioInputStream((File)this.m_dataSource);
            } else if (this.m_dataSource instanceof InputStream) {
                this.initAudioInputStream((InputStream)this.m_dataSource);
            }
            this.createLine();
            Map<String, String> map = null;
            if (this.m_audioFileFormat instanceof TAudioFileFormat) {
                map = ((TAudioFileFormat)this.m_audioFileFormat).properties();
                map = this.deepCopy(map);
            } else {
                map = new HashMap();
            }
            if (this.m_audioFileFormat.getByteLength() > 0) {
                map.put("audio.length.bytes", (String)((Object)new Integer(this.m_audioFileFormat.getByteLength())));
            }
            if (this.m_audioFileFormat.getFrameLength() > 0) {
                map.put("audio.length.frames", (String)((Object)new Integer(this.m_audioFileFormat.getFrameLength())));
            }
            if (this.m_audioFileFormat.getType() != null) {
                map.put("audio.type", this.m_audioFileFormat.getType().toString());
            }
            if ((audioFormat = this.m_audioFileFormat.getFormat()).getFrameRate() > 0.0f) {
                map.put("audio.framerate.fps", (String)((Object)new Float(audioFormat.getFrameRate())));
            }
            if (audioFormat.getFrameSize() > 0) {
                map.put("audio.framesize.bytes", (String)((Object)new Integer(audioFormat.getFrameSize())));
            }
            if (audioFormat.getSampleRate() > 0.0f) {
                map.put("audio.samplerate.hz", (String)((Object)new Float(audioFormat.getSampleRate())));
            }
            if (audioFormat.getSampleSizeInBits() > 0) {
                map.put("audio.samplesize.bits", (String)((Object)new Integer(audioFormat.getSampleSizeInBits())));
            }
            if (audioFormat.getChannels() > 0) {
                map.put("audio.channels", (String)((Object)new Integer(audioFormat.getChannels())));
            }
            if (audioFormat instanceof TAudioFormat) {
                object = ((TAudioFormat)audioFormat).properties();
                map.putAll((Map<String, String>)object);
            }
            map.put("basicplayer.sourcedataline", (String)((Object)this.m_line));
            object = this.m_listeners.iterator();
            while (object.hasNext()) {
                BasicPlayerListener basicPlayerListener = (BasicPlayerListener)object.next();
                basicPlayerListener.opened(this.m_dataSource, map);
            }
            this.m_status = 3;
            this.notifyEvent(1, this.getEncodedStreamPosition(), -1.0, null);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new BasicPlayerException(lineUnavailableException);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new BasicPlayerException(unsupportedAudioFileException);
        }
        catch (IOException iOException) {
            throw new BasicPlayerException(iOException);
        }
    }

    protected void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(file);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(file);
    }

    protected void initAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(uRL);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
    }

    protected void initAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
    }

    protected void initLine() throws LineUnavailableException {
        log.info((Object)"initLine()");
        if (this.m_line == null) {
            this.createLine();
        }
        if (!this.m_line.isOpen()) {
            this.openLine();
        } else {
            AudioFormat audioFormat;
            AudioFormat audioFormat2 = this.m_line.getFormat();
            AudioFormat audioFormat3 = audioFormat = this.m_audioInputStream == null ? null : this.m_audioInputStream.getFormat();
            if (!audioFormat2.equals(audioFormat)) {
                this.m_line.close();
                this.openLine();
            }
        }
    }

    protected void createLine() throws LineUnavailableException {
        log.info((Object)"Create Line");
        if (this.m_line == null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            log.info((Object)("Create Line : Source format : " + audioFormat.toString()));
            int n = audioFormat.getSampleSizeInBits();
            if (n <= 0) {
                n = 16;
            }
            if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                n = 16;
            }
            if (n != 8) {
                n = 16;
            }
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), false);
            log.info((Object)("Create Line : Target format: " + audioFormat2));
            this.m_encodedaudioInputStream = this.m_audioInputStream;
            try {
                this.encodedLength = this.m_encodedaudioInputStream.available();
            }
            catch (IOException iOException) {
                log.error((Object)"Cannot get m_encodedaudioInputStream.available()", (Throwable)iOException);
            }
            this.m_audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, this.m_audioInputStream);
            AudioFormat audioFormat3 = this.m_audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = BasicPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat3, -1);
            Mixer mixer = this.getMixer(this.m_mixerName);
            if (mixer != null) {
                log.info((Object)("Mixer : " + mixer.getMixerInfo().toString()));
                this.m_line = (SourceDataLine)mixer.getLine(info);
            } else {
                this.m_line = (SourceDataLine)AudioSystem.getLine(info);
                this.m_mixerName = null;
            }
            log.info((Object)("Line : " + this.m_line.toString()));
            log.debug((Object)("Line Info : " + this.m_line.getLineInfo().toString()));
            log.debug((Object)("Line AudioFormat: " + this.m_line.getFormat().toString()));
        }
    }

    protected void openLine() throws LineUnavailableException {
        if (this.m_line != null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            int n = this.lineBufferSize;
            if (n <= 0) {
                n = this.m_line.getBufferSize();
            }
            this.m_lineCurrentBufferSize = n;
            this.m_line.open(audioFormat, n);
            log.info((Object)("Open Line : BufferSize=" + n));
            Control[] controlArray = this.m_line.getControls();
            for (int i = 0; i < controlArray.length; ++i) {
                log.debug((Object)("Controls : " + controlArray[i].toString()));
            }
            if (this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
                log.info((Object)("Master Gain Control : [" + this.m_gainControl.getMinimum() + "," + this.m_gainControl.getMaximum() + "] " + this.m_gainControl.getPrecision()));
            }
            if (this.m_line.isControlSupported(FloatControl.Type.PAN)) {
                this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
                log.info((Object)("Pan Control : [" + this.m_panControl.getMinimum() + "," + this.m_panControl.getMaximum() + "] " + this.m_panControl.getPrecision()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPlayback() {
        if (this.m_status == 0 || this.m_status == 1) {
            if (this.m_line != null) {
                this.m_line.flush();
                this.m_line.stop();
            }
            this.m_status = 2;
            this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
            AudioInputStream audioInputStream = this.m_audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
            log.info((Object)"stopPlayback() completed");
        }
    }

    protected void pausePlayback() {
        if (this.m_line != null && this.m_status == 0) {
            this.m_line.flush();
            this.m_line.stop();
            this.m_status = 1;
            log.info((Object)"pausePlayback() completed");
            this.notifyEvent(4, this.getEncodedStreamPosition(), -1.0, null);
        }
    }

    protected void resumePlayback() {
        if (this.m_line != null && this.m_status == 1) {
            this.m_line.start();
            this.m_status = 0;
            log.info((Object)"resumePlayback() completed");
            this.notifyEvent(5, this.getEncodedStreamPosition(), -1.0, null);
        }
    }

    protected void startPlayback() throws BasicPlayerException {
        if (this.m_status == 2) {
            this.initAudioInputStream();
        }
        if (this.m_status == 3) {
            log.info((Object)"startPlayback called");
            if (this.m_thread != null && this.m_thread.isAlive()) {
                log.info((Object)"WARNING: old thread still running!!");
                int n = 0;
                while (this.m_status != 3) {
                    try {
                        if (this.m_thread == null) continue;
                        log.info((Object)("Waiting ... " + n));
                        Thread.sleep(1000L);
                        if (++n <= 2) continue;
                        this.m_thread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BasicPlayerException("Wait error", interruptedException);
                    }
                }
            }
            try {
                this.initLine();
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new BasicPlayerException("Cannot init line", lineUnavailableException);
            }
            log.info((Object)"Creating new thread");
            this.m_thread = new Thread((Runnable)this, "BasicPlayer");
            this.m_thread.start();
            if (this.m_line != null) {
                this.m_line.start();
                this.m_status = 0;
                this.notifyEvent(2, this.getEncodedStreamPosition(), -1.0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info((Object)"Thread Running");
        int n = 1;
        byte[] byArray = new byte[EXTERNAL_BUFFER_SIZE];
        AudioInputStream audioInputStream = this.m_audioInputStream;
        synchronized (audioInputStream) {
            while (n != -1 && this.m_status != 2 && this.m_status != 4 && this.m_status != -1) {
                if (this.m_status == 0) {
                    try {
                        n = this.m_audioInputStream.read(byArray, 0, byArray.length);
                        if (n >= 0) {
                            byte[] byArray2 = new byte[n];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            if (this.m_line.available() >= this.m_line.getBufferSize()) {
                                log.debug((Object)("Underrun : " + this.m_line.available() + "/" + this.m_line.getBufferSize()));
                            }
                            int n2 = this.m_line.write(byArray, 0, n);
                            int n3 = this.getEncodedStreamPosition();
                            Iterator iterator = this.m_listeners.iterator();
                            while (iterator.hasNext()) {
                                BasicPlayerListener basicPlayerListener = (BasicPlayerListener)iterator.next();
                                if (this.m_audioInputStream instanceof PropertiesContainer) {
                                    Map map = ((PropertiesContainer)this.m_audioInputStream).properties();
                                    basicPlayerListener.progress(n3, this.m_line.getMicrosecondPosition(), byArray2, map);
                                    continue;
                                }
                                basicPlayerListener.progress(n3, this.m_line.getMicrosecondPosition(), byArray2, this.empty_map);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        log.error((Object)"Thread cannot run()", (Throwable)iOException);
                        this.m_status = 2;
                        this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
                    }
                    if (this.threadSleep <= 0L) continue;
                    try {
                        Thread.sleep(this.threadSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        log.error((Object)("Thread cannot sleep(" + this.threadSleep + ")"), (Throwable)interruptedException);
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)"Thread cannot sleep(1000)", (Throwable)interruptedException);
                }
            }
            if (this.m_line != null) {
                this.m_line.drain();
                this.m_line.stop();
                this.m_line.close();
                this.m_line = null;
            }
            if (n == -1) {
                this.notifyEvent(8, this.getEncodedStreamPosition(), -1.0, null);
            }
            this.closeStream();
        }
        this.m_status = 2;
        this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
        log.info((Object)"Thread completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long skipBytes(long l) throws BasicPlayerException {
        long l2 = 0L;
        if (this.m_dataSource instanceof File) {
            log.info((Object)("Bytes to skip : " + l));
            int n = this.m_status;
            this.m_status = 4;
            long l3 = 0L;
            try {
                AudioInputStream audioInputStream = this.m_audioInputStream;
                synchronized (audioInputStream) {
                    this.notifyEvent(6, this.getEncodedStreamPosition(), -1.0, null);
                    this.initAudioInputStream();
                    if (this.m_audioInputStream != null) {
                        while (l2 < l - (long)SKIP_INACCURACY_SIZE && (l3 = this.m_audioInputStream.skip(l - l2)) != 0L) {
                            log.info((Object)("Skipped : " + (l2 += l3) + "/" + l));
                            if (l2 != -1L) continue;
                            throw new BasicPlayerException("Skip not supported");
                        }
                    }
                }
                this.notifyEvent(7, this.getEncodedStreamPosition(), -1.0, null);
                this.m_status = 3;
                if (n == 0) {
                    this.startPlayback();
                } else if (n == 1) {
                    this.startPlayback();
                    this.pausePlayback();
                }
            }
            catch (IOException iOException) {
                throw new BasicPlayerException(iOException);
            }
        }
        return l2;
    }

    protected void notifyEvent(int n, int n2, double d, Object object) {
        BasicPlayerEventLauncher basicPlayerEventLauncher = new BasicPlayerEventLauncher(n, n2, d, object, new ArrayList(this.m_listeners), this);
        basicPlayerEventLauncher.start();
    }

    protected int getEncodedStreamPosition() {
        int n = -1;
        if (this.m_dataSource instanceof File) {
            try {
                if (this.m_encodedaudioInputStream != null) {
                    n = this.encodedLength - this.m_encodedaudioInputStream.available();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    protected void closeStream() {
        try {
            if (this.m_audioInputStream != null) {
                this.m_audioInputStream.close();
                log.info((Object)"Stream closed");
            }
        }
        catch (IOException iOException) {
            log.info((Object)"Cannot close stream", (Throwable)iOException);
        }
    }

    public boolean hasGainControl() {
        if (this.m_gainControl == null && this.m_line != null && this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return this.m_gainControl != null;
    }

    public float getGainValue() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximumGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimumGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasPanControl() {
        if (this.m_panControl == null && this.m_line != null && this.m_line.isControlSupported(FloatControl.Type.PAN)) {
            this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
        }
        return this.m_panControl != null;
    }

    public float getPrecision() {
        if (this.hasPanControl()) {
            return this.m_panControl.getPrecision();
        }
        return 0.0f;
    }

    public float getPan() {
        if (this.hasPanControl()) {
            return this.m_panControl.getValue();
        }
        return 0.0f;
    }

    protected Map deepCopy(Map map) {
        HashMap hashMap = new HashMap();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                hashMap.put(k, v);
            }
        }
        return hashMap;
    }

    public long seek(long l) throws BasicPlayerException {
        return this.skipBytes(l);
    }

    public void play() throws BasicPlayerException {
        this.startPlayback();
    }

    public void stop() throws BasicPlayerException {
        this.stopPlayback();
    }

    public void pause() throws BasicPlayerException {
        this.pausePlayback();
    }

    public void resume() throws BasicPlayerException {
        this.resumePlayback();
    }

    public void setPan(double d) throws BasicPlayerException {
        if (!this.hasPanControl()) {
            throw new BasicPlayerException("Pan control not supported");
        }
        log.debug((Object)("Pan : " + d));
        this.m_panControl.setValue((float)d);
        this.notifyEvent(9, this.getEncodedStreamPosition(), d, null);
    }

    public void setGain(double d) throws BasicPlayerException {
        if (!this.hasGainControl()) {
            throw new BasicPlayerException("Gain control not supported");
        }
        double d2 = this.getMinimumGain();
        double d3 = 0.5f * this.getMaximumGain() - this.getMinimumGain();
        double d4 = Math.log(10.0) / 20.0;
        double d5 = d2 + 1.0 / d4 * Math.log(1.0 + (Math.exp(d4 * d3) - 1.0) * d);
        log.debug((Object)("Gain : " + d5));
        this.m_gainControl.setValue((float)d5);
        this.notifyEvent(10, this.getEncodedStreamPosition(), d, null);
    }

    public List getMixers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        if (infoArray != null) {
            for (int i = 0; i < infoArray.length; ++i) {
                Line.Info info = new Line.Info(class$javax$sound$sampled$SourceDataLine == null ? BasicPlayer.class$("javax.sound.sampled.SourceDataLine") : class$javax$sound$sampled$SourceDataLine);
                Mixer mixer = AudioSystem.getMixer(infoArray[i]);
                if (!mixer.isLineSupported(info)) continue;
                arrayList.add(infoArray[i].getName());
            }
        }
        return arrayList;
    }

    public Mixer getMixer(String string) {
        Mixer.Info[] infoArray;
        Mixer mixer = null;
        if (string != null && (infoArray = AudioSystem.getMixerInfo()) != null) {
            for (int i = 0; i < infoArray.length; ++i) {
                if (!infoArray[i].getName().equals(string)) continue;
                mixer = AudioSystem.getMixer(infoArray[i]);
                break;
            }
        }
        return mixer;
    }

    public String getMixerName() {
        return this.m_mixerName;
    }

    public void setMixerName(String string) {
        this.m_mixerName = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

