/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public final class BenutzerAktie
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1997061300002L;
    public static final long VALUE_MISSING = 0L;
    public static final long VALUE_ERROR = -1L;
    public static final long VALUE_NA = -2L;
    public static final int HTMLCOLS = 12;
    private static final String STR_MISSING = "<aktualisieren>";
    private static final String STR_ERROR = "<Fehler>";
    private static final String STR_NA = "n/a";
    private static final String STR_CURRENCY = "<W\u00e4hrung?>";
    private static final String STR_1JAHR = "<1 J.";
    private static final String STR_DIVIDENDE = "D+";
    private static final String STR_SPACE = "  ";
    private static final long FONDSANTEILE = 10000L;
    private static final int HEADROWS = 2;
    private static final int ZEILENABSTAND = 0;
    private static final int HEADERABSTAND = 3;
    private static final int FOOTERABSTAND = 3;
    private static final int X_NAME = 0;
    private static final int X_STUECKZAHL = 1;
    private static final int X_DIVIDENDE = 2;
    private static final int X_KAUFKURS = 3;
    private static final int X_WARNING = 4;
    private static final int X_AKTKURS = 5;
    private static final int X_KURSDATUM = 6;
    private static final int X_ARROW = 7;
    private static final int X_AKTWERT = 8;
    private static final int X_DIFFERENZ = 9;
    private static final int X_LAUFZEIT = 10;
    private static final int X_PABSOLUT = 11;
    private static final int X_PJAHR = 12;
    private static final int X_KAUFDATUM = 13;
    private static final int X_WKNBOERSE = 14;
    private static final int X_LEN = 15;
    private static final int X_KURSSTART = 4;
    private static final int X_KURSLEN = 2;
    private static ADate heute = new ADate();
    private static transient long aktsumme = 0L;
    private static transient long kaufsumme = 0L;
    private static transient long difsteuer = 0L;
    private static transient long diffrei = 0L;
    private static transient long dividenden = 0L;
    private static transient Label lupdate = null;
    private static transient Color farbeHintergrund;
    private static transient int konfigspekfrist;
    private transient Color farbeSteuerfrei;
    private transient Color farbeName;
    private transient Color farbeSelected;
    private transient boolean selected = false;
    private transient AktieInfo infodialog = null;
    private transient BALabel l1;
    private transient BALabel l2;
    private transient BALabel l3;
    private transient BALabel l4;
    private transient BALabel l5;
    private transient BALabel l6;
    private transient BALabel l7;
    private transient BALabel l8;
    private transient BALabel l9;
    private transient BALabel l10;
    private transient BALabel l11;
    private transient BALabel l12;
    private transient BALabel l15;
    private transient BAImageArrowCanvas l13;
    private transient BAImageWarnCanvas l14;
    private String name;
    private String wkn;
    private String kursdatum;
    private String isin;
    private Boersenplatz boersenplatz;
    private ADate kaufdatum;
    private ADate steuerfrei;
    private long kaufkurs;
    private long hochkurs;
    private long tiefkurs;
    private long gewinngrenze;
    private long prozgrenze;
    private long stueckzahl;
    private long kurs = 0L;
    private long vortageskurs = 0L;
    private long eroeffnungskurs = 0L;
    private long hoechstkurs = 0L;
    private long tiefstkurs = 0L;
    private long handelsvolumen = 0L;
    private long dividende = 0L;
    private ADate divdate = null;
    private ADate fixDate = null;
    private ADate watchstart = null;
    private long watchhoechst = 0L;
    private long watchtiefst = 0L;
    private String watchhdate = null;
    private String watchtdate = null;
    private int watchwaehrung = 0;
    private String symbol = null;
    private int waehrung = 0;
    private int kurswaehrung = 0;
    private int spekulationsfrist = 12;
    private int oldWarnType = -1;
    private boolean nurdiese = false;
    private boolean usegrenze = true;
    private boolean watchonly = false;
    private boolean dontUpdate = false;

    public BenutzerAktie(String string, String string2, Boersenplatz boersenplatz, boolean bl, ADate aDate, long l, long l2, long l3, long l4, long l5, int n, boolean bl2, boolean bl3) {
        this.name = string;
        this.wkn = string2;
        this.kaufdatum = aDate;
        this.kaufkurs = l;
        this.hochkurs = l3;
        this.tiefkurs = l4;
        this.waehrung = n;
        this.nurdiese = bl;
        this.usegrenze = bl2;
        this.watchonly = bl3;
        this.prozgrenze = l5;
        this.boersenplatz = boersenplatz;
        this.setStueckzahl(l2);
        this.setSymbol(null);
        this.kursdatum = "";
        this.isin = "";
        this.spekulationsfrist = 12;
        this.setupValues();
        this.setColors();
    }

    private BenutzerAktie() {
        this.usegrenze = false;
        this.setColors();
    }

    public synchronized Object clone() {
        BenutzerAktie benutzerAktie;
        try {
            benutzerAktie = (BenutzerAktie)super.clone();
        }
        catch (Exception exception) {
            benutzerAktie = null;
        }
        return benutzerAktie;
    }

    public synchronized void destroy() {
        this.infoDialogClose();
    }

    private void setupValues() {
        this.gewinngrenzeBerechnen();
        this.steuerfreiBerechnen();
    }

    private synchronized void gewinngrenzeBerechnen() {
        this.gewinngrenze = this.prozgrenze == 0L ? 0L : this.getKaufkurs() * (10000L + this.prozgrenze) / 10000L;
    }

    private synchronized void steuerfreiBerechnen() {
        int n;
        int n2;
        int n3;
        if (this.kaufdatum == null) {
            this.kaufdatum = new ADate();
        }
        if (this.spekulationsfrist == 12) {
            n3 = this.kaufdatum.getYear() + 1;
            n2 = this.kaufdatum.getMonth();
            n = this.kaufdatum.getDay() + 1;
            if (n > ADate.getDays(n3, n2)) {
                n = 1;
                if (++n2 > 12) {
                    n2 = 1;
                    ++n3;
                }
            }
        } else {
            n3 = this.kaufdatum.getYear();
            n2 = this.kaufdatum.getMonth() + 6;
            n = this.kaufdatum.getDay() + 1;
            if (n2 > 12) {
                n2 -= 12;
                ++n3;
            }
            if (n > ADate.getDays(n3, n2)) {
                n = 1;
                if (++n2 > 12) {
                    n2 = 1;
                    ++n3;
                }
            }
        }
        this.steuerfrei = new ADate(n3, n2, n);
    }

    private synchronized void checkSpekulationsfrist(int n) {
        if (this.spekulationsfrist != n) {
            this.spekulationsfrist = n;
            this.steuerfreiBerechnen();
        }
    }

    private void setColors() {
        this.farbeSteuerfrei = Color.yellow.darker().darker();
        this.farbeSelected = Color.lightGray;
        this.clearStatusRequesting();
    }

    public synchronized String getProzentString() {
        return this.prozgrenze == 0L ? "" : NumUtil.get00String(this.prozgrenze);
    }

    private String datum2String(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        if (bl) {
            string = "(" + string + ")";
        }
        return string;
    }

    public synchronized String getKursdatumString() {
        return this.datum2String(this.kursdatum, true);
    }

    public synchronized String getKursdatumRawString() {
        return this.datum2String(this.kursdatum, false);
    }

    public synchronized String getFixedDateString() {
        return this.fixDate == null ? this.kursdatum : this.fixDate.toString();
    }

    public synchronized ADate getFixedDate() {
        return this.fixDate == null ? heute : this.fixDate;
    }

    public synchronized long getHochkurs() {
        return this.hochkurs;
    }

    public synchronized String getHochkursString() {
        return this.getHochkurs() == 0L ? "" : NumUtil.get00String(this.getHochkurs());
    }

    public synchronized long getTiefkurs() {
        return this.tiefkurs;
    }

    public synchronized String getTiefkursString() {
        return this.getTiefkurs() == 0L ? "" : NumUtil.get00String(this.getTiefkurs());
    }

    public synchronized ADate getKaufdatum() {
        return this.kaufdatum == null ? new ADate() : this.kaufdatum;
    }

    public synchronized String getISIN() {
        return this.isin == null ? "" : this.isin;
    }

    public synchronized String getWKNString() {
        return this.wkn;
    }

    public synchronized boolean hasWKN(String string) {
        return this.wkn.equalsIgnoreCase(string);
    }

    public synchronized void setSymbol(String string) {
        if (string == null) {
            this.symbol = null;
            return;
        }
        if ((string = string.trim()).length() == 0) {
            this.symbol = null;
            return;
        }
        this.symbol = string;
    }

    public synchronized String getSymbol() {
        return this.symbol == null ? "" : this.symbol;
    }

    public synchronized boolean isBoerseFixed() {
        return this.nurdiese;
    }

    public synchronized boolean isFonds() {
        return this.boersenplatz.isFondsOnly();
    }

    public synchronized boolean doUseGrenze() {
        return this.usegrenze;
    }

    public synchronized boolean nurBeobachten() {
        return this.watchonly;
    }

    public synchronized boolean doNotUpdate() {
        return this.dontUpdate;
    }

    public synchronized long getVortageskurs() {
        return this.vortageskurs;
    }

    public synchronized String getVortageskursString() {
        return this.kurs2String(this.getVortageskurs(), this.getKurswaehrung());
    }

    public synchronized String getEroeffnungskursString() {
        return this.kurs2String(this.eroeffnungskurs, this.getKurswaehrung());
    }

    public synchronized String getHoechstkursString() {
        return this.kurs2String(this.hoechstkurs, this.getKurswaehrung());
    }

    public synchronized String getTiefstkursString() {
        return this.kurs2String(this.tiefstkurs, this.getKurswaehrung());
    }

    public synchronized String getHandelsvolumenString() {
        return String.valueOf(this.handelsvolumen);
    }

    public synchronized String getWatchStartString() {
        if (this.watchstart == null) {
            return "";
        }
        return this.watchstart.toString();
    }

    public synchronized String getWatchHoechstString() {
        return this.kurs2String(this.watchhoechst, this.watchwaehrung);
    }

    public synchronized String getWatchHoechstDatumString() {
        return this.datum2String(this.watchhdate, true);
    }

    public synchronized String getWatchTiefstString() {
        return this.kurs2String(this.watchtiefst, this.watchwaehrung);
    }

    public synchronized String getWatchTiefstDatumString() {
        return this.datum2String(this.watchtdate, true);
    }

    public synchronized int getWKN() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getWKNString());
        }
        catch (Exception exception) {}
        return n;
    }

    public synchronized String getBoerse() {
        return this.boersenplatz.getKurz();
    }

    public synchronized String getBoerse(String string) {
        if (this.isBoerseFixed() || string == null) {
            return this.getBoerse();
        }
        if (string.length() == 0 || this.isFonds()) {
            return this.getBoerse();
        }
        return string;
    }

    public synchronized String getRequest() {
        return this.getRequest("");
    }

    public synchronized String getRequest(String string) {
        return String.valueOf(this.getRequestWKN()) + this.getBoerse(string);
    }

    public synchronized String getRequestWKN() {
        String string = this.getSymbol();
        if (string.length() == 0) {
            string = this.getWKNString();
        }
        return String.valueOf(string) + ".";
    }

    public synchronized String getName(boolean bl) {
        if (this.name.length() == 0) {
            return this.getKurs() < 0L ? STR_ERROR : STR_MISSING;
        }
        return bl ? Aktienname.getKurzName(this.name) : this.name;
    }

    public synchronized int getKaufwaehrung() {
        return this.waehrung;
    }

    public synchronized int getKurswaehrung() {
        return this.kurswaehrung;
    }

    public synchronized long getStueckzahl() {
        return this.stueckzahl;
    }

    public synchronized String getStueckzahlString() {
        return String.valueOf(this.getStueckzahl());
    }

    public synchronized void decStueckzahl(long l) {
        if (l > 0L) {
            this.setStueckzahl(this.getStueckzahl() - l);
        }
    }

    public synchronized void setStueckzahl(long l) {
        this.stueckzahl = l < 0L ? 0L : l;
    }

    public synchronized long getKurs() {
        return this.kurs;
    }

    public synchronized String getRawVerkaufsKursString() {
        if (this.getKurs() <= 0L) {
            return "0";
        }
        return NumUtil.get00String(Waehrungen.exchange(this.getKurs(), this.getKurswaehrung(), Waehrungen.getVerkaufsWaehrung()));
    }

    private String kurs2String(long l, int n, int n2) {
        if (l == 0L) {
            return STR_MISSING;
        }
        if (l == -2L) {
            return STR_NA;
        }
        if (l <= -1L) {
            return STR_ERROR;
        }
        if (!Waehrungen.isValid(n)) {
            return STR_CURRENCY;
        }
        return Waehrungen.getString(Waehrungen.exchange(l, n, n2), n2);
    }

    private String kurs2String(long l, int n) {
        return this.kurs2String(l, n, Waehrungen.getListenWaehrung());
    }

    public synchronized String getKursString() {
        return this.kurs2String(this.getKurs(), this.getKurswaehrung());
    }

    public synchronized String getOnlineKursString() {
        if (this.getKurs() <= 0L) {
            return null;
        }
        if (this.getKurswaehrung() == -1) {
            return null;
        }
        if (this.getKurswaehrung() == Waehrungen.getListenWaehrung()) {
            return null;
        }
        return "Online-W\u00e4hrung ist " + Waehrungen.index2Id(this.getKurswaehrung()) + ", akt. Kurs: " + Waehrungen.getString(this.getKurs(), this.getKurswaehrung());
    }

    public synchronized long getWert() {
        if (this.getKurs() < 0L) {
            return 0L;
        }
        if (this.nurBeobachten()) {
            return Waehrungen.exchange(this.getKurs(), this.getKurswaehrung(), Waehrungen.getListenWaehrung());
        }
        return Waehrungen.exchange(this.getKurs(), this.getKurswaehrung(), Waehrungen.getListenWaehrung()) * this.getStueckzahl();
    }

    public synchronized long getKaufkurs() {
        return this.kaufkurs;
    }

    public synchronized String getKaufkursString() {
        return this.kurs2String(this.getKaufkurs(), this.getKaufwaehrung());
    }

    public synchronized long getDividende() {
        return this.dividende;
    }

    public synchronized String getDividendeString() {
        return this.getDividende() == 0L ? "" : NumUtil.get00String(this.getDividende());
    }

    public synchronized String getDividendeDatum() {
        return this.divdate == null ? "" : this.divdate.toString();
    }

    private synchronized void setDividende(long l, ADate aDate) {
        this.dividende = l < 0L ? 0L : l;
        this.divdate = aDate;
    }

    private synchronized boolean hasDividende() {
        if (this.divdate == null) {
            return false;
        }
        if (this.nurBeobachten()) {
            return false;
        }
        if (this.getDividende() <= 0L) {
            return false;
        }
        if (this.getKaufdatum().after(this.divdate)) {
            return false;
        }
        return heute.before(this.divdate) ^ true;
    }

    public synchronized boolean isEqual(String string, String string2, boolean bl) {
        return this.isEqual(string, "", string2, bl);
    }

    public synchronized boolean isEqual(String string, String string2, String string3, boolean bl) {
        if (bl) {
            return this.isEqual(string, string2, string3);
        }
        return this.isEqual(string, string2);
    }

    private synchronized boolean isEqual(String string, String string2, String string3) {
        boolean bl = string2.length() == 0 ? false : string2.equalsIgnoreCase(this.getWKNString());
        return (bl || string.equalsIgnoreCase(this.getWKNString())) && string3.equalsIgnoreCase(this.getBoerse());
    }

    private synchronized boolean isEqual(String string, String string2) {
        boolean bl = string2.length() == 0 ? false : string2.equalsIgnoreCase(this.getWKNString());
        return bl || string.equalsIgnoreCase(this.getWKNString());
    }

    public synchronized boolean istSteuerfrei() {
        return false;
    }

    public synchronized void setValues(long l) {
        this.setValues("", l);
    }

    public synchronized void setValues(String string, long l) {
        this.setValues(string, null, l, "", -2L, -2L, -2L, -2L, 0L, this.getKurswaehrung());
    }

    public synchronized void setValues(String string, String string2, long l, String string3, long l2, long l3, long l4, long l5, long l6, int n) {
        if (!this.doNotUpdate()) {
            if (string.length() > 0 && (this.name.length() == 0 || BenutzerListe.useOnlineNames())) {
                this.name = string;
            }
            if (ISIN.isValid(string2)) {
                this.isin = string2;
            }
            this.kurswaehrung = n;
            this.kurs = l;
            this.kursdatum = string3;
            this.vortageskurs = l2;
            this.eroeffnungskurs = l3;
            this.hoechstkurs = l4;
            this.tiefstkurs = l5;
            this.handelsvolumen = l6;
            if (this.kaufkurs == 0L && this.nurBeobachten() && l > 0L) {
                this.kaufkurs = l;
                this.kaufdatum = new ADate();
                this.waehrung = n;
                this.setupValues();
            }
            if (l > 0L && this.watchstart == null) {
                this.watchstart = new ADate();
            }
            if (n != this.watchwaehrung) {
                this.watchhoechst = Waehrungen.exchange(this.watchhoechst, this.watchwaehrung, n);
                this.watchtiefst = Waehrungen.exchange(this.watchtiefst, this.watchwaehrung, n);
                this.watchwaehrung = n;
            }
            if (l4 > 0L && (l4 > this.watchhoechst || this.watchhoechst == 0L)) {
                this.watchhoechst = l4;
                this.watchhdate = string3;
            }
            if (l5 > 0L && (l5 < this.watchtiefst || this.watchtiefst == 0L)) {
                this.watchtiefst = l5;
                this.watchtdate = string3;
            }
        }
        this.clearStatusRequesting();
        this.infoDialogSetValues(true);
    }

    public synchronized void changeValues(String string, String string2, Boersenplatz boersenplatz, boolean bl, ADate aDate, long l, long l2, long l3, long l4, long l5, int n, boolean bl2, boolean bl3, boolean bl4, long l6, ADate aDate2, long l7, ADate aDate3) {
        boolean bl5 = !string2.equalsIgnoreCase(this.getWKNString()) || !boersenplatz.getKurz().equalsIgnoreCase(this.getBoerse());
        this.name = string;
        this.wkn = string2;
        this.boersenplatz = boersenplatz;
        this.nurdiese = bl;
        this.kaufdatum = aDate;
        this.kaufkurs = l;
        this.hochkurs = l3;
        this.tiefkurs = l4;
        this.prozgrenze = l5;
        this.usegrenze = bl2;
        this.watchonly = bl3;
        this.dontUpdate = bl4;
        this.waehrung = n;
        this.fixDate = aDate2;
        this.setStueckzahl(l2);
        this.setSymbol(null);
        this.setDividende(l7, aDate3);
        this.setupValues();
        if (this.dontUpdate) {
            this.fixAktie(this.fixDate, l6, this.getKaufwaehrung());
        } else if (bl5) {
            this.kurs = 0L;
            this.kursdatum = "";
        }
        this.infoDialogSetValues(true);
    }

    public synchronized void changeKaufkurs(long l, int n, ADate aDate) {
        if (l > 0L) {
            this.kaufkurs = l;
            this.kaufdatum = aDate;
            this.waehrung = n;
            this.setupValues();
            this.infoDialogSetValues(true);
        }
    }

    public synchronized void split(double d) {
        if (d > 1.0) {
            this.setStueckzahl((long)((double)this.getStueckzahl() * d));
            this.kaufkurs = Math.round((double)this.getKaufkurs() / d);
            this.hochkurs = Math.round((double)this.getHochkurs() / d);
            this.tiefkurs = Math.round((double)this.getTiefkurs() / d);
            this.kurs = 0L;
            this.kursdatum = "";
            this.vortageskurs = 0L;
            this.eroeffnungskurs = 0L;
            this.hoechstkurs = 0L;
            this.tiefstkurs = 0L;
            this.watchhoechst = 0L;
            this.watchtiefst = 0L;
            this.watchhdate = null;
            this.watchtdate = null;
            this.watchstart = null;
        }
    }

    public synchronized void fixAktie(ADate aDate, long l, int n) {
        this.dontUpdate = true;
        this.fixDate = aDate;
        if (l > 0L) {
            this.kurs = Waehrungen.exchange(l, n, this.getKurswaehrung());
            this.kursdatum = this.fixDate != null ? this.fixDate.toString() : "";
        }
    }

    public synchronized void setStatusRequestingAndRepaint() {
        this.farbeName = Color.blue;
        this.l1.setForeground(this.farbeName);
        this.l1.repaint();
    }

    public synchronized void setStatusErrorAndRepaint() {
        this.farbeName = Color.red;
        this.l1.setForeground(this.farbeName);
        this.l1.repaint();
    }

    public synchronized void clearStatusRequesting() {
        this.farbeName = Color.black;
    }

    public synchronized boolean isSelected() {
        return this.selected;
    }

    private synchronized void setColorAndRepaint(Color color) {
        this.l1.setBackground(color);
        this.l15.setBackground(color);
        this.l14.setBackground(color);
        this.l2.setBackground(color);
        this.l11.setBackground(color);
        this.l12.setBackground(color);
        this.l13.setBackground(color);
        this.l3.setBackground(color);
        this.l4.setBackground(color);
        this.l5.setBackground(color);
        this.l6.setBackground(color);
        this.l7.setBackground(color);
        this.l8.setBackground(color);
        this.l9.setBackground(color);
        this.l10.setBackground(color);
        this.l1.repaint();
        this.l15.repaint();
        this.l14.repaint();
        this.l2.repaint();
        this.l11.repaint();
        this.l12.repaint();
        this.l13.repaint();
        this.l3.repaint();
        this.l4.repaint();
        this.l5.repaint();
        this.l6.repaint();
        this.l7.repaint();
        this.l8.repaint();
        this.l9.repaint();
        this.l10.repaint();
    }

    public synchronized void Select() {
        if (!this.isSelected()) {
            this.selected = true;
            this.setColorAndRepaint(this.farbeSelected);
        }
    }

    public synchronized void Unselect() {
        if (this.isSelected()) {
            this.selected = false;
            this.setColorAndRepaint(farbeHintergrund);
        }
    }

    public synchronized void Toggle() {
        if (this.isSelected()) {
            this.Unselect();
        } else {
            this.Select();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setColors();
    }

    public synchronized void saveCSV(BufferedWriter bufferedWriter, boolean bl, boolean bl2) {
        long l = Waehrungen.exchange(this.getKurs(), this.getKurswaehrung(), Waehrungen.getListenWaehrung());
        long l2 = this.doNotUpdate() && this.fixDate != null ? (long)(this.fixDate.getSerialDate() - this.getKaufdatum().getSerialDate()) : (long)(heute.getSerialDate() - this.getKaufdatum().getSerialDate());
        try {
            long l3;
            long l4;
            bufferedWriter.write("\"" + this.getName(bl) + "\";");
            if (!this.nurBeobachten()) {
                bufferedWriter.write(this.getStueckzahlString());
            }
            bufferedWriter.write(";");
            long l5 = Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung());
            if (l5 > 0L) {
                bufferedWriter.write(String.valueOf((double)l5 / 100.0).replace('.', ','));
            }
            bufferedWriter.write(";");
            if (l > 0L) {
                bufferedWriter.write(String.valueOf((double)l / 100.0).replace('.', ','));
            }
            bufferedWriter.write(";");
            if (this.kursdatum != null && this.kursdatum.length() > 0) {
                bufferedWriter.write("\"(" + this.kursdatum + ")\"");
            }
            bufferedWriter.write(";");
            if (l5 > 0L && l > 0L && !this.nurBeobachten()) {
                bufferedWriter.write(String.valueOf((double)this.getWert() / 100.0).replace('.', ','));
            }
            bufferedWriter.write(";");
            if (l5 > 0L && l > 0L) {
                l4 = this.nurBeobachten() ? 1L : this.getStueckzahl();
                l3 = this.getWert() - l4 * Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung());
                bufferedWriter.write(String.valueOf((double)l3 / 100.0).replace('.', ','));
            }
            bufferedWriter.write(";");
            l4 = 0L;
            if (l > 0L) {
                try {
                    l3 = l4 = l * 10000L / Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) - 10000L;
                    if (l3 > 0L) {
                        l3 += 5L;
                    } else if (l3 < 0L) {
                        l3 -= 5L;
                    }
                    bufferedWriter.write(String.valueOf((double)(l3 /= 10L) / 10.0).replace('.', ','));
                }
                catch (Exception exception) {}
            }
            bufferedWriter.write(";");
            if ((bl2 || l2 >= 360L) && l > 0L) {
                if ((l4 = l4 * 360L / (l2 + 1L)) > 0L) {
                    l4 += 5L;
                } else if (l4 < 0L) {
                    l4 -= 5L;
                }
                bufferedWriter.write(String.valueOf((double)(l4 /= 10L) / 10.0).replace('.', ','));
            }
            bufferedWriter.write(";");
            bufferedWriter.write(String.valueOf(this.getKaufdatum().toString()) + ";");
            bufferedWriter.write("\"" + this.getISIN() + "\";");
            bufferedWriter.write("\"" + this.getWKNString() + "\";");
            bufferedWriter.write("\"" + this.getBoerse() + "\"");
            bufferedWriter.newLine();
        }
        catch (Exception exception) {}
    }

    public synchronized void saveHTML(BufferedWriter bufferedWriter, boolean bl, boolean bl2, boolean bl3) {
        long l = Waehrungen.exchange(this.getKurs(), this.getKurswaehrung(), Waehrungen.getListenWaehrung());
        long l2 = 0L;
        String string = this.getKursString();
        long l3 = this.doNotUpdate() && this.fixDate != null ? (long)(this.fixDate.getSerialDate() - this.getKaufdatum().getSerialDate()) : (long)(heute.getSerialDate() - this.getKaufdatum().getSerialDate());
        try {
            long l4;
            String string2;
            bufferedWriter.write("<TR>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"left\">");
            bufferedWriter.write(HTMLUtil.toHTML(this.getName(bl)));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            if (this.nurBeobachten()) {
                bufferedWriter.write("&nbsp;");
            } else {
                bufferedWriter.write(HTMLUtil.toHTML(this.getStueckzahlString()));
            }
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (this.hasDividende()) {
                dividenden += Waehrungen.exchange(this.getDividende(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) * this.getStueckzahl();
            }
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            String string3 = this.getKaufkursString();
            if (this.nurBeobachten() && this.getKaufkurs() > 0L) {
                string3 = "(" + string3 + ")";
            }
            bufferedWriter.write(HTMLUtil.toNbspHTML(string3));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (l > 0L && !this.nurBeobachten()) {
                l2 = Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) * this.getStueckzahl();
                kaufsumme += l2;
            }
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(string));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            string3 = this.kursdatum != null ? this.kursdatum : "";
            bufferedWriter.write("  <TD ALIGN=\"center\">");
            bufferedWriter.write(HTMLUtil.toHTML(string3));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (this.nurBeobachten()) {
                string2 = " ";
            } else if (l > 0L) {
                l4 = this.getWert();
                string2 = Waehrungen.getString(l4, Waehrungen.getListenWaehrung());
                aktsumme += l4;
                l2 = l4 - l2;
            } else {
                string2 = string;
            }
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(string2));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (l > 0L) {
                if (this.nurBeobachten()) {
                    string2 = "(" + Waehrungen.getString(l - Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()), Waehrungen.getListenWaehrung()) + ")";
                } else {
                    string2 = Waehrungen.getString(l2, Waehrungen.getListenWaehrung());
                    if (this.istSteuerfrei()) {
                        diffrei += l2;
                    } else {
                        difsteuer += l2;
                    }
                }
            } else {
                string2 = string;
            }
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(string2));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            if (bl2 && this.istSteuerfrei() && !this.nurBeobachten()) {
                bufferedWriter.write("steuerfrei");
            } else {
                bufferedWriter.write(HTMLUtil.toHTML(this.getLaufzeitMonateString()));
            }
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (l > 0L) {
                try {
                    long l5 = l4 = l * 10000L / Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) - 10000L;
                    if (l5 > 0L) {
                        l5 += 5L;
                    } else if (l5 < 0L) {
                        l5 -= 5L;
                    }
                    string2 = String.valueOf((double)(l5 /= 10L) / 10.0);
                    if (l4 > 0L) {
                        string2 = "+" + string2;
                    }
                }
                catch (Exception exception) {
                    l4 = 0L;
                    string2 = STR_NA;
                }
            } else {
                l4 = 0L;
                string2 = string;
            }
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toHTML(string2));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (bl3 || l3 >= 360L) {
                if (l > 0L) {
                    if ((l4 = l4 * 360L / (l3 + 1L)) > 0L) {
                        l4 += 5L;
                    } else if (l4 < 0L) {
                        l4 -= 5L;
                    }
                    string2 = String.valueOf((double)(l4 /= 10L) / 10.0);
                    if (l4 > 0L) {
                        string2 = "+" + string2;
                    }
                } else {
                    l4 = 0L;
                    string2 = string;
                }
            } else {
                string2 = STR_1JAHR;
            }
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(string2));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toHTML(this.getKaufdatum().toString()));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"center\">");
            bufferedWriter.write(String.valueOf(HTMLUtil.toHTML(this.getWKNString())) + " " + HTMLUtil.toHTML(this.getBoerse()));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("</TR>");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        catch (Exception exception) {}
    }

    public static synchronized void saveHeaderHTML(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write("<TR>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD COLSPAN=\"12\">");
            bufferedWriter.write(HTMLUtil.toHTML(string));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("</TR>");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("<TR>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"left\">");
            bufferedWriter.write("Aktienname");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("St&uuml;ck");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("Kaufkurs");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\" COLSPAN=\"2\">");
            bufferedWriter.write("akt. Kurs");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("akt. Wert");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("Differenz");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("Laufzeit");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("%<BR>absolut");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("%<BR>Jahr");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("Kaufdatum");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TH ALIGN=\"center\">");
            bufferedWriter.write("WKN B&ouml;rse");
            bufferedWriter.write("</TH>");
            bufferedWriter.newLine();
            bufferedWriter.write("</TR>");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        catch (Exception exception) {}
        heute = new ADate();
        kaufsumme = 0L;
        aktsumme = 0L;
        difsteuer = 0L;
        diffrei = 0L;
        dividenden = 0L;
    }

    public static synchronized void saveFooterHTML(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<TR>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD COLSPAN=\"2\" ALIGN=\"right\">Summe Kaufwert:</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(Waehrungen.getString(kaufsumme, Waehrungen.getListenWaehrung())));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD COLSPAN=\"2\" ALIGN=\"right\">Summe aktuell:</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(Waehrungen.getString(aktsumme, Waehrungen.getListenWaehrung())));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD COLSPAN=\"6\">&nbsp;</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("</TR>");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("<TR>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD COLSPAN=\"6\" ALIGN=\"right\">Differenz zum Kaufwert:</TD>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <TD ALIGN=\"right\">");
            bufferedWriter.write(HTMLUtil.toNbspHTML(Waehrungen.getString(aktsumme - kaufsumme, Waehrungen.getListenWaehrung())));
            bufferedWriter.write("</TD>");
            bufferedWriter.newLine();
            if (kaufsumme > 0L) {
                bufferedWriter.write("  <TD COLSPAN=\"2\" ALIGN=\"right\">");
                long l = aktsumme * 10000L / kaufsumme - 10000L;
                if (l > 0L) {
                    l += 5L;
                } else if (l < 0L) {
                    l -= 5L;
                }
                String string = String.valueOf((double)(l /= 10L) / 10.0);
                if (l > 0L) {
                    string = "+" + string;
                }
                bufferedWriter.write(HTMLUtil.toNbspHTML(string));
                bufferedWriter.write("</TD>");
                bufferedWriter.newLine();
                bufferedWriter.write("  <TD COLSPAN=\"3\">&nbsp;</TD>");
                bufferedWriter.newLine();
            } else {
                bufferedWriter.write("  <TD COLSPAN=\"5\">&nbsp;</TD>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</TR>");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            if (dividenden > 0L) {
                bufferedWriter.write("<TR>");
                bufferedWriter.newLine();
                bufferedWriter.write("  <TD COLSPAN=\"6\" ALIGN=\"right\">Dividenden:</TD>");
                bufferedWriter.newLine();
                bufferedWriter.write("  <TD ALIGN=\"right\">");
                bufferedWriter.write(HTMLUtil.toNbspHTML(Waehrungen.getString(dividenden, Waehrungen.getListenWaehrung())));
                bufferedWriter.write("</TD>");
                bufferedWriter.newLine();
                bufferedWriter.write("  <TD COLSPAN=\"5\">&nbsp;</TD>");
                bufferedWriter.newLine();
                bufferedWriter.write("</TR>");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void saveXML(PrintWriter printWriter) {
        printWriter.println("<value type=\"basic\">");
        printWriter.println("<name>" + XMLUtil.escapeString(this.name) + "</name>");
        printWriter.println("<symbol>" + XMLUtil.escapeString(this.symbol) + "</symbol>");
        printWriter.println("<wkn>" + XMLUtil.escapeString(this.wkn) + "</wkn>");
        printWriter.println("<isin>" + XMLUtil.escapeString(this.isin) + "</isin>");
        printWriter.println("<stueckzahl>" + this.stueckzahl * 10000L + "</stueckzahl>");
        printWriter.println("<kaufkurs>" + this.kaufkurs + "</kaufkurs>");
        printWriter.println("<kaufdatum>" + (this.kaufdatum == null ? "" : this.kaufdatum.toTimestamp(true, true)) + "</kaufdatum>");
        printWriter.println("<steuerfrei>" + (this.steuerfrei == null ? "" : this.steuerfrei.toTimestamp(true, true)) + "</steuerfrei>");
        printWriter.println("<spekulationsfrist>" + this.spekulationsfrist + "</spekulationsfrist>");
        printWriter.println("<waehrung>" + Waehrungen.index2Id(this.waehrung) + "</waehrung>");
        printWriter.println("<kurswaehrung>" + Waehrungen.index2Id(this.kurswaehrung) + "</kurswaehrung>");
        printWriter.println("<boersenplatz>" + (this.boersenplatz == null ? "" : this.boersenplatz.getKurz()) + "</boersenplatz>");
        printWriter.println("<kurs>" + this.kurs + "</kurs>");
        printWriter.println("<kursdatum>" + XMLUtil.escapeString(this.kursdatum) + "</kursdatum>");
        printWriter.println("<fixDate>" + (this.fixDate == null ? "" : this.fixDate.toTimestamp(true, true)) + "</fixDate>");
        printWriter.println("<vortageskurs>" + this.vortageskurs + "</vortageskurs>");
        printWriter.println("<eroeffnungskurs>" + this.eroeffnungskurs + "</eroeffnungskurs>");
        printWriter.println("<hoechstkurs>" + this.hoechstkurs + "</hoechstkurs>");
        printWriter.println("<tiefstkurs>" + this.tiefstkurs + "</tiefstkurs>");
        printWriter.println("<handelsvolumen>" + this.handelsvolumen + "</handelsvolumen>");
        printWriter.println("<hochkurs>" + this.hochkurs + "</hochkurs>");
        printWriter.println("<tiefkurs>" + this.tiefkurs + "</tiefkurs>");
        printWriter.println("<gewinngrenze>" + this.gewinngrenze + "</gewinngrenze>");
        printWriter.println("<prozgrenze>" + this.prozgrenze + "</prozgrenze>");
        printWriter.println("<oldWarnType>" + this.oldWarnType + "</oldWarnType>");
        printWriter.println("<watchstart>" + (this.watchstart == null ? "" : this.watchstart.toTimestamp(true, true)) + "</watchstart>");
        printWriter.println("<watchhoechst>" + this.watchhoechst + "</watchhoechst>");
        printWriter.println("<watchtiefst>" + this.watchtiefst + "</watchtiefst>");
        printWriter.println("<watchhdate>" + XMLUtil.escapeString(this.watchhdate) + "</watchhdate>");
        printWriter.println("<watchtdate>" + XMLUtil.escapeString(this.watchtdate) + "</watchtdate>");
        printWriter.println("<watchwaehrung>" + Waehrungen.index2Id(this.watchwaehrung) + "</watchwaehrung>");
        printWriter.println("<dividende>" + this.dividende + "</dividende>");
        printWriter.println("<divdate>" + (this.divdate == null ? "" : this.divdate.toTimestamp(true, true)) + "</divdate>");
        if (this.nurdiese) {
            printWriter.println("<nurdiese />");
        }
        if (this.usegrenze) {
            printWriter.println("<usegrenze />");
        }
        if (this.watchonly) {
            printWriter.println("<watchonly />");
        }
        if (this.dontUpdate) {
            printWriter.println("<dontUpdate />");
        }
        printWriter.println("</value>");
        printWriter.println();
    }

    public static BenutzerAktie readXML(BufferedReader bufferedReader) throws Exception {
        String string = XMLUtil.nextDataLine(bufferedReader);
        BenutzerAktie benutzerAktie = new BenutzerAktie();
        while (!string.startsWith("</value")) {
            if (string.startsWith("<boersenplatz")) {
                benutzerAktie.boersenplatz = AktienMan.boersenliste.getBoerse(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<divdate")) {
                benutzerAktie.divdate = ADate.parseTimestamp(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<dividende")) {
                benutzerAktie.dividende = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<dontUpdate")) {
                benutzerAktie.dontUpdate = true;
            } else if (string.startsWith("<eroeffnungskurs")) {
                benutzerAktie.eroeffnungskurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<fixDate")) {
                benutzerAktie.fixDate = ADate.parseTimestamp(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<gewinngrenze")) {
                benutzerAktie.gewinngrenze = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<handelsvolumen")) {
                benutzerAktie.handelsvolumen = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<hochkurs")) {
                benutzerAktie.hochkurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<hoechstkurs")) {
                benutzerAktie.hoechstkurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<isin")) {
                benutzerAktie.isin = XMLUtil.unescapeString(XMLUtil.getValue(string, false));
            } else if (string.startsWith("<kaufdatum")) {
                benutzerAktie.kaufdatum = ADate.parseTimestamp(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<kaufkurs")) {
                benutzerAktie.kaufkurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<kursdatum")) {
                benutzerAktie.kursdatum = XMLUtil.unescapeString(XMLUtil.getValue(string, false));
            } else if (string.startsWith("<kurswaehrung")) {
                benutzerAktie.kurswaehrung = Waehrungen.id2Index(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<kurs")) {
                benutzerAktie.kurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<name")) {
                benutzerAktie.name = XMLUtil.unescapeString(XMLUtil.getValue(string, false));
            } else if (string.startsWith("<nurdiese")) {
                benutzerAktie.nurdiese = true;
            } else if (string.startsWith("<oldWarnType")) {
                benutzerAktie.oldWarnType = XMLUtil.getIntValue(string);
            } else if (string.startsWith("<prozgrenze")) {
                benutzerAktie.prozgrenze = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<spekulationsfrist")) {
                benutzerAktie.spekulationsfrist = XMLUtil.getIntValue(string);
            } else if (string.startsWith("<steuerfrei")) {
                benutzerAktie.steuerfrei = ADate.parseTimestamp(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<stueckzahl")) {
                benutzerAktie.stueckzahl = XMLUtil.getLongValue(string) / 10000L;
            } else if (string.startsWith("<symbol")) {
                benutzerAktie.symbol = XMLUtil.unescapeString(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<tiefkurs")) {
                benutzerAktie.tiefkurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<tiefstkurs")) {
                benutzerAktie.tiefstkurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<usegrenze")) {
                benutzerAktie.usegrenze = true;
            } else if (string.startsWith("<vortageskurs")) {
                benutzerAktie.vortageskurs = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<waehrung")) {
                benutzerAktie.waehrung = Waehrungen.id2Index(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<watchhdate")) {
                benutzerAktie.watchhdate = XMLUtil.unescapeString(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<watchhoechst")) {
                benutzerAktie.watchhoechst = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<watchonly")) {
                benutzerAktie.watchonly = true;
            } else if (string.startsWith("<watchstart")) {
                benutzerAktie.watchstart = ADate.parseTimestamp(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<watchtdate")) {
                benutzerAktie.watchtdate = XMLUtil.unescapeString(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<watchtiefst")) {
                benutzerAktie.watchtiefst = XMLUtil.getLongValue(string);
            } else if (string.startsWith("<watchwaehrung")) {
                benutzerAktie.watchwaehrung = Waehrungen.id2Index(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<wkn")) {
                benutzerAktie.wkn = XMLUtil.unescapeString(XMLUtil.getValue(string, false));
            }
            string = XMLUtil.nextDataLine(bufferedReader);
        }
        return benutzerAktie;
    }

    public static synchronized void addSummen(Panel panel, String string, String string2, String string3, boolean bl) {
        AFrame.constrain(panel, new Label("Summe aktuell:"), 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        AFrame.constrain(panel, new Label(string), 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 2, 0, 0);
        AFrame.constrain(panel, new Label("Differenz zum Kaufwert:"), 2, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 18, 0, 0);
        if (string3.length() > 0) {
            string2 = String.valueOf(string2) + "  (" + string3 + "%)";
        }
        Label label = new Label(string2);
        if (bl) {
            label.setForeground(Color.red);
        }
        AFrame.constrain(panel, label, 3, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 2, 0, 0);
    }

    public static synchronized void addFooterToPanel(Panel panel, int n, Panel panel2) {
        String string = Waehrungen.getString(aktsumme, Waehrungen.getListenWaehrung());
        AFrame.constrain(panel, new Label("Summe aktuell:", 2), 4, n, 4, 1, 2, 12, 1.0, 0.0, 3, 10, 0, 0);
        AFrame.constrain(panel, new Label(string, 2), 8, n, 1, 1, 2, 12, 1.0, 0.0, 3, 10, 0, 0);
        AFrame.constrain(panel, new Label("Summe Kaufwert:", 2), 0, n, 3, 1, 2, 12, 1.0, 0.0, 3, 10, 0, 0);
        AFrame.constrain(panel, new Label(Waehrungen.getString(kaufsumme, Waehrungen.getListenWaehrung()), 2), 3, n, 1, 1, 2, 12, 1.0, 0.0, 3, 10, 0, 0);
        int n2 = 9;
        int n3 = 4;
        int n4 = n2 - n3;
        AFrame.constrain(panel, new Label("Differenz zum Kaufwert:", 2), n3, n + 1, n4, 1, 2, 12, 1.0, 0.0, 0, 10, 0, 0);
        if (dividenden > 0L) {
            AFrame.constrain(panel, new Label("Dividenden:", 2), n3, n + 2, n4, 1, 2, 12, 1.0, 0.0, 0, 10, 0, 0);
            AFrame.constrain(panel, new Label(Waehrungen.getString(dividenden, Waehrungen.getListenWaehrung()), 2), n2, n + 2, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        }
        long l = aktsumme - kaufsumme;
        String string2 = Waehrungen.getString(l, Waehrungen.getListenWaehrung());
        Label label = new Label(STR_SPACE + string2, 2);
        if (l < 0L) {
            label.setForeground(Color.red);
        } else if (l > 0L) {
            label.setForeground(Color.green.darker());
        }
        AFrame.constrain(panel, label, n2, n + 1, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        String string3 = "";
        if (kaufsumme > 0L) {
            long l2 = aktsumme * 10000L / kaufsumme - 10000L;
            if (l2 > 0L) {
                l2 += 5L;
            } else if (l2 < 0L) {
                l2 -= 5L;
            }
            string3 = String.valueOf((double)(l2 /= 10L) / 10.0);
            if (l2 > 0L) {
                string3 = "+" + string3;
            }
            label = new Label(STR_SPACE + string3, 2);
            if (l2 > 0L) {
                label.setForeground(Color.green.darker());
            } else if (l2 < 0L) {
                label.setForeground(Color.red);
            }
            AFrame.constrain(panel, label, 11, n + 1, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        }
        BenutzerAktie.addSummen(panel2, string, string2, string3, (double)l < 0.0);
    }

    public static synchronized void setLastUpdateAndRepaint(String string) {
        if (lupdate != null) {
            lupdate.setText(string);
            lupdate.repaint();
        }
    }

    public static synchronized int addHeadingsToPanel(Panel panel, String string) {
        lupdate = new Label(string);
        AFrame.constrain(panel, lupdate, 0, 0, 15, 1, 2, 18, 1.0, 0.0, 0, 0, 2, 0);
        AFrame.constrain(panel, new Label(" Aktienname"), 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  St\u00fcck", 2), 1, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  Kaufkurs", 2), 3, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  akt. Kurs", 2), 4, 1, 2, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  akt. Wert", 2), 8, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  Differenz", 2), 9, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  Laufzeit", 2), 10, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  %absolut", 2), 11, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  %Jahr", 2), 12, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  Kaufdatum ", 2), 13, 1, 1, 1, 0, 12, 0.0, 0.0, 0, 0, 3, 0);
        AFrame.constrain(panel, new Label("  WKN.B\u00f6rse "), 14, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 3, 0);
        heute = new ADate();
        kaufsumme = 0L;
        aktsumme = 0L;
        difsteuer = 0L;
        diffrei = 0L;
        dividenden = 0L;
        farbeHintergrund = panel.getBackground();
        konfigspekfrist = 12;
        return 2;
    }

    private synchronized String getLaufzeitMonateString() {
        int n;
        int n2;
        int n3;
        ADate aDate = this.getKaufdatum();
        int n4 = aDate.getYear();
        int n5 = aDate.getMonth();
        int n6 = aDate.getDay();
        if (this.doNotUpdate() && this.fixDate != null) {
            n3 = this.fixDate.getYear();
            n2 = this.fixDate.getMonth();
            n = this.fixDate.getDay();
        } else {
            n3 = heute.getYear();
            n2 = heute.getMonth();
            n = heute.getDay();
        }
        int n7 = 0;
        int n8 = 0;
        if (n4 < n3) {
            if (n3 - n4 > 1) {
                n7 += (n3 - n4 - 1) * 12;
            }
            n7 += n2 - 1 + (12 - n5);
        } else if (n2 - n5 > 1) {
            n7 += n2 - n5 - 1;
        }
        if (n >= n6) {
            if (n5 != n2 || n3 > n4) {
                ++n7;
            }
            n8 += n - n6;
        } else {
            n8 += ADate.getDays(n4, n5) - n6 + n;
        }
        String string = String.valueOf(n8) + " T";
        if (n7 > 0) {
            string = String.valueOf(n7) + " M " + string;
        }
        if (this.istSteuerfrei() && !this.nurBeobachten()) {
            string = String.valueOf(string) + " (*)";
        }
        return string;
    }

    public synchronized long getAbsPercent() {
        long l;
        long l2 = this.getKurs();
        if (l2 > 0L) {
            try {
                l = l2 * 10000L / Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), this.getKurswaehrung()) - 10000L;
                if (l > 0L) {
                    l += 5L;
                } else if (l < 0L) {
                    l -= 5L;
                }
                l /= 10L;
            }
            catch (Exception exception) {
                l = 0L;
            }
        } else {
            l = 0L;
        }
        return l;
    }

    public synchronized long getAbsDiff() {
        if (this.getKurs() > 0L) {
            if (this.nurBeobachten()) {
                return this.getKurs() - Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung());
            }
            return this.getWert() - Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) * this.getStueckzahl();
        }
        return 0L;
    }

    public synchronized void addToPanel(Panel panel, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        long l;
        String string;
        boolean bl5;
        String string2;
        long l2 = Waehrungen.exchange(this.getKurs(), this.getKurswaehrung(), Waehrungen.getListenWaehrung());
        long l3 = 0L;
        int n2 = n - 2;
        String string3 = this.getKursString();
        long l4 = this.doNotUpdate() && this.fixDate != null ? (long)(this.fixDate.getSerialDate() - this.getKaufdatum().getSerialDate()) : (long)(heute.getSerialDate() - this.getKaufdatum().getSerialDate());
        this.checkSpekulationsfrist(konfigspekfrist);
        if (this.l1 == null) {
            this.l1 = new BALabel(" " + this.getName(bl), n2, 0);
        } else {
            this.l1.setValues(" " + this.getName(bl), n2);
        }
        if (this.doNotUpdate()) {
            this.l1.setForeground(Color.gray);
        } else {
            this.l1.setForeground(this.farbeName);
        }
        AFrame.constrain(panel, this.l1, 0, n, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
        String string4 = string2 = this.nurBeobachten() ? "" : this.getStueckzahlString();
        if (this.l3 == null) {
            this.l3 = new BALabel(STR_SPACE + string2, n2);
        } else {
            this.l3.setValues(STR_SPACE + string2, n2);
        }
        AFrame.constrain(panel, this.l3, 1, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (this.hasDividende()) {
            dividenden += Waehrungen.exchange(this.getDividende(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) * this.getStueckzahl();
            bl5 = true;
        } else {
            bl5 = false;
        }
        if (this.l15 == null) {
            this.l15 = new BALabel(bl5 ? "  D+" : "", n2, 0);
        } else {
            this.l15.setValues(bl5 ? "  D+" : "", n2);
        }
        this.l15.setForeground(Color.gray);
        AFrame.constrain(panel, this.l15, 2, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (this.l8 == null) {
            this.l8 = new BALabel(STR_SPACE + this.getKaufkursString(), n2);
        } else {
            this.l8.setValues(STR_SPACE + this.getKaufkursString(), n2);
        }
        if (l2 > 0L && !this.nurBeobachten()) {
            l3 = Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) * this.getStueckzahl();
            kaufsumme += l3;
        } else {
            this.l8.setForeground(Color.gray);
        }
        AFrame.constrain(panel, this.l8, 3, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        int n3 = 0;
        if (this.l2 == null) {
            this.l2 = new BALabel(STR_SPACE + string3, n2);
        } else {
            this.l2.setValues(STR_SPACE + string3, n2);
        }
        if (l2 > 0L) {
            if (this.getTiefkurs() > 0L && l2 <= Waehrungen.exchange(this.getTiefkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung())) {
                this.l2.setForeground(Color.red);
                n3 = 1;
            } else if (!this.doUseGrenze() && this.getHochkurs() > 0L && l2 >= Waehrungen.exchange(this.getHochkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung())) {
                this.l2.setForeground(Color.green.darker());
                n3 = 2;
            } else if (this.doUseGrenze() && this.gewinngrenze > 0L && l2 >= Waehrungen.exchange(this.gewinngrenze, this.getKaufwaehrung(), Waehrungen.getListenWaehrung())) {
                this.l2.setForeground(Color.green.darker());
                n3 = 2;
            }
        }
        this.l14 = new BAImageWarnCanvas(n2, n3, this.l8);
        AFrame.constrain(panel, this.l14, 4, n, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.checkWarn(n3);
        AFrame.constrain(panel, this.l2, 5, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (this.l11 == null) {
            this.l11 = new BALabel(" " + this.getKursdatumString(), n2);
        } else {
            this.l11.setValues(" " + this.getKursdatumString(), n2);
        }
        AFrame.constrain(panel, this.l11, 6, n, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
        this.l13 = new BAImageArrowCanvas(n2, l2, this.getVortageskurs(), this.getKurswaehrung(), this.l11);
        AFrame.constrain(panel, this.l13, 7, n, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
        if (this.nurBeobachten()) {
            string = "";
        } else if (l2 > 0L) {
            l = this.getWert();
            string = Waehrungen.getString(l, Waehrungen.getListenWaehrung());
            aktsumme += l;
            l3 = l - l3;
        } else {
            string = string3;
        }
        if (this.l4 == null) {
            this.l4 = new BALabel(STR_SPACE + string, n2);
        } else {
            this.l4.setValues(STR_SPACE + string, n2);
        }
        AFrame.constrain(panel, this.l4, 8, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (l2 > 0L) {
            if (this.nurBeobachten()) {
                string = Waehrungen.getString(l2 - Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()), Waehrungen.getListenWaehrung());
            } else {
                string = Waehrungen.getString(l3, Waehrungen.getListenWaehrung());
                if (this.istSteuerfrei()) {
                    diffrei += l3;
                } else {
                    difsteuer += l3;
                }
            }
        } else {
            string = string3;
        }
        if (this.l12 == null) {
            this.l12 = new BALabel(STR_SPACE + string, n2);
        } else {
            this.l12.setValues(STR_SPACE + string, n2);
        }
        if (this.nurBeobachten()) {
            this.l12.setForeground(Color.gray);
        } else if (l3 > 0L) {
            this.l12.setForeground(Color.green.darker());
        } else if (l3 < 0L) {
            this.l12.setForeground(Color.red);
        }
        AFrame.constrain(panel, this.l12, 9, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        boolean bl6 = bl4 = this.istSteuerfrei() && !this.nurBeobachten();
        if (this.l5 == null) {
            this.l5 = new BALabel();
        }
        if (bl2 && bl4) {
            this.l5.setValues("  steuerfrei", n2);
            this.l5.setForeground(this.farbeSteuerfrei);
        } else {
            this.l5.setValues(STR_SPACE + this.getLaufzeitMonateString(), n2);
            if (bl4) {
                this.l5.setForeground(this.farbeSteuerfrei);
            }
        }
        AFrame.constrain(panel, this.l5, 10, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (l2 > 0L) {
            try {
                long l5 = l = l2 * 10000L / Waehrungen.exchange(this.getKaufkurs(), this.getKaufwaehrung(), Waehrungen.getListenWaehrung()) - 10000L;
                if (l5 > 0L) {
                    l5 += 5L;
                } else if (l5 < 0L) {
                    l5 -= 5L;
                }
                string = String.valueOf((double)(l5 /= 10L) / 10.0);
                if (l > 0L) {
                    string = "+" + string;
                }
            }
            catch (Exception exception) {
                l = 0L;
                string = STR_NA;
            }
        } else {
            l = 0L;
            string = string3;
        }
        if (this.l6 == null) {
            this.l6 = new BALabel(STR_SPACE + string, n2);
        } else {
            this.l6.setValues(STR_SPACE + string, n2);
        }
        if (l > 0L) {
            this.l6.setForeground(Color.green.darker());
        } else if (l < 0L) {
            this.l6.setForeground(Color.red);
        }
        AFrame.constrain(panel, this.l6, 11, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (bl3 || l4 >= 360L) {
            if (l2 > 0L) {
                if ((l = l * 360L / (l4 + 1L)) > 0L) {
                    l += 5L;
                } else if (l < 0L) {
                    l -= 5L;
                }
                string = String.valueOf((double)(l /= 10L) / 10.0);
                if (l > 0L) {
                    string = "+" + string;
                }
            } else {
                l = 0L;
                string = string3;
            }
        } else {
            string = STR_1JAHR;
        }
        if (this.l7 == null) {
            this.l7 = new BALabel(STR_SPACE + string, n2);
        } else {
            this.l7.setValues(STR_SPACE + string, n2);
        }
        if (l4 < 360L) {
            this.l7.setForeground(Color.gray);
        } else if (l > 0L) {
            this.l7.setForeground(Color.green.darker());
        } else if (l < 0L) {
            this.l7.setForeground(Color.red);
        }
        AFrame.constrain(panel, this.l7, 12, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (this.l9 == null) {
            this.l9 = new BALabel(STR_SPACE + this.getKaufdatum().toString() + " ", n2);
        } else {
            this.l9.setValues(STR_SPACE + this.getKaufdatum().toString() + " ", n2);
        }
        if (this.nurBeobachten()) {
            this.l9.setForeground(Color.gray);
        }
        AFrame.constrain(panel, this.l9, 13, n, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        if (this.l10 == null) {
            this.l10 = new BALabel(STR_SPACE + this.getWKNString() + "." + this.getBoerse() + " ", n2, 0);
        } else {
            this.l10.setValues(STR_SPACE + this.getWKNString() + "." + this.getBoerse() + " ", n2);
        }
        AFrame.constrain(panel, this.l10, 14, n, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
        this.Unselect();
    }

    private void checkWarn(int n) {
        int n2 = KonfigurationWarnungen.getWarnType();
        if (this.oldWarnType != -1 && n != 0 && n2 != 0 && n != this.oldWarnType) {
            if (n2 == 2) {
                new BeepWarnalert((AFrame)AktienMan.hauptdialog, n, this.getName(true), this.getKursString());
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        this.oldWarnType = n;
    }

    public synchronized void infoDialogOpen() {
        if (this.infodialog == null) {
            this.infodialog = new AktieInfo(this);
            this.infoDialogSetValues(false);
            if (this.infodialog != null) {
                ((Component)this.infodialog).setVisible(true);
                AktienMan.hauptdialog.windowToFront(this.infodialog);
            }
        } else {
            this.infodialog.toFront();
        }
    }

    public synchronized void infoDialogSetValues(boolean bl) {
        if (this.infodialog != null) {
            this.infodialog.setValues(bl);
        }
    }

    public synchronized void infoDialogClose() {
        if (this.infodialog != null) {
            ((Component)this.infodialog).setVisible(false);
            this.infodialog.dispose();
            this.infodialog = null;
        }
    }

    public synchronized void infoDialogClosed() {
        this.infodialog = null;
    }
}

