/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class BenutzerListe
extends Vector
implements Serializable {
    static final long serialVersionUID = 1972011800002L;
    private static final int SORT_NONE = -1;
    private static final int SORT_NAME = 0;
    private static final int SORT_ABSPERC = 1;
    private static final int SORT_ABSDIFF = 2;
    private static final int SORT_KAUFDATUM = 3;
    private static final int SORT_FIXDATUM = 4;
    private ADate letzteAktualisierung = null;
    private String festeBoerse = null;
    private String kommentar = null;
    private long verkaufserloes = 0L;
    private int erloesWaehrung = 1;
    private int portfoliover = 0;
    private int sortBy = 0;
    private transient String portfolioFile = "";

    public BenutzerListe() {
        super(50);
    }

    public synchronized void destroy() {
        int n = 0;
        while (n < this.size()) {
            this.getAt(n).destroy();
            ++n;
        }
        this.removeAllElements();
    }

    public synchronized void setPortfolioFile(String string) {
        this.portfolioFile = string;
    }

    public synchronized String getPortfolioFile() {
        return this.portfolioFile;
    }

    public synchronized void add(BenutzerAktie benutzerAktie) {
        this.addElement(benutzerAktie);
    }

    public synchronized void removeAt(int n) {
        this.getAt(n).destroy();
        this.removeElementAt(n);
    }

    public synchronized BenutzerAktie getAt(int n) {
        return (BenutzerAktie)this.elementAt(n);
    }

    public synchronized void setDate(String string, String string2) {
        this.letzteAktualisierung = new ADate();
        this.festeBoerse = string;
        this.kommentar = string2;
    }

    public synchronized void clearDate() {
        this.letzteAktualisierung = null;
    }

    private synchronized ADate getDate() {
        return this.letzteAktualisierung;
    }

    public synchronized String getFesteBoerse() {
        return this.festeBoerse == null ? "" : this.festeBoerse;
    }

    private synchronized String getKommentar() {
        if (this.kommentar == null) {
            return "";
        }
        if (this.kommentar.length() == 0) {
            return "";
        }
        return " (" + this.kommentar + ")";
    }

    public synchronized String getDateString() {
        ADate aDate = this.getDate();
        String string = aDate == null ? " Bisher noch keine Aktualisierung." : " Letzte Aktualisierung am " + aDate.toString() + " um " + aDate.timeToString() + this.getKommentar() + ".";
        return string;
    }

    public synchronized long getErloes() {
        return this.verkaufserloes;
    }

    public synchronized void clearErloes() {
        this.verkaufserloes = 0L;
    }

    public synchronized void addToErloes(long l) {
        this.verkaufserloes += l;
    }

    public synchronized int getErloesWaehrung() {
        return this.erloesWaehrung;
    }

    public synchronized void erloesToWaehrung(int n) {
        this.verkaufserloes = Waehrungen.exchange(this.verkaufserloes, this.getErloesWaehrung(), n);
        this.erloesWaehrung = n;
    }

    public synchronized int getSortBy() {
        return this.sortBy;
    }

    public synchronized void setSortBy(int n) {
        this.sortBy = n;
    }

    public synchronized void sort(boolean bl) {
        switch (this.getSortBy()) {
            case 1: {
                this.sortByAbsPercent();
                break;
            }
            case 3: {
                this.sortByKaufdatum();
                break;
            }
            case 4: {
                this.sortByFixDatum();
                break;
            }
            case 2: {
                this.sortByAbsDiff();
                break;
            }
            default: {
                this.sortByName(bl);
            }
        }
    }

    private synchronized void sortByFixDatum() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            int n4 = this.getAt(n3).getFixedDate().getSerialDate();
            int n5 = n2 + 1;
            while (n5 < n) {
                if (this.getAt(n5).getFixedDate().getSerialDate() < n4) {
                    n3 = n5;
                    n4 = this.getAt(n3).getFixedDate().getSerialDate();
                }
                ++n5;
            }
            if (n3 != n2) {
                BenutzerAktie benutzerAktie = this.getAt(n2);
                this.setElementAt(this.getAt(n3), n2);
                this.setElementAt(benutzerAktie, n3);
            }
            ++n2;
        }
    }

    private synchronized void sortByKaufdatum() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            int n4 = this.getAt(n3).getKaufdatum().getSerialDate();
            int n5 = n2 + 1;
            while (n5 < n) {
                if (this.getAt(n5).getKaufdatum().getSerialDate() < n4) {
                    n3 = n5;
                    n4 = this.getAt(n3).getKaufdatum().getSerialDate();
                }
                ++n5;
            }
            if (n3 != n2) {
                BenutzerAktie benutzerAktie = this.getAt(n2);
                this.setElementAt(this.getAt(n3), n2);
                this.setElementAt(benutzerAktie, n3);
            }
            ++n2;
        }
    }

    private synchronized void sortByAbsDiff() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            long l = this.getAt(n3).getAbsDiff();
            int n4 = n2 + 1;
            while (n4 < n) {
                if (this.getAt(n4).getAbsDiff() > l) {
                    n3 = n4;
                    l = this.getAt(n3).getAbsDiff();
                }
                ++n4;
            }
            if (n3 != n2) {
                BenutzerAktie benutzerAktie = this.getAt(n2);
                this.setElementAt(this.getAt(n3), n2);
                this.setElementAt(benutzerAktie, n3);
            }
            ++n2;
        }
    }

    private synchronized void sortByAbsPercent() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            long l = this.getAt(n3).getAbsPercent();
            int n4 = n2 + 1;
            while (n4 < n) {
                if (this.getAt(n4).getAbsPercent() > l) {
                    n3 = n4;
                    l = this.getAt(n3).getAbsPercent();
                }
                ++n4;
            }
            if (n3 != n2) {
                BenutzerAktie benutzerAktie = this.getAt(n2);
                this.setElementAt(this.getAt(n3), n2);
                this.setElementAt(benutzerAktie, n3);
            }
            ++n2;
        }
    }

    private synchronized void sortByName(boolean bl) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            String string = this.getAt(n3).getName(bl).trim().toUpperCase();
            int n4 = n2 + 1;
            while (n4 < n) {
                if (string.compareTo(this.getAt(n4).getName(bl).trim().toUpperCase()) > 0) {
                    n3 = n4;
                    string = this.getAt(n3).getName(bl).trim().toUpperCase();
                }
                ++n4;
            }
            if (n3 != n2) {
                BenutzerAktie benutzerAktie = this.getAt(n2);
                this.setElementAt(this.getAt(n3), n2);
                this.setElementAt(benutzerAktie, n3);
            }
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.portfoliover = 0;
        objectOutputStream.defaultWriteObject();
    }

    public static synchronized boolean useShortNames() {
        return AktienMan.properties.getBoolean("Konfig.Aktiennamen.kuerzen", true);
    }

    public static synchronized boolean useOnlineNames() {
        return AktienMan.properties.getBoolean("Konfig.Aktiennamen", true);
    }

    public static synchronized boolean useSteuerfrei() {
        return AktienMan.properties.getBoolean("Konfig.Steuerfrei", true);
    }

    public static synchronized boolean calcProzJahr() {
        return AktienMan.properties.getBoolean("Konfig.ProzJahr", true);
    }

    private synchronized void saveXML(PrintWriter printWriter) {
        printWriter.println("<data>");
        printWriter.println("<release>23</release>");
        printWriter.println("<aktienman>1.99</aktienman>");
        printWriter.println("<kommentar>" + XMLUtil.escapeString(this.kommentar) + "</kommentar>");
        printWriter.println("<festeBoerse>" + XMLUtil.escapeString(this.festeBoerse) + "</festeBoerse>");
        printWriter.println("<letzteAktualisierung>" + (this.letzteAktualisierung == null ? "" : this.letzteAktualisierung.toTimestamp(true, true)) + "</letzteAktualisierung>");
        printWriter.println("<verkaufserloes>" + this.verkaufserloes + "</verkaufserloes>");
        printWriter.println("<erloesWaehrung>" + Waehrungen.index2Id(this.erloesWaehrung) + "</erloesWaehrung>");
        printWriter.println("<sortBy>" + this.sortBy + "</sortBy>");
        printWriter.println("</data>");
        printWriter.println();
    }

    private static BenutzerListe readXML(BufferedReader bufferedReader) throws Exception {
        String string = XMLUtil.nextDataLine(bufferedReader);
        if (!string.startsWith("<data")) {
            throw new Exception("Unerwartetes Tag: " + string);
        }
        string = XMLUtil.nextDataLine(bufferedReader);
        BenutzerListe benutzerListe = new BenutzerListe();
        while (!string.startsWith("</data")) {
            if (string.startsWith("<erloesWaehrung")) {
                benutzerListe.erloesWaehrung = Waehrungen.id2Index(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<festeBoerse")) {
                benutzerListe.festeBoerse = XMLUtil.unescapeString(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<kommentar")) {
                benutzerListe.kommentar = XMLUtil.unescapeString(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<letzteAktualisierung")) {
                benutzerListe.letzteAktualisierung = ADate.parseTimestamp(XMLUtil.getValue(string, true));
            } else if (string.startsWith("<sortBy")) {
                benutzerListe.sortBy = XMLUtil.getIntValue(string);
            } else if (string.startsWith("<verkaufserloes")) {
                benutzerListe.verkaufserloes = XMLUtil.getLongValue(string);
            }
            string = XMLUtil.nextDataLine(bufferedReader);
        }
        return benutzerListe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean store(BenutzerListe benutzerListe) {
        boolean bl = false;
        BenutzerListe benutzerListe2 = benutzerListe;
        synchronized (benutzerListe2) {
            File file;
            Object object;
            String string = benutzerListe.getPortfolioFile();
            String string2 = String.valueOf(string) + ".tmp";
            File file2 = new File(string2);
            if (file2.exists()) {
                file2.delete();
            }
            PrintWriter printWriter = null;
            try {
                try {
                    printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8")), false);
                    int n = benutzerListe.size();
                    XMLUtil.writePrologue(printWriter);
                    XMLUtil.writeComment(printWriter, "ACHTUNG: Veraendern Sie diese Datei in keiner Weise, AktienMan kann derzeit noch keine beliebigen XML-Dokumente einlesen!");
                    XMLUtil.writeComment(printWriter, new Date().toString());
                    printWriter.println("<portfolio version=\"0\" length=\"" + n + "\">");
                    printWriter.println();
                    benutzerListe.saveXML(printWriter);
                    int n2 = 0;
                    while (n2 < n) {
                        benutzerListe.getAt(n2).saveXML(printWriter);
                        ++n2;
                    }
                    printWriter.println("</portfolio>");
                    printWriter.flush();
                }
                catch (Exception exception) {
                    bl = true;
                    AktienMan.errlog("Fehler beim Speichern der Aktienliste " + string + " (xml)", exception);
                }
                object = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (printWriter == null) throw throwable;
                printWriter.close();
                throw throwable;
            }
            if (!bl) {
                file = new File(string);
                if (file.exists()) {
                    if (file.length() == 0L) {
                        file.delete();
                    } else {
                        object = String.valueOf(string) + ".bak";
                        File file3 = new File((String)object);
                        if (file3.exists()) {
                            file3.delete();
                        }
                        file.renameTo(file3);
                    }
                }
                file2.renameTo(file);
                if (!file.exists() || file.length() == 0L) {
                    bl = true;
                    AktienMan.errlog("Fehler beim Umkopieren der tempor\u00e4ren Aktienliste nach " + string, null);
                }
            }
            if (!bl) return bl;
            bl = false;
            file = new File(string);
            if (file.exists()) {
                object = new File(String.valueOf(string) + ".bak");
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                file.renameTo((File)object);
            }
            object = null;
            file = null;
            try {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
                    object = new ObjectOutputStream(fileOutputStream);
                    ((ObjectOutputStream)object).writeObject(benutzerListe);
                    ((ObjectOutputStream)object).flush();
                }
                catch (Exception exception) {
                    bl = true;
                    AktienMan.errlog("Fehler beim Speichern der Aktienliste " + string + " (old-ser)", exception);
                }
                Object var11_12 = null;
                if (object == null) return bl;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (object == null) throw throwable;
                try {
                    ((ObjectOutputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    bl = true;
                }
                throw throwable;
            }
            try {
                ((ObjectOutputStream)object).close();
            }
            catch (IOException iOException) {
                return true;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BenutzerListe restore(String string) {
        BenutzerListe benutzerListe;
        block29: {
            Object var7_15;
            Object object;
            Object object2;
            Closeable closeable;
            boolean bl;
            block28: {
                boolean bl2;
                block27: {
                    benutzerListe = null;
                    bl = false;
                    bl2 = false;
                    BufferedReader bufferedReader = null;
                    try {
                        try {
                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                            XMLUtil.checkValidPrologue(bufferedReader);
                            bl2 = true;
                        }
                        catch (Exception exception) {
                        }
                        Object var6_5 = null;
                        if (bufferedReader == null) break block27;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (bufferedReader == null) throw throwable;
                        try {
                            bufferedReader.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    bufferedReader.close();
                }
                if (bl2) {
                    closeable = null;
                    try {
                        try {
                            closeable = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                            XMLUtil.checkValidPrologue((BufferedReader)closeable);
                            object2 = XMLUtil.nextDataLine((BufferedReader)closeable);
                            if (!((String)object2).startsWith("<portfolio")) {
                                throw new Exception("Unerwartetes Tag: " + (String)object2);
                            }
                            benutzerListe = BenutzerListe.readXML((BufferedReader)closeable);
                            object2 = XMLUtil.nextDataLine((BufferedReader)closeable);
                            while (true) {
                                if (!((String)object2).startsWith("<value")) {
                                    if (((String)object2).startsWith("</portfolio")) break;
                                    throw new Exception("Unerwartetes Tag: " + (String)object2);
                                }
                                object = BenutzerAktie.readXML((BufferedReader)closeable);
                                benutzerListe.add((BenutzerAktie)object);
                                object2 = XMLUtil.nextDataLine((BufferedReader)closeable);
                            }
                            bl = true;
                        }
                        catch (Exception exception) {
                            benutzerListe = null;
                            AktienMan.errlog("Gespeicherte Aktienliste " + string + " fehlerhaft (xml)", exception);
                        }
                        var7_15 = null;
                        if (closeable == null) break block28;
                    }
                    catch (Throwable throwable) {
                        Object var7_16 = null;
                        if (closeable == null) throw throwable;
                        try {
                            ((BufferedReader)closeable).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    ((BufferedReader)closeable).close();
                }
            }
            if (!bl) {
                closeable = null;
                try {
                    try {
                        object2 = new FileInputStream(string);
                        object = new GZIPInputStream((InputStream)object2);
                        closeable = new ObjectInputStream((InputStream)object2);
                        benutzerListe = (BenutzerListe)((ObjectInputStream)closeable).readObject();
                    }
                    catch (Exception exception) {
                        benutzerListe = null;
                        AktienMan.errlog("Gespeicherte Aktienliste " + string + " fehlerhaft (old-ser)", exception);
                    }
                    var7_15 = null;
                    if (closeable == null) break block29;
                }
                catch (Throwable throwable) {
                    var7_15 = null;
                    if (closeable == null) throw throwable;
                    try {
                        ((ObjectInputStream)closeable).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((ObjectInputStream)closeable).close();
            }
        }
        if (benutzerListe == null) {
            benutzerListe = new BenutzerListe();
        }
        benutzerListe.setPortfolioFile(string);
        return benutzerListe;
    }
}

