/*
 * Decompiled with CFR 0.152.
 */
public final class SysUtil {
    private static final String OS_MAC = "MACOS";
    private static final String OS_MACX = "MOSX";
    private static final String OS_WINDOWS = "WINOS";
    private static final String OS_LINUX = "LINUX";
    private static final String OS_2 = "OS2";
    private static final boolean ismacos;
    private static final boolean ismacosx;
    private static final boolean islinux;
    private static final boolean iswindows;
    private static final boolean isos2;

    static {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.vendor");
        ismacosx = string2.indexOf("Apple") >= 0 && string.indexOf("Mac OS X") >= 0;
        ismacos = !ismacosx && (string2.indexOf("Apple") >= 0 || string.indexOf("Mac OS") >= 0);
        islinux = string.indexOf("Linux") >= 0;
        iswindows = string.indexOf("Windows") >= 0;
        isos2 = string.indexOf("OS/2") >= 0;
        System.out.println("java.version: " + System.getProperty("java.version"));
        System.out.println("java.vendor:  " + string2);
        System.out.println("os.name:      " + string);
        System.out.println("os.arch:      " + System.getProperty("os.arch"));
        System.out.println("os.version:   " + System.getProperty("os.version"));
        System.out.println("mrj.version:  " + System.getProperty("mrj.version"));
        System.out.println();
        System.out.println("Erkanntes System: " + SysUtil.getOSString());
        System.out.println();
    }

    private SysUtil() {
    }

    public static boolean isMacOS() {
        return ismacos;
    }

    public static boolean isMacOSX() {
        return ismacosx;
    }

    public static boolean isAMac() {
        return ismacos || ismacosx;
    }

    public static boolean isLinux() {
        return islinux;
    }

    public static boolean isAUnix() {
        return islinux;
    }

    public static boolean isWindows() {
        return iswindows;
    }

    public static boolean isOS2() {
        return isos2;
    }

    public static String getOSString() {
        if (SysUtil.isMacOS()) {
            return OS_MAC;
        }
        if (SysUtil.isMacOSX()) {
            return OS_MACX;
        }
        if (SysUtil.isWindows()) {
            return OS_WINDOWS;
        }
        if (SysUtil.isOS2()) {
            return OS_2;
        }
        return OS_LINUX;
    }
}

