/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import net.sf.nachocalendar.components.MoonPhase;

class MoonCanvas2
extends Canvas {
    private Dimension d;
    private MoonPhase top;
    private int xmid;
    private int ymid;
    private double scale;
    private double extrasun;

    public MoonCanvas2(MoonPhase parent) {
        this.top = parent;
        this.scale = 0.2;
        this.extrasun = 1.05;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    protected void paintSun(Graphics g) {
        int size = (int)((double)this.d.width * this.scale * this.extrasun / 2.0);
        g.setColor(Color.yellow);
        g.fillOval(this.xmid - size - (int)((double)this.d.width * this.scale * (this.top.phase - 0.5) * 720.0), this.ymid - size, size * 2, size * 2);
    }

    protected void paintMoon(Graphics g) {
        int size = (int)((double)this.d.width * this.scale / 2.0);
        double p = this.top.phase;
        p = p < 0.5 ? p + 0.5 : p - 0.5;
        int limit = size;
        int sign = p < 0.5 ? 1 : -1;
        g.setColor(Color.darkGray);
        g.fillOval(this.xmid - size, this.ymid - size, size * 2, size * 2);
        g.setColor(Color.white);
        for (int i = -limit; i <= limit; ++i) {
            g.drawLine(this.xmid + sign * (int)((double)limit * Math.sqrt(1.0 - (double)(i * i) / (double)(limit * limit))), this.ymid + i, this.xmid + sign * (int)((double)limit * Math.cos(Math.PI * 2 * p) * Math.sqrt(1.0 - (double)(i * i) / (double)(limit * limit))), this.ymid + i);
        }
    }

    public void paintSky(Graphics g) {
        this.d = this.getSize();
        this.xmid = this.d.width / 2;
        this.ymid = this.d.height / 2;
        this.paintSky(g, this.d.width, this.d.height, this.xmid, this.ymid);
    }

    public void paintSky(Graphics g, int x, int y, int xm, int ym) {
        this.xmid = xm;
        this.ymid = ym;
        this.d.width = x;
        this.d.height = y;
        g.setColor(Color.black);
        g.fillRect(0, 0, x, y);
        this.paintSun(g);
        this.paintMoon(g);
    }

    @Override
    public void paint(Graphics g) {
        this.paintSky(this.top.gBuf);
        g.drawImage(this.top.buf, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

