/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.charting;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.yccheok.jstock.charting.ChartData;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;

public class Utils {
    private static final List<Color> _kellysMaxContrastSet = new ArrayList<Color>();
    private static final List<Color> _boyntonOptimized = new ArrayList<Color>();
    private static final StandardXYBarPainter barPainter;

    public static void setPriceSeriesPaint(XYItemRenderer xyItemRenderer) {
    }

    public static void setVolumeSeriesPaint(XYItemRenderer xyItemRenderer) {
    }

    public static List<ChartData> getDailyChartData(StockHistoryServer stockHistoryServer) {
        int days = stockHistoryServer.size();
        ArrayList<ChartData> chartDatas = new ArrayList<ChartData>();
        double prevPrice = 0.0;
        double openPrice = 0.0;
        double lastPrice = 0.0;
        double highPrice = Double.MIN_VALUE;
        double lowPrice = Double.MAX_VALUE;
        long volume = 0L;
        long timestamp = 0L;
        for (int i = 0; i < days; ++i) {
            long t = stockHistoryServer.getTimestamp(i);
            Stock stock = stockHistoryServer.getStock(t);
            prevPrice = stock.getPrevPrice();
            openPrice = stock.getOpenPrice();
            lastPrice = stock.getLastPrice();
            highPrice = stock.getHighPrice();
            lowPrice = stock.getLowPrice();
            volume = stock.getVolume();
            timestamp = stock.getTimestamp();
            ChartData chartData = ChartData.newInstance(prevPrice, openPrice, lastPrice, highPrice, lowPrice, volume, timestamp);
            chartDatas.add(chartData);
        }
        return chartDatas;
    }

    public static List<ChartData> getWeeklyChartData(StockHistoryServer stockHistoryServer) {
        int days = stockHistoryServer.size();
        Calendar prevCalendar = null;
        ArrayList<ChartData> chartDatas = new ArrayList<ChartData>();
        double prevPrice = 0.0;
        double openPrice = 0.0;
        double lastPrice = 0.0;
        double highPrice = Double.MIN_VALUE;
        double lowPrice = Double.MAX_VALUE;
        long volume = 0L;
        long timestamp = 0L;
        int count = 0;
        for (int i = 0; i < days; ++i) {
            boolean isSameWeek = false;
            long t = stockHistoryServer.getTimestamp(i);
            Stock stock = stockHistoryServer.getStock(t);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(t);
            if (prevCalendar != null) {
                int prevWeekOfYear;
                int weekOfYear = calendar.get(3);
                isSameWeek = weekOfYear == (prevWeekOfYear = prevCalendar.get(3));
            } else {
                isSameWeek = true;
                openPrice = stock.getOpenPrice();
                prevPrice = stock.getPrevPrice();
            }
            if (!isSameWeek) {
                assert (count > 0);
                ChartData chartData = ChartData.newInstance(prevPrice, openPrice, lastPrice / (double)count, highPrice, lowPrice, volume / (long)count, timestamp);
                chartDatas.add(chartData);
                prevPrice = stock.getPrevPrice();
                openPrice = stock.getOpenPrice();
                lastPrice = stock.getLastPrice();
                highPrice = stock.getHighPrice();
                lowPrice = stock.getLowPrice();
                volume = stock.getVolume();
                timestamp = stock.getTimestamp();
                count = 1;
            } else {
                lastPrice += stock.getLastPrice();
                highPrice = Math.max(highPrice, stock.getHighPrice());
                lowPrice = Math.min(lowPrice, stock.getLowPrice());
                volume += stock.getVolume();
                timestamp = stock.getTimestamp();
                ++count;
            }
            prevCalendar = calendar;
        }
        if (count > 0) {
            ChartData chartData = ChartData.newInstance(prevPrice, openPrice, lastPrice / (double)count, highPrice, lowPrice, volume / (long)count, timestamp);
            chartDatas.add(chartData);
        }
        return chartDatas;
    }

    public static List<ChartData> getMonthlyChartData(StockHistoryServer stockHistoryServer) {
        int days = stockHistoryServer.size();
        Calendar prevCalendar = null;
        ArrayList<ChartData> chartDatas = new ArrayList<ChartData>();
        double prevPrice = 0.0;
        double openPrice = 0.0;
        double lastPrice = 0.0;
        double highPrice = Double.MIN_VALUE;
        double lowPrice = Double.MAX_VALUE;
        long volume = 0L;
        long timestamp = 0L;
        int count = 0;
        for (int i = 0; i < days; ++i) {
            boolean isSameMonth = false;
            long t = stockHistoryServer.getTimestamp(i);
            Stock stock = stockHistoryServer.getStock(t);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(t);
            if (prevCalendar != null) {
                int prevMonth;
                int month = calendar.get(2);
                isSameMonth = month == (prevMonth = prevCalendar.get(2));
            } else {
                isSameMonth = true;
                openPrice = stock.getOpenPrice();
                prevPrice = stock.getPrevPrice();
            }
            if (!isSameMonth) {
                assert (count > 0);
                ChartData chartData = ChartData.newInstance(prevPrice, openPrice, lastPrice / (double)count, highPrice, lowPrice, volume / (long)count, timestamp);
                chartDatas.add(chartData);
                prevPrice = stock.getPrevPrice();
                openPrice = stock.getOpenPrice();
                lastPrice = stock.getLastPrice();
                highPrice = stock.getHighPrice();
                lowPrice = stock.getLowPrice();
                volume = stock.getVolume();
                timestamp = stock.getTimestamp();
                count = 1;
            } else {
                lastPrice += stock.getLastPrice();
                highPrice = Math.max(highPrice, stock.getHighPrice());
                lowPrice = Math.min(lowPrice, stock.getLowPrice());
                volume += stock.getVolume();
                timestamp = stock.getTimestamp();
                ++count;
            }
            prevCalendar = calendar;
        }
        if (count > 0) {
            ChartData chartData = ChartData.newInstance(prevPrice, openPrice, lastPrice / (double)count, highPrice, lowPrice, volume / (long)count, timestamp);
            chartDatas.add(chartData);
        }
        return chartDatas;
    }

    public static void applyChartThemeEx(JFreeChart chart) {
        JStockOptions.ChartTheme theme = MainFrame.getInstance().getJStockOptions().getChartTheme();
        if (theme == JStockOptions.ChartTheme.Light) {
            Utils.applyChartTheme(chart);
            return;
        }
        assert (theme == JStockOptions.ChartTheme.Dark);
        StandardChartTheme chartTheme = (StandardChartTheme)StandardChartTheme.createDarknessTheme();
        Locale defaultLocale = Locale.getDefault();
        if (org.yccheok.jstock.gui.Utils.isSimplifiedChinese(defaultLocale) || org.yccheok.jstock.gui.Utils.isTraditionalChinese(defaultLocale)) {
            Font oldExtraLargeFont = chartTheme.getExtraLargeFont();
            Font oldLargeFont = chartTheme.getLargeFont();
            Font oldRegularFont = chartTheme.getRegularFont();
            Font oldSmallFont = chartTheme.getSmallFont();
            Font extraLargeFont = new Font("Sans-serif", oldExtraLargeFont.getStyle(), oldExtraLargeFont.getSize());
            Font largeFont = new Font("Sans-serif", oldLargeFont.getStyle(), oldLargeFont.getSize());
            Font regularFont = new Font("Sans-serif", oldRegularFont.getStyle(), oldRegularFont.getSize());
            Font smallFont = new Font("Sans-serif", oldSmallFont.getStyle(), oldSmallFont.getSize());
            chartTheme.setExtraLargeFont(extraLargeFont);
            chartTheme.setLargeFont(largeFont);
            chartTheme.setRegularFont(regularFont);
            chartTheme.setSmallFont(smallFont);
        }
        chartTheme.apply(chart);
    }

    public static void applyChartTheme(JFreeChart chart) {
        StandardChartTheme chartTheme = (StandardChartTheme)StandardChartTheme.createJFreeTheme();
        chartTheme.setXYBarPainter((XYBarPainter)barPainter);
        chartTheme.setShadowVisible(false);
        chartTheme.setPlotBackgroundPaint((Paint)Color.WHITE);
        chartTheme.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        chartTheme.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        chartTheme.setPlotOutlinePaint((Paint)Color.LIGHT_GRAY);
        Locale defaultLocale = Locale.getDefault();
        if (org.yccheok.jstock.gui.Utils.isSimplifiedChinese(defaultLocale) || org.yccheok.jstock.gui.Utils.isTraditionalChinese(defaultLocale)) {
            Font oldExtraLargeFont = chartTheme.getExtraLargeFont();
            Font oldLargeFont = chartTheme.getLargeFont();
            Font oldRegularFont = chartTheme.getRegularFont();
            Font oldSmallFont = chartTheme.getSmallFont();
            Font extraLargeFont = new Font("Sans-serif", oldExtraLargeFont.getStyle(), oldExtraLargeFont.getSize());
            Font largeFont = new Font("Sans-serif", oldLargeFont.getStyle(), oldLargeFont.getSize());
            Font regularFont = new Font("Sans-serif", oldRegularFont.getStyle(), oldRegularFont.getSize());
            Font smallFont = new Font("Sans-serif", oldSmallFont.getStyle(), oldSmallFont.getSize());
            chartTheme.setExtraLargeFont(extraLargeFont);
            chartTheme.setLargeFont(largeFont);
            chartTheme.setRegularFont(regularFont);
            chartTheme.setSmallFont(smallFont);
        }
        if (chart.getPlot() instanceof CombinedDomainXYPlot) {
            List plots = ((CombinedDomainXYPlot)chart.getPlot()).getSubplots();
            for (Plot plot : plots) {
                int i;
                int domainAxisCount = ((XYPlot)plot).getDomainAxisCount();
                int rangeAxisCount = ((XYPlot)plot).getRangeAxisCount();
                for (i = 0; i < domainAxisCount; ++i) {
                    ((XYPlot)plot).getDomainAxis(i).setAxisLinePaint((Paint)Color.LIGHT_GRAY);
                    ((XYPlot)plot).getDomainAxis(i).setTickMarkPaint((Paint)Color.LIGHT_GRAY);
                }
                for (i = 0; i < rangeAxisCount; ++i) {
                    ((XYPlot)plot).getRangeAxis(i).setAxisLinePaint((Paint)Color.LIGHT_GRAY);
                    ((XYPlot)plot).getRangeAxis(i).setTickMarkPaint((Paint)Color.LIGHT_GRAY);
                }
            }
        } else {
            Plot plot = chart.getPlot();
            if (plot instanceof XYPlot) {
                int i;
                XYPlot xyPlot = (XYPlot)plot;
                int domainAxisCount = xyPlot.getDomainAxisCount();
                int rangeAxisCount = xyPlot.getRangeAxisCount();
                for (i = 0; i < domainAxisCount; ++i) {
                    xyPlot.getDomainAxis(i).setAxisLinePaint((Paint)Color.LIGHT_GRAY);
                    xyPlot.getDomainAxis(i).setTickMarkPaint((Paint)Color.LIGHT_GRAY);
                }
                for (i = 0; i < rangeAxisCount; ++i) {
                    xyPlot.getRangeAxis(i).setAxisLinePaint((Paint)Color.LIGHT_GRAY);
                    xyPlot.getRangeAxis(i).setTickMarkPaint((Paint)Color.LIGHT_GRAY);
                }
            }
        }
        chartTheme.apply(chart);
    }

    static {
        _kellysMaxContrastSet.add(new Color(0));
        _kellysMaxContrastSet.add(new Color(16757504));
        _kellysMaxContrastSet.add(new Color(8404597));
        _kellysMaxContrastSet.add(new Color(16738304));
        _kellysMaxContrastSet.add(new Color(10927575));
        _kellysMaxContrastSet.add(new Color(12648480));
        _kellysMaxContrastSet.add(new Color(13541986));
        _kellysMaxContrastSet.add(new Color(8482918));
        _kellysMaxContrastSet.add(new Color(32052));
        _kellysMaxContrastSet.add(new Color(16152206));
        _kellysMaxContrastSet.add(new Color(21386));
        _kellysMaxContrastSet.add(new Color(16743004));
        _kellysMaxContrastSet.add(new Color(5453690));
        _kellysMaxContrastSet.add(new Color(16748032));
        _kellysMaxContrastSet.add(new Color(11741265));
        _kellysMaxContrastSet.add(new Color(16041984));
        _kellysMaxContrastSet.add(new Color(8329229));
        _kellysMaxContrastSet.add(new Color(9677312));
        _kellysMaxContrastSet.add(new Color(5845781));
        _kellysMaxContrastSet.add(new Color(15809043));
        _kellysMaxContrastSet.add(new Color(2305046));
        _boyntonOptimized.add(new Color(0, 0, 255));
        _boyntonOptimized.add(new Color(255, 0, 0));
        _boyntonOptimized.add(new Color(0, 255, 0));
        _boyntonOptimized.add(new Color(255, 255, 0));
        _boyntonOptimized.add(new Color(255, 0, 255));
        _boyntonOptimized.add(new Color(255, 128, 128));
        _boyntonOptimized.add(new Color(128, 128, 128));
        _boyntonOptimized.add(new Color(128, 0, 0));
        _boyntonOptimized.add(new Color(255, 128, 0));
        barPainter = new StandardXYBarPainter();
    }
}

