/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Market;
import org.yccheok.jstock.engine.MarketServer;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;

public abstract class AbstractYahooMarketServer
implements MarketServer {
    private static final Log log = LogFactory.getLog(AbstractYahooMarketServer.class);

    protected abstract StockServer getStockServer();

    @Override
    public Market getMarket(Index index) {
        ArrayList<Index> indices = new ArrayList<Index>();
        indices.add(index);
        List<Market> markets = this.getMarkets(indices);
        if (markets.size() == 1) {
            return markets.get(0);
        }
        return null;
    }

    @Override
    public List<Market> getMarkets(List<Index> indices) {
        assert (!indices.isEmpty());
        StockServer stockServer = this.getStockServer();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (Index index : indices) {
            codes.add(index.code);
        }
        List<Stock> stocks = null;
        try {
            stocks = stockServer.getStocks(codes);
        }
        catch (StockNotFoundException e) {
            log.error(null, (Throwable)e);
            return Collections.emptyList();
        }
        HashMap<Code, Stock> map = new HashMap<Code, Stock>();
        for (Stock stock : stocks) {
            map.put(stock.code, stock);
        }
        ArrayList<Market> markets = new ArrayList<Market>();
        for (Index index : indices) {
            Stock stock = (Stock)map.get(index.code);
            if (stock == null) continue;
            Market market = Market.newInstance(stock, index);
            markets.add(market);
        }
        return markets;
    }
}

