/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Symbol;

public class Stock {
    public final Code code;
    public final Symbol symbol;
    private final String name;
    private final Board board;
    private final Industry industry;
    private final double prevPrice;
    private final double openPrice;
    private final double lastPrice;
    private final double highPrice;
    private final double lowPrice;
    private final long volume;
    private final double changePrice;
    private final double changePricePercentage;
    private final int lastVolume;
    private final double buyPrice;
    private final int buyQuantity;
    private final double sellPrice;
    private final int sellQuantity;
    private final double secondBuyPrice;
    private final int secondBuyQuantity;
    private final double secondSellPrice;
    private final int secondSellQuantity;
    private final double thirdBuyPrice;
    private final int thirdBuyQuantity;
    private final double thirdSellPrice;
    private final int thirdSellQuantity;
    private final long timestamp;

    private Stock(Builder builder) {
        this(builder.code, builder.symbol, builder.name, builder.board, builder.industry, builder.prevPrice, builder.openPrice, builder.lastPrice, builder.highPrice, builder.lowPrice, builder.volume, builder.changePrice, builder.changePricePercentage, builder.lastVolume, builder.buyPrice, builder.buyQuantity, builder.sellPrice, builder.sellQuantity, builder.secondBuyPrice, builder.secondBuyQuantity, builder.secondSellPrice, builder.secondSellQuantity, builder.thirdBuyPrice, builder.thirdBuyQuantity, builder.thirdSellPrice, builder.thirdSellQuantity, builder.timestamp);
    }

    public Stock(Code code, Symbol symbol, String name, Board board, Industry industry, double prevPrice, double openPrice, double lastPrice, double highPrice, double lowPrice, long volume, double changePrice, double changePricePercentage, int lastVolume, double buyPrice, int buyQuantity, double sellPrice, int sellQuantity, double secondBuyPrice, int secondBuyQuantity, double secondSellPrice, int secondSellQuantity, double thirdBuyPrice, int thirdBuyQuantity, double thirdSellPrice, int thirdSellQuantity, long timestamp) {
        this.code = code;
        this.symbol = symbol;
        this.name = name;
        this.board = board;
        this.industry = industry;
        this.prevPrice = prevPrice;
        this.openPrice = openPrice;
        this.lastPrice = lastPrice;
        this.highPrice = highPrice;
        this.lowPrice = lowPrice;
        this.volume = volume;
        this.changePrice = changePrice;
        this.changePricePercentage = changePricePercentage;
        this.lastVolume = lastVolume;
        this.buyPrice = buyPrice;
        this.buyQuantity = buyQuantity;
        this.sellPrice = sellPrice;
        this.sellQuantity = sellQuantity;
        this.secondBuyPrice = secondBuyPrice;
        this.secondBuyQuantity = secondBuyQuantity;
        this.secondSellPrice = secondSellPrice;
        this.secondSellQuantity = secondSellQuantity;
        this.thirdBuyPrice = thirdBuyPrice;
        this.thirdBuyQuantity = thirdBuyQuantity;
        this.thirdSellPrice = thirdSellPrice;
        this.thirdSellQuantity = thirdSellQuantity;
        this.timestamp = timestamp;
    }

    public Stock(Stock stock) {
        this.code = stock.code;
        this.symbol = stock.symbol;
        this.name = stock.name;
        this.board = stock.board;
        this.industry = stock.industry;
        this.prevPrice = stock.prevPrice;
        this.openPrice = stock.openPrice;
        this.lastPrice = stock.lastPrice;
        this.highPrice = stock.highPrice;
        this.lowPrice = stock.lowPrice;
        this.volume = stock.volume;
        this.changePrice = stock.changePrice;
        this.changePricePercentage = stock.changePricePercentage;
        this.lastVolume = stock.lastVolume;
        this.buyPrice = stock.buyPrice;
        this.buyQuantity = stock.buyQuantity;
        this.sellPrice = stock.sellPrice;
        this.sellQuantity = stock.sellQuantity;
        this.secondBuyPrice = stock.secondBuyPrice;
        this.secondBuyQuantity = stock.secondBuyQuantity;
        this.secondSellPrice = stock.secondSellPrice;
        this.secondSellQuantity = stock.secondSellQuantity;
        this.thirdBuyPrice = stock.thirdBuyPrice;
        this.thirdBuyQuantity = stock.thirdBuyQuantity;
        this.thirdSellPrice = stock.thirdSellPrice;
        this.thirdSellQuantity = stock.thirdSellQuantity;
        this.timestamp = stock.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public Board getBoard() {
        return this.board;
    }

    public Industry getIndustry() {
        return this.industry;
    }

    public double getPrevPrice() {
        return this.prevPrice;
    }

    public double getOpenPrice() {
        return this.openPrice;
    }

    public double getLastPrice() {
        return this.lastPrice;
    }

    public double getHighPrice() {
        return this.highPrice;
    }

    public double getLowPrice() {
        return this.lowPrice;
    }

    public long getVolume() {
        return this.volume;
    }

    public double getChangePrice() {
        return this.changePrice;
    }

    public double getChangePricePercentage() {
        return this.changePricePercentage;
    }

    public int getLastVolume() {
        return this.lastVolume;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public int getBuyQuantity() {
        return this.buyQuantity;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public int getSellQuantity() {
        return this.sellQuantity;
    }

    public double getSecondBuyPrice() {
        return this.secondBuyPrice;
    }

    public int getSecondBuyQuantity() {
        return this.secondBuyQuantity;
    }

    public double getSecondSellPrice() {
        return this.secondSellPrice;
    }

    public int getSecondSellQuantity() {
        return this.secondSellQuantity;
    }

    public double getThirdBuyPrice() {
        return this.thirdBuyPrice;
    }

    public int getThirdBuyQuantity() {
        return this.thirdBuyQuantity;
    }

    public double getThirdSellPrice() {
        return this.thirdSellPrice;
    }

    public int getThirdSellQuantity() {
        return this.thirdSellQuantity;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Stock deriveStock(String name) {
        return new Stock(this.code, this.symbol, name, this.board, this.industry, this.prevPrice, this.openPrice, this.lastPrice, this.highPrice, this.lowPrice, this.volume, this.changePrice, this.changePricePercentage, this.lastVolume, this.buyPrice, this.buyQuantity, this.sellPrice, this.sellQuantity, this.secondBuyPrice, this.secondBuyQuantity, this.secondSellPrice, this.secondSellQuantity, this.thirdBuyPrice, this.thirdBuyQuantity, this.thirdSellPrice, this.thirdSellQuantity, this.timestamp);
    }

    public Stock deriveStock(Symbol symbol) {
        return new Stock(this.code, symbol, this.name, this.board, this.industry, this.prevPrice, this.openPrice, this.lastPrice, this.highPrice, this.lowPrice, this.volume, this.changePrice, this.changePricePercentage, this.lastVolume, this.buyPrice, this.buyQuantity, this.sellPrice, this.sellQuantity, this.secondBuyPrice, this.secondBuyQuantity, this.secondSellPrice, this.secondSellQuantity, this.thirdBuyPrice, this.thirdBuyQuantity, this.thirdSellPrice, this.thirdSellQuantity, this.timestamp);
    }

    public String toString() {
        return this.symbol.toString();
    }

    public static enum Industry {
        ConsumerProducts("Consumer Products"),
        IndustrialProducts("Industrial Products"),
        Construction("Construction"),
        TradingServices("Trading / Services"),
        Technology("Technology"),
        Infrastructure("Infrastructure"),
        Finance("Finance"),
        Hotels("Hotels"),
        Properties("Properties"),
        Plantation("Plantation"),
        Mining("Mining"),
        Trusts("Trusts"),
        CloseEndFund("Close-End Fund"),
        ETF("ETF"),
        Loans("Loans"),
        CallWarrant("Call Warrant"),
        UserDefined("User Defined"),
        Unknown("Unknown");

        private final String name;

        private Industry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String toOriginalString() {
            return super.toString();
        }
    }

    public static enum Board {
        Main("Main Board"),
        Second("Second Board"),
        Mesdaq("Mesdaq"),
        CallWarrant("Call Warrant"),
        KualaLumpur("Kuala Lumpur"),
        SES("SES"),
        Copenhagen("Copenhagen"),
        Paris("Paris"),
        Xetra("Xetra"),
        XETRA("XETRA"),
        Munich("Munich"),
        Stuttgart("Stuttgart"),
        Berlin("Berlin"),
        Hamburg("Hamburg"),
        Dusseldorf("Dusseldorf"),
        Frankfurt("Frankfurt"),
        Hannover("Hannover"),
        Milan("Milan"),
        Oslo("Oslo"),
        Madrid("Madrid"),
        MCE("MCE"),
        MercadoContinuo("Mercado Continuo"),
        Stockholm("Stockholm"),
        FSI("FSI"),
        London("London"),
        NasdaqSC("NasdaqSC"),
        DJI("DJI"),
        NasdaqNM("NasdaqNM"),
        NYSE("NYSE"),
        Nasdaq("Nasdaq"),
        AMEX("AMEX"),
        PinkSheet("Pink Sheet"),
        Sydney("Sydney"),
        ASX("ASX"),
        Vienna("Vienna"),
        Brussels("Brussels"),
        Toronto("Toronto"),
        HKSE("HKSE"),
        Jakarta("Jakarta"),
        KSE("KSE"),
        KOSDAQ("KOSDAQ"),
        Amsterdam("Amsterdam"),
        ENX("ENX"),
        Lisbon("Lisbon"),
        VTX("VTX"),
        Virt_X("Virt-X"),
        Switzerland("Switzerland"),
        Taiwan("Taiwan"),
        BOM("Bombay"),
        NSE("NSE"),
        NZSX("NZ Stock Market"),
        NZDX("NZ Debt Market"),
        NZAX("NZ Alternative Market"),
        TASE("Tel Aviv Stock Exchange"),
        UserDefined("User Defined"),
        Unknown("Unknown");

        private final String name;

        private Board(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String toOriginalString() {
            return super.toString();
        }
    }

    public static class Builder {
        private final Code code;
        private final Symbol symbol;
        private String name = "";
        private Board board = Board.Unknown;
        private Industry industry = Industry.Unknown;
        private double prevPrice = 0.0;
        private double openPrice = 0.0;
        private double lastPrice = 0.0;
        private double highPrice = 0.0;
        private double lowPrice = 0.0;
        private long volume = 0L;
        private double changePrice = 0.0;
        private double changePricePercentage = 0.0;
        private int lastVolume = 0;
        private double buyPrice = 0.0;
        private int buyQuantity = 0;
        private double sellPrice = 0.0;
        private int sellQuantity = 0;
        private double secondBuyPrice = 0.0;
        private int secondBuyQuantity = 0;
        private double secondSellPrice = 0.0;
        private int secondSellQuantity = 0;
        private double thirdBuyPrice = 0.0;
        private int thirdBuyQuantity = 0;
        private double thirdSellPrice = 0.0;
        private int thirdSellQuantity = 0;
        private long timestamp = 0L;
        private volatile boolean hasTimestampInitialized = false;

        public Builder(Code code, Symbol symbol) {
            this.code = code;
            this.symbol = symbol;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder board(Board board) {
            this.board = board;
            return this;
        }

        public Builder industry(Industry industry) {
            this.industry = industry;
            return this;
        }

        public Builder prevPrice(double prevPrice) {
            this.prevPrice = prevPrice;
            return this;
        }

        public Builder openPrice(double openPrice) {
            this.openPrice = openPrice;
            return this;
        }

        public Builder lastPrice(double lastPrice) {
            this.lastPrice = lastPrice;
            return this;
        }

        public Builder highPrice(double highPrice) {
            this.highPrice = highPrice;
            return this;
        }

        public Builder lowPrice(double lowPrice) {
            this.lowPrice = lowPrice;
            return this;
        }

        public Builder volume(long volume) {
            this.volume = volume;
            return this;
        }

        public Builder changePrice(double changePrice) {
            this.changePrice = changePrice;
            return this;
        }

        public Builder changePricePercentage(double changePricePercentage) {
            this.changePricePercentage = changePricePercentage;
            return this;
        }

        public Builder lastVolume(int lastVolume) {
            this.lastVolume = lastVolume;
            return this;
        }

        public Builder buyPrice(double buyPrice) {
            this.buyPrice = buyPrice;
            return this;
        }

        public Builder buyQuantity(int buyQuantity) {
            this.buyQuantity = buyQuantity;
            return this;
        }

        public Builder sellPrice(double sellPrice) {
            this.sellPrice = sellPrice;
            return this;
        }

        public Builder sellQuantity(int sellQuantity) {
            this.sellQuantity = sellQuantity;
            return this;
        }

        public Builder secondBuyPrice(double secondBuyPrice) {
            this.secondBuyPrice = secondBuyPrice;
            return this;
        }

        public Builder secondBuyQuantity(int secondBuyQuantity) {
            this.secondBuyQuantity = secondBuyQuantity;
            return this;
        }

        public Builder secondSellPrice(double secondSellPrice) {
            this.secondSellPrice = secondSellPrice;
            return this;
        }

        public Builder secondSellQuantity(int secondSellQuantity) {
            this.secondSellQuantity = secondSellQuantity;
            return this;
        }

        public Builder thirdBuyPrice(double thirdBuyPrice) {
            this.thirdBuyPrice = thirdBuyPrice;
            return this;
        }

        public Builder thirdBuyQuantity(int thirdBuyQuantity) {
            this.thirdBuyQuantity = thirdBuyQuantity;
            return this;
        }

        public Builder thirdSellPrice(double thirdSellPrice) {
            this.thirdSellPrice = thirdSellPrice;
            return this;
        }

        public Builder thirdSellQuantity(int thirdSellQuantity) {
            this.thirdSellQuantity = thirdSellQuantity;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            this.hasTimestampInitialized = true;
            return this;
        }

        public Stock build() {
            if (!this.hasTimestampInitialized) {
                this.timestamp = System.currentTimeMillis();
            }
            return new Stock(this);
        }
    }
}

