/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;

public class YQLStockServer
implements StockServer {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final int MAX_STOCK_PER_ITERATION = 180;
    private static final double STABILITY_RATE = 90.0;
    private static final String baseURL = "http://query.yahooapis.com/v1/public/yql?q=";
    private static final Log log = LogFactory.getLog(YQLStockServer.class);

    @Override
    public Stock getStock(Code code) throws StockNotFoundException {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(code);
        List<Stock> stocks = this.getStocks(codes);
        if (stocks.size() == 1) {
            return stocks.get(0);
        }
        throw new StockNotFoundException();
    }

    @Override
    public List<Stock> getStocks(List<Code> codes) throws StockNotFoundException {
        StringBuilder builder = new StringBuilder("select symbol,Name,PreviousClose,LastTradePriceOnly,Open,DaysHigh,DaysLow,Volume,Change,PercentChange,BidRealtime,AskRealtime from yahoo.finance.quotes where symbol in (");
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        ArrayList<String> queries = new ArrayList<String>();
        int count = 0;
        int size = codes.size();
        for (int i = 0; i < size; ++i) {
            StringBuilder tmp;
            Code code = codes.get(i);
            if (++count >= size) {
                builder.append("\"");
                builder.append(code);
                builder.append("\")");
                try {
                    tmp = new StringBuilder(URLEncoder.encode(builder.toString(), "UTF-8"));
                    tmp.append("&format=json&env=http%3A%2F%2Fdatatables.org%2Falltables.env&callback=");
                    queries.add(tmp.toString());
                }
                catch (UnsupportedEncodingException ex) {
                    log.error(null, (Throwable)ex);
                }
                continue;
            }
            if (count >= 180) {
                builder.append("\"");
                builder.append(code);
                builder.append("\")");
                try {
                    tmp = new StringBuilder(URLEncoder.encode(builder.toString(), "UTF-8"));
                    tmp.append("&format=json&env=http%3A%2F%2Fdatatables.org%2Falltables.env&callback=");
                    queries.add(tmp.toString());
                }
                catch (UnsupportedEncodingException ex) {
                    log.error(null, (Throwable)ex);
                }
                builder = new StringBuilder("select symbol,Name,PreviousClose,LastTradePriceOnly,Open,DaysHigh,DaysLow,Volume,Change,PercentChange,BidRealtime,AskRealtime from yahoo.finance.quotes where symbol in (");
                count = 0;
                continue;
            }
            builder.append("\"");
            builder.append(code);
            builder.append("\",");
        }
        for (String query : queries) {
            Object value;
            StringBuilder tmp = new StringBuilder(baseURL);
            tmp.append(query);
            String request = tmp.toString();
            String respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(request);
            String json = Utils.YahooRespondToJSON(respond);
            boolean success_at_least_one = false;
            try {
                value = (Holder)this.mapper.readValue(json, Holder.class);
                List<QuoteType> quotes = ((Holder)value).query.results.quote;
                for (QuoteType quote : quotes) {
                    if (quote.symbol == null || quote.symbol.trim().isEmpty()) continue;
                    String Name2 = "";
                    if (quote.Name != null && !quote.Name.trim().isEmpty()) {
                        Name2 = quote.Name.trim();
                    }
                    Stock stock = new Stock.Builder(Code.newInstance(quote.symbol.trim()), Symbol.newInstance(Name2)).prevPrice(Utils.parseDouble(quote.PreviousClose)).lastPrice(Utils.parseDouble(quote.LastTradePriceOnly)).openPrice(Utils.parseDouble(quote.Open)).highPrice(Utils.parseDouble(quote.DaysHigh)).lowPrice(Utils.parseDouble(quote.DaysLow)).volume(Utils.parseLong(quote.Volume)).changePrice(Utils.parseDouble(quote.Change)).changePricePercentage(Utils.parseDouble(quote.PercentChange)).buyPrice(Utils.parseDouble(quote.BidRealtime)).sellPrice(Utils.parseDouble(quote.AskRealtime)).build();
                    stocks.add(stock);
                    success_at_least_one = true;
                }
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
            }
            if (success_at_least_one) continue;
            try {
                value = (Holder2)this.mapper.readValue(json, Holder2.class);
                QuoteType quote = ((Holder2)value).query.results.quote;
                if (quote.symbol == null || quote.symbol.trim().isEmpty()) continue;
                String Name3 = "";
                if (quote.Name != null && !quote.Name.trim().isEmpty()) {
                    Name3 = quote.Name.trim();
                }
                Stock stock = new Stock.Builder(Code.newInstance(quote.symbol.trim()), Symbol.newInstance(Name3)).prevPrice(Utils.parseDouble(quote.PreviousClose)).lastPrice(Utils.parseDouble(quote.LastTradePriceOnly)).openPrice(Utils.parseDouble(quote.Open)).highPrice(Utils.parseDouble(quote.DaysHigh)).lowPrice(Utils.parseDouble(quote.DaysLow)).volume(Utils.parseLong(quote.Volume)).changePrice(Utils.parseDouble(quote.Change)).changePricePercentage(Utils.parseDouble(quote.PercentChange)).buyPrice(Utils.parseDouble(quote.BidRealtime)).sellPrice(Utils.parseDouble(quote.AskRealtime)).build();
                stocks.add(stock);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if (this.isToleranceAllowed(stocks.size(), codes.size())) {
            ArrayList<Code> currentCodes = new ArrayList<Code>();
            for (Stock stock : stocks) {
                currentCodes.add(stock.code);
            }
            for (Code code : codes) {
                if (currentCodes.contains(code)) continue;
                stocks.add(org.yccheok.jstock.gui.Utils.getEmptyStock(code, Symbol.newInstance(code.toString())));
            }
        }
        if (stocks.size() != codes.size()) {
            throw new StockNotFoundException("Stock size (" + stocks.size() + ") inconsistent with code size (" + codes.size() + ")");
        }
        return stocks;
    }

    private boolean isToleranceAllowed(int currSize, int expectedSize) {
        if (currSize >= expectedSize) {
            return true;
        }
        if (expectedSize <= 0) {
            return true;
        }
        double result = 100.0 - (double)(expectedSize - currSize) / (double)expectedSize * 100.0;
        return result >= 90.0;
    }

    private static class ResultsType2 {
        public final QuoteType quote = null;

        private ResultsType2() {
        }
    }

    private static class QueryType2 {
        public final String count;
        public final String created;
        public final String lang;
        public final ResultsType2 results = null;

        private QueryType2() {
            this.count = null;
            this.created = null;
            this.lang = null;
        }
    }

    private static class Holder2 {
        public final QueryType2 query = null;

        private Holder2() {
        }
    }

    private static class QuoteType {
        public final String symbol;
        public final String Name;
        public final String PreviousClose;
        public final String LastTradePriceOnly;
        public final String Open;
        public final String DaysHigh;
        public final String DaysLow;
        public final String Volume;
        public final String Change;
        public final String PercentChange;
        public final String BidRealtime;
        public final String AskRealtime;

        private QuoteType() {
            this.symbol = null;
            this.Name = null;
            this.PreviousClose = null;
            this.LastTradePriceOnly = null;
            this.Open = null;
            this.DaysHigh = null;
            this.DaysLow = null;
            this.Volume = null;
            this.Change = null;
            this.PercentChange = null;
            this.BidRealtime = null;
            this.AskRealtime = null;
        }
    }

    private static class ResultsType {
        public final List<QuoteType> quote = null;

        private ResultsType() {
        }
    }

    private static class QueryType {
        public final String count;
        public final String created;
        public final String lang;
        public final ResultsType results = null;

        private QueryType() {
            this.count = null;
            this.created = null;
            this.lang = null;
        }
    }

    private static class Holder {
        public final QueryType query = null;

        private Holder() {
        }
    }
}

