/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.AjaxGoogleSearchEngineMonitor;
import org.yccheok.jstock.engine.AjaxYahooSearchEngineMonitor;
import org.yccheok.jstock.engine.MatchSetType;
import org.yccheok.jstock.engine.MatchType;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.ResultSetType;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.gui.AjaxServiceProvider;
import org.yccheok.jstock.gui.JComboBoxPopupAdjustable;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.MatchSetCellRenderer;
import org.yccheok.jstock.gui.ResultSetCellRenderer;
import org.yccheok.jstock.gui.StockInfoCellRenderer;
import org.yccheok.jstock.gui.Utils;

public class AutoCompleteJComboBox
extends JComboBox
implements JComboBoxPopupAdjustable {
    private final SubjectEx<AutoCompleteJComboBox, ResultType> resultSubject = new SubjectEx();
    private final SubjectEx<AutoCompleteJComboBox, MatchType> matchSubject = new SubjectEx();
    private final SubjectEx<AutoCompleteJComboBox, StockInfo> stockInfoSubject = new SubjectEx();
    private final SubjectEx<AutoCompleteJComboBox, Boolean> busySubject = new SubjectEx();
    private boolean greedyEnabled = false;
    private List<String> codeExtensionSortingOption = Collections.emptyList();
    private final ListCellRenderer offlineModeCellRenderer = new StockInfoCellRenderer();
    private final ListCellRenderer yahooOnlineModeCellRenderer = new ResultSetCellRenderer();
    private final ListCellRenderer googleOnlineModeCellRenderer = new MatchSetCellRenderer();
    private final ListCellRenderer oldListCellRenderer;
    private ListCellRenderer currentListCellRenderer;
    private AjaxServiceProvider ajaxServiceProvider;
    private final AjaxYahooSearchEngineMonitor ajaxYahooSearchEngineMonitor = new AjaxYahooSearchEngineMonitor();
    private final AjaxGoogleSearchEngineMonitor ajaxGoogleSearchEngineMonitor = new AjaxGoogleSearchEngineMonitor();
    private StockInfoDatabase stockInfoDatabase = null;
    private final KeyAdapter keyAdapter;
    private final MyJComboBoxEditor jComboBoxEditor;
    private static final Log log = LogFactory.getLog(AutoCompleteJComboBox.class);
    private int popupWidth = 0;
    private boolean layingOut = false;

    public AutoCompleteJComboBox() {
        this.oldListCellRenderer = this.getRenderer();
        this.changeMode(Mode.Offline);
        this.setEditable(true);
        this.keyAdapter = this.getEditorComponentKeyAdapter();
        this.jComboBoxEditor = new MyJComboBoxEditor();
        this.setEditor(this.jComboBoxEditor);
        this.getEditor().getEditorComponent().addKeyListener(this.keyAdapter);
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(this.getDocumentListener());
        } else {
            log.error((Object)"Unable to attach DocumentListener to AutoCompleteJComboBox.");
        }
        this.ajaxYahooSearchEngineMonitor.attach(this.getYahooMonitorObserver());
        this.ajaxGoogleSearchEngineMonitor.attach(this.getGoogleMonitorObserver());
        this.addActionListener(this.getActionListener());
        this.addPopupMenuListener(this.getPopupMenuListener());
        this.adjustScrollBar();
    }

    private PopupMenuListener getPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Utils.adjustPopupWidth(AutoCompleteJComboBox.this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AutoCompleteJComboBox.this.setPopupWidth(-1);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                AutoCompleteJComboBox.this.setPopupWidth(-1);
            }
        };
    }

    private ActionListener getActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 0x10) == 16) {
                    Object object = AutoCompleteJComboBox.this.getEditor().getItem();
                    if (object instanceof ResultType) {
                        ResultType lastEnteredResult = (ResultType)object;
                        AutoCompleteJComboBox.this.resultSubject.notify(AutoCompleteJComboBox.this, lastEnteredResult);
                    } else if (object instanceof StockInfo) {
                        StockInfo lastEnteredStockInfo = (StockInfo)object;
                        AutoCompleteJComboBox.this.stockInfoSubject.notify(AutoCompleteJComboBox.this, lastEnteredStockInfo);
                    } else {
                        assert (object instanceof MatchType);
                        MatchType lastEnteredMatch = (MatchType)object;
                        AutoCompleteJComboBox.this.matchSubject.notify(AutoCompleteJComboBox.this, lastEnteredMatch);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoCompleteJComboBox.this.getEditor().setItem(null);
                            AutoCompleteJComboBox.this.hidePopup();
                            AutoCompleteJComboBox.this.removeAllItems();
                        }
                    });
                }
            }
        };
    }

    public void setStockInfoDatabase(StockInfoDatabase stockInfoDatabase) {
        KeyListener[] listeners;
        this.stockInfoDatabase = stockInfoDatabase;
        for (KeyListener listener : listeners = this.getEditor().getEditorComponent().getKeyListeners()) {
            if (listener != this.keyAdapter) continue;
            return;
        }
        this.getEditor().getEditorComponent().addKeyListener(this.keyAdapter);
        log.info((Object)"Reassign key adapter to combo box");
    }

    private DocumentListener getDocumentListener() {
        return new DocumentListener(){
            private volatile boolean ignore = false;

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    String string = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    this.handle(string);
                }
                catch (BadLocationException ex) {
                    log.error(null, (Throwable)ex);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    String string = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    this.handle(string);
                }
                catch (BadLocationException ex) {
                    log.error(null, (Throwable)ex);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    String string = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    this.handle(string);
                }
                catch (BadLocationException ex) {
                    log.error(null, (Throwable)ex);
                }
            }

            private void _handle(String string) {
                Component component;
                AutoCompleteJComboBox.this.busySubject.notify(AutoCompleteJComboBox.this, false);
                if (AutoCompleteJComboBox.this.getSelectedItem() != null && AutoCompleteJComboBox.this.getSelectedItem().toString().equals(string)) {
                    return;
                }
                if (string.isEmpty()) {
                    return;
                }
                this.ignore = true;
                AutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(true);
                AutoCompleteJComboBox.this.hidePopup();
                AutoCompleteJComboBox.this.removeAllItems();
                boolean shouldShowPopup = false;
                if (AutoCompleteJComboBox.this.stockInfoDatabase != null) {
                    List<StockInfo> stockInfos = AutoCompleteJComboBox.this.greedyEnabled ? AutoCompleteJComboBox.this.stockInfoDatabase.greedySearchStockInfos(string) : AutoCompleteJComboBox.this.stockInfoDatabase.searchStockInfos(string);
                    AutoCompleteJComboBox.this.sortStockInfosIfPossible(stockInfos);
                    if (!stockInfos.isEmpty()) {
                        AutoCompleteJComboBox.this.changeMode(Mode.Offline);
                    }
                    for (StockInfo stockInfo : stockInfos) {
                        AutoCompleteJComboBox.this.addItem(stockInfo);
                        shouldShowPopup = true;
                    }
                    if (shouldShowPopup) {
                        AutoCompleteJComboBox.this.showPopup();
                    }
                }
                if (!shouldShowPopup) {
                    AutoCompleteJComboBox.this.busySubject.notify(AutoCompleteJComboBox.this, true);
                    if (AutoCompleteJComboBox.this.ajaxServiceProvider == AjaxServiceProvider.Yahoo) {
                        AutoCompleteJComboBox.this.ajaxYahooSearchEngineMonitor.clearAndPut(string);
                    } else if (AutoCompleteJComboBox.this.ajaxServiceProvider == AjaxServiceProvider.Google) {
                        AutoCompleteJComboBox.this.ajaxGoogleSearchEngineMonitor.clearAndPut(string);
                    }
                }
                if ((component = AutoCompleteJComboBox.this.getEditor().getEditorComponent()) instanceof JTextField) {
                    JTextField jTextField = (JTextField)component;
                    jTextField.setSelectionStart(jTextField.getText().length());
                    jTextField.setSelectionEnd(jTextField.getText().length());
                    jTextField.setCaretPosition(jTextField.getText().length());
                }
                AutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(false);
                this.ignore = false;
            }

            private void handle(final String string) {
                if (this.ignore) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this._handle(string);
                    }
                });
            }
        };
    }

    private KeyAdapter getEditorComponentKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AutoCompleteJComboBox.this.busySubject.notify(AutoCompleteJComboBox.this, false);
                    StockInfo lastEnteredStockInfo = null;
                    ResultType lastEnteredResultType = null;
                    MatchType lastEnteredMatchType = null;
                    if (AutoCompleteJComboBox.this.getItemCount() > 0) {
                        int index = AutoCompleteJComboBox.this.getSelectedIndex();
                        if (index == -1) {
                            Object object = AutoCompleteJComboBox.this.getItemAt(0);
                            if (object instanceof StockInfo) {
                                lastEnteredStockInfo = (StockInfo)object;
                            } else if (object instanceof ResultType) {
                                lastEnteredResultType = (ResultType)object;
                            } else {
                                assert (object instanceof MatchType);
                                lastEnteredMatchType = (MatchType)object;
                            }
                        } else {
                            Object object = AutoCompleteJComboBox.this.getItemAt(index);
                            if (object instanceof StockInfo) {
                                lastEnteredStockInfo = (StockInfo)object;
                            } else if (object instanceof ResultType) {
                                lastEnteredResultType = (ResultType)object;
                            } else {
                                assert (object instanceof MatchType);
                                lastEnteredMatchType = (MatchType)object;
                            }
                        }
                    } else if (AutoCompleteJComboBox.this.stockInfoDatabase != null) {
                        Object object = AutoCompleteJComboBox.this.getEditor().getItem();
                        if (object instanceof String) {
                            String lastEnteredString = ((String)object).trim();
                            lastEnteredStockInfo = AutoCompleteJComboBox.this.stockInfoDatabase.searchStockInfo(lastEnteredString);
                        } else assert (false);
                    }
                    AutoCompleteJComboBox.this.removeAllItems();
                    if (lastEnteredStockInfo != null) {
                        AutoCompleteJComboBox.this.stockInfoSubject.notify(AutoCompleteJComboBox.this, lastEnteredStockInfo);
                    } else if (lastEnteredResultType != null) {
                        AutoCompleteJComboBox.this.resultSubject.notify(AutoCompleteJComboBox.this, lastEnteredResultType);
                    } else if (lastEnteredMatchType != null) {
                        AutoCompleteJComboBox.this.matchSubject.notify(AutoCompleteJComboBox.this, lastEnteredMatchType);
                    }
                    return;
                }
                Object object = AutoCompleteJComboBox.this.getEditor().getItem();
                if (object == null || object.toString().length() <= 0) {
                    AutoCompleteJComboBox.this.hidePopup();
                    AutoCompleteJComboBox.this.removeAllItems();
                }
            }
        };
    }

    public boolean isGreedyEnabled() {
        return this.greedyEnabled;
    }

    public void setGreedyEnabled(boolean greedyEnabled, List<String> codeExtensionSortingOption) {
        this.greedyEnabled = greedyEnabled;
        this.codeExtensionSortingOption = codeExtensionSortingOption;
    }

    public void setAjaxProvider(AjaxServiceProvider ajaxServiceProvider, List<String> exchs) {
        this.ajaxServiceProvider = ajaxServiceProvider;
        if (this.ajaxServiceProvider == AjaxServiceProvider.Google) {
            this.ajaxGoogleSearchEngineMonitor.setExchs(exchs);
        }
    }

    private void adjustScrollBar() {
        int max_search = 8;
        Container popup = null;
        int count = this.getUI().getAccessibleChildrenCount(this);
        for (int i = 0; i < count && i < 8; ++i) {
            Accessible o = this.getUI().getAccessibleChild(this, i);
            if (!(o instanceof JPopupMenu)) continue;
            popup = (JPopupMenu)o;
            break;
        }
        if (popup == null) {
            return;
        }
        JScrollPane scrollPane = null;
        int count2 = popup.getComponentCount();
        for (int i = 0; i < count2 && i < 8; ++i) {
            Component c = popup.getComponent(i);
            if (!(c instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)c;
            break;
        }
        if (scrollPane == null) {
            return;
        }
        scrollPane.setHorizontalScrollBar(new JScrollBar(0));
        scrollPane.setHorizontalScrollBarPolicy(30);
    }

    private void changeMode(Mode mode) {
        ListCellRenderer me = null;
        if (mode == Mode.Offline) {
            if (MainFrame.getInstance().getJStockOptions().getStockInputSuggestionListOption() == JStockOptions.StockInputSuggestionListOption.OneColumn) {
                me = this.oldListCellRenderer;
            } else {
                assert (MainFrame.getInstance().getJStockOptions().getStockInputSuggestionListOption() == JStockOptions.StockInputSuggestionListOption.TwoColumns);
                me = this.offlineModeCellRenderer;
            }
        } else if (mode == Mode.YahooOnline) {
            me = this.yahooOnlineModeCellRenderer;
        } else if (mode == Mode.GoogleOnline) {
            me = this.googleOnlineModeCellRenderer;
        }
        if (this.currentListCellRenderer != me) {
            this.currentListCellRenderer = me;
            this.setRenderer(this.currentListCellRenderer);
            this.removeAllItems();
        }
    }

    private Observer<AjaxGoogleSearchEngineMonitor, MatchSetType> getGoogleMonitorObserver() {
        return new Observer<AjaxGoogleSearchEngineMonitor, MatchSetType>(){

            @Override
            public void update(final AjaxGoogleSearchEngineMonitor subject, final MatchSetType arg) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this._update(subject, arg);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this._update(subject, arg);
                        }
                    });
                }
            }

            public void _update(AjaxGoogleSearchEngineMonitor subject, MatchSetType arg) {
                String string = AutoCompleteJComboBox.this.getEditor().getItem().toString().trim();
                if (string.isEmpty() || !string.equalsIgnoreCase(arg.Query)) {
                    return;
                }
                AutoCompleteJComboBox.this.busySubject.notify(AutoCompleteJComboBox.this, false);
                AutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(true);
                AutoCompleteJComboBox.this.hidePopup();
                AutoCompleteJComboBox.this.removeAllItems();
                if (!arg.Match.isEmpty()) {
                    AutoCompleteJComboBox.this.changeMode(Mode.GoogleOnline);
                }
                boolean shouldShowPopup = false;
                for (MatchType match : arg.Match) {
                    AutoCompleteJComboBox.this.addItem(match);
                    shouldShowPopup = true;
                }
                if (shouldShowPopup) {
                    AutoCompleteJComboBox.this.showPopup();
                }
                AutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(false);
            }
        };
    }

    private Observer<AjaxYahooSearchEngineMonitor, ResultSetType> getYahooMonitorObserver() {
        return new Observer<AjaxYahooSearchEngineMonitor, ResultSetType>(){

            @Override
            public void update(final AjaxYahooSearchEngineMonitor subject, final ResultSetType arg) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this._update(subject, arg);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this._update(subject, arg);
                        }
                    });
                }
            }

            public void _update(AjaxYahooSearchEngineMonitor subject, ResultSetType arg) {
                String string = AutoCompleteJComboBox.this.getEditor().getItem().toString().trim();
                if (string.isEmpty() || !string.equalsIgnoreCase(arg.Query)) {
                    return;
                }
                AutoCompleteJComboBox.this.busySubject.notify(AutoCompleteJComboBox.this, false);
                AutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(true);
                AutoCompleteJComboBox.this.hidePopup();
                AutoCompleteJComboBox.this.removeAllItems();
                if (!arg.Result.isEmpty()) {
                    AutoCompleteJComboBox.this.changeMode(Mode.YahooOnline);
                }
                boolean shouldShowPopup = false;
                for (ResultType result : arg.Result) {
                    AutoCompleteJComboBox.this.addItem(result);
                    shouldShowPopup = true;
                }
                if (shouldShowPopup) {
                    AutoCompleteJComboBox.this.showPopup();
                }
                AutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(false);
            }
        };
    }

    public void attachStockInfoObserver(Observer<AutoCompleteJComboBox, StockInfo> observer) {
        this.stockInfoSubject.attach(observer);
    }

    public void attachResultObserver(Observer<AutoCompleteJComboBox, ResultType> observer) {
        this.resultSubject.attach(observer);
    }

    public void attachMatchObserver(Observer<AutoCompleteJComboBox, MatchType> observer) {
        this.matchSubject.attach(observer);
    }

    public void attachBusyObserver(Observer<AutoCompleteJComboBox, Boolean> observer) {
        this.busySubject.attach(observer);
    }

    public void dettachAll() {
        this.stockInfoSubject.dettachAll();
        this.resultSubject.dettachAll();
        this.matchSubject.dettachAll();
        this.busySubject.dettachAll();
    }

    public void stop() {
        this.ajaxYahooSearchEngineMonitor.stop();
        this.ajaxGoogleSearchEngineMonitor.stop();
    }

    private void sortStockInfosIfPossible(List<StockInfo> stockInfos) {
        if (!this.greedyEnabled) {
            return;
        }
        final HashMap<String, Integer> m = new HashMap<String, Integer>();
        int ei = this.codeExtensionSortingOption.size();
        for (int i = 0; i < ei; ++i) {
            m.put(this.codeExtensionSortingOption.get(i), i);
        }
        Collections.sort(stockInfos, new Comparator<StockInfo>(){

            @Override
            public int compare(StockInfo o1, StockInfo o2) {
                Integer order2;
                Integer order1;
                String str1 = o1.code.toString();
                String str2 = o2.code.toString();
                String extension1 = null;
                String extension2 = null;
                int index1 = str1.lastIndexOf(".");
                int index2 = str2.lastIndexOf(".");
                if (index1 >= 0) {
                    extension1 = str1.substring(index1 + 1);
                }
                if (index2 >= 0) {
                    extension2 = str2.substring(index2 + 1);
                }
                if ((order1 = (Integer)m.get(extension1)) == (order2 = (Integer)m.get(extension2))) {
                    return str1.compareTo(str2);
                }
                if (order1 != null && order2 == null) {
                    return -1;
                }
                if (order1 == null && order2 != null) {
                    return 1;
                }
                return order1 - order2;
            }
        });
    }

    @Override
    public void setPopupWidth(int popupWidth) {
        this.popupWidth = popupWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut && this.popupWidth != 0 && dim.width < this.popupWidth) {
            dim.width = this.popupWidth;
        }
        return dim;
    }

    private static enum Mode {
        Offline,
        YahooOnline,
        GoogleOnline;

    }

    private class MyJComboBoxEditor
    extends BasicComboBoxEditor {
        private boolean readonly = false;

        private MyJComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            MyTextField _editor = new MyTextField("");
            if (UIManager.getLookAndFeel().getClass().getName().equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                Component component = new MetalComboBoxEditor().getEditorComponent();
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    _editor.setBorder(jComponent.getBorder());
                }
            } else {
                _editor.setBorder(null);
            }
            return _editor;
        }

        public void setReadOnly(boolean readonly) {
            this.readonly = readonly;
        }

        private class MyTextField
        extends JTextField {
            public MyTextField(String s) {
                super(s);
            }

            @Override
            public void setText(String s) {
                if (MyJComboBoxEditor.this.readonly || this.getText().equals(s)) {
                    return;
                }
                super.setText(s);
            }
        }
    }

    private static class SubjectEx<S, A>
    extends Subject<S, A> {
        private SubjectEx() {
        }

        @Override
        public void notify(S subject, A arg) {
            super.notify(subject, arg);
        }
    }
}

