/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.yccheok.jstock.charting.Utils;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.treetable.BuyPortfolioTreeTableModelEx;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class BuyPortfolioChartJDialog
extends JDialog {
    private static final String[] cNames = new String[]{GUIBundle.getString("BuyPortfolioTreeTableModel_GainValue"), GUIBundle.getString("BuyPortfolioTreeTableModel_LossValue"), GUIBundle.getString("BuyPortfolioTreeTableModel_GainPercentage"), GUIBundle.getString("BuyPortfolioTreeTableModel_LossPercentage"), GUIBundle.getString("BuyPortfolioTreeTableModel_Dividend"), GUIBundle.getString("BuyPortfolioTreeTableModel_PurchaseValue"), GUIBundle.getString("BuyPortfolioTreeTableModel_CurrentValue"), GUIBundle.getString("BuyPortfolioTreeTableModel_Units"), GUIBundle.getString("BuyPortfolioTreeTableModel_Broker"), GUIBundle.getString("BuyPortfolioTreeTableModel_StampDuty"), GUIBundle.getString("BuyPortfolioTreeTableModel_ClearingFee")};
    private final BuyPortfolioTreeTableModelEx portfolioTreeTableModel;
    private final ChartPanel chartPanel;
    private final DividendSummary dividendSummary;
    private final Map<Code, Double> codeToTotalDividend = new HashMap<Code, Double>();
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public BuyPortfolioChartJDialog(Frame parent, boolean modal, BuyPortfolioTreeTableModelEx portfolioTreeTableModel, DividendSummary dividendSummary) {
        super(parent, GUIBundle.getString("BuyPortfolioChartJDialog_BuySummary"), modal);
        JFreeChart freeChart;
        this.dividendSummary = dividendSummary;
        this.initCodeToTotalDividend(dividendSummary);
        this.initComponents();
        this.portfolioTreeTableModel = portfolioTreeTableModel;
        final int lastSelectedBuyPortfolioChartIndex = MainFrame.getInstance().getJStockOptions().getLastSelectedBuyPortfolioChartIndex();
        if (lastSelectedBuyPortfolioChartIndex < this.jComboBox1.getItemCount() && lastSelectedBuyPortfolioChartIndex < cNames.length && lastSelectedBuyPortfolioChartIndex >= 0) {
            freeChart = this.createChart(cNames[lastSelectedBuyPortfolioChartIndex]);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BuyPortfolioChartJDialog.this.jComboBox1.setSelectedIndex(lastSelectedBuyPortfolioChartIndex);
                }
            });
        } else {
            freeChart = this.createChart(cNames[0]);
        }
        Utils.applyChartTheme(freeChart);
        this.chartPanel = new ChartPanel(freeChart, true, true, true, true, true);
        this.getContentPane().add((Component)this.chartPanel, "Center");
    }

    private void initCodeToTotalDividend(DividendSummary dividendSummary) {
        int size = dividendSummary.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            Code code = dividend.stockInfo.code;
            Double value = this.codeToTotalDividend.get(code);
            if (value != null) {
                double total = value + dividend.amount;
                this.codeToTotalDividend.put(code, total);
                continue;
            }
            this.codeToTotalDividend.put(code, dividend.amount);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new BorderLayout());
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        HashSet<String> excludedStrings = new HashSet<String>();
        excludedStrings.add(GUIBundle.getString("BuyPortfolioTreeTableModel_Broker"));
        excludedStrings.add(GUIBundle.getString("BuyPortfolioTreeTableModel_StampDuty"));
        excludedStrings.add(GUIBundle.getString("BuyPortfolioTreeTableModel_ClearingFee"));
        for (String cName : cNames) {
            if (!isFeeCalculationEnabled && excludedStrings.contains(cName)) continue;
            this.jComboBox1.addItem(cName);
        }
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuyPortfolioChartJDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jComboBox1);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.getContentPane().add((Component)this.jPanel1, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 750) / 2, (screenSize.height - 600) / 2, 750, 600);
    }

    private JFreeChart createChart(String name) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        boolean isPenceToPoundConversionEnabled = jStockOptions.isPenceToPoundConversionEnabled();
        Portfolio portfolio = (Portfolio)this.portfolioTreeTableModel.getRoot();
        int count = portfolio.getChildCount();
        DefaultPieDataset data = new DefaultPieDataset();
        ArrayList<DataEx> dataExs = new ArrayList<DataEx>();
        for (int i = 0; i < count; ++i) {
            TransactionSummary transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            if (transactionSummary.getChildCount() <= 0) continue;
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Symbol symbol = transaction.getStock().symbol;
            Code code = transaction.getStock().code;
            if (name.equals(cNames[0])) {
                if (!isPenceToPoundConversionEnabled) {
                    if (isFeeCalculationEnabled) {
                        dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getNetGainLossValue(transactionSummary)));
                        continue;
                    }
                    dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getGainLossValue(transactionSummary)));
                    continue;
                }
                if (isFeeCalculationEnabled) {
                    dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getNetGainLossValue(transactionSummary) / 100.0));
                    continue;
                }
                dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getGainLossValue(transactionSummary) / 100.0));
                continue;
            }
            if (name.equals(cNames[1])) {
                if (!isPenceToPoundConversionEnabled) {
                    if (isFeeCalculationEnabled) {
                        dataExs.add(DataEx.newInstance(symbol.toString(), -this.portfolioTreeTableModel.getNetGainLossValue(transactionSummary)));
                        continue;
                    }
                    dataExs.add(DataEx.newInstance(symbol.toString(), -this.portfolioTreeTableModel.getGainLossValue(transactionSummary)));
                    continue;
                }
                if (isFeeCalculationEnabled) {
                    dataExs.add(DataEx.newInstance(symbol.toString(), -this.portfolioTreeTableModel.getNetGainLossValue(transactionSummary) / 100.0));
                    continue;
                }
                dataExs.add(DataEx.newInstance(symbol.toString(), -this.portfolioTreeTableModel.getGainLossValue(transactionSummary) / 100.0));
                continue;
            }
            if (name.equals(cNames[2])) {
                if (isFeeCalculationEnabled) {
                    dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getNetGainLossPercentage(transactionSummary)));
                    continue;
                }
                dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getGainLossPercentage(transactionSummary)));
                continue;
            }
            if (name.equals(cNames[3])) {
                if (isFeeCalculationEnabled) {
                    dataExs.add(DataEx.newInstance(symbol.toString(), -this.portfolioTreeTableModel.getNetGainLossPercentage(transactionSummary)));
                    continue;
                }
                dataExs.add(DataEx.newInstance(symbol.toString(), -this.portfolioTreeTableModel.getGainLossPercentage(transactionSummary)));
                continue;
            }
            if (name.equals(cNames[4])) {
                Double value = this.codeToTotalDividend.get(code);
                if (value == null || !(value > 0.0)) continue;
                dataExs.add(DataEx.newInstance(symbol.toString(), this.codeToTotalDividend.get(code)));
                continue;
            }
            if (name.equals(cNames[5])) {
                if (!isPenceToPoundConversionEnabled) {
                    if (isFeeCalculationEnabled) {
                        dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getNetTotal()));
                        continue;
                    }
                    dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getTotal()));
                    continue;
                }
                if (isFeeCalculationEnabled) {
                    dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getNetTotal() / 100.0));
                    continue;
                }
                dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getTotal() / 100.0));
                continue;
            }
            if (name.equals(cNames[6])) {
                if (!isPenceToPoundConversionEnabled) {
                    dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getCurrentValue(transactionSummary)));
                    continue;
                }
                dataExs.add(DataEx.newInstance(symbol.toString(), this.portfolioTreeTableModel.getCurrentValue(transactionSummary) / 100.0));
                continue;
            }
            if (name.equals(cNames[7])) {
                dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getQuantity()));
                continue;
            }
            if (name.equals(cNames[8])) {
                dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getBroker()));
                continue;
            }
            if (name.equals(cNames[9])) {
                dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getStampDuty()));
                continue;
            }
            if (!name.equals(cNames[10])) continue;
            dataExs.add(DataEx.newInstance(symbol.toString(), transactionSummary.getClearingFee()));
        }
        Collections.sort(dataExs);
        for (DataEx dataEx : dataExs) {
            data.setValue((Comparable)((Object)dataEx.data), dataEx.value);
        }
        return ChartFactory.createPieChart((String)name, (PieDataset)data, (boolean)true, (boolean)true, (boolean)true);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        String selected = ((JComboBox)evt.getSource()).getSelectedItem().toString();
        int selectedIndex = ((JComboBox)evt.getSource()).getSelectedIndex();
        MainFrame.getInstance().getJStockOptions().setLastSelectedBuyPortfolioChartIndex(selectedIndex);
        JFreeChart freeChart = this.createChart(selected);
        Utils.applyChartTheme(freeChart);
        this.chartPanel.setChart(freeChart);
    }

    private static class DataEx
    implements Comparable<DataEx> {
        public final String data;
        public final double value;

        private DataEx(String data, double value) {
            this.data = data;
            this.value = value;
        }

        public static DataEx newInstance(String data, double value) {
            return new DataEx(data, value);
        }

        @Override
        public int compareTo(DataEx o) {
            return Double.compare(o.value, this.value);
        }
    }
}

