/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.yccheok.jstock.engine.Country;

public class CountryJDialog
extends JDialog {
    private Country country = null;
    JButton jButton1;
    JButton jButton2;
    JList jList1;
    JPanel jPanel1;
    JPanel jPanel2;
    JScrollPane jScrollPane1;

    public CountryJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("CountryJDialog_SelectCountry"));
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("CountryJDialog_Country")));
        this.jList1.setModel(this.getMyListModel());
        this.jList1.setSelectionMode(0);
        this.jList1.setCellRenderer(new MyCellRenderer());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CountryJDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 150, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("CountryJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CountryJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("CountryJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CountryJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.country = (Country)((Object)this.jList1.getSelectedValue());
            this.setVisible(false);
            this.dispose();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.country = (Country)((Object)this.jList1.getSelectedValue());
        this.setVisible(false);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.country = null;
        this.setVisible(false);
        this.dispose();
    }

    private ListModel getMyListModel() {
        return new AbstractListModel(){
            List<Country> countries = new ArrayList<Country>(Arrays.asList(Country.values()));
            {
                this.countries.remove((Object)Country.Czech);
            }

            @Override
            public int getSize() {
                return this.countries.size();
            }

            @Override
            public Object getElementAt(int index) {
                return this.countries.get(index);
            }
        };
    }

    public void setCountry(Country country) {
        this.country = country;
        this.jList1.setSelectedValue((Object)country, true);
    }

    public Country getCountry() {
        return this.country;
    }

    private static class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (value instanceof Country) {
                this.setIcon(((Country)((Object)value)).getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

