/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.text.NumberFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.StockServerFactoryJRadioButton;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.ProxyDetector;

public class OptionsNetworkJPanel
extends JPanel
implements JStockOptionsObserver {
    private static final Log log = LogFactory.getLog(OptionsNetworkJPanel.class);
    private volatile SwingWorker testConnectionSwingWorker = null;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JFormattedTextField jFormattedTextField1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPasswordField jPasswordField1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JXHeader jXHeader1;

    public OptionsNetworkJPanel() {
        this.initComponents();
    }

    private SwingWorker getTestConnectionSwingWorker() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doInBackground() {
                String httpproxyHost = System.getProperties().getProperty("http.proxyHost");
                String httpproxyPort = System.getProperties().getProperty("http.proxyPort");
                String oldProxyAuthUsername = MainFrame.getInstance().getJStockOptions().getProxyAuthUserName();
                String oldProxyAuthPassword = MainFrame.getInstance().getJStockOptions().getProxyAuthPassword();
                boolean oldIsProxyAuthEnabled = MainFrame.getInstance().getJStockOptions().isProxyAuthEnabled();
                String newProxyAuthUsername = OptionsNetworkJPanel.this.jTextField2.getText() != null ? OptionsNetworkJPanel.this.jTextField2.getText() : "";
                String newProxyAuthPassword = Utils.encrypt(new String(OptionsNetworkJPanel.this.jPasswordField1.getPassword()));
                MainFrame.getInstance().getJStockOptions().setProxyAuthUserName(newProxyAuthUsername);
                MainFrame.getInstance().getJStockOptions().setProxyAuthPassword(newProxyAuthPassword);
                MainFrame.getInstance().getJStockOptions().setIsProxyAuthEnabled(OptionsNetworkJPanel.this.jCheckBox1.isSelected());
                if (OptionsNetworkJPanel.this.jTextField1.getText().length() > 0 && org.yccheok.jstock.engine.Utils.isValidPortNumber(OptionsNetworkJPanel.this.jFormattedTextField1.getText())) {
                    System.getProperties().put("http.proxyHost", OptionsNetworkJPanel.this.jTextField1.getText());
                    System.getProperties().put("http.proxyPort", OptionsNetworkJPanel.this.jFormattedTextField1.getText());
                } else {
                    System.getProperties().remove("http.proxyHost");
                    System.getProperties().remove("http.proxyPort");
                }
                try {
                    String request = "http://www.google.com";
                    boolean success = null != Utils.getResponseBodyAsStringBasedOnProxyAuthOption("http://www.google.com");
                    Boolean bl = success;
                    return bl;
                }
                catch (Exception exp) {
                    log.error(null, (Throwable)exp);
                }
                finally {
                    MainFrame.getInstance().getJStockOptions().setProxyAuthUserName(oldProxyAuthUsername);
                    MainFrame.getInstance().getJStockOptions().setProxyAuthPassword(oldProxyAuthPassword);
                    MainFrame.getInstance().getJStockOptions().setIsProxyAuthEnabled(oldIsProxyAuthEnabled);
                    if (httpproxyHost != null) {
                        System.getProperties().put("http.proxyHost", httpproxyHost);
                    } else {
                        System.getProperties().remove("http.proxyHost");
                    }
                    if (httpproxyPort != null) {
                        System.getProperties().put("http.proxyPort", httpproxyPort);
                    } else {
                        System.getProperties().remove("http.proxyPort");
                    }
                }
                return false;
            }

            @Override
            public void done() {
                if (this.isCancelled()) {
                    return;
                }
                Boolean status = null;
                try {
                    status = (Boolean)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                OptionsNetworkJPanel.this.updateGUIState();
                if (status == null || !status.booleanValue()) {
                    JOptionPane.showMessageDialog(OptionsNetworkJPanel.this, MessagesBundle.getString("warning_message_wrong_proxy_or_port"), MessagesBundle.getString("warning_title_wrong_proxy_or_port"), 2);
                } else {
                    JOptionPane.showMessageDialog(OptionsNetworkJPanel.this, MessagesBundle.getString("info_message_correct_proxy_and_port"), MessagesBundle.getString("info_title_correct_proxy_and_port"), 1);
                }
            }
        };
        return worker;
    }

    private void initJRadioButtons(JStockOptions jStockOptions) {
        Country country = jStockOptions.getCountry();
        List<StockServerFactory> stockServerFactories = MainFrame.getInstance().getStockServerFactories();
        final JLabel label = new JLabel();
        boolean selected = false;
        AbstractButton first = null;
        this.jPanel5.setLayout(new GridLayout(stockServerFactories.size() + 1, 1, 5, 5));
        for (StockServerFactory stockServerFactory : stockServerFactories) {
            final StockServerFactoryJRadioButton stockServerJRadioButton = new StockServerFactoryJRadioButton(stockServerFactory);
            if (first == null) {
                first = stockServerJRadioButton;
            }
            stockServerJRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String text = MessageFormat.format(GUIBundle.getString("OptionsNetworkJPanel_IsBeingUsedAsPrimaryServer_template"), StockServerFactoryJRadioButton.toReadableText(stockServerJRadioButton.getStockServerFactory()));
                    label.setText(text);
                }
            });
            if (stockServerFactory.getClass() == jStockOptions.getPrimaryStockServerFactoryClass(country)) {
                selected = true;
                stockServerJRadioButton.setSelected(true);
                String text = MessageFormat.format(GUIBundle.getString("OptionsNetworkJPanel_IsBeingUsedAsPrimaryServer_template"), StockServerFactoryJRadioButton.toReadableText(stockServerJRadioButton.getStockServerFactory()));
                label.setText(text);
            }
            this.buttonGroup1.add(stockServerJRadioButton);
            JPanel jPanel = new JPanel();
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(0);
            layout.setHgap(0);
            layout.setVgap(0);
            jPanel.setLayout(layout);
            jPanel.add(stockServerJRadioButton);
            this.jPanel5.add(jPanel);
        }
        if (!selected && first != null) {
            first.setSelected(true);
            String text = MessageFormat.format(GUIBundle.getString("OptionsNetworkJPanel_IsBeingUsedAsPrimaryServer_template"), StockServerFactoryJRadioButton.toReadableText(((StockServerFactoryJRadioButton)first).getStockServerFactory()));
            label.setText(text);
        }
        this.jPanel5.add(label);
    }

    private JFormattedTextField getPortNumberJFormattedTextField() {
        DecimalFormat df = new DecimalFormat("#####");
        NumberFormatter nf = new NumberFormatter(df){

            @Override
            public String valueToString(Object iv) throws ParseException {
                if (iv == null || (Integer)iv == -1) {
                    return "";
                }
                return super.valueToString(iv);
            }

            @Override
            public Object stringToValue(String text) throws ParseException {
                if ("".equals(text)) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        nf.setMinimum(Integer.valueOf(0));
        nf.setMaximum(Integer.valueOf(65534));
        nf.setValueClass(Integer.class);
        return new JFormattedTextField(nf);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jTextField2 = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPasswordField1 = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jFormattedTextField1 = this.getPortNumberJFormattedTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jLabel7 = new JLabel();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("OptionsNetworkJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/connect_to_network.png")));
        this.jXHeader1.setTitle(bundle.getString("OptionsNetworkJPanel_ProxyServer"));
        this.add((Component)this.jXHeader1, "North");
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsNetworkJPanel_StockServer")));
        this.jPanel5.setLayout(new GridLayout(3, 1, 5, 5));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -1, 447, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel5, -1, 56, Short.MAX_VALUE).addContainerGap()));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsNetworkJPanel_ProxyServer")));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("NT LAN Manager (NTLM)"));
        this.jCheckBox1.setText(bundle.getString("OptionsNetworkJPanel_EnableNTLM"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsNetworkJPanel.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        this.jLabel5.setText(bundle.getString("OptionsNetworkJPanel_Username"));
        this.jLabel6.setText(bundle.getString("OptionsNetworkJPanel_Password"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(27, 27, 27).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPasswordField1, 0, 0, Short.MAX_VALUE).addComponent(this.jTextField2, -2, 108, -2)))).addContainerGap(242, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel5)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jPasswordField1, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsNetworkJPanel_Server")));
        this.jLabel1.setText(bundle.getString("OptionsNetworkJPanel_ProxyServer"));
        this.jLabel2.setText(bundle.getString("OptionsNetworkJPanel_Port"));
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont((float)this.jLabel3.getFont().getSize() - 1.0f));
        this.jLabel3.setText(bundle.getString("OptionsNetworkJPanel_Example0"));
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont((float)this.jLabel4.getFont().getSize() - 1.0f));
        this.jLabel4.setText(bundle.getString("OptionsNetworkJPanel_Example1"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jFormattedTextField1).addComponent(this.jTextField1, -1, 109, Short.MAX_VALUE)).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addContainerGap(152, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/idea.png")));
        this.jButton2.setText(bundle.getString("OptionsNetworkJPanel_AutoDetectProxy"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsNetworkJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton2);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/internet.png")));
        this.jButton1.setText(bundle.getString("OptionsNetworkJPanel_TestConnection"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsNetworkJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton1);
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jPanel7.add(this.jLabel7);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, 447, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -2, -1, -2).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addGap(21, 21, 21)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.testConnectionSwingWorker = this.getTestConnectionSwingWorker();
        this.updateGUIState();
        this.jButton1.requestFocus();
        this.testConnectionSwingWorker.execute();
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        ProxyDetector detector = ProxyDetector.getInstance();
        if (detector.directConnectionAvailable()) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("info_message_no_proxy_necessary"), MessagesBundle.getString("info_title_no_proxy_necessary"), 1);
            this.jTextField1.setText(null);
            this.jFormattedTextField1.setText(null);
        } else if (!detector.proxyDetected()) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("error_message_no_proxy_found"), MessagesBundle.getString("error_title_no_proxy_found"), 0);
        } else {
            this.jTextField1.setText(detector.getHostname());
            this.jFormattedTextField1.setText("" + detector.getPort());
        }
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.jTextField1.setText(jStockOptions.getProxyServer());
        if (org.yccheok.jstock.engine.Utils.isValidPortNumber(jStockOptions.getProxyPort())) {
            this.jFormattedTextField1.setText("" + jStockOptions.getProxyPort());
        } else {
            this.jFormattedTextField1.setText("");
        }
        this.jCheckBox1.setSelected(jStockOptions.isProxyAuthEnabled());
        this.jTextField2.setText(jStockOptions.getProxyAuthUserName());
        this.jPasswordField1.setText(Utils.decrypt(jStockOptions.getProxyAuthPassword()));
        this.initJRadioButtons(jStockOptions);
        this.updateGUIState();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        if (this.jTextField1.getText().length() > 0 && org.yccheok.jstock.engine.Utils.isValidPortNumber(this.jFormattedTextField1.getText())) {
            System.getProperties().put("http.proxyHost", this.jTextField1.getText());
            System.getProperties().put("http.proxyPort", this.jFormattedTextField1.getText());
        } else {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
        }
        jStockOptions.setProxyServer(this.jTextField1.getText());
        int port = -1;
        if (this.jFormattedTextField1.getText().length() > 0) {
            try {
                port = Integer.parseInt(this.jFormattedTextField1.getText());
            }
            catch (NumberFormatException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        jStockOptions.setProxyPort(port);
        jStockOptions.setIsProxyAuthEnabled(this.jCheckBox1.isSelected());
        jStockOptions.setProxyAuthUserName(this.jTextField2.getText());
        jStockOptions.setProxyAuthPassword(Utils.encrypt(new String(this.jPasswordField1.getPassword())));
        JRadioButton tmp = Utils.getSelection(this.buttonGroup1);
        if (tmp != null) {
            StockServerFactoryJRadioButton button = (StockServerFactoryJRadioButton)tmp;
            MainFrame.getInstance().updatePrimaryStockServerFactory(jStockOptions.getCountry(), button.getStockServerFactory().getClass());
        }
        return true;
    }

    public void cancel() {
        if (this.testConnectionSwingWorker != null) {
            this.testConnectionSwingWorker.cancel(true);
        }
    }

    private void updateGUIState() {
        boolean isTestConnectionDone = this.testConnectionSwingWorker == null || this.testConnectionSwingWorker.isDone();
        boolean state = this.jCheckBox1.isSelected();
        this.jTextField2.setEnabled(state & isTestConnectionDone);
        this.jPasswordField1.setEnabled(state & isTestConnectionDone);
        this.jLabel5.setEnabled(state);
        this.jLabel6.setEnabled(state);
        this.jTextField1.setEnabled(isTestConnectionDone);
        this.jFormattedTextField1.setEnabled(isTestConnectionDone);
        this.jCheckBox1.setEnabled(isTestConnectionDone);
        this.jButton1.setEnabled(isTestConnectionDone);
        this.jButton2.setEnabled(isTestConnectionDone);
        this.jLabel7.setVisible(!isTestConnectionDone);
    }
}

