/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.CurrencyExchangeMonitor;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.BuyPortfolioChartJDialog;
import org.yccheok.jstock.gui.GUIOptions;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.NewBuyTransactionJDialog;
import org.yccheok.jstock.gui.NewSellTransactionJDialog;
import org.yccheok.jstock.gui.SellPortfolioChartJDialog;
import org.yccheok.jstock.gui.TableColumnSelectionPopupListener;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.InvestmentFlowChartJDialog;
import org.yccheok.jstock.gui.portfolio.CommentJDialog;
import org.yccheok.jstock.gui.portfolio.DepositSummaryJDialog;
import org.yccheok.jstock.gui.portfolio.DepositSummaryTableModel;
import org.yccheok.jstock.gui.portfolio.DividendSummaryBarChartJDialog;
import org.yccheok.jstock.gui.portfolio.DividendSummaryJDialog;
import org.yccheok.jstock.gui.portfolio.DividendSummaryTableModel;
import org.yccheok.jstock.gui.portfolio.SplitJDialog;
import org.yccheok.jstock.gui.portfolio.ToolTipHighlighter;
import org.yccheok.jstock.gui.treetable.AbstractPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.BuyPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.SellPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.SortableTreeTable;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Deposit;
import org.yccheok.jstock.portfolio.DepositSummary;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class PortfolioManagementJPanel
extends JPanel {
    private static final Log log = LogFactory.getLog(PortfolioManagementJPanel.class);
    private int dividerLocation = -1;
    private DepositSummary depositSummary = new DepositSummary();
    private DividendSummary dividendSummary = new DividendSummary();
    private RealTimeStockMonitor realTimeStockMonitor = null;
    private CurrencyExchangeMonitor currencyExchangeMonitor = null;
    private final Observer<RealTimeStockMonitor, List<Stock>> realTimeStockMonitorObserver = this.getRealTimeStockMonitorObserver();
    private final Observer<CurrencyExchangeMonitor, Double> currencyExchangeMonitorObserver = this.getCurrencyExchangeMonitorObserver();
    private long timestamp = 0L;
    private SortableTreeTable buyTreeTable;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private SortableTreeTable sellTreeTable;

    public PortfolioManagementJPanel() {
        this.initComponents();
        this.initPortfolio();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.buyTreeTable = new SortableTreeTable((TreeTableModel)new BuyPortfolioTreeTableModelEx());
        ((TableColumnExt)this.buyTreeTable.getColumn(GUIBundle.getString("PortfolioManagementJPanel_Comment"))).setVisible(false);
        this.jScrollPane2 = new JScrollPane();
        this.sellTreeTable = new SortableTreeTable((TreeTableModel)new SellPortfolioTreeTableModelEx());
        ((TableColumnExt)this.sellTreeTable.getColumn(GUIBundle.getString("PortfolioManagementJPanel_Comment"))).setVisible(false);
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PortfolioManagementJPanel.this.formMouseClicked(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Portfolio Management"));
        this.jPanel1.setLayout(new BorderLayout(0, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jLabel1.setText(this.getShareLabel());
        this.jPanel3.add(this.jLabel1);
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jPanel3.add(this.jLabel2);
        this.jLabel3.setText(this.getCashLabel());
        this.jPanel3.add(this.jLabel3);
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jPanel3.add(this.jLabel4);
        this.jPanel4.add((Component)this.jPanel3, "West");
        this.jLabel5.setText(this.getPaperProfitLabel());
        this.jPanel5.add(this.jLabel5);
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jPanel5.add(this.jLabel6);
        this.jLabel7.setText(this.getRealizedProfitLabel());
        this.jPanel5.add(this.jLabel7);
        this.jLabel8.setFont(this.jLabel8.getFont().deriveFont(this.jLabel8.getFont().getStyle() | 1));
        this.jPanel5.add(this.jLabel8);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(bundle.getString("PortfolioManagementJPanel_Buy")));
        this.buyTreeTable.setAutoResizeMode(0);
        this.buyTreeTable.setRootVisible(true);
        this.buyTreeTable.setAutoCreateColumnsFromModel(false);
        this.buyTreeTable.addMouseListener(new BuyTableRowPopupListener());
        this.buyTreeTable.addKeyListener(new TableKeyEventListener());
        Highlighter highlighter0 = HighlighterFactory.createSimpleStriping((Color)new Color(245, 245, 220));
        this.buyTreeTable.addHighlighter(highlighter0);
        this.buyTreeTable.addHighlighter((Highlighter)new ToolTipHighlighter());
        this.initTreeTableDefaultRenderer(this.buyTreeTable);
        JTableHeader oldBuyTableHeader = this.buyTreeTable.getTableHeader();
        JXTableHeader newBuyTableHeader = new JXTableHeader(oldBuyTableHeader.getColumnModel());
        this.buyTreeTable.setTableHeader((JTableHeader)newBuyTableHeader);
        this.buyTreeTable.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(1, new String[]{GUIBundle.getString("PortfolioManagementJPanel_Comment")}));
        this.buyTreeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PortfolioManagementJPanel.this.buyTreeTableValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)((Object)this.buyTreeTable));
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder(bundle.getString("PortfolioManagementJPanel_Sell")));
        this.sellTreeTable.setAutoResizeMode(0);
        this.sellTreeTable.setRootVisible(true);
        this.sellTreeTable.setAutoCreateColumnsFromModel(false);
        this.sellTreeTable.addMouseListener(new SellTableRowPopupListener());
        this.sellTreeTable.addKeyListener(new TableKeyEventListener());
        Highlighter highlighter1 = HighlighterFactory.createSimpleStriping((Color)new Color(245, 245, 220));
        this.sellTreeTable.addHighlighter(highlighter1);
        this.sellTreeTable.addHighlighter((Highlighter)new ToolTipHighlighter());
        this.initTreeTableDefaultRenderer(this.sellTreeTable);
        JTableHeader oldSellTableHeader = this.sellTreeTable.getTableHeader();
        JXTableHeader newSellTableHeader = new JXTableHeader(oldSellTableHeader.getColumnModel());
        this.sellTreeTable.setTableHeader((JTableHeader)newSellTableHeader);
        this.sellTreeTable.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(1, new String[]{GUIBundle.getString("PortfolioManagementJPanel_Comment")}));
        this.sellTreeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PortfolioManagementJPanel.this.sellTreeTableValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)((Object)this.sellTreeTable));
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/inbox.png")));
        this.jButton1.setText(bundle.getString("PortfolioManagementJPanel_Buy..."));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/outbox.png")));
        this.jButton3.setText(bundle.getString("PortfolioManagementJPanel_Sell..."));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/money.png")));
        this.jButton4.setText(bundle.getString("PortfolioManagementJPanel_Cash..."));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/money2.png")));
        this.jButton5.setText(bundle.getString("PortfolioManagementJPanel_Dividen..."));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton5);
        this.add((Component)this.jPanel2, "South");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        List<Stock> stocks = this.getSelectedStocks();
        if (stocks.size() == 1) {
            this.showNewBuyTransactionJDialog(stocks.get(0), this.getStockPrice(stocks.get(0)), true);
        } else {
            this.showNewBuyTransactionJDialog(null, 0.0, true);
        }
    }

    private void initTreeTableDefaultRenderer(JXTreeTable treeTable) {
        final TableCellRenderer doubleOldTableCellRenderer = treeTable.getDefaultRenderer(Double.class);
        treeTable.setDefaultRenderer(Double.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = doubleOldTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String UNITS = GUIBundle.getString("PortfolioManagementJPanel_Units");
                if (!UNITS.equals(table.getColumnName(column))) {
                    if (value != null && c instanceof JLabel) {
                        if (value instanceof DoubleWrapper) {
                            DoubleWrapper v = (DoubleWrapper)value;
                            ((JLabel)c).setText(org.yccheok.jstock.portfolio.Utils.toCurrency(v.decimalPlace, v.value));
                        } else {
                            ((JLabel)c).setText(org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Four, value));
                        }
                    }
                } else if (value != null && c instanceof JLabel) {
                    ((JLabel)c).setText(org.yccheok.jstock.portfolio.Utils.toUnits(value));
                }
                return c;
            }
        });
        treeTable.setDefaultRenderer(SimpleDate.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && c instanceof JLabel) {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    SimpleDate simpleDate = (SimpleDate)value;
                    ((JLabel)c).setText(dateFormat.format(simpleDate.getTime()));
                }
                return c;
            }
        });
    }

    private boolean isValidTreeTableNode(TreeTableModel treeTableModel, Object node) {
        boolean result = false;
        Object root = treeTableModel.getRoot();
        if (node instanceof TreeTableNode) {
            for (TreeTableNode ttn = (TreeTableNode)node; !result && ttn != null; ttn = ttn.getParent()) {
                result = ttn == root;
            }
        }
        return result;
    }

    private String getSelectedFirstColumnString(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return null;
        }
        if (treePaths.length == 1) {
            return treePaths[0].getLastPathComponent().toString();
        }
        return null;
    }

    private Commentable getSelectedCommentable(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return null;
        }
        if (treePaths.length == 1 && treePaths[0].getLastPathComponent() instanceof Commentable) {
            return (Commentable)treePaths[0].getLastPathComponent();
        }
        return null;
    }

    public boolean openAsExcelFile(File file) {
        List<Statements> statementsList = Statements.newInstanceFromExcelFile(file);
        boolean status = true;
        for (Statements statements : statementsList) {
            status &= this.openAsStatements(statements, file);
        }
        return status;
    }

    public boolean openAsCSVFile(File file) {
        Statements statements = Statements.newInstanceFromCSVFile(file);
        return this.openAsStatements(statements, file);
    }

    /*
     * Unable to fully structure code
     */
    public boolean openAsStatements(Statements statements, File file) {
        block69: {
            block68: {
                if (!PortfolioManagementJPanel.$assertionsDisabled && statements == null) {
                    throw new AssertionError();
                }
                if (statements.getType() != Statement.Type.PortfolioManagementBuy && statements.getType() != Statement.Type.PortfolioManagementSell && statements.getType() != Statement.Type.PortfolioManagementDeposit && statements.getType() != Statement.Type.PortfolioManagementDividend) break block68;
                guiBundleWrapper = statements.getGUIBundleWrapper();
                dateFormat = null;
                size = statements.size();
                switch (43.$SwitchMap$org$yccheok$jstock$file$Statement$Type[statements.getType().ordinal()]) {
                    case 1: {
                        transactions = new ArrayList<Transaction>();
                        for (i = 0; i < size; ++i) {
                            statement = statements.get(i);
                            _code = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                            _symbol = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                            _date = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            units = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Units"));
                            purchasePrice = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"));
                            broker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"));
                            clearingFee = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"));
                            stampDuty = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"));
                            _comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            stock = null;
                            if (_code.length() <= 0 || _symbol.length() <= 0) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected empty stock. Ignore");
                                continue;
                            }
                            stock = Utils.getEmptyStock(Code.newInstance(_code), Symbol.newInstance(_symbol));
                            date = null;
                            if (dateFormat != null) ** GOTO lbl39
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(_date);
                                    ** GOTO lbl44
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl44
lbl39:
                            // 1 sources

                            try {
                                date = dateFormat.parse(_date);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl44:
                            // 4 sources

                            if (date == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date. Ignore");
                                continue;
                            }
                            if (units == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong units. Ignore");
                                continue;
                            }
                            if (purchasePrice == null || broker == null || clearingFee == null || stampDuty == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong purchasePrice/broker/clearingFee/stampDuty. Ignore");
                                continue;
                            }
                            simpleDate = new SimpleDate(date);
                            type = Contract.Type.Buy;
                            builder = new Contract.ContractBuilder(stock, simpleDate);
                            contract = builder.type(type).quantity(units).price(purchasePrice).build();
                            t = new Transaction(contract, broker, stampDuty, clearingFee);
                            t.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(_comment));
                            transactions.add(t);
                        }
                        if (this.getBuyTransactionSize() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_buy_portfolio_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_load_file_for_buy_portfolio"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.buyTreeTable.setTreeTableModel((TreeTableModel)new BuyPortfolioTreeTableModelEx());
                        metadatas = statements.getMetadatas();
                        for (Transaction transaction : transactions) {
                            code = transaction.getStock().code;
                            transactionSummary = this.addBuyTransaction(transaction);
                            if (transactionSummary == null || (comment = metadatas.get(code.toString())) == null) continue;
                            transactionSummary.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                        }
                        this.initGUIOptions();
                        this.expandTreeTable(this.buyTreeTable);
                        this.updateRealTimeStockMonitorAccordingToBuyPortfolioTreeTableModel();
                        break;
                    }
                    case 2: {
                        transactions = new ArrayList<Transaction>();
                        for (i = 0; i < size; ++i) {
                            statement = statements.get(i);
                            _code = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                            _symbol = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                            _referenceDate = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate"));
                            purchaseBroker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseBroker"));
                            if (purchaseBroker == null && (purchaseBroker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseFee"))) == null) {
                                purchaseBroker = new Double(0.0);
                            }
                            if ((purchaseClearingFee = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseClearingFee"))) == null) {
                                purchaseClearingFee = new Double(0.0);
                            }
                            if ((purchaseStampDuty = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseStampDuty"))) == null) {
                                purchaseStampDuty = new Double(0.0);
                            }
                            _date = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            units = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Units"));
                            sellingPrice = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice"));
                            purchasePrice = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"));
                            broker = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"));
                            clearingFee = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"));
                            stampDuty = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"));
                            _comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            stock = null;
                            if (_code.length() <= 0 || _symbol.length() <= 0) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected empty stock. Ignore");
                                continue;
                            }
                            stock = Utils.getEmptyStock(Code.newInstance(_code), Symbol.newInstance(_symbol));
                            date = null;
                            referenceDate = null;
                            if (dateFormat != null) ** GOTO lbl122
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(_date);
                                    referenceDate = dateFormat.parse(_referenceDate);
                                    ** GOTO lbl128
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    referenceDate = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl128
lbl122:
                            // 1 sources

                            try {
                                date = dateFormat.parse(_date);
                                referenceDate = dateFormat.parse(_referenceDate);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl128:
                            // 4 sources

                            if (date == null || referenceDate == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date/referenceDate. Ignore");
                                continue;
                            }
                            if (units == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong units. Ignore");
                                continue;
                            }
                            if (purchasePrice == null || broker == null || clearingFee == null || stampDuty == null || sellingPrice == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong purchasePrice/broker/clearingFee/stampDuty/sellingPrice. Ignore");
                                continue;
                            }
                            simpleDate = new SimpleDate(date);
                            simpleReferenceDate = new SimpleDate(referenceDate);
                            type = Contract.Type.Sell;
                            builder = new Contract.ContractBuilder(stock, simpleDate);
                            contract = builder.type(type).quantity(units).price(sellingPrice).referencePrice(purchasePrice).referenceDate(simpleReferenceDate).referenceBroker(purchaseBroker).referenceClearingFee(purchaseClearingFee).referenceStampDuty(purchaseStampDuty).build();
                            t = new Transaction(contract, broker, stampDuty, clearingFee);
                            t.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(_comment));
                            transactions.add(t);
                        }
                        if (this.getSellTransactionSize() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_sell_portfolio_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_load_file_for_sell_portfolio"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.sellTreeTable.setTreeTableModel((TreeTableModel)new SellPortfolioTreeTableModelEx());
                        metadatas = statements.getMetadatas();
                        for (Transaction transaction : transactions) {
                            code = transaction.getStock().code;
                            transactionSummary = this.addSellTransaction(transaction);
                            if (transactionSummary == null || (comment = metadatas.get(code.toString())) == null) continue;
                            transactionSummary.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                        }
                        this.initGUIOptions();
                        this.expandTreeTable(this.sellTreeTable);
                        break;
                    }
                    case 3: {
                        deposits = new ArrayList<Deposit>();
                        for (i = 0; i < size; ++i) {
                            date = null;
                            statement = statements.get(i);
                            object0 = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            if (!PortfolioManagementJPanel.$assertionsDisabled && object0 == null) {
                                throw new AssertionError();
                            }
                            if (dateFormat != null) ** GOTO lbl183
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(object0);
                                    ** GOTO lbl188
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl188
lbl183:
                            // 1 sources

                            try {
                                date = dateFormat.parse(object0);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl188:
                            // 4 sources

                            if (date == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date. Ignore");
                                continue;
                            }
                            cash = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Cash"));
                            if (cash == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong cash. Ignore");
                                continue;
                            }
                            deposit = new Deposit(cash, new SimpleDate(date));
                            comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            if (comment != null) {
                                deposit.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                            }
                            deposits.add(deposit);
                        }
                        if (this.depositSummary.size() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_cash_deposit_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_load_file_for_cash_deposit"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.depositSummary = new DepositSummary();
                        for (Deposit deposit : deposits) {
                            this.depositSummary.add(deposit);
                        }
                        break;
                    }
                    case 4: {
                        dividends = new ArrayList<Dividend>();
                        for (i = 0; i < size; ++i) {
                            date = null;
                            stockInfo = null;
                            statement = statements.get(i);
                            object0 = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Date"));
                            if (!PortfolioManagementJPanel.$assertionsDisabled && object0 == null) {
                                throw new AssertionError();
                            }
                            if (dateFormat != null) ** GOTO lbl234
                            for (Locale locale : locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.GERMAN, Locale.TRADITIONAL_CHINESE, Locale.ITALIAN}) {
                                dateFormat = DateFormat.getDateInstance(2, locale);
                                try {
                                    date = dateFormat.parse(object0);
                                    ** GOTO lbl239
                                }
                                catch (ParseException exp) {
                                    PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                                    date = null;
                                    dateFormat = null;
                                }
                            }
                            ** GOTO lbl239
lbl234:
                            // 1 sources

                            try {
                                date = dateFormat.parse(object0);
                            }
                            catch (ParseException exp) {
                                PortfolioManagementJPanel.log.error(null, (Throwable)exp);
                            }
lbl239:
                            // 4 sources

                            if (date == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong date. Ignore");
                                continue;
                            }
                            dividend = statement.getValueAsDouble(guiBundleWrapper.getString("PortfolioManagementJPanel_Dividend"));
                            if (dividend == null) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong dividend. Ignore");
                                continue;
                            }
                            codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                            symbolStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Symbol"));
                            if (codeStr.isEmpty() || symbolStr.isEmpty()) {
                                PortfolioManagementJPanel.log.error((Object)"Unexpected wrong stock. Ignore");
                                continue;
                            }
                            stockInfo = StockInfo.newInstance(Code.newInstance(codeStr), Symbol.newInstance(symbolStr));
                            if (!PortfolioManagementJPanel.$assertionsDisabled && stockInfo == null) {
                                throw new AssertionError();
                            }
                            if (!PortfolioManagementJPanel.$assertionsDisabled && dividend == null) {
                                throw new AssertionError();
                            }
                            if (!PortfolioManagementJPanel.$assertionsDisabled && date == null) {
                                throw new AssertionError();
                            }
                            d = new Dividend(stockInfo, dividend, new SimpleDate(date));
                            comment = statement.getValueAsString(guiBundleWrapper.getString("PortfolioManagementJPanel_Comment"));
                            if (comment != null) {
                                d.setComment(org.yccheok.jstock.portfolio.Utils.replaceCSVLineFeedToSystemLineFeed(comment));
                            }
                            dividends.add(d);
                        }
                        if (this.dividendSummary.size() > 0) {
                            output = MessageFormat.format(MessagesBundle.getString("question_message_load_file_for_dividend_template"), new Object[]{file.getName()});
                            result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_load_file_for_dividend"), 0, 3);
                            if (result != 0) {
                                return true;
                            }
                        }
                        this.dividendSummary = new DividendSummary();
                        for (Dividend dividend : dividends) {
                            this.dividendSummary.add(dividend);
                        }
                        break;
                    }
                    default: {
                        if (!PortfolioManagementJPanel.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                break block69;
            }
            if (statements.getType() == Statement.Type.RealtimeInfo) {
                return MainFrame.getInstance().openAsStatements(statements, file);
            }
            return false;
        }
        this.updateWealthHeader();
        return true;
    }

    private List<Stock> getSelectedStocks() {
        List<Stock> stocks0 = this.getSelectedStocks(this.buyTreeTable);
        List<Stock> stocks1 = this.getSelectedStocks(this.sellTreeTable);
        HashSet<Code> c = new HashSet<Code>();
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        for (Stock stock : stocks0) {
            if (c.contains(stock.code)) continue;
            c.add(stock.code);
            stocks.add(stock);
        }
        for (Stock stock : stocks1) {
            if (c.contains(stock.code)) continue;
            c.add(stock.code);
            stocks.add(stock);
        }
        return Collections.unmodifiableList(stocks);
    }

    public double getStockPrice(Stock stock) {
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        return buyPortfolioTreeTableModel.getStockPrice(stock.code);
    }

    private void showNewSellTransactionJDialog(List<Transaction> buyTransactions) {
        MainFrame mainFrame = MainFrame.getInstance();
        NewSellTransactionJDialog newSellTransactionJDialog = new NewSellTransactionJDialog((Frame)mainFrame, true);
        if (buyTransactions.size() > 1) {
            String template = GUIBundle.getString("PortfolioManagementJPanel_BatchSell_template");
            newSellTransactionJDialog.setTitle(MessageFormat.format(template, newSellTransactionJDialog.getTitle(), buyTransactions.size()));
        }
        newSellTransactionJDialog.setLocationRelativeTo(this);
        newSellTransactionJDialog.setBuyTransactions(buyTransactions);
        newSellTransactionJDialog.setVisible(true);
        List<Transaction> newSellTransactions = newSellTransactionJDialog.getTransactions();
        for (int i = 0; i < newSellTransactions.size(); ++i) {
            Transaction newSellTransaction = newSellTransactions.get(i);
            Transaction buyTransaction = buyTransactions.get(i);
            double remain = buyTransaction.getQuantity() - newSellTransaction.getQuantity();
            assert (remain >= 0.0);
            this.addSellTransaction(newSellTransaction);
            BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
            if (remain <= 0.0) {
                portfolioTreeTableModel.removeTransaction(buyTransaction);
                continue;
            }
            double newBroker = buyTransaction.getBroker() - newSellTransaction.getReferenceBroker();
            double newStampDuty = buyTransaction.getStampDuty() - newSellTransaction.getReferenceStampDuty();
            double newClearingFee = buyTransaction.getClearingFee() - newSellTransaction.getReferenceClearingFee();
            this.editBuyTransaction(buyTransaction.deriveWithQuantity(remain).deriveWithBroker(newBroker).deriveWithStampDuty(newStampDuty).deriveWithClearingFee(newClearingFee), buyTransaction);
        }
        this.updateWealthHeader();
    }

    private void showEditTransactionJDialog(Transaction transaction) {
        MainFrame mainFrame = MainFrame.getInstance();
        if (transaction.getType() == Contract.Type.Buy) {
            NewBuyTransactionJDialog newTransactionJDialog = new NewBuyTransactionJDialog((Frame)mainFrame, true);
            newTransactionJDialog.setStockSelectionEnabled(false);
            newTransactionJDialog.setTransaction(transaction);
            String template = GUIBundle.getString("PortfolioManagementJPanel_EditBuy_template");
            newTransactionJDialog.setTitle(MessageFormat.format(template, transaction.getStock().symbol));
            newTransactionJDialog.setLocationRelativeTo(this);
            newTransactionJDialog.setVisible(true);
            Transaction newTransaction = newTransactionJDialog.getTransaction();
            if (newTransaction != null) {
                this.editBuyTransaction(newTransaction, transaction);
                this.updateWealthHeader();
            }
        } else {
            assert (transaction.getType() == Contract.Type.Sell);
            NewSellTransactionJDialog newTransactionJDialog = new NewSellTransactionJDialog((Frame)mainFrame, true);
            newTransactionJDialog.setSellTransaction(transaction);
            String template = GUIBundle.getString("PortfolioManagementJPanel_EditSell_template");
            newTransactionJDialog.setTitle(MessageFormat.format(template, transaction.getStock().symbol));
            newTransactionJDialog.setLocationRelativeTo(this);
            newTransactionJDialog.setVisible(true);
            List<Transaction> transactions = newTransactionJDialog.getTransactions();
            for (Transaction newTransaction : transactions) {
                this.editSellTransaction(newTransaction, transaction);
                this.updateWealthHeader();
            }
        }
    }

    public void showNewBuyTransactionJDialog(Stock stock, double lastPrice, boolean JComboBoxEnabled) {
        MainFrame mainFrame = MainFrame.getInstance();
        StockInfoDatabase stockInfoDatabase = mainFrame.getStockInfoDatabase();
        if (stockInfoDatabase == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("info_message_we_havent_connected_to_stock_server"), MessagesBundle.getString("info_title_we_havent_connected_to_stock_server"), 1);
            return;
        }
        NewBuyTransactionJDialog newTransactionJDialog = new NewBuyTransactionJDialog((Frame)mainFrame, true);
        newTransactionJDialog.setLocationRelativeTo(this);
        newTransactionJDialog.setStock(stock);
        newTransactionJDialog.setPrice(lastPrice);
        newTransactionJDialog.setJComboBoxEnabled(JComboBoxEnabled);
        newTransactionJDialog.setStockInfoDatabase(stockInfoDatabase);
        if (mainFrame.getSelectedComponent() != this) {
            JStockOptions jStockOptions = mainFrame.getJStockOptions();
            String title = newTransactionJDialog.getTitle() + " (" + jStockOptions.getPortfolioName() + ")";
            newTransactionJDialog.setTitle(title);
        }
        newTransactionJDialog.setVisible(true);
        Transaction transaction = newTransactionJDialog.getTransaction();
        if (transaction != null) {
            this.addBuyTransaction(transaction);
            this.updateWealthHeader();
        }
    }

    public void clearTableSelection() {
        this.buyTreeTable.getSelectionModel().clearSelection();
        this.sellTreeTable.getSelectionModel().clearSelection();
    }

    private void deleteSelectedTreeTableRow(JXTreeTable treeTable) {
        AbstractPortfolioTreeTableModelEx portfolioTreeTableModel = (AbstractPortfolioTreeTableModelEx)treeTable.getTreeTableModel();
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        if (treePaths == null) {
            return;
        }
        for (TreePath treePath : treePaths) {
            Object o = treePath.getLastPathComponent();
            if (portfolioTreeTableModel.getRoot() == o) continue;
            MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)o;
            if (!this.isValidTreeTableNode((TreeTableModel)portfolioTreeTableModel, mutableTreeTableNode)) {
                portfolioTreeTableModel.fireTreeTableNodeChanged((TreeTableNode)mutableTreeTableNode);
                continue;
            }
            if (o instanceof Transaction) {
                portfolioTreeTableModel.removeTransaction((Transaction)o);
                continue;
            }
            if (!(o instanceof TransactionSummary)) continue;
            portfolioTreeTableModel.removeTransactionSummary((TransactionSummary)o);
        }
    }

    private void deteleSelectedTreeTableRow() {
        this.deleteSelectedTreeTableRow(this.buyTreeTable);
        this.deleteSelectedTreeTableRow(this.sellTreeTable);
        this.updateWealthHeader();
    }

    private void buyTreeTableValueChanged(TreeSelectionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PortfolioManagementJPanel.this.buyTreeTable.getSelectedRowCount() > 0) {
                    PortfolioManagementJPanel.this.sellTreeTable.clearSelection();
                }
            }
        });
    }

    private void sellTreeTableValueChanged(TreeSelectionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PortfolioManagementJPanel.this.sellTreeTable.getSelectedRowCount() > 0) {
                    PortfolioManagementJPanel.this.buyTreeTable.clearSelection();
                }
            }
        });
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clearTableSelection();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        List<Stock> stocks = this.getSelectedStocks(this.buyTreeTable);
        if (stocks.size() != 1) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_you_need_to_select_only_single_stock_from_buy_portfolio_to_perform_sell_transaction"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_you_need_to_select_only_single_stock_from_buy_portfolio_to_perform_sell_transaction"), 1);
            return;
        }
        List<Transaction> transactions = this.getSelectedTransactions(this.buyTreeTable);
        this.showNewSellTransactionJDialog(transactions);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.showDepositSummaryJDialog();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.showDividendSummaryJDialog();
    }

    private List<Transaction> getSelectedTransactions(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        if (treePaths == null) {
            return Collections.unmodifiableList(transactions);
        }
        for (TreePath treePath : treePaths) {
            Object o = treePath.getLastPathComponent();
            if (o instanceof Transaction) {
                Transaction transaction = (Transaction)o;
                if (transactions.contains(transaction)) continue;
                transactions.add(transaction);
                continue;
            }
            if (!(o instanceof TransactionSummary)) continue;
            TransactionSummary transactionSummary = (TransactionSummary)o;
            int count = transactionSummary.getChildCount();
            for (int i = 0; i < count; ++i) {
                Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
                if (transactions.contains(transaction)) continue;
                transactions.add(transaction);
            }
        }
        return Collections.unmodifiableList(transactions);
    }

    private boolean isOnlyTreeTableRootBeingSelected(JXTreeTable treeTable) {
        if (treeTable.getSelectedRowCount() != 1) {
            return false;
        }
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        Object o = treePaths[0].getLastPathComponent();
        AbstractPortfolioTreeTableModelEx portfolioTreeTableModel = (AbstractPortfolioTreeTableModelEx)treeTable.getTreeTableModel();
        return portfolioTreeTableModel.getRoot() == o;
    }

    private void showDividendSummaryJDialog() {
        MainFrame mainFrame = MainFrame.getInstance();
        DividendSummaryJDialog dividendSummaryJDialog = new DividendSummaryJDialog((Frame)mainFrame, true, this.getDividendSummary(), this);
        dividendSummaryJDialog.setLocationRelativeTo(this);
        List<Stock> stocks = this.getSelectedStocks();
        if (stocks.size() == 1) {
            dividendSummaryJDialog.addNewDividend(StockInfo.newInstance(stocks.get(0)));
        }
        dividendSummaryJDialog.setVisible(true);
        DividendSummary _dividendSummary = dividendSummaryJDialog.getDividendSummaryAfterPressingOK();
        if (_dividendSummary != null) {
            this.dividendSummary = _dividendSummary;
            this.updateWealthHeader();
        }
    }

    private void showSplitOrMergeJDialog(StockInfo stockInfo) {
        MainFrame mainFrame = MainFrame.getInstance();
        SplitJDialog splitOrMergeJDialog = new SplitJDialog((Frame)mainFrame, true, stockInfo);
        splitOrMergeJDialog.pack();
        splitOrMergeJDialog.setLocationRelativeTo(this);
        splitOrMergeJDialog.setVisible(true);
        if (splitOrMergeJDialog.getRatio() == null) {
            return;
        }
        double ratio = splitOrMergeJDialog.getRatio();
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        portfolioTreeTableModel.split(stockInfo, ratio);
        this.updateWealthHeader();
    }

    private void showDepositSummaryJDialog() {
        MainFrame mainFrame = MainFrame.getInstance();
        DepositSummaryJDialog depositSummaryJDialog = new DepositSummaryJDialog((Frame)mainFrame, true, this.getDepositSummary());
        depositSummaryJDialog.setLocationRelativeTo(this);
        depositSummaryJDialog.setVisible(true);
        DepositSummary _depositSummary = depositSummaryJDialog.getDepositSummaryAfterPressingOK();
        if (_depositSummary != null) {
            this.depositSummary = _depositSummary;
            this.updateWealthHeader();
        }
    }

    private void showCommentJDialog(Commentable commentable, String title) {
        if (commentable == null) {
            return;
        }
        MainFrame mainFrame = MainFrame.getInstance();
        CommentJDialog commentJDialog = new CommentJDialog((Frame)mainFrame, true, commentable);
        commentJDialog.setTitle(title);
        commentJDialog.setLocationRelativeTo(this);
        commentJDialog.setVisible(true);
    }

    public DepositSummary getDepositSummary() {
        return this.depositSummary;
    }

    public DividendSummary getDividendSummary() {
        return this.dividendSummary;
    }

    private ImageIcon getImageIcon(String imageIcon) {
        return new ImageIcon(this.getClass().getResource(imageIcon));
    }

    private void showBuyPortfolioChartJDialog() {
        MainFrame m = MainFrame.getInstance();
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        BuyPortfolioChartJDialog buyPortfolioChartJDialog = new BuyPortfolioChartJDialog((Frame)m, false, buyPortfolioTreeTableModel, this.getDividendSummary());
        buyPortfolioChartJDialog.setVisible(true);
    }

    private void showChashFlowChartJDialog() {
        MainFrame m = MainFrame.getInstance();
        InvestmentFlowChartJDialog cashFlowChartJDialog = new InvestmentFlowChartJDialog((Frame)m, false, this);
        cashFlowChartJDialog.setVisible(true);
    }

    private void showSellPortfolioChartJDialog() {
        MainFrame m = MainFrame.getInstance();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        SellPortfolioChartJDialog sellPortfolioChartJDialog = new SellPortfolioChartJDialog((Frame)m, false, sellPortfolioTreeTableModel, this.getDividendSummary());
        sellPortfolioChartJDialog.setVisible(true);
    }

    private JPopupMenu getSellTreeTablePopupMenu() {
        final List<Transaction> transactions = this.getSelectedTransactions(this.sellTreeTable);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = null;
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_Cash..."), this.getImageIcon("/images/16x16/money.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDepositSummaryJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Dividend..."), this.getImageIcon("/images/16x16/money2.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryJDialog();
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        if (transactions.size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Edit..."), this.getImageIcon("/images/16x16/edit.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
                }
            });
            popup.add(menuItem);
        }
        final Commentable commentable = this.getSelectedCommentable(this.sellTreeTable);
        final String tmp = this.getSelectedFirstColumnString(this.sellTreeTable);
        if (commentable != null && tmp != null) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Note..."), this.getImageIcon("/images/16x16/sticky.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String template = GUIBundle.getString("PortfolioManagementJPanel_NoteFor_template");
                    String title = MessageFormat.format(template, tmp);
                    PortfolioManagementJPanel.this.showCommentJDialog(commentable, title);
                }
            });
            popup.add(menuItem);
            popup.addSeparator();
        } else if (transactions.size() == 1) {
            popup.addSeparator();
        }
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_InvestmentChart..."), this.getImageIcon("/images/16x16/graph.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showChashFlowChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_DividendChart"), this.getImageIcon("/images/16x16/chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryBarChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Summary..."), this.getImageIcon("/images/16x16/pie_chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showSellPortfolioChartJDialog();
            }
        });
        popup.add(menuItem);
        if (!this.isOnlyTreeTableRootBeingSelected(this.sellTreeTable) && this.sellTreeTable.getSelectedRow() > 0) {
            final MainFrame m = MainFrame.getInstance();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List stocks = PortfolioManagementJPanel.this.getSelectedStocks(PortfolioManagementJPanel.this.sellTreeTable);
                    for (Stock stock : stocks) {
                        m.displayHistoryChart(stock);
                    }
                }
            });
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.deteleSelectedTreeTableRow();
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private void showDividendSummaryBarChartJDialog() {
        MainFrame m = MainFrame.getInstance();
        DividendSummaryBarChartJDialog dividendSummaryBarChartJDialog = new DividendSummaryBarChartJDialog((Frame)m, false, this.getDividendSummary());
        dividendSummaryBarChartJDialog.setVisible(true);
    }

    private JPopupMenu getBuyTreeTablePopupMenu() {
        List<Stock> selectedStocks;
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Buy..."), this.getImageIcon("/images/16x16/inbox.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                List stocks = PortfolioManagementJPanel.this.getSelectedStocks();
                if (stocks.size() == 1) {
                    PortfolioManagementJPanel.this.showNewBuyTransactionJDialog((Stock)stocks.get(0), PortfolioManagementJPanel.this.getStockPrice((Stock)stocks.get(0)), true);
                } else {
                    PortfolioManagementJPanel.this.showNewBuyTransactionJDialog(Utils.getEmptyStock(Code.newInstance(""), Symbol.newInstance("")), 0.0, true);
                }
            }
        });
        popup.add(menuItem);
        final List<Transaction> transactions = this.getSelectedTransactions(this.buyTreeTable);
        List<Stock> stocks = this.getSelectedStocks(this.buyTreeTable);
        if (transactions.size() > 0 && stocks.size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Sell..."), this.getImageIcon("/images/16x16/outbox.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showNewSellTransactionJDialog(transactions);
                }
            });
            popup.add(menuItem);
        }
        popup.addSeparator();
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_Cash..."), this.getImageIcon("/images/16x16/money.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDepositSummaryJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Dividend..."), this.getImageIcon("/images/16x16/money2.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryJDialog();
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        boolean needToAddSeperator = false;
        if (transactions.size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Edit..."), this.getImageIcon("/images/16x16/edit.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
                }
            });
            popup.add(menuItem);
            needToAddSeperator = true;
        }
        final Commentable commentable = this.getSelectedCommentable(this.buyTreeTable);
        final String tmp = this.getSelectedFirstColumnString(this.buyTreeTable);
        if (commentable != null && tmp != null) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Note..."), this.getImageIcon("/images/16x16/sticky.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String template = GUIBundle.getString("PortfolioManagementJPanel_NoteFor_template");
                    String title = MessageFormat.format(template, tmp);
                    PortfolioManagementJPanel.this.showCommentJDialog(commentable, title);
                }
            });
            popup.add(menuItem);
            needToAddSeperator = true;
        }
        if ((selectedStocks = this.getSelectedStocks()).size() == 1) {
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_SplitOrMerge"), this.getImageIcon("/images/16x16/merge.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.showSplitOrMergeJDialog(StockInfo.newInstance((Stock)selectedStocks.get(0)));
                }
            });
            popup.add(menuItem);
            needToAddSeperator = true;
        }
        if (needToAddSeperator) {
            popup.addSeparator();
        }
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_InvestmentChart..."), this.getImageIcon("/images/16x16/graph.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showChashFlowChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagementJPanel_DividendChart"), this.getImageIcon("/images/16x16/chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showDividendSummaryBarChartJDialog();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Summary..."), this.getImageIcon("/images/16x16/pie_chart.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioManagementJPanel.this.showBuyPortfolioChartJDialog();
            }
        });
        popup.add(menuItem);
        if (!this.isOnlyTreeTableRootBeingSelected(this.buyTreeTable) && this.buyTreeTable.getSelectedRow() > 0) {
            final MainFrame m = MainFrame.getInstance();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List stocks = PortfolioManagementJPanel.this.getSelectedStocks(PortfolioManagementJPanel.this.buyTreeTable);
                    for (Stock stock : stocks) {
                        m.displayHistoryChart(stock);
                    }
                }
            });
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = new JMenuItem(GUIBundle.getString("PortfolioManagement_Delete"), this.getImageIcon("/images/16x16/editdelete.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PortfolioManagementJPanel.this.deteleSelectedTreeTableRow();
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private void editSellTransaction(Transaction newTransaction, Transaction oldTransaction) {
        assert (newTransaction.getType() == Contract.Type.Sell);
        assert (oldTransaction.getType() == Contract.Type.Sell);
        SellPortfolioTreeTableModelEx portfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        portfolioTreeTableModel.editTransaction(newTransaction, oldTransaction);
    }

    private void editBuyTransaction(Transaction newTransaction, Transaction oldTransaction) {
        assert (newTransaction.getType() == Contract.Type.Buy);
        assert (oldTransaction.getType() == Contract.Type.Buy);
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        portfolioTreeTableModel.editTransaction(newTransaction, oldTransaction);
    }

    private int getBuyTransactionSize() {
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        return portfolioTreeTableModel.getTransactionSize();
    }

    private int getSellTransactionSize() {
        SellPortfolioTreeTableModelEx portfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        return portfolioTreeTableModel.getTransactionSize();
    }

    private TransactionSummary addBuyTransaction(Transaction transaction) {
        assert (transaction.getType() == Contract.Type.Buy);
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        TransactionSummary transactionSummary = portfolioTreeTableModel.addTransaction(transaction);
        if (this.realTimeStockMonitor != null) {
            this.realTimeStockMonitor.addStockCode(transaction.getStock().code);
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
        }
        return transactionSummary;
    }

    public List<TransactionSummary> getTransactionSummariesFromPortfolios() {
        int i;
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        Portfolio buyPortfolio = (Portfolio)buyPortfolioTreeTableModel.getRoot();
        Portfolio sellPortfolio = (Portfolio)sellPortfolioTreeTableModel.getRoot();
        ArrayList<TransactionSummary> summaries = new ArrayList<TransactionSummary>();
        int count = buyPortfolio.getChildCount();
        for (i = 0; i < count; ++i) {
            summaries.add((TransactionSummary)buyPortfolio.getChildAt(i));
        }
        count = sellPortfolio.getChildCount();
        for (i = 0; i < count; ++i) {
            summaries.add((TransactionSummary)sellPortfolio.getChildAt(i));
        }
        return summaries;
    }

    public List<StockInfo> getStockInfosFromPortfolios() {
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        Portfolio buyPortfolio = (Portfolio)buyPortfolioTreeTableModel.getRoot();
        Portfolio sellPortfolio = (Portfolio)sellPortfolioTreeTableModel.getRoot();
        HashSet<Code> codes = new HashSet<Code>();
        ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
        int count = buyPortfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            transactionSummary = (TransactionSummary)buyPortfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Stock stock = transaction.getStock();
            if (codes.contains(stock.code)) continue;
            codes.add(stock.code);
            stockInfos.add(StockInfo.newInstance(stock));
        }
        int count2 = sellPortfolio.getChildCount();
        transactionSummary = null;
        for (int i = 0; i < count2; ++i) {
            transactionSummary = (TransactionSummary)sellPortfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Stock stock = transaction.getStock();
            if (codes.contains(stock.code)) continue;
            codes.add(stock.code);
            stockInfos.add(StockInfo.newInstance(stock));
        }
        return stockInfos;
    }

    private TransactionSummary addSellTransaction(Transaction transaction) {
        assert (transaction.getType() == Contract.Type.Sell);
        SellPortfolioTreeTableModelEx portfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        return portfolioTreeTableModel.addTransaction(transaction);
    }

    private void updateRealTimeStockMonitorAccordingToBuyPortfolioTreeTableModel() {
        if (this.realTimeStockMonitor == null) {
            return;
        }
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        if (portfolioTreeTableModel != null) {
            this.buyTreeTable.setTreeTableModel((TreeTableModel)portfolioTreeTableModel);
            Portfolio portfolio = (Portfolio)portfolioTreeTableModel.getRoot();
            int count = portfolio.getChildCount();
            for (int i = 0; i < count; ++i) {
                TransactionSummary transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
                if (transactionSummary.getChildCount() <= 0) continue;
                Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
                this.realTimeStockMonitor.addStockCode(transaction.getStock().code);
            }
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
        }
    }

    private List<Stock> getSelectedStocks(JXTreeTable treeTable) {
        TreePath[] treePaths = treeTable.getTreeSelectionModel().getSelectionPaths();
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        HashSet<Code> c = new HashSet<Code>();
        if (treePaths == null) {
            return Collections.unmodifiableList(stocks);
        }
        for (TreePath treePath : treePaths) {
            Object lastPathComponent = treePath.getLastPathComponent();
            if (lastPathComponent instanceof TransactionSummary) {
                TransactionSummary transactionSummary = (TransactionSummary)lastPathComponent;
                assert (transactionSummary.getChildCount() > 0);
                Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
                Stock stock = transaction.getStock();
                Code code = stock.code;
                if (c.contains(code)) continue;
                stocks.add(stock);
                c.add(code);
                continue;
            }
            if (!(lastPathComponent instanceof Transaction)) continue;
            Transaction transaction = (Transaction)lastPathComponent;
            Stock stock = transaction.getStock();
            Code code = stock.code;
            if (c.contains(code)) continue;
            stocks.add(stock);
            c.add(code);
        }
        return Collections.unmodifiableList(stocks);
    }

    private boolean initCSVPortfolio() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        List<String> availablePortfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        if (availablePortfolioNames.size() <= 0) {
            org.yccheok.jstock.portfolio.Utils.createEmptyPortfolio(org.yccheok.jstock.portfolio.Utils.getDefaultPortfolioName());
            availablePortfolioNames = org.yccheok.jstock.portfolio.Utils.getPortfolioNames();
        }
        assert (!availablePortfolioNames.isEmpty());
        if (!availablePortfolioNames.contains(jStockOptions.getPortfolioName())) {
            jStockOptions.setPortfolioName(availablePortfolioNames.get(0));
        }
        this.buyTreeTable.setTreeTableModel((TreeTableModel)new BuyPortfolioTreeTableModelEx());
        this.sellTreeTable.setTreeTableModel((TreeTableModel)new SellPortfolioTreeTableModelEx());
        this.depositSummary = new DepositSummary();
        this.dividendSummary = new DividendSummary();
        File buyPortfolioFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "buyportfolio.csv");
        File sellPortfolioFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "sellportfolio.csv");
        File depositSummaryFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "depositsummary.csv");
        File dividendSummaryFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "dividendsummary.csv");
        if (!this.openAsCSVFile(buyPortfolioFile) && buyPortfolioFile.exists()) {
            return false;
        }
        if (!this.openAsCSVFile(sellPortfolioFile) && sellPortfolioFile.exists()) {
            return false;
        }
        if (!this.openAsCSVFile(dividendSummaryFile) && dividendSummaryFile.exists()) {
            return false;
        }
        if (!this.openAsCSVFile(depositSummaryFile) && depositSummaryFile.exists()) {
            return false;
        }
        this.timestamp = this.initCSVStockPrices();
        this.refershGUIAfterInitPortfolio((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), this.dividendSummary, this.depositSummary);
        return true;
    }

    public void refreshGUIAfterOptionsJDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._refreshGUIAfterOptionsJDialog();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this._refreshGUIAfterOptionsJDialog();
                }
            });
        }
    }

    private void _refreshGUIAfterOptionsJDialog() {
        this.buyTreeTable.repaint();
        this.sellTreeTable.repaint();
        this.updateWealthHeader();
    }

    public void refreshGUIAfterFeeCalculationEnabledOptionsChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._refreshGUIAfterFeeCalculationEnabledOptionsChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this._refreshGUIAfterFeeCalculationEnabledOptionsChanged();
                }
            });
        }
    }

    public void _refreshGUIAfterFeeCalculationEnabledOptionsChanged() {
        this.buyTreeTable.repaint();
        this.sellTreeTable.repaint();
        this.updateWealthHeader();
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        JTable[] tables = new JTable[]{this.sellTreeTable, this.buyTreeTable};
        String[] names = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty")};
        for (JTable table : tables) {
            for (String name : names) {
                if (jStockOptions.isFeeCalculationEnabled()) {
                    int columnCount = table.getColumnCount();
                    JTableUtilities.insertTableColumnFromModel(table, name, columnCount);
                    continue;
                }
                JTableUtilities.removeTableColumn(table, name);
            }
        }
    }

    private void _refershGUIAfterInitPortfolio(BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, DividendSummary _dividendSummary, DepositSummary _depositSummary) {
        if (this.buyTreeTable.getTreeTableModel() != buyPortfolioTreeTableModel) {
            this.buyTreeTable.setTreeTableModel((TreeTableModel)buyPortfolioTreeTableModel);
        }
        if (this.sellTreeTable.getTreeTableModel() != sellPortfolioTreeTableModel) {
            this.sellTreeTable.setTreeTableModel((TreeTableModel)sellPortfolioTreeTableModel);
        }
        this.depositSummary = _depositSummary;
        this.dividendSummary = _dividendSummary;
        this.updateRealTimeStockMonitorAccordingToBuyPortfolioTreeTableModel();
        this.updateWealthHeader();
        this.initGUIOptions();
        this.updateTitledBorder();
        this.refreshCurrencySymbol();
        this.expandTreeTable(this.buyTreeTable);
        this.expandTreeTable(this.sellTreeTable);
    }

    private void expandTreeTable(JXTreeTable treeTable) {
        if (treeTable.isExpanded(0)) {
            treeTable.collapseRow(0);
        }
        treeTable.expandRow(0);
    }

    private void refershGUIAfterInitPortfolio(final BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, final SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, final DividendSummary _dividendSummary, final DepositSummary _depositSummary) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._refershGUIAfterInitPortfolio(buyPortfolioTreeTableModel, sellPortfolioTreeTableModel, _dividendSummary, _depositSummary);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this._refershGUIAfterInitPortfolio(buyPortfolioTreeTableModel, sellPortfolioTreeTableModel, _dividendSummary, _depositSummary);
                }
            });
        }
    }

    public final void initPortfolio() {
        this.timestamp = 0L;
        this.initCSVPortfolio();
    }

    public void updateTitledBorder() {
        final JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (SwingUtilities.isEventDispatchThread()) {
            TitledBorder titledBorder = (TitledBorder)this.jPanel1.getBorder();
            titledBorder.setTitle(jStockOptions.getPortfolioName());
            this.jPanel1.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TitledBorder titledBorder = (TitledBorder)PortfolioManagementJPanel.this.jPanel1.getBorder();
                    titledBorder.setTitle(jStockOptions.getPortfolioName());
                    PortfolioManagementJPanel.this.jPanel1.repaint();
                }
            });
        }
    }

    public static boolean saveCSVPortfolio(String directory, CSVPortfolio csvPortfolio, long timestamp) {
        int count;
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel;
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel;
        int count2;
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        assert (directory.endsWith(File.separator));
        File buyPortfolioFile = new File(directory + "buyportfolio.csv");
        File sellPortfolioFile = new File(directory + "sellportfolio.csv");
        File dividendSummaryFile = new File(directory + "dividendsummary.csv");
        File depositSummaryFile = new File(directory + "depositsummary.csv");
        Utils.FileEx buyPortfolioFileEx = new Utils.FileEx(buyPortfolioFile, Statement.Type.PortfolioManagementBuy);
        Utils.FileEx sellPortfolioFileEx = new Utils.FileEx(sellPortfolioFile, Statement.Type.PortfolioManagementSell);
        Utils.FileEx dividendSummaryFileEx = new Utils.FileEx(dividendSummaryFile, Statement.Type.PortfolioManagementDividend);
        Utils.FileEx depositSummaryFileEx = new Utils.FileEx(depositSummaryFile, Statement.Type.PortfolioManagementDeposit);
        if (!PortfolioManagementJPanel.saveAsCSVFile(csvPortfolio, buyPortfolioFileEx, true) && (count2 = (buyPortfolioTreeTableModel = csvPortfolio.buyPortfolioTreeTableModel).getRoot().getChildCount()) > 0) {
            buyPortfolioFileEx.file.delete();
            return false;
        }
        if (!PortfolioManagementJPanel.saveAsCSVFile(csvPortfolio, sellPortfolioFileEx, true) && (count2 = (sellPortfolioTreeTableModel = csvPortfolio.sellPortfolioTreeTableModel).getRoot().getChildCount()) > 0) {
            sellPortfolioFileEx.file.delete();
            buyPortfolioFileEx.file.delete();
            return false;
        }
        if (!PortfolioManagementJPanel.saveAsCSVFile(csvPortfolio, dividendSummaryFileEx, true) && (count = csvPortfolio.dividendSummary.size()) > 0) {
            dividendSummaryFileEx.file.delete();
            depositSummaryFileEx.file.delete();
            sellPortfolioFileEx.file.delete();
            buyPortfolioFileEx.file.delete();
            return false;
        }
        if (!PortfolioManagementJPanel.saveAsCSVFile(csvPortfolio, depositSummaryFileEx, true) && (count = csvPortfolio.depositSummary.size()) > 0) {
            depositSummaryFileEx.file.delete();
            sellPortfolioFileEx.file.delete();
            buyPortfolioFileEx.file.delete();
            return false;
        }
        return PortfolioManagementJPanel.saveCSVStockPrices(directory, csvPortfolio.buyPortfolioTreeTableModel, timestamp);
    }

    private boolean saveCSVPortfolio() {
        return PortfolioManagementJPanel.saveCSVPortfolio(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory(), CSVPortfolio.newInstance((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), this.dividendSummary, this.depositSummary), this.timestamp);
    }

    private long initCSVStockPrices() {
        File stockPricesFile = new File(org.yccheok.jstock.portfolio.Utils.getPortfolioDirectory() + "stockprices.csv");
        LinkedHashMap<Code, Double> stockPrices = new LinkedHashMap<Code, Double>();
        Statements statements = Statements.newInstanceFromCSVFile(stockPricesFile);
        if (statements.getType() == Statement.Type.StockPrice) {
            GUIBundleWrapper guiBundleWrapper = statements.getGUIBundleWrapper();
            int ei = statements.size();
            for (int i = 0; i < ei; ++i) {
                Statement statement = statements.get(i);
                String codeStr = statement.getValueAsString(guiBundleWrapper.getString("MainFrame_Code"));
                Double price = statement.getValueAsDouble(guiBundleWrapper.getString("MainFrame_Last"));
                if (codeStr == null || price == null) continue;
                Code code = Code.newInstance(codeStr);
                stockPrices.put(code, price);
            }
        }
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        for (Map.Entry entry : stockPrices.entrySet()) {
            Code code = (Code)entry.getKey();
            Double price = (Double)entry.getValue();
            portfolioTreeTableModel.updateStockLastPrice(code, price);
        }
        long _timestamp = 0L;
        try {
            _timestamp = Long.parseLong(statements.getMetadatas().get("timestamp"));
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
        }
        return _timestamp;
    }

    private static boolean saveCSVStockPrices(String directory, BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModelEx, long timestamp) {
        assert (directory.endsWith(File.separator));
        Map<Code, Double> stockPrices = buyPortfolioTreeTableModelEx.getStockPrices();
        HashMap<Code, Double> goodStockPrices = new HashMap<Code, Double>();
        Portfolio portfolio = (Portfolio)buyPortfolioTreeTableModelEx.getRoot();
        int count = portfolio.getChildCount();
        for (int i = 0; i < count; ++i) {
            TransactionSummary transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Code code = transaction.getStock().code;
            Double price = stockPrices.get(code);
            if (price == null) {
                goodStockPrices.put(code, 0.0);
                continue;
            }
            goodStockPrices.put(code, price);
        }
        Statements statements = Statements.newInstanceFromStockPrices(goodStockPrices, timestamp);
        File stockPricesFile = new File(directory + "stockprices.csv");
        return statements.saveAsCSVFile(stockPricesFile);
    }

    public boolean savePortfolio() {
        return this.saveCSVPortfolio();
    }

    public void updatePrimaryStockServerFactory(List<StockServerFactory> stockServerFactories) {
        if (this.realTimeStockMonitor != null) {
            this.realTimeStockMonitor.setStockServerFactories(stockServerFactories);
        }
        if (this.currencyExchangeMonitor != null) {
            this.currencyExchangeMonitor.setStockServerFactories(stockServerFactories);
        }
    }

    public void initCurrencyExchangeMonitor(List<StockServerFactory> stockServerFactories) {
        MainFrame mainFrame = MainFrame.getInstance();
        JStockOptions jStockOptions = mainFrame.getJStockOptions();
        Country fromCountry = jStockOptions.getCountry();
        Country toCountry = jStockOptions.getLocalCurrencyCountry(fromCountry);
        mainFrame.setStatusBarExchangeRateVisible(jStockOptions.isCurrencyExchangeEnable(fromCountry));
        if (this.currencyExchangeMonitor != null && this.currencyExchangeMonitor.getFromCountry() == fromCountry && this.currencyExchangeMonitor.getToCountry() == toCountry) {
            if (jStockOptions.isCurrencyExchangeEnable(fromCountry)) {
                this.currencyExchangeMonitor.start();
                this.currencyExchangeMonitor.resume();
            } else {
                this.currencyExchangeMonitor.suspend();
            }
            this.updateWealthHeader();
            return;
        }
        final CurrencyExchangeMonitor oldCurrencyExchangeMonitor = this.currencyExchangeMonitor;
        if (oldCurrencyExchangeMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldCurrencyExchangeMonitor + "..."));
                    oldCurrencyExchangeMonitor.dettachAll();
                    oldCurrencyExchangeMonitor.stop();
                    log.info((Object)("Shut down " + oldCurrencyExchangeMonitor + " peacefully."));
                }
            });
        }
        this.currencyExchangeMonitor = new CurrencyExchangeMonitor(fromCountry, toCountry);
        this.currencyExchangeMonitor.setStockServerFactories(stockServerFactories);
        this.currencyExchangeMonitor.attach(this.currencyExchangeMonitorObserver);
        String text = MessageFormat.format(GUIBundle.getString("MyJXStatusBar_CurrencyExchangeRateFor"), this.currencyExchangeMonitor.getFromCurrency(), this.currencyExchangeMonitor.getToCurrency());
        mainFrame.setStatusBarExchangeRateToolTipText(text);
        mainFrame.setStatusBarExchangeRate(null);
        if (jStockOptions.isCurrencyExchangeEnable(fromCountry)) {
            this.currencyExchangeMonitor.start();
        }
        this.updateWealthHeader();
    }

    public void initRealTimeStockMonitor(List<StockServerFactory> stockServerFactories) {
        final RealTimeStockMonitor oldRealTimeStockMonitor = this.realTimeStockMonitor;
        if (oldRealTimeStockMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeStockMonitor + "..."));
                    oldRealTimeStockMonitor.clearStockCodes();
                    oldRealTimeStockMonitor.dettachAll();
                    oldRealTimeStockMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeStockMonitor + " peacefully."));
                }
            });
        }
        this.realTimeStockMonitor = new RealTimeStockMonitor(4, 20, MainFrame.getInstance().getJStockOptions().getScanningSpeed());
        this.realTimeStockMonitor.setStockServerFactories(stockServerFactories);
        this.realTimeStockMonitor.attach(this.realTimeStockMonitorObserver);
        this.updateRealTimeStockMonitorAccordingToBuyPortfolioTreeTableModel();
    }

    private Observer<CurrencyExchangeMonitor, Double> getCurrencyExchangeMonitorObserver() {
        return new Observer<CurrencyExchangeMonitor, Double>(){

            @Override
            public void update(CurrencyExchangeMonitor subject, Double arg) {
                MainFrame.getInstance().setStatusBarExchangeRate(arg);
                PortfolioManagementJPanel.this.updateWealthHeader();
            }
        };
    }

    private Observer<RealTimeStockMonitor, List<Stock>> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, List<Stock>>(){

            @Override
            public void update(RealTimeStockMonitor monitor, List<Stock> stocks) {
                PortfolioManagementJPanel.this.update(monitor, stocks);
            }
        };
    }

    private void update(RealTimeStockMonitor monitor, List<Stock> stocks) {
        BuyPortfolioTreeTableModelEx portfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        for (Stock stock : stocks) {
            if (portfolioTreeTableModel.updateStockLastPrice(stock)) continue;
            this.realTimeStockMonitor.removeStockCode(stock.code);
        }
        this.updateWealthHeader();
        this.timestamp = System.currentTimeMillis();
        MainFrame.getInstance().updateStatusBarWithLastUpdateDateMessageIfPossible();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void initGUIOptions() {
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "portfoliomanagementjpanel.xml");
        GUIOptions guiOptions = Utils.fromXML(GUIOptions.class, f);
        if (guiOptions == null) {
            return;
        }
        if (guiOptions.getJTableOptionsSize() <= 1) {
            return;
        }
        JXTreeTable[] treeTables = new JXTreeTable[]{this.buyTreeTable, this.sellTreeTable};
        for (int tableIndex = 0; tableIndex < treeTables.length; ++tableIndex) {
            JXTreeTable treeTable = treeTables[tableIndex];
            JTableHeader jTableHeader = treeTable.getTableHeader();
            JTable jTable = jTableHeader.getTable();
            JTableUtilities.setJTableOptions(jTable, guiOptions.getJTableOptions(tableIndex));
        }
        if (guiOptions.getDividerLocationSize() > 0) {
            this.dividerLocation = guiOptions.getDividerLocation(0);
        }
    }

    public void updateDividerLocation() {
        if (this.dividerLocation > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioManagementJPanel.this.jSplitPane1.setDividerLocation(PortfolioManagementJPanel.this.dividerLocation);
                }
            });
        }
    }

    public boolean saveGUIOptions() {
        JXTreeTable[] treeTables;
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(Utils.getUserDataDirectory() + "config")) {
            return false;
        }
        GUIOptions guiOptions = new GUIOptions();
        for (JXTreeTable treeTable : treeTables = new JXTreeTable[]{this.buyTreeTable, this.sellTreeTable}) {
            JTableHeader jTableHeader = treeTable.getTableHeader();
            JTable jTable = jTableHeader.getTable();
            GUIOptions.JTableOptions jTableOptions = new GUIOptions.JTableOptions();
            int count = jTable.getColumnCount();
            for (int i = 0; i < count; ++i) {
                String name = jTable.getColumnName(i);
                TableColumn column = jTable.getColumnModel().getColumn(i);
                jTableOptions.addColumnOption(GUIOptions.JTableOptions.ColumnOption.newInstance(name, column.getWidth()));
            }
            guiOptions.addJTableOptions(jTableOptions);
        }
        guiOptions.addDividerLocation(this.jSplitPane1.getDividerLocation());
        File f = new File(Utils.getUserDataDirectory() + "config" + File.separator + "portfoliomanagementjpanel.xml");
        return Utils.toXML((Object)guiOptions, f);
    }

    public boolean saveAsExcelFile(File file, boolean languageIndependent) {
        Statements statements0 = Statements.newInstanceFromBuyPortfolioTreeTableModel((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), languageIndependent);
        Statements statements1 = Statements.newInstanceFromSellPortfolioTreeTableModel((SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), languageIndependent);
        Statements statements2 = Statements.newInstanceFromTableModel(new DividendSummaryTableModel(this.dividendSummary), languageIndependent);
        Statements statements3 = Statements.newInstanceFromTableModel(new DepositSummaryTableModel(this.depositSummary), languageIndependent);
        Statements.StatementsEx statementsEx0 = new Statements.StatementsEx(statements0, GUIBundle.getString("PortfolioManagementJPanel_BuyPortfolio"));
        Statements.StatementsEx statementsEx1 = new Statements.StatementsEx(statements1, GUIBundle.getString("PortfolioManagementJPanel_SellPortfolio"));
        Statements.StatementsEx statementsEx2 = new Statements.StatementsEx(statements2, GUIBundle.getString("PortfolioManagementJPanel_DividendPortfolio"));
        Statements.StatementsEx statementsEx3 = new Statements.StatementsEx(statements3, GUIBundle.getString("PortfolioManagementJPanel_CashDepositPortfolio"));
        List<Statements.StatementsEx> statementsExs = Arrays.asList(statementsEx0, statementsEx1, statementsEx2, statementsEx3);
        return Statements.saveAsExcelFile(file, statementsExs);
    }

    private static boolean saveAsCSVFile(CSVPortfolio csvPortfolio, Utils.FileEx fileEx, boolean languageIndependent) {
        Statements statements = null;
        if (fileEx.type == Statement.Type.PortfolioManagementBuy) {
            statements = Statements.newInstanceFromBuyPortfolioTreeTableModel(csvPortfolio.buyPortfolioTreeTableModel, languageIndependent);
        } else if (fileEx.type == Statement.Type.PortfolioManagementSell) {
            statements = Statements.newInstanceFromSellPortfolioTreeTableModel(csvPortfolio.sellPortfolioTreeTableModel, languageIndependent);
        } else if (fileEx.type == Statement.Type.PortfolioManagementDividend) {
            statements = Statements.newInstanceFromTableModel(new DividendSummaryTableModel(csvPortfolio.dividendSummary), languageIndependent);
        } else if (fileEx.type == Statement.Type.PortfolioManagementDeposit) {
            statements = Statements.newInstanceFromTableModel(new DepositSummaryTableModel(csvPortfolio.depositSummary), languageIndependent);
        }
        return statements.saveAsCSVFile(fileEx.file);
    }

    public boolean saveAsCSVFile(Utils.FileEx fileEx, boolean languageIndependent) {
        CSVPortfolio csvPortfolio = CSVPortfolio.newInstance((BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel(), (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel(), this.dividendSummary, this.depositSummary);
        return PortfolioManagementJPanel.saveAsCSVFile(csvPortfolio, fileEx, languageIndependent);
    }

    public double getCurrencyExchangeRate() {
        CurrencyExchangeMonitor _currencyExchangeMonitor;
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        double exchangeRate = 1.0;
        if (jStockOptions.isCurrencyExchangeEnable(jStockOptions.getCountry()) && (_currencyExchangeMonitor = this.currencyExchangeMonitor) != null) {
            exchangeRate = _currencyExchangeMonitor.getExchangeRate();
        }
        return exchangeRate;
    }

    private void updateWealthHeader() {
        double realizedProfitPercentage;
        double paperProfitPercentage;
        double realizedProfit;
        double paperProfit;
        double cash;
        double share;
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        boolean isPenceToPoundConversionEnabled = jStockOptions.isPenceToPoundConversionEnabled();
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel = (BuyPortfolioTreeTableModelEx)this.buyTreeTable.getTreeTableModel();
        SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel = (SellPortfolioTreeTableModelEx)this.sellTreeTable.getTreeTableModel();
        double exchangeRate = this.getCurrencyExchangeRate();
        if (!isPenceToPoundConversionEnabled) {
            if (isFeeCalculationEnabled) {
                share = exchangeRate * buyPortfolioTreeTableModel.getCurrentValue();
                cash = exchangeRate * (sellPortfolioTreeTableModel.getNetSellingValue() - ((Portfolio)sellPortfolioTreeTableModel.getRoot()).getNetReferenceTotal() - buyPortfolioTreeTableModel.getNetPurchaseValue() + this.getDepositSummary().getTotal() + this.getDividendSummary().getTotal());
                paperProfit = exchangeRate * buyPortfolioTreeTableModel.getNetGainLossValue();
                realizedProfit = exchangeRate * sellPortfolioTreeTableModel.getNetGainLossValue();
            } else {
                share = exchangeRate * buyPortfolioTreeTableModel.getCurrentValue();
                cash = exchangeRate * (sellPortfolioTreeTableModel.getSellingValue() - ((Portfolio)sellPortfolioTreeTableModel.getRoot()).getReferenceTotal() - buyPortfolioTreeTableModel.getPurchaseValue() + this.getDepositSummary().getTotal() + this.getDividendSummary().getTotal());
                paperProfit = exchangeRate * buyPortfolioTreeTableModel.getGainLossValue();
                realizedProfit = exchangeRate * sellPortfolioTreeTableModel.getGainLossValue();
            }
        } else if (isFeeCalculationEnabled) {
            share = exchangeRate * buyPortfolioTreeTableModel.getCurrentValue() / 100.0;
            cash = exchangeRate * (sellPortfolioTreeTableModel.getNetSellingValue() / 100.0 - ((Portfolio)sellPortfolioTreeTableModel.getRoot()).getNetReferenceTotal() / 100.0 - buyPortfolioTreeTableModel.getNetPurchaseValue() / 100.0 + this.getDepositSummary().getTotal() + this.getDividendSummary().getTotal());
            paperProfit = exchangeRate * buyPortfolioTreeTableModel.getNetGainLossValue() / 100.0;
            realizedProfit = exchangeRate * sellPortfolioTreeTableModel.getNetGainLossValue() / 100.0;
        } else {
            share = exchangeRate * buyPortfolioTreeTableModel.getCurrentValue() / 100.0;
            cash = exchangeRate * (sellPortfolioTreeTableModel.getSellingValue() / 100.0 - ((Portfolio)sellPortfolioTreeTableModel.getRoot()).getReferenceTotal() / 100.0 - buyPortfolioTreeTableModel.getPurchaseValue() / 100.0 + this.getDepositSummary().getTotal() + this.getDividendSummary().getTotal());
            paperProfit = exchangeRate * buyPortfolioTreeTableModel.getGainLossValue() / 100.0;
            realizedProfit = exchangeRate * sellPortfolioTreeTableModel.getGainLossValue() / 100.0;
        }
        if (isFeeCalculationEnabled) {
            paperProfitPercentage = buyPortfolioTreeTableModel.getNetGainLossPercentage();
            realizedProfitPercentage = sellPortfolioTreeTableModel.getNetGainLossPercentage();
        } else {
            paperProfitPercentage = buyPortfolioTreeTableModel.getGainLossPercentage();
            realizedProfitPercentage = sellPortfolioTreeTableModel.getGainLossPercentage();
        }
        final String _share = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Two, share);
        final String _cash = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Two, cash);
        final String _paperProfit = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Two, paperProfit);
        final String _paperProfitPercentage = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Two, paperProfitPercentage);
        final String _realizedProfit = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Two, realizedProfit);
        final String _realizedProfitPercentage = org.yccheok.jstock.portfolio.Utils.toCurrency(DecimalPlaces.Two, realizedProfitPercentage);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PortfolioManagementJPanel.this.jLabel2.setText(_share);
                PortfolioManagementJPanel.this.jLabel4.setText(_cash);
                PortfolioManagementJPanel.this.jLabel6.setText(_paperProfit + " (" + _paperProfitPercentage + "%)");
                PortfolioManagementJPanel.this.jLabel8.setText(_realizedProfit + " (" + _realizedProfitPercentage + "%)");
                PortfolioManagementJPanel.this.jLabel2.setForeground(Utils.getColor(share, 0.0));
                PortfolioManagementJPanel.this.jLabel4.setForeground(Utils.getColor(cash, 0.0));
                PortfolioManagementJPanel.this.jLabel6.setForeground(Utils.getColor(paperProfit, 0.0));
                PortfolioManagementJPanel.this.jLabel8.setForeground(Utils.getColor(realizedProfit, 0.0));
            }
        });
    }

    public void resumeRealTimeStockMonitor() {
        if (this.realTimeStockMonitor == null) {
            return;
        }
        this.realTimeStockMonitor.resume();
    }

    public void suspendRealTimeStockMonitor() {
        if (this.realTimeStockMonitor == null) {
            return;
        }
        this.realTimeStockMonitor.suspend();
    }

    public void refreshCurrencySymbol() {
        this.jLabel1.setText(this.getShareLabel());
        this.jLabel3.setText(this.getCashLabel());
        this.jLabel5.setText(this.getPaperProfitLabel());
        this.jLabel7.setText(this.getRealizedProfitLabel());
    }

    private String getShareLabel() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_ShareLabel"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    private String getCashLabel() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_CashLabel_template"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    private String getPaperProfitLabel() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_PaperProfitLabel_template"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    private String getRealizedProfitLabel() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return MessageFormat.format(GUIBundle.getString("PortfolioManagementJPanel_RealizedProfitLabel_template"), jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
    }

    public void refreshCurrencyExchangeMonitor() {
        CurrencyExchangeMonitor _currencyExchangeMonitor = this.currencyExchangeMonitor;
        if (_currencyExchangeMonitor != null) {
            _currencyExchangeMonitor.refresh();
        }
    }

    public void refreshRealTimeStockMonitor() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.refresh();
        }
    }

    static class 43 {
        static final /* synthetic */ int[] $SwitchMap$org$yccheok$jstock$file$Statement$Type;

        static {
            $SwitchMap$org$yccheok$jstock$file$Statement$Type = new int[Statement.Type.values().length];
            try {
                43.$SwitchMap$org$yccheok$jstock$file$Statement$Type[Statement.Type.PortfolioManagementBuy.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                43.$SwitchMap$org$yccheok$jstock$file$Statement$Type[Statement.Type.PortfolioManagementSell.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                43.$SwitchMap$org$yccheok$jstock$file$Statement$Type[Statement.Type.PortfolioManagementDeposit.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                43.$SwitchMap$org$yccheok$jstock$file$Statement$Type[Statement.Type.PortfolioManagementDividend.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class SellTableRowPopupListener
    extends MouseAdapter {
        private SellTableRowPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            List transactions;
            if (evt.getClickCount() == 2 && (transactions = PortfolioManagementJPanel.this.getSelectedTransactions(PortfolioManagementJPanel.this.sellTreeTable)).size() == 1) {
                PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JPopupMenu popupMenu;
            if (e.isPopupTrigger() && (popupMenu = PortfolioManagementJPanel.this.getSellTreeTablePopupMenu()) != null) {
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class BuyTableRowPopupListener
    extends MouseAdapter {
        private BuyTableRowPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            List transactions;
            if (evt.getClickCount() == 2 && (transactions = PortfolioManagementJPanel.this.getSelectedTransactions(PortfolioManagementJPanel.this.buyTreeTable)).size() == 1) {
                PortfolioManagementJPanel.this.showEditTransactionJDialog((Transaction)transactions.get(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PortfolioManagementJPanel.this.getBuyTreeTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class TableKeyEventListener
    extends KeyAdapter {
        private TableKeyEventListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            PortfolioManagementJPanel.this.clearTableSelection();
        }
    }

    public static final class CSVPortfolio {
        public final BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel;
        public final SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel;
        public final DividendSummary dividendSummary;
        public final DepositSummary depositSummary;

        private CSVPortfolio(BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, DividendSummary dividendSummary, DepositSummary depositSummary) {
            this.buyPortfolioTreeTableModel = buyPortfolioTreeTableModel;
            this.sellPortfolioTreeTableModel = sellPortfolioTreeTableModel;
            this.dividendSummary = dividendSummary;
            this.depositSummary = depositSummary;
        }

        public static CSVPortfolio newInstance(BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, DividendSummary dividendSummary, DepositSummary depositSummary) {
            return new CSVPortfolio(buyPortfolioTreeTableModel, sellPortfolioTreeTableModel, dividendSummary, depositSummary);
        }
    }
}

