/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.yccheok.jstock.gui.AbstractTableModelWithMemory;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.watchlist.Utils;

public class StockTableCellRenderer
extends DefaultTableCellRenderer {
    private static final String PREV = GUIBundle.getString("MainFrame_Prev");
    private static final String OPEN = GUIBundle.getString("MainFrame_Open");
    private static final String RISE_ABOVE = GUIBundle.getString("MainFrame_RiseAbove");
    private static final String FALL_BELOW = GUIBundle.getString("MainFrame_FallBelow");
    private static final String LAST = GUIBundle.getString("MainFrame_Last");
    private static final String BUY = GUIBundle.getString("MainFrame_Buy");
    private static final String SELL = GUIBundle.getString("MainFrame_Sell");
    private static final String LOW = GUIBundle.getString("MainFrame_Low");
    private static final String HIGH = GUIBundle.getString("MainFrame_High");
    private static final String CHG = GUIBundle.getString("MainFrame_Chg");
    private static final String CHG_PERCENTAGE = GUIBundle.getString("MainFrame_ChgPercentage");
    private static final String VOL = GUIBundle.getString("MainFrame_Vol");
    private static final String LVOL = GUIBundle.getString("MainFrame_LVol");
    private static final String BQTY = GUIBundle.getString("MainFrame_BQty");
    private static final String SQTY = GUIBundle.getString("MainFrame_SQty");
    private static final String INDICATOR = GUIBundle.getString("IndicatorScannerJPanel_Indicator");

    public StockTableCellRenderer(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
    }

    private void performCellBlinking(Component cell, double value, double oldValue, Color finalForegroundColor, Color finalBackgroundColor, final AbstractTableModelWithMemory tableModel, final int modelRow, final int modelCol) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (value == oldValue) {
            cell.setForeground(finalForegroundColor);
            cell.setBackground(finalBackgroundColor);
            return;
        }
        cell.setForeground(jStockOptions.getAutoUpdateForegroundColor());
        cell.setBackground(jStockOptions.getAutoUpdateBackgroundColor());
        int scanningSpeed = MainFrame.getInstance().getJStockOptions().getScanningSpeed();
        int numberOfMillisecondsInTheFuture = Math.min(5000, scanningSpeed);
        Date timeToRun = new Date(System.currentTimeMillis() + (long)numberOfMillisecondsInTheFuture);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                tableModel.fireTableCellUpdated(modelRow, modelCol);
            }
        }, timeToRun);
    }

    private Color getBackgroundColor(int row, Alert alert) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (alert == Alert.FallBelow) {
            return jStockOptions.getFallBelowAlertBackgroundColor();
        }
        if (alert == Alert.RiseAbove) {
            return jStockOptions.getRiseAboveAlertBackgroundColor();
        }
        if (row % 2 == 0) {
            return jStockOptions.getFirstRowBackgroundColor();
        }
        return jStockOptions.getSecondRowBackgroundColor();
    }

    private Color getNormalTextForegroundColor(Alert alert) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (alert == Alert.FallBelow) {
            return jStockOptions.getFallBelowAlertForegroundColor();
        }
        if (alert == Alert.RiseAbove) {
            return jStockOptions.getRiseAboveAlertForegroundColor();
        }
        return jStockOptions.getNormalTextForegroundColor();
    }

    private Color getForegroundColor(double value, double ref, Alert alert) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean reverse = org.yccheok.jstock.engine.Utils.isFallBelowAndRiseAboveColorReverse();
        if (alert == Alert.FallBelow) {
            return jStockOptions.getFallBelowAlertForegroundColor();
        }
        if (alert == Alert.RiseAbove) {
            return jStockOptions.getRiseAboveAlertForegroundColor();
        }
        if (value > ref) {
            if (reverse) {
                return jStockOptions.getLowerNumericalValueForegroundColor();
            }
            return jStockOptions.getHigherNumericalValueForegroundColor();
        }
        if (value < ref) {
            if (reverse) {
                return jStockOptions.getHigherNumericalValueForegroundColor();
            }
            return jStockOptions.getLowerNumericalValueForegroundColor();
        }
        return jStockOptions.getNormalTextForegroundColor();
    }

    private Component getTableCellRendererComponentWithCellBlinking(Component c, JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel jLabel;
        Object o;
        Object o2;
        JLabel jLabel2;
        int modelCol;
        assert (!isSelected);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        AbstractTableModelWithMemory tableModel = (AbstractTableModelWithMemory)table.getModel();
        int modelRow = table.convertRowIndexToModel(row);
        double prevPrice = (Double)tableModel.getValueAt(modelRow, tableModel.findColumn(PREV));
        double lastPrice = (Double)tableModel.getValueAt(modelRow, tableModel.findColumn(LAST));
        Alert alert = Alert.NoAlert;
        if (lastPrice > 0.0 && jStockOptions.isEnableColorAlert()) {
            Double fallBelow;
            int riseAboveIndex = tableModel.findColumn(RISE_ABOVE);
            int fallBelowIndex = tableModel.findColumn(FALL_BELOW);
            Double riseAbove = riseAboveIndex >= 0 ? (Double)tableModel.getValueAt(table.convertRowIndexToModel(row), riseAboveIndex) : null;
            Double d = fallBelow = fallBelowIndex >= 0 ? (Double)tableModel.getValueAt(table.convertRowIndexToModel(row), fallBelowIndex) : null;
            if (riseAbove != null && lastPrice >= riseAbove) {
                alert = Alert.RiseAbove;
            }
            if (fallBelow != null && lastPrice <= fallBelow) {
                alert = Alert.FallBelow;
            }
        }
        if (table.getColumnName(column).equalsIgnoreCase(BUY)) {
            modelCol = tableModel.findColumn(BUY);
            double buyPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(buyPrice));
            }
            double oldBuyPrice = (o2 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? buyPrice : (Double)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, buyPrice, oldBuyPrice, this.getForegroundColor(buyPrice, prevPrice, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(SELL)) {
            modelCol = tableModel.findColumn(SELL);
            double sellPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(sellPrice));
            }
            double oldSellPrice = (o2 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? sellPrice : (Double)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, sellPrice, oldSellPrice, this.getForegroundColor(sellPrice, prevPrice, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(LAST)) {
            Object o3;
            modelCol = tableModel.findColumn(LAST);
            if (c instanceof JLabel) {
                JLabel jLabel3 = (JLabel)c;
                jLabel3.setText(Utils.toStockPrice(lastPrice));
            }
            double oldLastPrice = (o3 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? lastPrice : (Double)o3;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, lastPrice, oldLastPrice, this.getForegroundColor(lastPrice, prevPrice, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(LOW)) {
            modelCol = tableModel.findColumn(LOW);
            double lowPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(lowPrice));
            }
            double oldLowPrice = (o2 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? lowPrice : (Double)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, lowPrice, oldLowPrice, this.getForegroundColor(lowPrice, prevPrice, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(HIGH)) {
            modelCol = tableModel.findColumn(HIGH);
            double highPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(highPrice));
            }
            double oldHighPrice = (o2 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? highPrice : (Double)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, highPrice, oldHighPrice, this.getForegroundColor(highPrice, prevPrice, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(CHG)) {
            modelCol = tableModel.findColumn(CHG);
            double changePrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(changePrice));
            }
            double oldChangePrice = (o2 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? changePrice : (Double)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, changePrice, oldChangePrice, this.getForegroundColor(changePrice, 0.0, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(CHG_PERCENTAGE)) {
            modelCol = tableModel.findColumn(CHG_PERCENTAGE);
            double changePricePercentage = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(changePricePercentage));
            }
            double oldChangePricePercentage = (o2 = tableModel.getOldValueAt(modelRow, modelCol)) == null ? changePricePercentage : (Double)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, changePricePercentage, oldChangePricePercentage, this.getForegroundColor(changePricePercentage, 0.0, alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(VOL)) {
            modelCol = tableModel.findColumn(VOL);
            long volume = (Long)tableModel.getValueAt(modelRow, modelCol);
            o2 = tableModel.getOldValueAt(modelRow, modelCol);
            long oldVolume = o2 == null ? volume : (Long)o2;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, volume, oldVolume, this.getNormalTextForegroundColor(alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(LVOL)) {
            modelCol = tableModel.findColumn(LVOL);
            int lastVolume = (Integer)tableModel.getValueAt(modelRow, modelCol);
            o = tableModel.getOldValueAt(modelRow, modelCol);
            int oldLastVolume = o == null ? lastVolume : (Integer)o;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, lastVolume, oldLastVolume, this.getNormalTextForegroundColor(alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(BQTY)) {
            modelCol = tableModel.findColumn(BQTY);
            int buyQuantity = (Integer)tableModel.getValueAt(modelRow, modelCol);
            o = tableModel.getOldValueAt(modelRow, modelCol);
            int oldBuyQuantity = o == null ? buyQuantity : (Integer)o;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, buyQuantity, oldBuyQuantity, this.getNormalTextForegroundColor(alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(SQTY)) {
            modelCol = tableModel.findColumn(SQTY);
            int sellQuantity = (Integer)tableModel.getValueAt(modelRow, modelCol);
            o = tableModel.getOldValueAt(modelRow, modelCol);
            int oldSellQuantity = o == null ? sellQuantity : (Integer)o;
            tableModel.clearOldValueAt(modelRow, modelCol);
            this.performCellBlinking(c, sellQuantity, oldSellQuantity, this.getNormalTextForegroundColor(alert), this.getBackgroundColor(row, alert), tableModel, modelRow, modelCol);
            return c;
        }
        if (table.getColumnName(column).equalsIgnoreCase(RISE_ABOVE)) {
            modelCol = tableModel.findColumn(RISE_ABOVE);
            Double riseAbove = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (riseAbove != null && c instanceof JLabel) {
                jLabel = (JLabel)c;
                jLabel.setText(Utils.toStockPrice(riseAbove));
            }
            c.setForeground(this.getNormalTextForegroundColor(alert));
        } else if (table.getColumnName(column).equalsIgnoreCase(FALL_BELOW)) {
            modelCol = tableModel.findColumn(FALL_BELOW);
            Double fallBelow = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (fallBelow != null && c instanceof JLabel) {
                jLabel = (JLabel)c;
                jLabel.setText(Utils.toStockPrice(fallBelow));
            }
            c.setForeground(this.getNormalTextForegroundColor(alert));
        } else if (table.getColumnName(column).equalsIgnoreCase(PREV)) {
            if (c instanceof JLabel) {
                JLabel jLabel4 = (JLabel)c;
                jLabel4.setText(Utils.toStockPrice(prevPrice));
            }
            c.setForeground(this.getNormalTextForegroundColor(alert));
        } else if (table.getColumnName(column).equalsIgnoreCase(INDICATOR)) {
            c.setForeground(Color.BLUE);
        } else {
            c.setForeground(this.getNormalTextForegroundColor(alert));
        }
        c.setBackground(this.getBackgroundColor(row, alert));
        return c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel jLabel;
        JLabel jLabel2;
        int modelCol;
        Component c = super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, column);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (!isSelected && jStockOptions.isEnableColorChange()) {
            return this.getTableCellRendererComponentWithCellBlinking(c, table, color, isSelected, hasFocus, row, column);
        }
        AbstractTableModelWithMemory tableModel = (AbstractTableModelWithMemory)table.getModel();
        int modelRow = table.convertRowIndexToModel(row);
        double prevPrice = (Double)tableModel.getValueAt(modelRow, tableModel.findColumn(PREV));
        double lastPrice = (Double)tableModel.getValueAt(modelRow, tableModel.findColumn(LAST));
        Alert alert = Alert.NoAlert;
        if (lastPrice > 0.0 && jStockOptions.isEnableColorAlert()) {
            Double fallBelow;
            int riseAboveIndex = tableModel.findColumn(RISE_ABOVE);
            int fallBelowIndex = tableModel.findColumn(FALL_BELOW);
            Double riseAbove = riseAboveIndex >= 0 ? (Double)tableModel.getValueAt(table.convertRowIndexToModel(row), riseAboveIndex) : null;
            Double d = fallBelow = fallBelowIndex >= 0 ? (Double)tableModel.getValueAt(table.convertRowIndexToModel(row), fallBelowIndex) : null;
            if (riseAbove != null && lastPrice >= riseAbove) {
                alert = Alert.RiseAbove;
            }
            if (fallBelow != null && lastPrice <= fallBelow) {
                alert = Alert.FallBelow;
            }
        }
        if (table.getColumnName(column).equalsIgnoreCase(BUY)) {
            modelCol = tableModel.findColumn(BUY);
            double buyPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(buyPrice, prevPrice, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(buyPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(SELL)) {
            modelCol = tableModel.findColumn(SELL);
            double sellPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(sellPrice, prevPrice, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(sellPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(OPEN)) {
            modelCol = tableModel.findColumn(OPEN);
            double openPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(openPrice, prevPrice, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(openPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(LAST)) {
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(lastPrice, prevPrice, alert));
            }
            if (c instanceof JLabel) {
                JLabel jLabel3 = (JLabel)c;
                jLabel3.setText(Utils.toStockPrice(lastPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(LOW)) {
            modelCol = tableModel.findColumn(LOW);
            double lowPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(lowPrice, prevPrice, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(lowPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(HIGH)) {
            modelCol = tableModel.findColumn(HIGH);
            double highPrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(highPrice, prevPrice, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(highPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(CHG)) {
            modelCol = tableModel.findColumn(CHG);
            double changePrice = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(changePrice, 0.0, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(changePrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(CHG_PERCENTAGE)) {
            modelCol = tableModel.findColumn(CHG_PERCENTAGE);
            double changePricePercentage = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getForegroundColor(changePricePercentage, 0.0, alert));
            }
            if (c instanceof JLabel) {
                jLabel2 = (JLabel)c;
                jLabel2.setText(Utils.toStockPrice(changePricePercentage));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(RISE_ABOVE)) {
            modelCol = tableModel.findColumn(RISE_ABOVE);
            Double riseAbove = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getNormalTextForegroundColor(alert));
            }
            if (riseAbove != null && c instanceof JLabel) {
                jLabel = (JLabel)c;
                jLabel.setText(Utils.toStockPrice(riseAbove));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(FALL_BELOW)) {
            modelCol = tableModel.findColumn(FALL_BELOW);
            Double fallBelow = (Double)tableModel.getValueAt(modelRow, modelCol);
            if (!isSelected) {
                c.setForeground(this.getNormalTextForegroundColor(alert));
            }
            if (fallBelow != null && c instanceof JLabel) {
                jLabel = (JLabel)c;
                jLabel.setText(Utils.toStockPrice(fallBelow));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(PREV)) {
            if (!isSelected) {
                c.setForeground(this.getNormalTextForegroundColor(alert));
            }
            if (c instanceof JLabel) {
                JLabel jLabel4 = (JLabel)c;
                jLabel4.setText(Utils.toStockPrice(prevPrice));
            }
        } else if (table.getColumnName(column).equalsIgnoreCase(INDICATOR)) {
            if (!isSelected) {
                c.setForeground(Color.BLUE);
            }
        } else if (!isSelected) {
            c.setForeground(this.getNormalTextForegroundColor(alert));
        }
        if (!isSelected) {
            c.setBackground(this.getBackgroundColor(row, alert));
        }
        return c;
    }

    private static enum Alert {
        FallBelow,
        RiseAbove,
        NoAlert;

    }
}

