/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.analysis;

import java.awt.Color;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.yccheok.jstock.analysis.Connection;
import org.yccheok.jstock.gui.IndexedConnector;
import org.yccheok.jstock.gui.InputConnector;
import org.yccheok.jstock.gui.OutputConnector;
import org.yccheok.jstock.gui.analysis.OperatorFigure;

public class DependencyFigure
extends LineConnectionFigure {
    public DependencyFigure() {
        AttributeKeys.STROKE_COLOR.set((Figure)this, (Object)new Color(153));
        AttributeKeys.STROKE_WIDTH.set((Figure)this, (Object)1.0);
        AttributeKeys.END_DECORATION.set((Figure)this, (Object)new ArrowTip());
        this.setAttributeEnabled(AttributeKeys.END_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.START_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        this.setAttributeEnabled(AttributeKeys.FONT_ITALIC, false);
        this.setAttributeEnabled(AttributeKeys.FONT_UNDERLINE, false);
    }

    protected void handleDisconnect(Connector start, Connector end) {
        IndexedConnector indexedStart = (IndexedConnector)start;
        IndexedConnector indexedEnd = (IndexedConnector)end;
        indexedStart.setNumOfConnection(0);
        indexedEnd.setNumOfConnection(0);
        if (start instanceof InputConnector) {
            System.out.println("DependencyFigure handleDisconnect start InputConnector indexed " + ((InputConnector)start).getIndex());
        } else {
            System.out.println("DependencyFigure handleDisconnect start OutputConnector indexed " + ((OutputConnector)start).getIndex());
        }
        if (end instanceof InputConnector) {
            System.out.println("DependencyFigure handleDisconnect end InputConnector indexed " + ((InputConnector)end).getIndex());
        } else {
            System.out.println("DependencyFigure handleDisconnect end OutputConnector indexed " + ((OutputConnector)end).getIndex());
        }
        OperatorFigure startOperatorFigure = (OperatorFigure)start.getOwner();
        OperatorFigure endOperatorFigure = (OperatorFigure)end.getOwner();
        startOperatorFigure.getOperator().removeOutputConnection(indexedStart.getIndex());
        endOperatorFigure.getOperator().removeInputConnection(indexedEnd.getIndex());
    }

    protected void handleConnect(Connector start, Connector end) {
        IndexedConnector indexedStart = (IndexedConnector)start;
        IndexedConnector indexedEnd = (IndexedConnector)end;
        indexedStart.setNumOfConnection(1);
        indexedEnd.setNumOfConnection(1);
        if (start instanceof InputConnector) {
            System.out.println("DependencyFigure handleConnect start InputConnector indexed " + ((InputConnector)start).getIndex());
        } else {
            System.out.println("DependencyFigure handleConnect start OutputConnector indexed " + ((OutputConnector)start).getIndex());
        }
        if (end instanceof InputConnector) {
            System.out.println("DependencyFigure handleConnect end InputConnector indexed " + ((InputConnector)end).getIndex());
        } else {
            System.out.println("DependencyFigure handleConnect end OutputConnector indexed " + ((OutputConnector)end).getIndex());
        }
        OperatorFigure startOperatorFigure = (OperatorFigure)start.getOwner();
        OperatorFigure endOperatorFigure = (OperatorFigure)end.getOwner();
        Connection connection = new Connection();
        startOperatorFigure.getOperator().addOutputConnection(connection, indexedStart.getIndex());
        endOperatorFigure.getOperator().addInputConnection(connection, indexedEnd.getIndex());
    }

    public DependencyFigure clone() {
        DependencyFigure that = (DependencyFigure)super.clone();
        return that;
    }

    public boolean canConnect(Connector start, Connector end) {
        Class inputClass;
        if (start instanceof InputConnector || end instanceof OutputConnector) {
            return false;
        }
        if (!(start instanceof IndexedConnector) || !(end instanceof IndexedConnector)) {
            return false;
        }
        IndexedConnector indexedStart = (IndexedConnector)start;
        IndexedConnector indexedEnd = (IndexedConnector)end;
        if (indexedStart.getNumOfConnection() > 0 && this.getStartConnector() != indexedStart) {
            return false;
        }
        if (indexedEnd.getNumOfConnection() > 0 && this.getEndConnector() != indexedEnd) {
            return false;
        }
        Figure startFigure = start.getOwner();
        Figure endFigure = end.getOwner();
        if (!(startFigure instanceof OperatorFigure) || !(endFigure instanceof OperatorFigure)) {
            return false;
        }
        OperatorFigure startOperatorFigure = (OperatorFigure)startFigure;
        OperatorFigure endOperatorFigure = (OperatorFigure)endFigure;
        int startIndex = indexedStart.getIndex();
        int endIndex = indexedEnd.getIndex();
        Class outputClass = startOperatorFigure.getOperator().getOutputClass(startIndex);
        return outputClass.isAssignableFrom(inputClass = endOperatorFigure.getOperator().getInputClass(endIndex)) || inputClass.isAssignableFrom(outputClass);
    }

    public int getLayer() {
        return 1;
    }

    public void removeNotify(Drawing d) {
        super.removeNotify(d);
    }
}

