/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.analysis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.Icons;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.IndicatorDownloadManager;
import org.yccheok.jstock.gui.table.GenericRenderer;
import org.yccheok.jstock.internationalization.GUIBundle;

public class WizardSelectIndicatorJPanel
extends JPanel {
    private static final Log log = LogFactory.getLog(WizardSelectIndicatorJPanel.class);
    private final IndicatorProjectManager indicatorProjectManager;
    private volatile SwingWorker<IndicatorDownloadManager, Void> indicatorDownloadManagerTask = null;
    private IndicatorDownloadManager indicatorDownloadManager = null;
    private final Map<String, String> htmlDescriptionMap = new HashMap<String, String>();
    private TableCellRenderer booleanTableCellRenderer = null;
    private final ObservableEx observable = new ObservableEx();
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JXHeader jXHeader1;

    public WizardSelectIndicatorJPanel(IndicatorProjectManager indicatorProjectManager) {
        this.indicatorProjectManager = indicatorProjectManager;
        this.initComponents();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setLayout(new BorderLayout(10, 10));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("WizardSelectIndicatorJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/ark2.png")));
        this.jXHeader1.setTitle(bundle.getString("WizardSelectIndicatorJPanel_Title"));
        this.add((Component)this.jXHeader1, "North");
        this.jPanel1.setLayout(new BorderLayout(10, 10));
        this.jPanel3.setLayout(new BorderLayout(10, 10));
        this.jSplitPane1.setDividerLocation(230);
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Indicators"));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(this.getEmptyTableModel());
        this.jTable1.setAutoResizeMode(3);
        this.jTable1.setSelectionMode(0);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        JTableUtilities.makeTableColumnWidthFit(this.jTable1, 0, 5, true);
        this.jTable1.setDefaultRenderer(String.class, new IndicatorRenderer());
        this.booleanTableCellRenderer = this.jTable1.getDefaultRenderer(Boolean.class);
        this.jTable1.setDefaultRenderer(Boolean.class, new IndicatorRenderer());
        this.jTable1.getSelectionModel().addListSelectionListener(new RowListener());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jPanel4.setLayout(new BorderLayout(10, 10));
        this.jPanel5.setLayout(new FlowLayout(0));
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 3));
        this.jLabel1.setText(" ");
        this.jPanel5.add(this.jLabel1);
        this.jPanel4.add((Component)this.jPanel5, "North");
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Description"));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setMinimumSize(new Dimension(20, 20));
        this.jEditorPane1.setPreferredSize(new Dimension(20, 20));
        this.jEditorPane1.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                WizardSelectIndicatorJPanel.this.jEditorPane1HyperlinkUpdate(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.jPanel3.add((Component)this.jSplitPane1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel3.setText(bundle.getString("WizardSelectIndicatorJPanel_GettingIndicatorInfo..."));
        this.jPanel2.add(this.jLabel3);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jLabel2.setHorizontalTextPosition(2);
        this.jPanel2.add(this.jLabel2);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.add((Component)this.jPanel1, "Center");
    }

    private void jEditorPane1HyperlinkUpdate(HyperlinkEvent evt) {
        Utils.launchWebBrowser(evt);
    }

    public void start() {
        if (this.indicatorDownloadManager == null) {
            this.cancel();
            this.indicatorDownloadManagerTask = this.getIndicatorDownloadManagerTask();
            this.indicatorDownloadManagerTask.execute();
        } else if (this.jTable1.getModel() instanceof IndicatorDownloadManagerTableModel) {
            ((IndicatorDownloadManagerTableModel)this.jTable1.getModel()).updatePlannedInstall();
        }
        this.updateGUIState();
    }

    public void cancel() {
        if (this.indicatorDownloadManagerTask != null) {
            this.indicatorDownloadManagerTask.cancel(true);
        }
        this.indicatorDownloadManagerTask = null;
    }

    private TableModel getEmptyTableModel() {
        return new DefaultTableModel(new Object[0][], new String[]{GUIBundle.getString("WizardSelectIndicatorJPanel_Install"), GUIBundle.getString("WizardSelectIndicatorJPanel_Indicator")}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
    }

    private void updateGUIState() {
        if (this.indicatorDownloadManager != null) {
            this.jLabel2.setVisible(false);
            this.jLabel3.setVisible(true);
            if (!(this.jTable1.getModel() instanceof IndicatorDownloadManagerTableModel)) {
                this.jTable1.setModel(new IndicatorDownloadManagerTableModel(this.indicatorDownloadManager, this.indicatorProjectManager));
                this.jTable1.setRowSelectionInterval(0, 0);
            }
            this.jTable1.repaint();
            String output = MessageFormat.format(GUIBundle.getString("WizardSelectIndicatorJPanel_NIndicatorWillBeInstalled_template"), this.getPlannedInstallProjectSize());
            this.jLabel3.setForeground(Color.BLUE);
            this.jLabel3.setText(output);
            JTableUtilities.makeTableColumnWidthFit(this.jTable1, 0, 5, true);
            this.observable.setChanged();
            this.observable.notifyObservers();
        } else if (this.indicatorDownloadManagerTask != null) {
            boolean isIndicatorDownloadManagerTaskDone = this.indicatorDownloadManagerTask.isDone();
            if (!isIndicatorDownloadManagerTaskDone) {
                this.jLabel2.setVisible(true);
                this.jLabel3.setVisible(true);
                this.jLabel3.setText(GUIBundle.getString("WizardSelectIndicatorJPanel_GettingIndicatorInfo..."));
                this.jLabel3.setForeground(Color.BLUE);
            } else {
                this.jLabel2.setVisible(false);
                this.jLabel3.setVisible(true);
                this.jLabel3.setText(GUIBundle.getString("WizardSelectIndicatorJPanel_FailToGetIndicatorInfo"));
                this.jLabel3.setForeground(Color.RED);
            }
        } else {
            this.jLabel2.setVisible(true);
            this.jLabel3.setVisible(true);
            this.jLabel3.setText(GUIBundle.getString("WizardSelectIndicatorJPanel_GettingIndicatorInfo..."));
            this.jLabel3.setForeground(Color.BLUE);
            this.jTable1.setModel(this.getEmptyTableModel());
            JTableUtilities.makeTableColumnWidthFit(this.jTable1, 0, 5, true);
        }
    }

    private int getTotalProjectSize() {
        if (this.indicatorDownloadManager == null) {
            return -1;
        }
        return this.indicatorDownloadManager.size();
    }

    private int getInstalledProjectSize() {
        if (this.indicatorDownloadManager == null) {
            return -1;
        }
        int num = 0;
        for (int i = 0; i < this.indicatorDownloadManager.size(); ++i) {
            if (!this.indicatorProjectManager.contains(this.indicatorDownloadManager.get((int)i).projectName)) continue;
            ++num;
        }
        return num;
    }

    public List<IndicatorDownloadManager.Info> getPlannedInstallIndicatorDownloadInfos() {
        if (this.indicatorDownloadManager == null) {
            return Collections.emptyList();
        }
        ArrayList<IndicatorDownloadManager.Info> installIndicatorDownloadInfos = new ArrayList<IndicatorDownloadManager.Info>();
        IndicatorDownloadManagerTableModel tableModel = (IndicatorDownloadManagerTableModel)this.jTable1.getModel();
        for (int i = 0; i < this.indicatorDownloadManager.size(); ++i) {
            IndicatorDownloadManager.Info info = this.indicatorDownloadManager.get(i);
            if (!tableModel.isPlannedInstall(info.projectName)) continue;
            installIndicatorDownloadInfos.add(info);
        }
        return installIndicatorDownloadInfos;
    }

    private int getPlannedInstallProjectSize() {
        if (this.indicatorDownloadManager == null) {
            return -1;
        }
        IndicatorDownloadManagerTableModel tableModel = (IndicatorDownloadManagerTableModel)this.jTable1.getModel();
        int num = 0;
        for (int i = 0; i < this.indicatorDownloadManager.size(); ++i) {
            String projectName = this.indicatorDownloadManager.get((int)i).projectName;
            if (!tableModel.isPlannedInstall(projectName)) continue;
            ++num;
        }
        return num;
    }

    public boolean useFinishButton() {
        int total = this.getTotalProjectSize();
        int installed = this.getInstalledProjectSize();
        if (total < 0 || installed < 0) {
            return false;
        }
        return total == installed;
    }

    public boolean isNextFinishButtonEnabled() {
        int total = this.getTotalProjectSize();
        int installed = this.getInstalledProjectSize();
        int planned = this.getPlannedInstallProjectSize();
        if (total < 0 || installed < 0 || planned < 0) {
            return false;
        }
        if (total == 0) {
            return true;
        }
        if (total == installed) {
            return true;
        }
        return planned > 0;
    }

    private SwingWorker<IndicatorDownloadManager, Void> getIndicatorDownloadManagerTask() {
        SwingWorker<IndicatorDownloadManager, Void> worker = new SwingWorker<IndicatorDownloadManager, Void>(){

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    WizardSelectIndicatorJPanel.this.indicatorDownloadManager = null;
                    return;
                }
                try {
                    WizardSelectIndicatorJPanel.this.indicatorDownloadManager = (IndicatorDownloadManager)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                WizardSelectIndicatorJPanel.this.updateGUIState();
            }

            @Override
            protected IndicatorDownloadManager doInBackground() {
                int i;
                if (this.isCancelled()) {
                    return null;
                }
                String location = IndicatorDownloadManager.getIndicatorDownloadManagerDescriptionFileLocation(WizardSelectIndicatorJPanel.this.indicatorProjectManager.getPreferredOperatorIndicatorType());
                Utils.InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(location);
                if (inputStreamAndMethod.inputStream == null) {
                    inputStreamAndMethod.method.releaseConnection();
                    return null;
                }
                InputStreamReader reader = new InputStreamReader(inputStreamAndMethod.inputStream, Charset.forName("UTF-8"));
                IndicatorDownloadManager _indicatorDownloadManager = (IndicatorDownloadManager)Utils.fromXML(IndicatorDownloadManager.class, reader);
                Utils.close(reader);
                Utils.close(inputStreamAndMethod.inputStream);
                inputStreamAndMethod.method.releaseConnection();
                if (_indicatorDownloadManager == null) {
                    return null;
                }
                for (i = 0; i < _indicatorDownloadManager.size(); ++i) {
                    if (_indicatorDownloadManager.get((int)i).type == WizardSelectIndicatorJPanel.this.indicatorProjectManager.getPreferredOperatorIndicatorType()) continue;
                    return null;
                }
                for (i = 0; i < _indicatorDownloadManager.size(); ++i) {
                    IndicatorDownloadManager.Info info = _indicatorDownloadManager.get(i);
                    URL descriptionURL = info.descriptionURL;
                    String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(descriptionURL.toString());
                    if (respond == null || !respond.contains(Utils.getJStockUUID())) continue;
                    WizardSelectIndicatorJPanel.this.htmlDescriptionMap.put(info.projectName, respond);
                }
                return _indicatorDownloadManager;
            }
        };
        return worker;
    }

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    private static final class ObservableEx
    extends Observable {
        private ObservableEx() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }

    private class IndicatorDownloadManagerTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{GUIBundle.getString("WizardSelectIndicatorJPanel_Install"), GUIBundle.getString("WizardSelectIndicatorJPanel_Indicator")};
        private final Class[] columnClasses = new Class[]{Boolean.class, String.class};
        private final IndicatorDownloadManager downloadManager;
        private final IndicatorProjectManager projectManager;
        private final List<String> planToInstallProjectName = new ArrayList<String>();

        public IndicatorDownloadManagerTableModel(IndicatorDownloadManager downloadManager, IndicatorProjectManager projectManager) {
            this.downloadManager = downloadManager;
            this.projectManager = projectManager;
        }

        public boolean isInstalled(String projectName) {
            return this.projectManager.contains(projectName);
        }

        public boolean isPlannedInstall(String projectName) {
            return this.planToInstallProjectName.contains(projectName);
        }

        public void updatePlannedInstall() {
            for (int i = 0; i < this.planToInstallProjectName.size(); ++i) {
                if (!this.isInstalled(this.planToInstallProjectName.get(i))) continue;
                this.planToInstallProjectName.remove(i);
                --i;
            }
        }

        @Override
        public int getRowCount() {
            return this.downloadManager.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String projectName = this.downloadManager.get((int)rowIndex).projectName;
                return this.isInstalled(projectName) || this.isPlannedInstall(projectName);
            }
            if (columnIndex == 1) {
                return this.downloadManager.get((int)rowIndex).projectName;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                return false;
            }
            String projectName = this.downloadManager.get((int)rowIndex).projectName;
            return !this.isInstalled(projectName);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            String projectName = this.downloadManager.get((int)rowIndex).projectName;
            if (((Boolean)aValue).booleanValue()) {
                if (!this.planToInstallProjectName.contains(projectName)) {
                    this.planToInstallProjectName.add(projectName);
                }
            } else {
                this.planToInstallProjectName.remove(projectName);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
            WizardSelectIndicatorJPanel.this.updateGUIState();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int view = WizardSelectIndicatorJPanel.this.jTable1.getSelectedRow();
            int index = WizardSelectIndicatorJPanel.this.jTable1.convertRowIndexToModel(view);
            String projectName = (String)((IndicatorDownloadManagerTableModel)WizardSelectIndicatorJPanel.this.jTable1.getModel()).getValueAt(index, 1);
            WizardSelectIndicatorJPanel.this.jLabel1.setText(projectName);
            String htmlDescription = (String)WizardSelectIndicatorJPanel.this.htmlDescriptionMap.get(projectName);
            WizardSelectIndicatorJPanel.this.jEditorPane1.setText(htmlDescription);
            WizardSelectIndicatorJPanel.this.jEditorPane1.setCaretPosition(0);
        }
    }

    private class IndicatorRenderer
    extends GenericRenderer {
        private final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();

        private IndicatorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = null;
            if (value instanceof Boolean) {
                String projectName;
                IndicatorDownloadManagerTableModel tableModel = (IndicatorDownloadManagerTableModel)table.getModel();
                if (tableModel.isInstalled(projectName = (String)tableModel.getValueAt(table.convertRowIndexToModel(row), 1))) {
                    c = this.defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (c instanceof JLabel) {
                        JLabel l = (JLabel)c;
                        l.setText(null);
                        l.setHorizontalAlignment(0);
                        l.setHorizontalTextPosition(0);
                        l.setIcon(Icons.OK);
                    } else {
                        c = WizardSelectIndicatorJPanel.this.booleanTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                } else {
                    c = WizardSelectIndicatorJPanel.this.booleanTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                if (isSelected || hasFocus) {
                    return c;
                }
                c.setBackground(this.getBackgroundColor(row));
            } else {
                c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return c;
        }
    }
}

