/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.treetable;

import java.util.Arrays;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.treetable.AbstractPortfolioTreeTableModelEx;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class SellPortfolioTreeTableModelEx
extends AbstractPortfolioTreeTableModelEx {
    private static final String[] columnNames;
    private static final Class[] cTypes;

    public SellPortfolioTreeTableModelEx() {
        super(Arrays.asList(columnNames));
    }

    @Override
    public int getColumnCount() {
        assert (columnNames.length == cTypes.length);
        return columnNames.length;
    }

    @Override
    public Class getColumnClass(int column) {
        assert (columnNames.length == cTypes.length);
        return cTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    private double getGainLossPercentage(Portfolio portfolio) {
        if (portfolio.getReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (portfolio.getTotal() - portfolio.getReferenceTotal()) / portfolio.getReferenceTotal() * 100.0;
    }

    public double getGainLossValue() {
        return this.getGainLossValue((Portfolio)this.getRoot());
    }

    private double getGainLossValue(Portfolio portfolio) {
        return portfolio.getTotal() - portfolio.getReferenceTotal();
    }

    public double getSellingValue() {
        return ((Portfolio)this.getRoot()).getTotal();
    }

    public double getNetSellingValue() {
        return ((Portfolio)this.getRoot()).getNetTotal();
    }

    public double getGainLossPercentage() {
        return this.getGainLossPercentage((Portfolio)this.getRoot());
    }

    public double getNetGainLossPercentage() {
        return this.getNetGainLossPercentage((Portfolio)this.getRoot());
    }

    public double getNetGainLossValue() {
        return this.getNetGainLossValue((Portfolio)this.getRoot());
    }

    private double getNetGainLossPercentage(Portfolio portfolio) {
        if (portfolio.getNetReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (portfolio.getNetTotal() - portfolio.getNetReferenceTotal()) / portfolio.getNetReferenceTotal() * 100.0;
    }

    private double getNetGainLossValue(Portfolio portfolio) {
        return portfolio.getNetTotal() - portfolio.getNetReferenceTotal();
    }

    public double getSellingPrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    public double getPurchasePrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getReferenceTotal() / transactionSummary.getQuantity();
    }

    public double getGainLossValue(TransactionSummary transactionSummary) {
        return transactionSummary.getTotal() - transactionSummary.getReferenceTotal();
    }

    public double getGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transactionSummary.getTotal() - transactionSummary.getReferenceTotal()) / transactionSummary.getReferenceTotal() * 100.0;
    }

    public double getNetGainLossValue(TransactionSummary transactionSummary) {
        return transactionSummary.getNetTotal() - transactionSummary.getNetReferenceTotal();
    }

    public double getNetGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getNetReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transactionSummary.getNetTotal() - transactionSummary.getNetReferenceTotal()) / transactionSummary.getNetReferenceTotal() * 100.0;
    }

    public double getGainLossPrice(Transaction transaction) {
        if (transaction.getQuantity() == 0.0) {
            return 0.0;
        }
        return (transaction.getTotal() - transaction.getReferenceTotal()) / transaction.getQuantity();
    }

    public double getGainLossValue(Transaction transaction) {
        return transaction.getTotal() - transaction.getReferenceTotal();
    }

    public double getGainLossPercentage(Transaction transaction) {
        if (transaction.getReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transaction.getTotal() - transaction.getReferenceTotal()) / transaction.getReferenceTotal() * 100.0;
    }

    public double getNetGainLossValue(Transaction transaction) {
        return transaction.getNetTotal() - transaction.getNetReferenceTotal();
    }

    public double getNetGainLossPercentage(Transaction transaction) {
        if (transaction.getNetReferenceTotal() == 0.0) {
            return 0.0;
        }
        return (transaction.getNetTotal() - transaction.getNetReferenceTotal()) / transaction.getNetReferenceTotal() * 100.0;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        boolean isPenceToPoundConversionEnabled = jStockOptions.isPenceToPoundConversionEnabled();
        if (node instanceof Portfolio) {
            Portfolio portfolio = (Portfolio)node;
            switch (column) {
                case 0: {
                    return GUIBundle.getString("PortfolioManagementJPanel_Sell");
                }
                case 5: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return portfolio.getNetTotal();
                        }
                        return portfolio.getTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return portfolio.getNetTotal() / 100.0;
                    }
                    return portfolio.getTotal() / 100.0;
                }
                case 6: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return portfolio.getNetReferenceTotal();
                        }
                        return portfolio.getReferenceTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return portfolio.getNetReferenceTotal() / 100.0;
                    }
                    return portfolio.getReferenceTotal() / 100.0;
                }
                case 7: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return this.getNetGainLossValue(portfolio);
                        }
                        return this.getGainLossValue(portfolio);
                    }
                    if (isFeeCalculationEnabled) {
                        return this.getNetGainLossValue(portfolio) / 100.0;
                    }
                    return this.getGainLossValue(portfolio) / 100.0;
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(portfolio));
                    }
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(portfolio));
                }
                case 9: {
                    return portfolio.getBroker();
                }
                case 10: {
                    return portfolio.getClearingFee();
                }
                case 11: {
                    return portfolio.getStampDuty();
                }
                case 12: {
                    return portfolio.getComment();
                }
            }
        }
        if (node instanceof TransactionSummary) {
            TransactionSummary transactionSummary = (TransactionSummary)node;
            if (transactionSummary.getChildCount() <= 0) {
                return null;
            }
            switch (column) {
                case 0: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStock().symbol;
                }
                case 2: {
                    return transactionSummary.getQuantity();
                }
                case 3: {
                    if (MainFrame.getInstance().getJStockOptions().isFourDecimalPlacesEnabled()) {
                        return new DoubleWrapper(DecimalPlaces.Four, this.getSellingPrice(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlaces.Three, this.getSellingPrice(transactionSummary));
                }
                case 4: {
                    if (MainFrame.getInstance().getJStockOptions().isFourDecimalPlacesEnabled()) {
                        return new DoubleWrapper(DecimalPlaces.Four, this.getPurchasePrice(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlaces.Three, this.getPurchasePrice(transactionSummary));
                }
                case 5: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return transactionSummary.getNetTotal();
                        }
                        return transactionSummary.getTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return transactionSummary.getNetTotal() / 100.0;
                    }
                    return transactionSummary.getTotal() / 100.0;
                }
                case 6: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return transactionSummary.getNetReferenceTotal();
                        }
                        return transactionSummary.getReferenceTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return transactionSummary.getNetReferenceTotal() / 100.0;
                    }
                    return transactionSummary.getReferenceTotal() / 100.0;
                }
                case 7: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return this.getNetGainLossValue(transactionSummary);
                        }
                        return this.getGainLossValue(transactionSummary);
                    }
                    if (isFeeCalculationEnabled) {
                        return this.getNetGainLossValue(transactionSummary) / 100.0;
                    }
                    return this.getGainLossValue(transactionSummary) / 100.0;
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(transactionSummary));
                }
                case 9: {
                    return transactionSummary.getBroker();
                }
                case 10: {
                    return transactionSummary.getClearingFee();
                }
                case 11: {
                    return transactionSummary.getStampDuty();
                }
                case 12: {
                    return transactionSummary.getComment();
                }
            }
        }
        if (node instanceof Transaction) {
            Transaction transaction = (Transaction)node;
            switch (column) {
                case 0: {
                    return transaction.getStock().symbol;
                }
                case 1: {
                    return transaction.getDate();
                }
                case 2: {
                    return transaction.getQuantity();
                }
                case 3: {
                    return transaction.getPrice();
                }
                case 4: {
                    return transaction.getReferencePrice();
                }
                case 5: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return transaction.getNetTotal();
                        }
                        return transaction.getTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return transaction.getNetTotal() / 100.0;
                    }
                    return transaction.getTotal() / 100.0;
                }
                case 6: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return transaction.getNetReferenceTotal();
                        }
                        return transaction.getReferenceTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return transaction.getNetReferenceTotal() / 100.0;
                    }
                    return transaction.getReferenceTotal() / 100.0;
                }
                case 7: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return this.getNetGainLossValue(transaction);
                        }
                        return this.getGainLossValue(transaction);
                    }
                    if (isFeeCalculationEnabled) {
                        return this.getNetGainLossValue(transaction) / 100.0;
                    }
                    return this.getGainLossValue(transaction) / 100.0;
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(transaction));
                    }
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(transaction));
                }
                case 9: {
                    return transaction.getBroker();
                }
                case 10: {
                    return transaction.getClearingFee();
                }
                case 11: {
                    return transaction.getStampDuty();
                }
                case 12: {
                    return transaction.getComment();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isValidTransaction(Transaction transaction) {
        return transaction.getType() == Contract.Type.Sell;
    }

    static {
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Stock"), GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_Units"), GUIBundle.getString("PortfolioManagementJPanel_SellingPrice"), GUIBundle.getString("PortfolioManagementJPanel_PurchasePrice"), GUIBundle.getString("PortfolioManagementJPanel_SellingValue"), GUIBundle.getString("PortfolioManagementJPanel_PurchaseValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossPercentage"), GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty"), GUIBundle.getString("PortfolioManagementJPanel_Comment")};
        columnNames = tmp;
        cTypes = new Class[]{TreeTableModel.class, SimpleDate.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class};
    }
}

