/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.watchlist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class WatchlistJDialog
extends JDialog {
    private static final Set<Character> ILLEGAL_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('\u0000'), Character.valueOf('\f'), Character.valueOf('`'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')));
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JXHeader jXHeader1;

    public WatchlistJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel3 = new JPanel();
        this.jButton4 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("WatchlistJDialog_MultipleWatchlists"));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jXHeader1.setDescription(bundle.getString("WatchlistJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/stock_timezone.png")));
        this.jXHeader1.setTitle(bundle.getString("WatchlistJDialog_MultipleWatchlists"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jPanel2.setLayout(new BorderLayout(5, 5));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        this.jButton1.setText(bundle.getString("New..."));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchlistJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/editdelete.png")));
        this.jButton2.setText(bundle.getString("Delete"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchlistJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/edit.png")));
        this.jButton3.setText(bundle.getString("Rename..."));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchlistJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton3);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton4.setText(bundle.getString("OK"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatchlistJDialog.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton4);
        this.jPanel2.add((Component)this.jPanel3, "Last");
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(bundle.getString("WatchlistJDialog_Watchlist")));
        this.jPanel4.setLayout(new BorderLayout());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jList1.setSelectionMode(0);
        this.jList1.setCellRenderer(this.getListCellRenderer());
        this.jList1.setModel(new DefaultListModel());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WatchlistJDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 362) / 2, (screenSize.height - 341) / 2, 362, 341);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int select = this.jList1.getSelectedIndex();
        if (select < 0 || select >= this.jList1.getModel().getSize()) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_watchlist"), MessagesBundle.getString("warning_title_you_must_select_watchlist"), 2);
            return;
        }
        String oldWatchlistName = (String)this.jList1.getSelectedValue();
        if (oldWatchlistName == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_title_you_must_select_watchlist"), MessagesBundle.getString("warning_title_you_must_select_watchlist"), 2);
            return;
        }
        String newWatchlistName = null;
        boolean needToReload = false;
        MainFrame mainFrame = MainFrame.getInstance();
        if (mainFrame.getJStockOptions().getWatchlistName().equals(oldWatchlistName)) {
            needToReload = true;
        }
        block0: while (true) {
            File newFile;
            File oldFile;
            if ((newWatchlistName = JOptionPane.showInputDialog(this, MessagesBundle.getString("info_message_enter_rename_watchlist_name"), oldWatchlistName)) == null) {
                return;
            }
            if (newWatchlistName.length() > 50) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_watchlist_name"), MessagesBundle.getString("warning_title_invalid_watchlist_name"), 2);
                continue;
            }
            if ((newWatchlistName = newWatchlistName.trim()).isEmpty()) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_watchlist_name"), MessagesBundle.getString("warning_title_you_need_to_specific_watchlist_name"), 2);
                continue;
            }
            if (!WatchlistJDialog.isValidFolderName(newWatchlistName)) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_watchlist_name"), MessagesBundle.getString("warning_title_invalid_watchlist_name"), 2);
                continue;
            }
            if (Utils.isFileOrDirectoryExist(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(newWatchlistName))) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_watchlist_with_same_name"), MessagesBundle.getString("warning_title_already_a_watchlist_with_same_name"), 2);
                continue;
            }
            JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
            File file = new File(Utils.getUserDataDirectory() + (Object)((Object)jStockOptions.getCountry()) + File.separator + "watchlist" + File.separator);
            File[] children = file.listFiles();
            if (children != null) {
                for (File f : children) {
                    if (!newWatchlistName.equalsIgnoreCase(f.getName())) continue;
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_watchlist_with_same_name"), MessagesBundle.getString("warning_title_already_a_watchlist_with_same_name"), 2);
                    continue block0;
                }
            }
            if ((oldFile = new File(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(oldWatchlistName))).renameTo(newFile = new File(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(newWatchlistName)))) break;
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("error_message_unknown_error_during_renaming"), MessagesBundle.getString("error_title_unknown_error_during_renaming"), 0);
        }
        if (needToReload) {
            mainFrame.getJStockOptions().setWatchlistName(newWatchlistName);
        }
        this.init();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int select = this.jList1.getSelectedIndex();
        if (select < 0 || select >= this.jList1.getModel().getSize()) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_watchlist"), MessagesBundle.getString("warning_title_you_must_select_watchlist"), 2);
            return;
        }
        String selectedValue = (String)this.jList1.getSelectedValue();
        if (selectedValue == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_must_select_watchlist"), MessagesBundle.getString("warning_title_you_must_select_watchlist"), 2);
            return;
        }
        MainFrame mainFrame = MainFrame.getInstance();
        if (mainFrame.getJStockOptions().getWatchlistName().equals(selectedValue)) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_cannot_delete_current_active_watchlist"), MessagesBundle.getString("warning_title_cannot_delete_current_active_watchlist"), 2);
            return;
        }
        String output = MessageFormat.format(MessagesBundle.getString("question_message_delete_template"), selectedValue);
        int result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_delete"), 0, 3);
        if (result != 0) {
            return;
        }
        if (Utils.deleteDir(new File(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(selectedValue)))) {
            this.init();
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("error_message_unknown_error_during_delete"), MessagesBundle.getString("error_title_unknown_error_during_delete"), 0);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String newWatchlistName = null;
        block0: while (true) {
            if ((newWatchlistName = JOptionPane.showInputDialog(this, (Object)MessagesBundle.getString("info_message_enter_new_watchlist_name"))) == null) {
                return;
            }
            if (newWatchlistName.length() > 50) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_watchlist_name"), MessagesBundle.getString("warning_title_invalid_watchlist_name"), 2);
                continue;
            }
            if ((newWatchlistName = newWatchlistName.trim()).isEmpty()) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_you_need_to_specific_watchlist_name"), MessagesBundle.getString("warning_title_you_need_to_specific_watchlist_name"), 2);
                continue;
            }
            if (!WatchlistJDialog.isValidFolderName(newWatchlistName)) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_watchlist_name"), MessagesBundle.getString("warning_title_invalid_watchlist_name"), 2);
                continue;
            }
            if (Utils.isFileOrDirectoryExist(org.yccheok.jstock.watchlist.Utils.getWatchlistDirectory(newWatchlistName))) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_watchlist_with_same_name"), MessagesBundle.getString("warning_title_already_a_watchlist_with_same_name"), 2);
                continue;
            }
            JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
            File file = new File(Utils.getUserDataDirectory() + (Object)((Object)jStockOptions.getCountry()) + File.separator + "watchlist" + File.separator);
            File[] children = file.listFiles();
            if (children != null) {
                for (File f : children) {
                    if (!newWatchlistName.equalsIgnoreCase(f.getName())) continue;
                    JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_already_a_watchlist_with_same_name"), MessagesBundle.getString("warning_title_already_a_watchlist_with_same_name"), 2);
                    continue block0;
                }
            }
            if (org.yccheok.jstock.watchlist.Utils.createEmptyWatchlist(newWatchlistName)) break;
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("error_message_unknown_error_during_new"), MessagesBundle.getString("error_title_unknown_error_during_new"), 0);
        }
        this.init();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        JList list = (JList)evt.getSource();
        if (evt.getClickCount() == 2) {
            int index = list.locationToIndex(evt.getPoint());
            String watchlist = list.getModel().getElementAt(index).toString();
            if (!MainFrame.getInstance().getJStockOptions().getWatchlistName().equals(watchlist)) {
                MainFrame.getInstance().selectActiveWatchlist(watchlist);
                this.jList1.repaint();
            }
        }
    }

    private void init() {
        ((DefaultListModel)this.jList1.getModel()).clear();
        List<String> names = org.yccheok.jstock.watchlist.Utils.getWatchlistNames();
        for (String name : names) {
            ((DefaultListModel)this.jList1.getModel()).addElement(name);
        }
    }

    private ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component != null && value != null) {
                    MainFrame mainFrame = MainFrame.getInstance();
                    String watchlistName = mainFrame.getJStockOptions().getWatchlistName();
                    if (value.toString().equals(watchlistName)) {
                        Font oldFont = component.getFont();
                        component.setFont(Utils.getBoldFont(oldFont));
                    }
                }
                return component;
            }
        };
    }

    private static boolean isValidFolderName(String folderName) {
        char[] chars;
        for (char c : chars = folderName.toCharArray()) {
            if (!ILLEGAL_CHARACTERS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }
}

