/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.portfolio.Activity;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Utils;

public class Activities {
    private final List<Activity> activities = new ArrayList<Activity>();
    private final SimpleDate simpleDate;

    public Activities(SimpleDate simpleDate) {
        this.simpleDate = simpleDate;
    }

    public SimpleDate getDate() {
        return this.simpleDate;
    }

    public boolean add(Activity activity) {
        boolean status = this.activities.add(activity);
        Collections.sort(this.activities, new Comparator<Activity>(){

            @Override
            public int compare(Activity o1, Activity o2) {
                return o1.getType().compareTo(o2.getType());
            }
        });
        return status;
    }

    public int size() {
        return this.activities.size();
    }

    public Activity get(int index) {
        return this.activities.get(index);
    }

    public List<Activity.Type> getTypes() {
        ArrayList<Activity.Type> types = new ArrayList<Activity.Type>();
        for (Activity activity : this.activities) {
            if (types.contains((Object)activity.getType())) continue;
            types.add(activity.getType());
        }
        Collections.sort(types);
        return types;
    }

    public String toSummary() {
        HashMap<String, Double> datas = new HashMap<String, Double>();
        for (Activity activity : this.activities) {
            Stock stock = (Stock)activity.get(Activity.Param.Stock);
            String key = (stock != null ? stock.symbol.toString() : "") + (Object)((Object)activity.getType());
            Double d = (Double)datas.get(key);
            if (d != null) {
                double total = d + activity.getAmount();
                datas.put(key, total);
                continue;
            }
            datas.put(key, activity.getAmount());
        }
        String message = "";
        int count = 0;
        int size = this.activities.size();
        for (Activity activity : this.activities) {
            ++count;
            Stock stock = (Stock)activity.get(Activity.Param.Stock);
            String who = stock != null ? stock.symbol.toString() : "";
            Activity.Type type = activity.getType();
            String key = who + (Object)((Object)type);
            Double d = (Double)datas.get(key);
            message = who.length() > 1 ? message + who + " " + type.toString().toLowerCase() + " " + Utils.toCurrencyWithSymbol(DecimalPlaces.Three, d) : message + type.toString().toLowerCase() + " " + Utils.toCurrencyWithSymbol(DecimalPlaces.Three, d);
            if (count >= size) continue;
            message = message + "<br>";
        }
        message = message + "";
        return message;
    }
}

