/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Deposit;
import org.yccheok.jstock.portfolio.DepositSummary;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.PortfolioInfo;
import org.yccheok.jstock.portfolio.Transaction;

public class Utils {
    private static final ThreadLocal<NumberFormat> unitsNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.####");
        }
    };
    private static final ThreadLocal<NumberFormat> twoDecimalPlaceCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.00");
        }
    };
    private static final ThreadLocal<NumberFormat> threeDecimalPlaceCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.00#");
        }
    };
    private static final ThreadLocal<NumberFormat> fourDecimalPlaceCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.00##");
        }
    };
    private static final ThreadLocal<NumberFormat> quantityNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.###");
        }
    };
    private static final ThreadLocal<NumberFormat> exchangeRateNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("#,##0.######");
        }
    };
    private static final ThreadLocal<NumberFormat> editThreeCurrencyNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat("0.###");
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return decimalFormat;
        }
    };
    private static final double EPSILON = 1.0E-8;
    private static final Log log = LogFactory.getLog(Utils.class);

    private Utils() {
    }

    public static Dividend getLatestDividend(DividendSummary dividendSummary, Code code) {
        Dividend latestDividend = null;
        int ei = dividendSummary.size();
        for (int i = 0; i < ei; ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            if (!(dividend.amount > 0.0) || !dividend.stockInfo.code.equals(code)) continue;
            if (latestDividend == null) {
                latestDividend = dividend;
                continue;
            }
            if (latestDividend.date.compareTo(dividend.date) >= 0) continue;
            latestDividend = dividend;
        }
        return latestDividend;
    }

    public static String replaceCSVLineFeedToSystemLineFeed(String string) {
        String CSVLineFeed = "\n";
        String systemLineFeed = System.getProperty("line.separator");
        return string.replaceAll("\n", systemLineFeed);
    }

    public static String toExchangeRate(Object value) {
        return exchangeRateNumberFormat.get().format(value);
    }

    public static String toExchangeRate(double value) {
        return exchangeRateNumberFormat.get().format(value);
    }

    public static String toQuantity(Object value) {
        return quantityNumberFormat.get().format(value);
    }

    public static String toQuantity(double value) {
        return quantityNumberFormat.get().format(value);
    }

    public static String toCurrency(DecimalPlaces decimalPlace, Object value) {
        if (decimalPlace == DecimalPlaces.Two) {
            return twoDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        if (decimalPlace == DecimalPlaces.Three) {
            return threeDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        assert (decimalPlace == DecimalPlaces.Four);
        return fourDecimalPlaceCurrencyNumberFormat.get().format(value);
    }

    public static String toCurrency(DecimalPlaces decimalPlace, double value) {
        if (decimalPlace == DecimalPlaces.Two) {
            return twoDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        if (decimalPlace == DecimalPlaces.Three) {
            return threeDecimalPlaceCurrencyNumberFormat.get().format(value);
        }
        assert (decimalPlace == DecimalPlaces.Four);
        return fourDecimalPlaceCurrencyNumberFormat.get().format(value);
    }

    public static String toCurrencyWithSymbol(DecimalPlaces decimalPlace, Object value) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        Country country = jStockOptions.getCountry();
        return jStockOptions.getCurrencySymbol(country) + Utils.toCurrency(decimalPlace, value);
    }

    public static String toCurrencyWithSymbol(DecimalPlaces decimalPlace, double value) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        Country country = jStockOptions.getCountry();
        return jStockOptions.getCurrencySymbol(country) + Utils.toCurrency(decimalPlace, value);
    }

    public static boolean isTransactionWithEqualStockCode(Transaction t0, Transaction t1) {
        Code c0 = t0.getStock().code;
        Code c1 = t1.getStock().code;
        return c0.equals(c1);
    }

    public static String getPortfolioDirectory(String name) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return Utils.getPortfolioDirectory(jStockOptions.getCountry(), name);
    }

    public static String getPortfolioDirectory(Country country, String name) {
        return org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "portfolios" + File.separator + name + File.separator;
    }

    public static boolean createEmptyPortfolio(String name) {
        String directory = Utils.getPortfolioDirectory(name);
        File stockPricesFile = new File(directory + "stockprices.csv");
        if (stockPricesFile.exists()) {
            return false;
        }
        if (!org.yccheok.jstock.gui.Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        Statements statements4 = Statements.newInstanceFromStockPrices(Collections.<Code, Double>emptyMap(), 0L);
        boolean status = true;
        return status &= statements4.saveAsCSVFile(stockPricesFile);
    }

    public static String getPortfolioDirectory() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return Utils.getPortfolioDirectory(jStockOptions.getPortfolioName());
    }

    private static boolean isXMLPortfolioDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] files = file.list();
        List<String> list = Arrays.asList(files);
        return list.contains("buyportfolio.xml") && list.contains("sellportfolio.xml") && list.contains("depositsummary.xml") && list.contains("dividendsummary.xml");
    }

    private static boolean isCSVPortfolioDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] files = file.list();
        List<String> list = Arrays.asList(files);
        return list.contains("stockprices.csv");
    }

    private static boolean isPortfolioDirectory(File file) {
        return Utils.isCSVPortfolioDirectory(file);
    }

    public static String toUnits(Object value) {
        return unitsNumberFormat.get().format(value);
    }

    public static String toUnits(double value) {
        return unitsNumberFormat.get().format(value);
    }

    public static List<String> getPortfolioDirectories() {
        List<String> names = Utils.getPortfolioNames();
        ArrayList<String> directories = new ArrayList<String>();
        for (String name : names) {
            directories.add(Utils.getPortfolioDirectory(name));
        }
        return directories;
    }

    public static List<PortfolioInfo> getPortfolioInfos() {
        ArrayList<PortfolioInfo> portfolioInfos = new ArrayList<PortfolioInfo>();
        for (Country country : Country.values()) {
            File file = new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "portfolios" + File.separator);
            File[] children = file.listFiles();
            if (children == null) continue;
            for (File child : children) {
                File stockPricesFile = new File(child, "stockprices.csv");
                int lines = org.yccheok.jstock.gui.Utils.numOfLines(stockPricesFile, true);
                if (--lines > 0) {
                    PortfolioInfo portfolioInfo = PortfolioInfo.newInstance(country, child.getName(), lines);
                    portfolioInfos.add(portfolioInfo);
                    continue;
                }
                File sellPortfolioFile = new File(child, "sellportfolio.csv");
                lines = org.yccheok.jstock.gui.Utils.numOfLines(sellPortfolioFile, true);
                if (--lines > 0) {
                    PortfolioInfo portfolioInfo = PortfolioInfo.newInstance(country, child.getName(), lines);
                    portfolioInfos.add(portfolioInfo);
                    continue;
                }
                File dividendFile = new File(child, "dividendsummary.csv");
                lines = org.yccheok.jstock.gui.Utils.numOfLines(dividendFile, true);
                if (--lines > 0) {
                    PortfolioInfo portfolioInfo = PortfolioInfo.newInstance(country, child.getName(), lines);
                    portfolioInfos.add(portfolioInfo);
                    continue;
                }
                File depositFile = new File(child, "depositsummary.csv");
                lines = org.yccheok.jstock.gui.Utils.numOfLines(depositFile, true);
                if (--lines <= 0) continue;
                PortfolioInfo portfolioInfo = PortfolioInfo.newInstance(country, child.getName(), lines);
                portfolioInfos.add(portfolioInfo);
            }
        }
        return portfolioInfos;
    }

    public static List<String> getPortfolioNames() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return Utils.getPortfolioNames(jStockOptions.getCountry());
    }

    public static List<String> getPortfolioNames(Country country) {
        ArrayList<String> portfolioNames = new ArrayList<String>();
        File file = new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "portfolios" + File.separator);
        File[] children = file.listFiles();
        if (children == null) {
            return portfolioNames;
        }
        for (File child : children) {
            if (!Utils.isPortfolioDirectory(child)) continue;
            portfolioNames.add(child.getName());
        }
        return portfolioNames;
    }

    private static List<String> getXMLPortfolioNames(String baseDirectory, Country country, boolean oldData) {
        ArrayList<String> portfolioNames = new ArrayList<String>();
        File file = oldData ? new File(baseDirectory + (Object)((Object)country) + File.separator + "config" + File.separator) : new File(baseDirectory + (Object)((Object)country) + File.separator + "portfolios" + File.separator);
        File[] children = file.listFiles();
        if (children == null) {
            return portfolioNames;
        }
        for (File child : children) {
            if (!Utils.isXMLPortfolioDirectory(child)) continue;
            portfolioNames.add(child.getName());
        }
        return portfolioNames;
    }

    public static String getDefaultPortfolioName() {
        return "My Portfolio";
    }

    public static void removeMeaninglessRecords(DividendSummary dividendSummary) {
        for (int i = 0; i < dividendSummary.size(); ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            if (!(dividend.amount <= 0.0) && dividend.stockInfo.code.toString().length() > 0) continue;
            dividendSummary.remove(dividend);
            --i;
        }
    }

    public static void removeMeaninglessRecords(DepositSummary depositSummary) {
        for (int i = 0; i < depositSummary.size(); ++i) {
            Deposit deposit = (Deposit)depositSummary.get(i);
            if (!Utils.essentiallyEqual(deposit.getAmount(), 0.0)) continue;
            depositSummary.remove(deposit);
            --i;
        }
    }

    public static double getTotalDeposit(DepositSummary cashSummary) {
        int size = cashSummary.size();
        double totalDeposit = 0.0;
        for (int i = 0; i < size; ++i) {
            Deposit deposit = (Deposit)cashSummary.get(i);
            double amount = deposit.getAmount();
            if (!Utils.definitelyGreaterThan(amount, 0.0)) continue;
            totalDeposit += amount;
        }
        return totalDeposit;
    }

    public static String toEditCurrency(DecimalPlaces decimalPlace, double value) {
        if (decimalPlace == DecimalPlaces.Two) {
            throw new UnsupportedOperationException();
        }
        if (decimalPlace == DecimalPlaces.Three) {
            return editThreeCurrencyNumberFormat.get().format(value);
        }
        throw new UnsupportedOperationException();
    }

    public static double getTotalWithdraw(DepositSummary cashSummary) {
        int size = cashSummary.size();
        double totalWidthdraw = 0.0;
        for (int i = 0; i < size; ++i) {
            Deposit withdraw = (Deposit)cashSummary.get(i);
            double amount = withdraw.getAmount();
            if (!Utils.definitelyLessThan(amount, 0.0)) continue;
            totalWidthdraw += amount;
        }
        return totalWidthdraw;
    }

    public static boolean essentiallyEqual(double a, double b) {
        return Math.abs(a - b) <= (Math.abs(a) > Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }

    public static boolean definitelyGreaterThan(double a, double b) {
        return a - b > (Math.abs(a) < Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }

    public static boolean definitelyLessThan(double a, double b) {
        return b - a > (Math.abs(a) < Math.abs(b) ? Math.abs(b) : Math.abs(a)) * 1.0E-8;
    }
}

