/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.roydesign.app.Application;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.OSXPaletteHandler;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AboutAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ClearRecentFilesAction;
import org.jhotdraw.app.action.CloseAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExitAction;
import org.jhotdraw.app.action.FocusAction;
import org.jhotdraw.app.action.MaximizeAction;
import org.jhotdraw.app.action.MinimizeAction;
import org.jhotdraw.app.action.NewAction;
import org.jhotdraw.app.action.OSXDropOnDockAction;
import org.jhotdraw.app.action.OSXTogglePaletteAction;
import org.jhotdraw.app.action.OpenAction;
import org.jhotdraw.app.action.OpenRecentAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.PrintAction;
import org.jhotdraw.app.action.RedoAction;
import org.jhotdraw.app.action.SaveAction;
import org.jhotdraw.app.action.SaveAsAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.UndoAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class DefaultOSXApplication
extends AbstractApplication {
    private OSXPaletteHandler paletteHandler;
    private Preferences prefs;
    private LinkedList<Action> paletteActions;

    @Override
    public void init() {
        ResourceBundleUtil.putPropertyNameModifier("os", "mac", "default");
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLookAndFeel();
        this.paletteHandler = new OSXPaletteHandler(this);
        this.initLabels();
        this.initApplicationActions();
        this.getModel().initApplication(this);
        this.paletteActions = new LinkedList();
        this.initPalettes(this.paletteActions);
        this.initScreenMenuBar();
    }

    @Override
    public void launch(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        super.launch(args);
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
    }

    protected void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initApplicationActions() {
        ApplicationModel mo = this.getModel();
        mo.putAction("application.about", new AboutAction(this));
        mo.putAction("application.exit", new ExitAction(this));
        mo.putAction("file.drop", new OSXDropOnDockAction(this));
        mo.putAction("file.new", new NewAction(this));
        mo.putAction("file.open", new OpenAction(this));
        mo.putAction("file.clearRecentFiles", new ClearRecentFilesAction(this));
        mo.putAction("file.save", new SaveAction(this));
        mo.putAction("file.saveAs", new SaveAsAction(this));
        mo.putAction("file.print", new PrintAction(this));
        mo.putAction("file.close", new CloseAction(this));
        mo.putAction("edit.undo", new UndoAction(this));
        mo.putAction("edit.redo", new RedoAction(this));
        mo.putAction("edit.cut", new CutAction());
        mo.putAction("edit.copy", new CopyAction());
        mo.putAction("edit.paste", new PasteAction());
        mo.putAction("edit.delete", new DeleteAction());
        mo.putAction("edit.duplicate", new DuplicateAction());
        mo.putAction("edit.selectAll", new SelectAllAction());
        mo.putAction("window.maximize", new MaximizeAction(this));
        mo.putAction("window.minimize", new MinimizeAction(this));
    }

    @Override
    protected void initViewActions(View p) {
        p.putAction("window.focus", new FocusAction(p));
    }

    @Override
    public void addPalette(Window palette) {
        this.paletteHandler.addPalette(palette);
    }

    @Override
    public void removePalette(Window palette) {
        this.paletteHandler.removePalette(palette);
    }

    @Override
    public void addWindow(Window window, View p) {
        if (window instanceof JFrame) {
            ((JFrame)window).setJMenuBar(this.createMenuBar(p));
        } else if (window instanceof JDialog) {
            // empty if block
        }
        this.paletteHandler.add(window, p);
    }

    @Override
    public void removeWindow(Window window) {
        this.paletteHandler.remove(window);
    }

    @Override
    public void show(final View p) {
        if (!p.isShowing()) {
            boolean moved;
            p.setShowing(true);
            final JFrame f = new JFrame();
            f.setDefaultCloseOperation(0);
            f.setPreferredSize(new Dimension(400, 400));
            this.updateViewTitle(p, f);
            PreferencesUtil.installFramePrefsHandler(this.prefs, "view", f);
            Point loc = f.getLocation();
            block0: do {
                moved = false;
                for (View aView : this.views()) {
                    if (aView == p || !aView.isShowing() || !SwingUtilities.getWindowAncestor(aView.getComponent()).getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block0;
                }
            } while (moved);
            f.setLocation(loc);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    DefaultOSXApplication.this.setActiveView(p);
                    DefaultOSXApplication.this.getModel().getAction("file.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }

                @Override
                public void windowClosed(WindowEvent evt) {
                    if (p == DefaultOSXApplication.this.getActiveView()) {
                        DefaultOSXApplication.this.setActiveView(null);
                    }
                    p.stop();
                }

                @Override
                public void windowActivated(WindowEvent evt) {
                    DefaultOSXApplication.this.setActiveView(p);
                }
            });
            p.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("hasUnsavedChanges")) {
                        f.getRootPane().putClientProperty("windowModified", new Boolean(p.hasUnsavedChanges()));
                    } else if (name.equals("file")) {
                        DefaultOSXApplication.this.updateViewTitle(p, f);
                    }
                }
            });
            this.addWindow(f, p);
            f.getContentPane().add(p.getComponent());
            f.setVisible(true);
            p.start();
        }
    }

    protected void updateViewTitle(View p, JFrame f) {
        File file = p.getFile();
        String title = file == null ? this.labels.getString("unnamedFile") : file.getName();
        p.setTitle(this.labels.getFormatted("frame.title", title, this.getName(), p.getMultipleOpenId()));
        f.setTitle(p.getTitle());
        f.getRootPane().putClientProperty("Window.documentFile", file);
    }

    @Override
    public void hide(View p) {
        if (p.isShowing()) {
            JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
            f.setVisible(false);
            f.remove(p.getComponent());
            this.removeWindow(f);
            f.dispose();
        }
    }

    protected JMenuBar createMenuBar(View p) {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu(p));
        for (JMenu mm : this.getModel().createMenus(this, p)) {
            mb.add(mm);
        }
        String helpMenuText = this.labels.getString("help.text");
        int index = mb.getComponentCount();
        int n = mb.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JMenu m = (JMenu)mb.getComponent(i);
            if (m.getText() == null || !m.getText().equals(helpMenuText)) continue;
            index = i;
            break;
        }
        mb.add((Component)this.createWindowMenu(p), index);
        return mb;
    }

    protected JMenu createWindowMenu(final View p) {
        JMenu m;
        ApplicationModel model = this.getModel();
        final JMenu windowMenu = m = new JMenu();
        this.labels.configureMenu(m, "window");
        this.addViewWindowMenuItems(m, p);
        m.addSeparator();
        for (View pr : this.views()) {
            if (pr.getAction("window.focus") == null) continue;
            windowMenu.add(pr.getAction("window.focus"));
        }
        if (this.paletteActions.size() > 0) {
            m.addSeparator();
            for (Action a : this.paletteActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                cbmi.setIcon(null);
                m.add(cbmi);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "viewCount" || name == "paletteCount") {
                    if (p == null || DefaultOSXApplication.this.views().contains(p)) {
                        JMenu m = windowMenu;
                        m.removeAll();
                        DefaultOSXApplication.this.addViewWindowMenuItems(m, p);
                        m.addSeparator();
                        for (View pr : DefaultOSXApplication.this.views()) {
                            if (pr.getAction("window.focus") == null) continue;
                            m.add(pr.getAction("window.focus"));
                        }
                        if (DefaultOSXApplication.this.paletteActions.size() > 0) {
                            m.addSeparator();
                            for (Action a : DefaultOSXApplication.this.paletteActions) {
                                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                                Actions.configureJCheckBoxMenuItem(cbmi, a);
                                cbmi.setIcon(null);
                                m.add(cbmi);
                            }
                        }
                    } else {
                        DefaultOSXApplication.this.removePropertyChangeListener(this);
                    }
                }
            }
        });
        return m;
    }

    protected void addViewWindowMenuItems(JMenu m, View p) {
        ApplicationModel model = this.getModel();
        JMenuItem mi = m.add(model.getAction("window.minimize"));
        mi.setIcon(null);
        mi = m.add(model.getAction("window.maximize"));
        mi.setIcon(null);
    }

    protected void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new OpenRecentAction(this, f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    protected JMenu createFileMenu(View p) {
        ApplicationModel model = this.getModel();
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "file");
        JMenuItem mi = m.add(model.getAction("file.new"));
        mi.setIcon(null);
        mi = m.add(model.getAction("file.open"));
        mi.setIcon(null);
        if (model.getAction("file.openDirectory") != null) {
            mi = m.add(model.getAction("file.openDirectory"));
            mi.setIcon(null);
        }
        final JMenu openRecentMenu = new JMenu();
        this.labels.configureMenu(openRecentMenu, "file.openRecent");
        openRecentMenu.setIcon(null);
        openRecentMenu.add(model.getAction("file.clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        mi = m.add(model.getAction("file.close"));
        mi.setIcon(null);
        mi = m.add(model.getAction("file.save"));
        mi.setIcon(null);
        mi = m.add(model.getAction("file.saveAs"));
        mi.setIcon(null);
        if (model.getAction("file.export") != null) {
            mi = m.add(model.getAction("file.export"));
            mi.setIcon(null);
        }
        if (model.getAction("file.print") != null) {
            m.addSeparator();
            mi = m.add(model.getAction("file.print"));
            mi.setIcon(null);
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "recentFiles") {
                    DefaultOSXApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    protected void initScreenMenuBar() {
        ApplicationModel model = this.getModel();
        Application mrjapp = Application.getInstance();
        mrjapp.setFramelessJMenuBar(this.createMenuBar(null));
        this.paletteHandler.add(SwingUtilities.getWindowAncestor(mrjapp.getFramelessJMenuBar()), null);
        mrjapp.getAboutJMenuItem().setAction(model.getAction("application.about"));
        mrjapp.getQuitJMenuItem().setAction(model.getAction("application.exit"));
        mrjapp.addOpenDocumentListener((ActionListener)model.getAction("file.drop"));
    }

    protected void initPalettes(final LinkedList<Action> paletteActions) {
        SwingUtilities.invokeLater(new Worker(){

            @Override
            public Object construct() {
                LinkedList<JFrame> palettes = new LinkedList<JFrame>();
                LinkedList<JToolBar> toolBars = new LinkedList<JToolBar>(DefaultOSXApplication.this.getModel().createToolBars(DefaultOSXApplication.this, null));
                int i = 0;
                int x = 0;
                for (JToolBar tb : toolBars) {
                    ++i;
                    tb.setFloatable(false);
                    tb.setOrientation(1);
                    tb.setFocusable(false);
                    JFrame d = new JFrame();
                    d.getRootPane().putClientProperty("Window.style", "small");
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isVertical", Boolean.FALSE);
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
                    d.setFocusable(false);
                    d.setResizable(false);
                    d.getContentPane().setLayout(new BorderLayout());
                    d.getContentPane().add((Component)tb, "Center");
                    d.setAlwaysOnTop(true);
                    d.setUndecorated(true);
                    d.getRootPane().setWindowDecorationStyle(1);
                    d.getRootPane().setFont(new Font("Lucida Grande", 0, 11));
                    d.setJMenuBar(DefaultOSXApplication.this.createMenuBar(null));
                    d.pack();
                    d.setFocusableWindowState(false);
                    PreferencesUtil.installPalettePrefsHandler(DefaultOSXApplication.this.prefs, "toolbar." + i, d, x);
                    x += d.getWidth();
                    paletteActions.add(new OSXTogglePaletteAction(DefaultOSXApplication.this, d, tb.getName()));
                    palettes.add(d);
                }
                return palettes;
            }

            @Override
            public void finished(Object result) {
                LinkedList palettes = (LinkedList)result;
                if (palettes != null) {
                    for (JFrame p : palettes) {
                        DefaultOSXApplication.this.addPalette(p);
                    }
                    DefaultOSXApplication.this.firePropertyChange("paletteCount", 0, palettes.size());
                }
            }
        });
    }

    @Override
    public boolean isSharingToolsAmongViews() {
        return true;
    }

    @Override
    public Component getComponent() {
        return null;
    }
}

