/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TextAreaEditingTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.TextOverflowHandle;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

public class SVGTextAreaFigure
extends SVGAttributedFigure
implements SVGFigure,
TextHolderFigure {
    private Rectangle2D.Double bounds = new Rectangle2D.Double();
    private boolean editable = true;
    private static final BasicStroke dashes = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private Boolean isTextOverflow;
    private transient Rectangle2D.Double cachedDrawingArea;
    private transient Shape cachedTextShape;

    public SVGTextAreaFigure() {
        this("Text");
    }

    public SVGTextAreaFigure(String text) {
        this.setText(text);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawText(Graphics2D g) {
    }

    @Override
    protected void drawFill(Graphics2D g) {
        g.fill(this.getTextShape());
        g.draw(new Rectangle2D.Double(this.getBounds().x, this.getBounds().y, this.getPreferredTextSize((double)((double)this.changingDepth)).width, this.getPreferredTextSize((double)((double)this.changingDepth)).height));
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.getTextShape());
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D.Double rx = this.getBounds();
            Rectangle2D.Double r = rx instanceof Rectangle2D.Double ? rx : new Rectangle2D.Double(((RectangularShape)rx).getX(), ((RectangularShape)rx).getY(), ((RectangularShape)rx).getWidth(), ((RectangularShape)rx).getHeight());
            double g = SVGAttributeKeys.getPerpendicularHitGrowth(this);
            Geom.grow(r, g, g);
            if (SVGAttributeKeys.TRANSFORM.get(this) == null) {
                this.cachedDrawingArea = r;
            } else {
                this.cachedDrawingArea = new Rectangle2D.Double();
                this.cachedDrawingArea.setRect(((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).createTransformedShape(r).getBounds2D());
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        Rectangle2D r;
        if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
            try {
                p = (Point2D.Double)((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        return (r = this.getTextShape().getBounds2D()).isEmpty() ? this.getBounds().contains(p) : r.contains(p);
    }

    private Shape getTextShape() {
        if (this.cachedTextShape == null) {
            GeneralPath shape = new GeneralPath();
            this.cachedTextShape = shape;
            if (this.getText() != null || this.isEditable()) {
                Font font = this.getFont();
                boolean isUnderlined = (Boolean)SVGAttributeKeys.FONT_UNDERLINE.get(this);
                Insets2D.Double insets = this.getInsets();
                Rectangle2D.Double textRect = new Rectangle2D.Double(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
                float leftMargin = (float)textRect.x;
                float rightMargin = (float)Math.max((double)(leftMargin + 1.0f), textRect.x + textRect.width);
                float verticalPos = (float)textRect.y;
                float maxVerticalPos = (float)(textRect.y + textRect.height);
                if (leftMargin < rightMargin) {
                    float tabWidth = (float)((double)this.getTabSize() * font.getStringBounds("m", this.getFontRenderContext()).getWidth());
                    float[] tabStops = new float[(int)(textRect.width / (double)tabWidth)];
                    for (int i = 0; i < tabStops.length; ++i) {
                        tabStops[i] = (float)(textRect.x + (double)((int)(tabWidth * (float)(i + 1))));
                    }
                    if (this.getText() != null) {
                        String[] paragraphs = this.getText().split("\n");
                        for (int i = 0; i < paragraphs.length; ++i) {
                            if (paragraphs[i].length() == 0) {
                                paragraphs[i] = " ";
                            }
                            AttributedString as = new AttributedString(paragraphs[i]);
                            as.addAttribute(TextAttribute.FONT, font);
                            if (isUnderlined) {
                                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                            }
                            int tabCount = paragraphs[i].split("\t").length - 1;
                            Rectangle2D.Double paragraphBounds = this.appendParagraph(shape, as.getIterator(), verticalPos, maxVerticalPos, leftMargin, rightMargin, tabStops, tabCount);
                            verticalPos = (float)(paragraphBounds.y + paragraphBounds.height);
                            if ((double)verticalPos > textRect.y + textRect.height) break;
                        }
                    }
                }
            }
        }
        return this.cachedTextShape;
    }

    private Rectangle2D.Double appendParagraph(GeneralPath shape, AttributedCharacterIterator styledText, float verticalPos, float maxVerticalPos, float leftMargin, float rightMargin, float[] tabStops, int tabCount) {
        Rectangle2D.Double paragraphBounds = new Rectangle2D.Double(leftMargin, verticalPos, 0.0, 0.0);
        int[] tabLocations = new int[tabCount + 1];
        int i = 0;
        char c = styledText.first();
        while (true) {
            if (c == '\uffff') break;
            if (c == '\t') {
                tabLocations[i++] = styledText.getIndex();
            }
            c = styledText.next();
        }
        tabLocations[tabCount] = styledText.getEndIndex() - 1;
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, this.getFontRenderContext());
        int currentTab = 0;
        while (measurer.getPosition() < styledText.getEndIndex()) {
            boolean lineContainsText = false;
            boolean lineComplete = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float horizontalPos = leftMargin;
            LinkedList<TextLayout> layouts = new LinkedList<TextLayout>();
            LinkedList<Float> penPositions = new LinkedList<Float>();
            while (!lineComplete) {
                float wrappingWidth = rightMargin - horizontalPos;
                TextLayout layout = null;
                layout = measurer.nextLayout(wrappingWidth, tabLocations[currentTab] + 1, lineContainsText);
                if (layout != null) {
                    layouts.add(layout);
                    penPositions.add(Float.valueOf(horizontalPos));
                    horizontalPos += layout.getAdvance();
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                } else {
                    lineComplete = true;
                }
                lineContainsText = true;
                if (measurer.getPosition() == tabLocations[currentTab] + 1) {
                    ++currentTab;
                }
                if (measurer.getPosition() == styledText.getEndIndex()) {
                    lineComplete = true;
                } else if (tabStops.length == 0 || horizontalPos >= tabStops[tabStops.length - 1]) {
                    lineComplete = true;
                }
                if (lineComplete) continue;
                int j = 0;
                while (horizontalPos >= tabStops[j]) {
                    ++j;
                }
                horizontalPos = tabStops[j];
            }
            if ((verticalPos += maxAscent) > maxVerticalPos) break;
            Iterator layoutEnum = layouts.iterator();
            Iterator positionEnum = penPositions.iterator();
            while (layoutEnum.hasNext()) {
                TextLayout nextLayout = (TextLayout)layoutEnum.next();
                float nextPosition = ((Float)positionEnum.next()).floatValue();
                AffineTransform tx = new AffineTransform();
                tx.translate(nextPosition, verticalPos);
                if (shape != null) {
                    Shape outline = nextLayout.getOutline(tx);
                    shape.append(outline, false);
                }
                Rectangle2D layoutBounds = nextLayout.getBounds();
                paragraphBounds.add(new Rectangle2D.Double(layoutBounds.getX() + (double)nextPosition, layoutBounds.getY() + (double)verticalPos, layoutBounds.getWidth(), layoutBounds.getHeight()));
            }
            verticalPos += maxDescent;
        }
        return paragraphBounds;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.bounds.x = Math.min(anchor.x, lead.x);
        this.bounds.y = Math.min(anchor.y, lead.y);
        this.bounds.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.bounds.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
        this.invalidate();
    }

    @Override
    public void transform(AffineTransform tx) {
        if (SVGAttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (SVGAttributeKeys.TRANSFORM.get(this) == null) {
                SVGAttributeKeys.TRANSFORM.basicSet(this, (AffineTransform)tx.clone());
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                SVGAttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            Gradient g;
            Point2D.Double anchor = this.getStartPoint();
            Point2D.Double lead = this.getEndPoint();
            this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
            if (SVGAttributeKeys.FILL_GRADIENT.get(this) != null && !SVGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (SVGAttributeKeys.STROKE_GRADIENT.get(this) != null && !SVGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Object[] restoreData = (Object[])geometry;
        this.bounds = (Rectangle2D.Double)((Rectangle2D.Double)restoreData[0]).clone();
        SVGAttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        SVGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.bounds.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public String getText() {
        return (String)this.getAttribute(SVGAttributeKeys.TEXT);
    }

    @Override
    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    @Override
    public <T> void setAttribute(AttributeKey<T> key, T newValue) {
        if (key.equals(SVGAttributeKeys.TRANSFORM) || key.equals(SVGAttributeKeys.FONT_FACE) || key.equals(SVGAttributeKeys.FONT_BOLD) || key.equals(SVGAttributeKeys.FONT_ITALIC) || key.equals(SVGAttributeKeys.FONT_SIZE) || key.equals(SVGAttributeKeys.STROKE_WIDTH) || key.equals(SVGAttributeKeys.STROKE_COLOR) || key.equals(SVGAttributeKeys.STROKE_GRADIENT)) {
            this.invalidate();
        }
        super.setAttribute(key, newValue);
    }

    @Override
    public void setText(String newText) {
        SVGAttributeKeys.TEXT.set(this, newText);
    }

    @Override
    public Insets2D.Double getInsets() {
        double sw = SVGAttributeKeys.STROKE_COLOR.get(this) == null ? 0.0 : Math.ceil((Double)SVGAttributeKeys.STROKE_WIDTH.get(this) / 2.0);
        Insets2D.Double insets = new Insets2D.Double(0.0, 0.0, 0.0, 0.0);
        return new Insets2D.Double(insets.top + sw, insets.left + sw, insets.bottom + sw, insets.right + sw);
    }

    @Override
    public double getBaseline() {
        return (double)this.getFont().getLineMetrics(this.getText(), this.getFontRenderContext()).getAscent() + this.getInsets().top;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Font getFont() {
        return SVGAttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return (Color)SVGAttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return ((Color)SVGAttributeKeys.FILL_COLOR.get(this)).equals(Color.white) ? Color.black : Color.WHITE;
    }

    @Override
    public void setFontSize(float size) {
        Point2D.Double p = new Point2D.Double(0.0, size);
        AffineTransform tx = (AffineTransform)SVGAttributeKeys.TRANSFORM.get(this);
        if (tx != null) {
            try {
                tx.inverseTransform(p, p);
                Point2D.Double p0 = new Point2D.Double(0.0, 0.0);
                tx.inverseTransform(p0, p0);
                p.y -= p0.y;
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        SVGAttributeKeys.FONT_SIZE.set(this, Double.valueOf(Math.abs(p.y)));
    }

    @Override
    public float getFontSize() {
        Point2D.Double p = new Point2D.Double(0.0, (Double)SVGAttributeKeys.FONT_SIZE.get(this));
        AffineTransform tx = (AffineTransform)SVGAttributeKeys.TRANSFORM.get(this);
        if (tx != null) {
            tx.transform(p, p);
            Point2D.Double p0 = new Point2D.Double(0.0, 0.0);
            tx.transform(p0, p0);
            p.y -= p0.y;
        }
        return (float)Math.abs(p.y);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                handles.add(new FontSizeHandle(this));
                handles.add(new TextOverflowHandle(this));
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            TextAreaEditingTool tool = new TextAreaEditingTool(this);
            return tool;
        }
        return null;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedDrawingArea = null;
        this.cachedTextShape = null;
        this.isTextOverflow = null;
    }

    @Override
    public boolean isTextOverflow() {
        if (this.isTextOverflow == null) {
            Insets2D.Double insets = this.getInsets();
            this.isTextOverflow = this.getPreferredTextSize((double)(this.getBounds().width - insets.left - insets.right)).height > this.getBounds().height - insets.top - insets.bottom;
        }
        return this.isTextOverflow;
    }

    public Dimension2DDouble getPreferredTextSize(double maxWidth) {
        Rectangle2D.Double textRect = new Rectangle2D.Double();
        if (this.getText() != null) {
            Font font = this.getFont();
            boolean isUnderlined = (Boolean)SVGAttributeKeys.FONT_UNDERLINE.get(this);
            float leftMargin = 0.0f;
            float rightMargin = (float)maxWidth - 1.0f;
            float verticalPos = 0.0f;
            float maxVerticalPos = Float.MAX_VALUE;
            if (leftMargin < rightMargin) {
                float tabWidth = (float)((double)this.getTabSize() * font.getStringBounds("m", this.getFontRenderContext()).getWidth());
                float[] tabStops = new float[(int)(textRect.width / (double)tabWidth)];
                for (int i = 0; i < tabStops.length; ++i) {
                    tabStops[i] = (float)(textRect.x + (double)((int)(tabWidth * (float)(i + 1))));
                }
                if (this.getText() != null) {
                    String[] paragraphs = this.getText().split("\n");
                    for (int i = 0; i < paragraphs.length; ++i) {
                        if (paragraphs[i].length() == 0) {
                            paragraphs[i] = " ";
                        }
                        AttributedString as = new AttributedString(paragraphs[i]);
                        as.addAttribute(TextAttribute.FONT, font);
                        if (isUnderlined) {
                            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                        }
                        int tabCount = paragraphs[i].split("\t").length - 1;
                        Rectangle2D.Double paragraphBounds = this.appendParagraph(null, as.getIterator(), verticalPos, maxVerticalPos, leftMargin, rightMargin, tabStops, tabCount);
                        verticalPos = (float)(paragraphBounds.y + paragraphBounds.height);
                        textRect.add(paragraphBounds);
                    }
                }
            }
        }
        return new Dimension2DDouble(Math.abs(textRect.x) + textRect.width, Math.abs(textRect.y) + textRect.height);
    }

    @Override
    public SVGTextAreaFigure clone() {
        SVGTextAreaFigure that = (SVGTextAreaFigure)super.clone();
        that.bounds = (Rectangle2D.Double)this.bounds.clone();
        return that;
    }
}

