/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public class DrawingOpacityIcon
extends ImageIcon {
    private DrawingEditor editor;
    private AttributeKey<Double> opacityKey;
    private AttributeKey<Color> fillColorKey;
    private AttributeKey<Color> strokeColorKey;
    private Shape fillShape;
    private Shape strokeShape;

    public DrawingOpacityIcon(DrawingEditor editor, AttributeKey<Double> opacityKey, AttributeKey<Color> fillColorKey, AttributeKey<Color> strokeColorKey, URL imageLocation, Shape fillShape, Shape strokeShape) {
        super(imageLocation);
        this.editor = editor;
        this.opacityKey = opacityKey;
        this.fillColorKey = fillColorKey;
        this.strokeColorKey = strokeColorKey;
        this.fillShape = fillShape;
        this.strokeShape = strokeShape;
    }

    public DrawingOpacityIcon(DrawingEditor editor, AttributeKey<Double> opacityKey, AttributeKey<Color> fillColorKey, AttributeKey<Color> strokeColorKey, Image image, Shape fillShape, Shape strokeShape) {
        super(image);
        this.editor = editor;
        this.opacityKey = opacityKey;
        this.fillColorKey = fillColorKey;
        this.strokeColorKey = strokeColorKey;
        this.fillShape = fillShape;
        this.strokeShape = strokeShape;
    }

    @Override
    public void paintIcon(Component c, Graphics gr, int x, int y) {
        Graphics2D g = (Graphics2D)gr;
        super.paintIcon(c, g, x, y);
        Double opacity = 0.0;
        Color fillColor = null;
        Color strokeColor = null;
        if (this.editor != null) {
            DrawingView view = this.editor.getActiveView();
            if (view != null && view.getDrawing() != null) {
                opacity = this.opacityKey.get(view.getDrawing());
                fillColor = this.fillColorKey == null ? null : this.fillColorKey.get(view.getDrawing());
                strokeColor = this.strokeColorKey == null ? null : this.strokeColorKey.get(view.getDrawing());
            } else {
                opacity = this.opacityKey.get(this.editor.getDefaultAttributes());
                fillColor = this.fillColorKey == null ? null : this.fillColorKey.get(this.editor.getDefaultAttributes());
                Color color = strokeColor = this.strokeColorKey == null ? null : this.strokeColorKey.get(this.editor.getDefaultAttributes());
            }
        }
        if (this.fillColorKey != null && this.fillShape != null && opacity != null) {
            if (fillColor == null) {
                fillColor = Color.BLACK;
            }
            g.setColor(new Color((int)(opacity * 255.0) << 24 | fillColor.getRGB() & 0xFFFFFF, true));
            g.translate(x, y);
            g.fill(this.fillShape);
            g.translate(-x, -y);
        }
        if (this.strokeColorKey != null && this.strokeShape != null && opacity != null) {
            if (strokeColor == null) {
                strokeColor = Color.BLACK;
            }
            g.setColor(new Color((int)(opacity * 255.0) << 24 | strokeColor.getRGB() & 0xFFFFFF, true));
            g.translate(x, y);
            g.draw(this.strokeShape);
            g.translate(-x, -y);
        }
    }
}

