/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public final class BrowserSetupPanel
extends JPanel {
    String message = "NOTE: PLCash needs a Web browser to display reports and help pages. Although PLCash has an internal browser, it is not particularly good and has some important limitations.\nIt is desirable to locate any system browser that may exist and use it instead of the internal browser.\n\n* To skip the search and use the default browser, press \"Continue\".\n* To search for a Web browser on your system, check the default values below, make any changes you think appropriate, then press \"Go\" to begin the search.\n* If the search is successful, one or more browser names will appear in the \"Choose Browser\" list along with the internal browser. Select one and press \"Continue\".\n* If the search is not successful, change the names in the browser list, or change the search path, and try again.\n* If you include a browser name, make sure it is a complete executable name, e.g. \"mozilla.exe\", if this is appropriate on your system.\n* If you must include a drive letter in your search path, make sure the drive letter is entered in uppercase, like this: \"C:/Program Files\"\n* In the event of difficulty, be sure to read the help section on this topic, under \"Acquisition and Installation\".";
    PLCash parent;
    TreeMap browserMap = new TreeMap();
    public String browserLabel = "Browser Setup";
    boolean isWindows = false;
    boolean searching = false;
    int searchCounter = 0;
    int searchDivisor = 64;
    String savedDocPath = null;
    Process browserProcess = null;
    public static final String internalKey = "(internal browser)";
    public static final String internalTag = "*internal*";
    private JLabel jLabel4;
    private JLabel searchProgressLabel;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JButton continueButton;
    private JComboBox browserComboBox;
    private JLabel jLabel2;
    private JTextField browserNamesTextField;
    private JPanel jPanel2;
    private JButton goButton;
    private JTextArea messageTextArea;
    private JTextField browserPathTextField;
    private JButton helpButton;
    private JLabel jLabel5;

    public BrowserSetupPanel(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
        this.continueButton.setEnabled(false);
        this.setup();
    }

    public void launchBrowser(String string) {
        String string2 = this.getSelectedBrowserPath();
        if ((string2 = (String)this.browserMap.get(string2)) == null || !this.parent.programValues.db_BrowserSought) {
            this.savedDocPath = string;
            this.continueButton.setEnabled(this.savedDocPath.length() > 0);
            this.parent.setupBrowser();
            this.parent.programValues.db_BrowserSought = true;
            return;
        }
        if (this.savedDocPath != null) {
            if (this.savedDocPath.length() > 0) {
                string = this.savedDocPath;
            }
            this.continueButton.setEnabled(false);
            this.savedDocPath = null;
        }
        if (string != null && string.length() > 0) {
            this.launchBrowser2(string2, string);
        }
    }

    private void launchBrowser2(String string, String string2) {
        if (this.browserProcess != null) {
            this.browserProcess.destroy();
            this.browserProcess = null;
        }
        File file = new File(string2);
        String string3 = "file:" + string2;
        try {
            string3 = file.toURI().toURL().toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.equals(internalTag)) {
            this.parent.launchInternalBrowser(string3);
        } else {
            try {
                this.browserProcess = Runtime.getRuntime().exec(new String[]{string, string3});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String getSelectedBrowserPath() {
        String string = (String)this.browserComboBox.getSelectedItem();
        if (string == null || string.trim().length() == 0) {
            return internalKey;
        }
        return string;
    }

    private void setup() {
        this.messageTextArea.setText(this.message);
        File file = new File("/Program Files");
        this.isWindows = file.exists();
        if (this.parent.programValues.db_BrowserSearchPath.equals("")) {
            if (this.isWindows) {
                file = new File("/Program Files");
                this.parent.programValues.db_BrowserSearchPath = file.getPath();
            } else {
                file = new File("/usr/bin");
                this.parent.programValues.db_BrowserSearchPath = file.exists() ? "/usr/bin,/usr/local/bin" : "(please enter a search path here)";
            }
        }
        if (this.parent.programValues.db_BrowserSearchList.equals("")) {
            this.parent.programValues.db_BrowserSearchList = this.isWindows ? "IExplore,Netscape,Mozilla,Opera" : "Mozilla,Netscape,Galeon,Konqueror,Opera";
        }
        this.readValues();
    }

    private void readValues() {
        this.browserNamesTextField.setText(this.parent.programValues.db_BrowserSearchList);
        this.browserPathTextField.setText(this.parent.programValues.db_BrowserSearchPath);
        if (this.parent.programValues.db_LocatedBrowsers.length() > 0) {
            this.browserComboBox.setModel(new DefaultComboBoxModel<String>(this.decodeBrowserList(this.parent.programValues.db_LocatedBrowsers)));
        }
        if (this.parent.programValues.db_SelectedBrowser >= 0 && this.parent.programValues.db_SelectedBrowser < this.browserComboBox.getItemCount()) {
            this.browserComboBox.setSelectedIndex(this.parent.programValues.db_SelectedBrowser);
        } else if (this.browserComboBox.getItemCount() > 0) {
            this.browserComboBox.setSelectedIndex(0);
        }
        this.searchProgressLabel.setText("Found " + this.browserMap.keySet().size() + " browsers.");
    }

    private String[] decodeBrowserList(String string) {
        this.browserMap = new TreeMap();
        this.browserMap.put(internalKey, internalTag);
        String[] stringArray = this.parent.programValues.db_LocatedBrowsers.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("\\|");
            this.browserMap.put(stringArray2[0], stringArray2[1]);
        }
        String[] stringArray3 = this.browserMap.keySet().toArray(new String[0]);
        return stringArray3;
    }

    public void writeValues() {
        this.parent.programValues.db_BrowserSearchList = this.browserNamesTextField.getText();
        this.parent.programValues.db_BrowserSearchPath = this.browserPathTextField.getText();
        this.parent.programValues.db_LocatedBrowsers = this.encodeBrowserList(this.browserMap);
        this.parent.programValues.db_SelectedBrowser = this.browserComboBox.getSelectedIndex();
    }

    private String encodeBrowserList(TreeMap treeMap) {
        String string = "";
        String[] stringArray = treeMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i] + "|" + (String)this.browserMap.get(stringArray[i]);
            string = string + (i > 0 ? "," : "") + string2;
        }
        return string;
    }

    private void performSearch() {
        if (this.searching) {
            this.parent.beep();
            this.searching = false;
            return;
        }
        this.writeValues();
        this.setup();
        this.browserMap = new TreeMap();
        this.browserMap.put(internalKey, internalTag);
        String[] stringArray = this.parent.programValues.db_BrowserSearchPath.split(",|;");
        if (this.parent.programValues.db_BrowserSearchList.trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Please enter some browser names to search for.", "No browser names", 0);
            return;
        }
        this.performSearch2(stringArray, this.parent.programValues.db_BrowserSearchList);
    }

    private void performSearch2(final String[] stringArray, final String string) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                BrowserSetupPanel.this.performThreadSearch(stringArray, string);
            }
        };
        thread.start();
    }

    public void performThreadSearch(String[] stringArray, String string) {
        int n;
        this.searching = true;
        this.goButton.setText("Stop");
        this.searchCounter = 0;
        String[] stringArray2 = string.split(",");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray2[i].trim().toLowerCase();
            if (!this.isWindows || stringArray2[i].indexOf(".exe") != -1) continue;
            stringArray2[i] = stringArray2[i] + ".exe";
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray2));
        for (n = 0; n < stringArray.length; ++n) {
            File file = new File(stringArray[n]);
            this.recurseSearch(file, hashSet);
        }
        this.goButton.setText("Go");
        this.writeValues();
        this.readValues();
        n = this.browserMap.size();
        if (n > 0) {
            this.browserComboBox.setSelectedIndex(n - 1);
            this.parent.programValues.db_SelectedBrowser = n - 1;
        }
        if (n < 2) {
            JOptionPane.showMessageDialog(this, "Search failed.\nPlease be sure you have entered search data correctly:\n\n1. Make sure any entered browser names are complete\n   executable names, e.g. \"mozilla.exe\".\n2. Make sure the entered search paths actually exist.\n3. If you include a drive letter in your path,\n   make sure the drive letter is entered in uppercase:\n   \"C:/Program Files\".", "No Browsers found", 2);
        }
        this.searching = false;
    }

    private void recurseSearch(File file, HashSet hashSet) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length && this.searching; ++i) {
                File file2;
                ++this.searchCounter;
                if (this.searchCounter % this.searchDivisor == 0) {
                    this.updateSearchDisplay();
                }
                if ((file2 = fileArray[i]).isDirectory()) {
                    if (this.isSymLink(file2)) continue;
                    this.recurseSearch(file2, hashSet);
                    continue;
                }
                if (!hashSet.contains(file2.getName().toLowerCase())) continue;
                String string = file2.getName();
                if ((string = string.replaceFirst("\\.exe", "")).length() > 0) {
                    string = string.substring(0, 1).toUpperCase() + string.substring(1);
                }
                String string2 = string;
                int n = 1;
                while (this.browserMap.containsKey(string2)) {
                    string2 = string + ++n;
                }
                this.browserMap.put(string2, file2.getPath());
            }
        }
    }

    private void updateSearchDisplay() {
        String string = "..................................";
        int n = this.searchCounter / this.searchDivisor % string.length();
        String string2 = string.substring(0, n);
        this.searchProgressLabel.setText("Searching " + string2);
    }

    private boolean isSymLink(File file) {
        try {
            return !file.getCanonicalPath().equals(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void continueIfFinished() {
        String string = this.getSelectedBrowserPath();
        if (string == null) {
            this.performSearch();
        } else {
            this.launchBrowser(null);
        }
    }

    private void help_browser() {
        this.parent.launchHelp("AcquisitionInstallation.html#Preliminary_Configuration");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.browserPathTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.browserComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.goButton = new MyJButton();
        this.jLabel4 = new JLabel();
        this.browserNamesTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.continueButton = new MyJButton();
        this.searchProgressLabel = new JLabel();
        this.helpButton = new MyJButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Locate and set up external browser"));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setText("Help message");
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("2. Check/modify search path:");
        this.jLabel1.setToolTipText("Choose a ssearch path appropriate to your system");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.browserPathTextField.setText("jTextField1");
        this.browserPathTextField.setToolTipText("<html>Enter a search path appropriate to your system.<br>Any drive letters must be UPPERCASE.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.browserPathTextField, gridBagConstraints);
        this.jLabel2.setText("4. Choose browser:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.browserComboBox.setToolTipText("Select a browser for viewing reports and help");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.browserComboBox, gridBagConstraints);
        this.jLabel3.setText("3. Begin search:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.goButton.setText("Go");
        this.goButton.setToolTipText("Start searching");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSetupPanel.this.goButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.goButton, gridBagConstraints);
        this.jLabel4.setText("1. Check/modify browser names:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.browserNamesTextField.setText("jTextField2");
        this.browserNamesTextField.setToolTipText("<html>Add any browser executable names you wish, separated by commas.<br>Example: \"mozilla.exe\"</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.browserNamesTextField, gridBagConstraints);
        this.jLabel5.setText("5. Done:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.continueButton.setText("Continue");
        this.continueButton.setToolTipText("Close this window and resume");
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSetupPanel.this.continueButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.continueButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.searchProgressLabel, gridBagConstraints);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton.setText("Help");
        this.helpButton.setToolTipText("Provide context-sensitive help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserSetupPanel.this.helpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.help_browser();
    }

    private void continueButtonActionPerformed(ActionEvent actionEvent) {
        this.continueIfFinished();
    }

    private void goButtonActionPerformed(ActionEvent actionEvent) {
        this.performSearch();
    }
}

