/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class DisclaimerWindow
extends JDialog {
    PLCash parent;
    boolean valid = false;
    private JButton acceptButton;
    private JScrollPane jScrollPane1;
    private JTextArea dataTextArea;
    private JButton cancelButton;
    private JPanel jPanel1;

    public DisclaimerWindow(Frame frame, boolean bl) {
        super(frame, bl);
        this.parent = (PLCash)frame;
        this.initComponents();
        this.setTitle("PLCash" + " Disclaimer");
        this.dataTextArea.setFont(new Font("Monospaced", 0, 14));
        this.setSize(frame.getSize().width * 3 / 4, frame.getSize().height * 3 / 4);
        this.setLocationRelativeTo(frame);
        this.setup();
    }

    private void setup() {
        this.loadText(this.parent.programValues.db_documentationPath + "/Disclaimer.txt");
        this.parent.beep();
        this.setVisible(true);
        if (!this.valid) {
            this.parent.performExit();
        }
    }

    private void accept() {
        this.valid = true;
        this.setVisible(false);
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void loadText(String string) {
        String string2 = this.parent.commonCode.readFile(new File(string));
        this.dataTextArea.setText(string2);
        this.dataTextArea.setEditable(false);
        this.dataTextArea.setCaretPosition(0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.dataTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.acceptButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DisclaimerWindow.this.closeDialog(windowEvent);
            }
        });
        this.dataTextArea.setEditable(false);
        this.dataTextArea.setLineWrap(true);
        this.dataTextArea.setWrapStyleWord(true);
        this.dataTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane1.setViewportView(this.dataTextArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.acceptButton.setText("Accept");
        this.acceptButton.setToolTipText("I understand I'm on my own");
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisclaimerWindow.this.acceptButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.acceptButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("I don't accept these terms");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisclaimerWindow.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void acceptButtonActionPerformed(ActionEvent actionEvent) {
        this.accept();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new DisclaimerWindow((Frame)new JFrame(), true).setVisible(true);
    }
}

