/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public abstract class EditableList {
    TreeMap dataMap;
    Vector dataVector;
    boolean dataChanged = false;
    DataTableManager dataDisplay = null;
    PLCash parent;
    boolean unsorted = true;

    public EditableList(PLCash pLCash) {
        this.parent = pLCash;
        this.dataMap = new TreeMap();
        this.dataVector = new Vector();
    }

    public abstract boolean allowEditRecords(int var1);

    public abstract boolean allowCreateDeleteRecords();

    public abstract Object getDataObject(String var1);

    public abstract Object getDataObject(int var1);

    public void addItem(String string, Object object) {
        this.dataMap.put(string, object);
        this.dataChanged = true;
    }

    public String[] getDataKeys() {
        return this.dataMap.keySet().toArray(new String[0]);
    }

    public int getDataSize() {
        return this.dataMap.size();
    }

    public int getVectorSize() {
        return this.dataVector.size();
    }

    public HashSet getKeyHash() {
        return new HashSet<String>(Arrays.asList(this.getDataKeys()));
    }

    public boolean keyExists(String string) {
        return this.dataMap.containsKey(string);
    }

    public void deleteItem(String string) {
        this.dataMap.remove(string);
        this.dataChanged = true;
    }

    public void deleteItem(int n) {
        this.dataVector.remove(n);
    }

    public void deleteVectorObject(Object object) {
        this.dataVector.remove(object);
    }

    public void replaceItem(int n, Object object) {
        if (n < this.dataVector.size()) {
            this.dataVector.remove(n);
            this.dataVector.insertElementAt(object, n);
        } else {
            this.addItem(object);
        }
        this.dataChanged = true;
        this.unsorted = true;
    }

    public void addItem(Object object) {
        this.dataVector.add(object);
        this.dataChanged = true;
        this.unsorted = true;
    }

    public int rowForKey(String string) {
        ArrayList arrayList = new ArrayList(this.dataMap.keySet());
        int n = Collections.binarySearch(arrayList, string);
        return n;
    }

    public int rowForObject(Object object) {
        return this.dataVector.indexOf(object);
    }

    public void setupComboBox(JComboBox jComboBox, String string) {
        String[] stringArray = this.dataMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        if (string != null && string.length() > 0) {
            jComboBox.setSelectedItem(string);
        }
        jComboBox.setPreferredSize(new Dimension(32, 24));
        jComboBox.setMinimumSize(new Dimension(32, 24));
    }

    public void displayMap(String string, EditableList editableList, String string2) {
        if (this.dataDisplay == null) {
            this.dataDisplay = new DataTableManager(this.parent, editableList);
        }
        this.dataDisplay.setupTable(this.dataMap, string2);
        this.parent.displayHandler.addComp(string, this.dataDisplay);
    }

    public void sortVector() {
        if (this.dataVector.size() > 0 && this.unsorted) {
            Collections.sort(this.dataVector);
            this.unsorted = false;
        }
    }

    public void sortVector(boolean bl) {
        if (bl) {
            this.unsorted = bl;
        }
        this.sortVector();
    }

    public void displayVector(String string, EditableList editableList, String string2) {
        this.sortVector();
        if (this.dataDisplay == null) {
            this.dataDisplay = new DataTableManager(this.parent, editableList);
        }
        this.dataDisplay.setupTable(this.dataVector, string2);
        this.parent.displayHandler.addComp(string, this.dataDisplay);
    }

    public void writeTSV(String string, String string2, TreeMap treeMap, Object object, String string3) {
        if (this.dataChanged) {
            String string4 = string + "/" + string2;
            if (string4.indexOf(".tsv") == -1) {
                string4 = string4 + ".tsv";
            }
            this.parent.dataFileManager.writeDataTable(string4, treeMap, object, string3);
            this.dataChanged = false;
        }
    }

    public void writeTSV(String string, String string2, Vector vector, Object object, String string3) {
        if (this.dataChanged) {
            this.sortVector();
            String string4 = string + "/" + string2;
            if (string4.indexOf(".tsv") == -1) {
                string4 = string4 + ".tsv";
            }
            this.parent.dataFileManager.writeDataTable(string4, vector, object, string3);
            this.dataChanged = false;
        }
    }

    public void readTSV(String string, String string2, TreeMap treeMap, Object object, String string3) {
        this.readTSV(string, string2, treeMap, object, string3, true);
    }

    public void readTSV(String string, String string2, TreeMap treeMap, Object object, String string3, boolean bl) {
        String string4 = string + "/" + string2;
        if (string4.indexOf(".tsv") == -1) {
            string4 = string4 + ".tsv";
        }
        this.parent.dataFileManager.readDataTable(string4, treeMap, object, string3);
        if (treeMap.size() == 0 && bl) {
            try {
                treeMap.put("(new)", object.getClass().newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void readTSV(String string, String string2, Vector vector, Object object, String string3) {
        String string4 = string + "/" + string2;
        if (string4.indexOf(".tsv") == -1) {
            string4 = string4 + ".tsv";
        }
        this.parent.dataFileManager.readDataTable(string4, vector, object, string3);
        if (vector.size() == 0) {
            try {
                vector.add(object.getClass().newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean deleteRecords(int[] nArray) {
        if (this.dataVector.size() > 0) {
            return this.deleteVecRecords(nArray);
        }
        return this.deleteMapRecords(nArray);
    }

    public boolean deleteMapRecords(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray.length;
        boolean bl = this.confirmDeleteRecords(n);
        if (bl) {
            String[] stringArray = this.dataMap.keySet().toArray(new String[0]);
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.dataMap.remove(stringArray[nArray[i]]);
            }
            this.dataChanged = true;
        }
        return bl;
    }

    public boolean deleteVecRecords(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray.length;
        boolean bl = this.confirmDeleteRecords(n);
        if (bl) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.dataVector.remove(nArray[i]);
            }
            this.dataChanged = true;
        }
        return bl;
    }

    public boolean confirmDeleteRecords(int n) {
        int n2 = JOptionPane.showConfirmDialog(null, "Okay to delete " + n + " records(s)?", "Delete Records", 1);
        return n2 == 0;
    }
}

