/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class InvestmentAccountEditorPane
extends EditorPane {
    private JComboBox actionComboBox;
    private JTextField amountTextField;
    private JButton beginButton;
    private JButton cancelButton;
    private JComboBox categoryComboBox;
    private JCheckBox clearedCheckBox;
    private JButton closeButton;
    private JTextField commissionTextField;
    private JButton commitButton;
    private JTextField dateTextField;
    private JButton deleteButton;
    private JButton endButton;
    private JCheckBox enterModeCheckBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JTextField memoTextField;
    private JButton memorizeButton;
    private JButton newButton;
    private JButton nextButton;
    private JButton previousButton;
    private JTextField priceTextField;
    private JTextField recordNumTextField;
    private JComboBox securityComboBox;
    private JTextField sharesTextField;
    private JPanel splitsPanel;

    public InvestmentAccountEditorPane(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
        this.setupComboBoxes();
        this.getTextField(this.actionComboBox).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.setChanged(true);
                InvestmentAccountEditorPane.this.watchForLF(keyEvent);
            }
        });
    }

    private void setupComboBoxes() {
        this.actionComboBox.removeAllItems();
        this.actionComboBox.addItem("");
        for (int i = 0; i < this.parent.commonCode.actionLabels.length; ++i) {
            this.actionComboBox.addItem(this.parent.commonCode.actionLabels[i]);
        }
    }

    @Override
    public void loadForm(Account account, int n) {
        if (account != null) {
            this.handleEnterMode(false);
            this.account = account;
            this.index = n;
            this.categoryComboBox.removeAllItems();
            this.categoryComboBox.addItem("");
            this.parent.accountHandler.setupComboBox(this.categoryComboBox, "");
            this.securityComboBox.removeAllItems();
            this.parent.securityHandler.setupComboBox(this.securityComboBox, account.db_Security);
            this.orig_t = account.getTransaction(n);
            this.edit_t = new Transaction(this.parent, this.orig_t);
            if (this.edit_t != null) {
                this.loadForm(this.edit_t);
                this.account.accountDisplay.scrollToTransaction(n, true);
            }
        }
    }

    private void loadForm(Transaction transaction) {
        this.suppressChange = true;
        this.dateTextField.setText(transaction.displayDate);
        if (transaction.db_Number.equals("(new)")) {
            transaction.db_Number = "";
        }
        if (transaction.db_Number.length() > 0) {
            this.actionComboBox.setSelectedItem(transaction.db_Number);
        } else {
            this.actionComboBox.setSelectedIndex(this.account.db_DefaultAction);
        }
        this.securityComboBox.setSelectedItem(transaction.db_Security);
        this.amountTextField.setText(this.parent.commonCode.getAbsDollarCentString(transaction.db_Amount, false));
        this.sharesTextField.setText(String.valueOf(Math.abs(transaction.db_Shares)));
        this.priceTextField.setText(this.parent.commonCode.getAbsDollarCentString(transaction.db_Price, false));
        this.commissionTextField.setText(this.parent.commonCode.getDollarCentString(transaction.db_Commission, false));
        this.memoTextField.setText(transaction.db_Memo);
        this.categoryComboBox.setSelectedItem(transaction.db_Category);
        this.clearedCheckBox.setSelected(transaction.db_Cleared);
        this.dateTextField.requestFocus();
        this.hasSplits = this.getSplitsPanel().setupTable(this.account, this.orig_t, transaction.splits);
        this.showCount();
        this.dateTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InvestmentAccountEditorPane.this.setChanged(false);
            }
        });
        this.suppressChange = false;
    }

    private void showCount() {
        String string = "";
        string = this.index >= this.account.size() ? "New Transaction" : this.index + 1 + " of " + this.account.size() + " transactions";
        this.recordNumTextField.setText(string);
    }

    private SplitsHandler getSplitsPanel() {
        return (SplitsHandler)this.splitsPanel;
    }

    @Override
    protected void commit(int n) {
        if (this.account != null) {
            this.getSplitsPanel().stopEditing();
            boolean bl = this.buildTransaction(this.edit_t);
            if (bl) {
                this.account.deleteTransaction(this.orig_t, true, true);
                this.account.addTransaction(this.edit_t, true, true);
                this.loadForm(this.account, this.index + n);
                this.parent.playSound();
            }
        }
    }

    private boolean buildTransaction(Transaction transaction) {
        double d;
        int n = this.actionComboBox.getSelectedIndex() - 1;
        if (n >= this.parent.commonCode.saleForLabels.length || n < 0) {
            this.parent.beep();
            JOptionPane.showMessageDialog(null, "PLease choose an action for this transaction", "No action chosen", 0);
            return false;
        }
        boolean bl = this.parent.commonCode.saleForLabels[n];
        Object object = this.categoryComboBox.getSelectedItem();
        if (object != null) {
            transaction.db_Category = object.toString();
        }
        Vector vector = this.getSplitsPanel().createSplitsVector();
        double d2 = this.parent.commonCode.parseCurrencyDollarCentString(this.amountTextField.getText());
        double d3 = this.parent.commonCode.parseCurrencyDollarCentString(this.sharesTextField.getText());
        boolean bl2 = bl;
        if (vector != null) {
            transaction.db_Category = "";
            transaction.splits = vector;
            transaction.recomputeSplits();
            d2 = transaction.db_Amount;
            bl = d2 < 0.0;
        }
        double d4 = bl ? -1.0 : 1.0;
        d3 = Math.abs(d3) * d4;
        double d5 = d2 = Math.abs(d2) * d4;
        double d6 = this.parent.commonCode.parseCurrencyDollarCentString(this.priceTextField.getText());
        int n2 = this.validateBalance(d6, d3, d = this.parent.commonCode.parseCurrencyDollarCentString(this.commissionTextField.getText()), d2);
        if (n2 >= 0) {
            switch (n2) {
                case 0: {
                    if (d3 == 0.0) break;
                    d6 = (d2 - d) / d3;
                    break;
                }
                case 1: {
                    if (d6 == 0.0) break;
                    d3 = (d2 - d) / d6;
                    break;
                }
                case 2: {
                    d = d2 + d6 * d3;
                    break;
                }
                case 3: {
                    d2 = d + d6 * d3;
                }
            }
        }
        if (vector != null && this.parent.commonCode.nonZero(d5 - d2)) {
            this.parent.beep();
            JOptionPane.showMessageDialog(null, "The sum of the splits items (" + this.parent.commonCode.getCurrencyDollarCentString(d5, false) + ") must agree with\nthe computed amount for the transaction (" + this.parent.commonCode.getCurrencyDollarCentString(d2, false) + ").\nDifference: " + this.parent.commonCode.getCurrencyDollarCentString(d5 - d2, false) + "\n\nCommon remedies include:\n\n1. Adjusting one or more splits amounts,\n2. Setting the price or the shares value to zero\n   and allowing an automatic recomputation.", "Balance Error", 0);
            return false;
        }
        if (bl != d2 < 0.0 || bl != bl2) {
            bl = d2 < 0.0;
            this.actionComboBox.setSelectedItem(bl ? "SellX" : "BuyX");
            this.getTextField(this.actionComboBox).setText(bl ? "SellX" : "BuyX");
        }
        transaction.db_Amount = d2;
        transaction.db_Shares = d3;
        transaction.db_Price = d6;
        transaction.db_Commission = d;
        transaction.db_Memo = this.memoTextField.getText();
        Object object2 = this.actionComboBox.getSelectedItem();
        if (object2 != null) {
            transaction.db_Number = object2.toString();
        }
        transaction.db_Cleared = this.clearedCheckBox.isSelected();
        transaction.setTime(this.parent.commonCode.timeForDisplayDateLenient(this.dateTextField.getText()));
        this.loadForm(transaction);
        transaction.updateKey();
        this.account.db_DefaultAction = this.actionComboBox.getSelectedIndex();
        return true;
    }

    private int validateBalance(double d, double d2, double d3, double d4) {
        int n = -1;
        double d5 = d2 * d + d3 - d4;
        Object[] objectArray = new Object[]{"Price", "Shares", "Commission", "Amount"};
        if (Math.abs(d5) >= this.parent.commonCode.epsilon) {
            if (d4 != 0.0 && d2 != 0.0 && d == 0.0) {
                return 0;
            }
            if (d4 != 0.0 && d != 0.0 && d2 == 0.0) {
                return 1;
            }
            if (d2 != 0.0 && d != 0.0 && d4 == 0.0) {
                return 3;
            }
            this.parent.beep();
            Object object = JOptionPane.showInputDialog(null, "The entered values for price, shares and commission\ndo not produce the entered amount (a = (s*p)+c).\nIn this case, (s*p)+c-a = " + d5 + ".\nWhich value do you want to adjust\n(recommended: price)?", "Transaction Imbalance", 1, null, objectArray, objectArray[0]);
            if (object != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!object.equals(objectArray[i])) continue;
                    n = i;
                    break;
                }
            }
        }
        return n;
    }

    private void cancel() {
        this.parent.beep();
        int n = JOptionPane.showConfirmDialog(this.parent, "Discard Changes?", "Transaction Changed", 1);
        if (n == 0) {
            this.loadForm(this.account, this.index);
        }
    }

    @Override
    protected void setChanged(boolean bl) {
        if (!this.suppressChange) {
            this.dataChanged = bl;
            this.commitButton.setEnabled(bl);
            this.cancelButton.setEnabled(bl);
        }
    }

    private void memorizeTransaction() {
        String string = "I";
        Transaction transaction = new Transaction(this.parent);
        if (this.buildTransaction(transaction)) {
            this.parent.memHandler.memorizeTransaction(transaction.db_Payee, transaction, string);
        }
    }

    private void handleEnterMode(boolean bl) {
        if (bl) {
            this.parent.programValues.db_EnterMode = this.enterModeCheckBox.isSelected();
        } else {
            this.enterModeCheckBox.setSelected(this.parent.programValues.db_EnterMode);
        }
    }

    private void help_investmentAccount() {
        this.parent.launchHelp("AdvancedOperations.html#Creating_Investment_Transactions");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.memoTextField = new JTextField();
        this.splitsPanel = new SplitsHandler(this.parent, this, true);
        this.jPanel5 = new JPanel();
        this.jPanel3 = new JPanel();
        this.securityComboBox = new ActiveComboBox(this.parent, false);
        this.jLabel1 = new JLabel();
        this.sharesTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel3 = new JLabel();
        this.commissionTextField = new JTextField();
        this.dateTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.actionComboBox = new ActiveComboBox(this.parent, false);
        this.clearedCheckBox = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.priceTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.amountTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.categoryComboBox = new ActiveComboBox(this.parent, false);
        this.enterModeCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.deleteButton = new MyJButton();
        this.beginButton = new MyJButton();
        this.previousButton = new MyJButton();
        this.recordNumTextField = new JTextField();
        this.nextButton = new MyJButton();
        this.endButton = new MyJButton();
        this.newButton = new MyJButton();
        this.commitButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.memorizeButton = new MyJButton();
        this.jButton1 = new MyJButton();
        this.closeButton = new MyJButton();
        this.setBorder(BorderFactory.createTitledBorder("Investment Transaction Editor"));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel4.setText("Memo");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.memoTextField.setToolTipText("Additional notes");
        this.memoTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.memoTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.memoTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.splitsPanel, gridBagConstraints);
        this.jPanel5.setLayout(new GridLayout(1, 0));
        this.jPanel3.setLayout(new GridBagLayout());
        this.securityComboBox.setEditable(true);
        this.securityComboBox.setToolTipText("Security associated with this transaction");
        this.securityComboBox.setPreferredSize(new Dimension(4, 24));
        this.securityComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InvestmentAccountEditorPane.this.securityComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.securityComboBox, gridBagConstraints);
        this.jLabel1.setText("Shares");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.sharesTextField.setToolTipText("Number of shares");
        this.sharesTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.sharesTextFieldActionPerformed(actionEvent);
            }
        });
        this.sharesTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.sharesTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.sharesTextField, gridBagConstraints);
        this.jLabel9.setText("Comm/Fee");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel3.setText("Security");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.commissionTextField.setToolTipText("Commissions or fees");
        this.commissionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.commissionTextFieldActionPerformed(actionEvent);
            }
        });
        this.commissionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.commissionTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.commissionTextField, gridBagConstraints);
        this.dateTextField.setText("3/20/2003");
        this.dateTextField.setToolTipText("<html>You may use '+' and '-' keys,<br/>or your mouse wheel,<br/>to change this value");
        this.dateTextField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                InvestmentAccountEditorPane.this.dateTextFieldMouseWheelMoved(mouseWheelEvent);
            }
        });
        this.dateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.dateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.dateTextField, gridBagConstraints);
        this.jLabel2.setText("Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel5.add(this.jPanel3);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel6.setText("Action");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints);
        this.actionComboBox.setEditable(true);
        this.actionComboBox.setToolTipText("Type of transaction");
        this.actionComboBox.setPreferredSize(new Dimension(72, 24));
        this.actionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InvestmentAccountEditorPane.this.actionComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.actionComboBox, gridBagConstraints);
        this.clearedCheckBox.setText("Cleared");
        this.clearedCheckBox.setToolTipText("Normally controlled by \"Reconcile\"");
        this.clearedCheckBox.setFocusable(false);
        this.clearedCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InvestmentAccountEditorPane.this.clearedCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.clearedCheckBox, gridBagConstraints);
        this.jLabel7.setText("Price");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this.priceTextField.setToolTipText("Share price");
        this.priceTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.priceTextFieldActionPerformed(actionEvent);
            }
        });
        this.priceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.priceTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.priceTextField, gridBagConstraints);
        this.jLabel8.setText("Amount");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.amountTextField.setToolTipText("Amount of transaction");
        this.amountTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.amountTextFieldActionPerformed(actionEvent);
            }
        });
        this.amountTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                InvestmentAccountEditorPane.this.amountTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.amountTextField, gridBagConstraints);
        this.jLabel5.setText("Transfer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel5, gridBagConstraints);
        this.categoryComboBox.setEditable(true);
        this.categoryComboBox.setToolTipText("Transfer account");
        this.categoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InvestmentAccountEditorPane.this.categoryComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.categoryComboBox, gridBagConstraints);
        this.enterModeCheckBox.setText("Enter mode");
        this.enterModeCheckBox.setToolTipText("Pressing \"Enter\" completes transaction");
        this.enterModeCheckBox.setFocusable(false);
        this.enterModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.enterModeCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.enterModeCheckBox, gridBagConstraints);
        this.jPanel5.add(this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        this.deleteButton.setToolTipText("Delete this transaction");
        this.deleteButton.setMinimumSize(new Dimension(34, 30));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        this.beginButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBegin.png")));
        this.beginButton.setToolTipText("First transaction");
        this.beginButton.setMinimumSize(new Dimension(34, 30));
        this.beginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.beginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.beginButton, gridBagConstraints);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBack.png")));
        this.previousButton.setToolTipText("Previous transaction");
        this.previousButton.setMinimumSize(new Dimension(34, 30));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.previousButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.previousButton, gridBagConstraints);
        this.recordNumTextField.setEditable(false);
        this.recordNumTextField.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.recordNumTextField, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRForward.png")));
        this.nextButton.setToolTipText("Next transaction");
        this.nextButton.setMinimumSize(new Dimension(34, 30));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.nextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.nextButton, gridBagConstraints);
        this.endButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCREnd.png")));
        this.endButton.setToolTipText("Last transaction");
        this.endButton.setMinimumSize(new Dimension(34, 30));
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.endButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.endButton, gridBagConstraints);
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/New.png")));
        this.newButton.setToolTipText("New transaction");
        this.newButton.setMinimumSize(new Dimension(34, 30));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.newButton, gridBagConstraints);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentIn.png")));
        this.commitButton.setToolTipText("Commit changes to account");
        this.commitButton.setFocusable(false);
        this.commitButton.setMargin(new Insets(2, 4, 2, 4));
        this.commitButton.setMaximumSize(new Dimension(54, 30));
        this.commitButton.setPreferredSize(new Dimension(54, 30));
        this.commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.commitButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.commitButton, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Undo.png")));
        this.cancelButton.setToolTipText("Revert to original values");
        this.cancelButton.setFocusable(false);
        this.cancelButton.setMargin(new Insets(2, 4, 2, 4));
        this.cancelButton.setMaximumSize(new Dimension(54, 30));
        this.cancelButton.setPreferredSize(new Dimension(54, 30));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        this.memorizeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/LaptopIn.png")));
        this.memorizeButton.setToolTipText("Memorize this transaction");
        this.memorizeButton.setFocusable(false);
        this.memorizeButton.setMinimumSize(new Dimension(34, 30));
        this.memorizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.memorizeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.memorizeButton, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.jButton1.setToolTipText("Provide context-sensitive help");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/FolderOut.png")));
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.setFocusable(false);
        this.closeButton.setMaximumSize(new Dimension(54, 25));
        this.closeButton.setMinimumSize(new Dimension(34, 25));
        this.closeButton.setPreferredSize(new Dimension(54, 25));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestmentAccountEditorPane.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.closeButton, gridBagConstraints);
        this.add((Component)this.jPanel2, "South");
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.help_investmentAccount();
    }

    private void enterModeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.handleEnterMode(true);
    }

    private void memorizeButtonActionPerformed(ActionEvent actionEvent) {
        this.memorizeTransaction();
    }

    private void clearedCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void categoryComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void amountTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void priceTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void actionComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void memoTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void commissionTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void sharesTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
    }

    private void securityComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.newTransaction();
    }

    private void endButtonActionPerformed(ActionEvent actionEvent) {
        this.toEnd();
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        this.changeTransaction(1, false);
    }

    private void previousButtonActionPerformed(ActionEvent actionEvent) {
        this.changeTransaction(-1, false);
    }

    private void beginButtonActionPerformed(ActionEvent actionEvent) {
        this.toBegin();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteTransaction();
    }

    private void commitButtonActionPerformed(ActionEvent actionEvent) {
        this.commit(1);
    }

    private void commissionTextFieldActionPerformed(ActionEvent actionEvent) {
        this.setChanged(true);
        this.handleNumberEntry(actionEvent, false);
    }

    private void amountTextFieldActionPerformed(ActionEvent actionEvent) {
        this.setChanged(true);
        this.handleNumberEntry(actionEvent, false);
    }

    private void sharesTextFieldActionPerformed(ActionEvent actionEvent) {
        this.setChanged(true);
        this.handleNumberEntry(actionEvent, true);
    }

    private void priceTextFieldActionPerformed(ActionEvent actionEvent) {
        this.setChanged(true);
        this.handleNumberEntry(actionEvent, false);
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeEditingWindow(this.account);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void dateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.watchForLF(keyEvent);
        this.setChanged(true);
        this.parent.commonCode.handleDateFieldKey(keyEvent, true);
    }

    private void dateTextFieldMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.setChanged(true);
        this.parent.commonCode.handleDateFieldMouseWheel(mouseWheelEvent, true);
    }
}

