/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget.date;

import com.fathzer.soft.ajlib.swing.widget.date.MonthWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CalendarWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String DATE_PROPERTY = "DATE_PROPERTY";
    private Calendar chosenDate;
    private Color chosenDateButtonColor;
    private Color chosenMonthButtonColor;
    private Color chosenOtherButtonColor;
    private int firstDayOfWeek;
    private Float fontRatio = Float.valueOf(0.85f);
    private JButton[] buttons;
    private JLabel[] days;
    private MonthWidget monthSelector;
    private int[] weekDays;

    public CalendarWidget() {
        super(new BorderLayout());
        this.chosenDateButtonColor = Color.red;
        this.chosenMonthButtonColor = Color.white;
        this.chosenOtherButtonColor = Color.gray;
        this.chosenDate = Calendar.getInstance(this.getLocale());
        this.initializeDays();
        this.monthSelector = new MonthWidget();
        this.add((Component)this.monthSelector, "North");
        this.add((Component)this.getCalendarPanel(), "Center");
        this.monthSelector.addPropertyChangeListener("MONTH", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CalendarWidget.this.refreshButtons();
            }
        });
        this.monthSelector.getNow().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarWidget.this.setDate(new Date());
            }
        });
        this.refreshButtons();
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.monthSelector.setLocale(l);
        this.initializeDays();
        this.updateDays();
        this.refreshButtons();
    }

    private void initializeDays() {
        this.firstDayOfWeek = Calendar.getInstance(this.getLocale()).getFirstDayOfWeek();
        this.weekDays = new int[7];
        for (int i = 0; i < 7; ++i) {
            this.weekDays[i] = (this.firstDayOfWeek + i - 1) % 7 + 1;
        }
    }

    public void setDate(Date theDate) {
        Date old = this.getDate();
        if (!NullUtils.areEquals(theDate, old)) {
            if (theDate == null) {
                this.chosenDate = null;
            } else {
                if (this.chosenDate == null) {
                    this.chosenDate = Calendar.getInstance(this.getLocale());
                }
                this.chosenDate.setTime(theDate);
                this.monthSelector.setMonth(theDate);
            }
            this.refreshButtons();
            this.firePropertyChange(DATE_PROPERTY, old, theDate);
        }
    }

    public Date getDate() {
        return this.chosenDate == null ? null : this.chosenDate.getTime();
    }

    private JPanel getCalendarPanel() {
        JPanel p = new JPanel(new GridLayout(7, 7));
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.getLocale());
        String[] weekDays = dateFormatSymbols.getShortWeekdays();
        this.days = new JLabel[this.weekDays.length];
        for (int i = 0; i < this.weekDays.length; ++i) {
            this.days[i] = new JLabel(weekDays[this.weekDays[i]], 0);
            p.add(this.days[i]);
        }
        this.buttons = new JButton[42];
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                int i = Integer.parseInt(b.getName());
                Calendar cal = CalendarWidget.this.getFirstVisibleDate();
                cal.add(5, i);
                CalendarWidget.this.setDate(cal.getTime());
            }
        };
        Font bFont = null;
        for (int i = 0; i < 42; ++i) {
            JButton b = new JButton("");
            if (bFont == null) {
                bFont = b.getFont().deriveFont(this.fontRatio.floatValue() * (float)b.getFont().getSize());
            }
            b.setMargin(new Insets(1, 1, 1, 1));
            b.setName(Integer.toString(i));
            b.setFont(bFont);
            b.setFocusPainted(false);
            b.setActionCommand("dateButtonClicked");
            b.addActionListener(listener);
            this.buttons[i] = b;
            p.add(b);
        }
        return p;
    }

    private void updateDays() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.getLocale());
        String[] weekDaysWordings = dateFormatSymbols.getShortWeekdays();
        for (int i = 0; i < this.days.length; ++i) {
            this.days[i].setText(weekDaysWordings[this.weekDays[i]]);
        }
    }

    private boolean equalDates(Calendar c1, Calendar c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    private Calendar getFirstVisibleDate() {
        Calendar c = Calendar.getInstance(this.getLocale());
        c.setTime(this.monthSelector.getMonth());
        c.add(5, -1);
        while (c.get(7) != this.getFirstDayOfWeek()) {
            c.add(5, -1);
        }
        return c;
    }

    private int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private void refreshButtons() {
        Calendar c = this.getFirstVisibleDate();
        Calendar current = Calendar.getInstance(this.getLocale());
        current.setTime(this.monthSelector.getMonth());
        for (int i = 0; i < 42; ++i) {
            JButton b = this.buttons[i];
            this.setButtonAppearance(b, c, current);
            c.add(5, 1);
        }
    }

    private void setButtonAppearance(JButton button, Calendar date, Calendar currentMonth) {
        String day = Integer.toString(date.get(5));
        Color color = this.equalDates(date, this.chosenDate) ? this.chosenDateButtonColor : (date.get(2) == currentMonth.get(2) && date.get(1) == currentMonth.get(1) ? this.chosenMonthButtonColor : this.chosenOtherButtonColor);
        button.setBackground(color);
        if (this.equalDates(date, Calendar.getInstance())) {
            day = "<html><u><b>" + day + "</b></u></html>";
        }
        button.setText(day);
    }

    public Color getChosenDateButtonColor() {
        return this.chosenDateButtonColor;
    }

    public void setChosenDateButtonColor(Color chosenDateButtonColor) {
        if (chosenDateButtonColor == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color oldValue = this.chosenDateButtonColor;
        this.chosenDateButtonColor = chosenDateButtonColor;
        this.refreshButtons();
        this.firePropertyChange("chosenDateButtonColor", oldValue, chosenDateButtonColor);
    }

    public Color getChosenMonthButtonColor() {
        return this.chosenMonthButtonColor;
    }

    public void setChosenMonthButtonColor(Color chosenMonthButtonColor) {
        if (chosenMonthButtonColor == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color oldValue = this.chosenMonthButtonColor;
        this.chosenMonthButtonColor = chosenMonthButtonColor;
        this.refreshButtons();
        this.firePropertyChange("chosenMonthButtonColor", oldValue, chosenMonthButtonColor);
    }

    public Color getChosenOtherButtonColor() {
        return this.chosenOtherButtonColor;
    }

    public void setChosenOtherButtonColor(Color chosenOtherButtonColor) {
        if (chosenOtherButtonColor == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color oldValue = this.chosenOtherButtonColor;
        this.chosenOtherButtonColor = chosenOtherButtonColor;
        this.refreshButtons();
        this.firePropertyChange("chosenOtherButtonColor", oldValue, chosenOtherButtonColor);
    }
}

