/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.utilities;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class CSVWriter {
    private static final String BLANK = " ";
    private boolean lineIsEmpty;
    private BufferedWriter writer;
    private char separator;
    private char quote;
    private boolean alwaysQuoteCells;
    private String quoteSeq;
    private String doubleQuoteSeq;

    public CSVWriter(Writer writer) {
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.lineIsEmpty = true;
        this.separator = (char)59;
        this.alwaysQuoteCells = false;
        this.setQuote('\"');
    }

    public void writeCell(String cell) throws IOException {
        if (!this.lineIsEmpty) {
            this.writer.append(this.separator);
        }
        this.lineIsEmpty = false;
        if (cell == null) {
            cell = "";
        }
        boolean quoteCells = this.alwaysQuoteCells || cell.indexOf(this.separator) >= 0 || cell.indexOf(this.quote) >= 0 || cell.startsWith(BLANK) || cell.endsWith(BLANK);
        cell = cell.replace(this.quoteSeq, this.doubleQuoteSeq);
        if (quoteCells) {
            this.writer.append(this.quote);
        }
        this.writer.append(cell);
        if (quoteCells) {
            this.writer.append(this.quote);
        }
    }

    public void newLine() throws IOException {
        this.writer.newLine();
        this.lineIsEmpty = true;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setQuote(char quote) {
        this.quote = quote;
        this.quoteSeq = new String(new char[]{quote});
        this.doubleQuoteSeq = this.quoteSeq + this.quoteSeq;
    }

    public boolean isAlwaysQuoteCells() {
        return this.alwaysQuoteCells;
    }

    public void setAlwaysQuoteCells(boolean alwaysQuoteCells) {
        this.alwaysQuoteCells = alwaysQuoteCells;
    }

    public static NumberFormat getDecimalFormater(Locale locale) {
        NumberFormat result = NumberFormat.getInstance(locale);
        if (result instanceof DecimalFormat) {
            NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(locale);
            result.setMinimumFractionDigits(currencyFormat.getMinimumFractionDigits());
            result.setMaximumFractionDigits(currencyFormat.getMaximumFractionDigits());
        }
        result.setGroupingUsed(false);
        return result;
    }
}

