/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop;

import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.jclop.Account;
import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Entry;
import com.fathzer.soft.jclop.JClopException;
import com.fathzer.soft.jclop.SynchronizationState;
import com.fathzer.soft.jclop.swing.MessagePack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    public static final String UTF_8 = "UTF-8";
    static final String ZIP_SUFFIX = ".zip";
    static final String FILE_PREFIX = "f_";
    private static final String CACHE_PREFIX = "cache";
    private static final String SYNCHRONIZED_CACHE_PREFIX = "sync";
    public static final String URI_DOMAIN = "cloud.jclop.fathzer.com";
    private File root;
    private boolean local;
    private Collection<Account> accounts;

    protected Service(File root, boolean local) throws IOException {
        this.local = local;
        if (!local) {
            if (!(root = new File(root, this.getScheme())).exists() && !root.mkdirs()) {
                throw new IOException("Unable to create cache directory");
            }
            if (!root.isDirectory()) {
                throw new IllegalArgumentException();
            }
            this.root = root;
            File[] files = root.listFiles();
            this.accounts = new ArrayList<Account>();
            for (File file : files) {
                if (!file.isDirectory()) continue;
                try {
                    this.accounts.add(new Account(this, file));
                }
                catch (Exception e) {
                    LOGGER.warn(file + " is ignored", e);
                }
            }
        }
    }

    public final boolean isLocal() {
        return this.local;
    }

    public synchronized Account newAccount(String id, String displayName, Serializable connectionData) {
        if (id == null) {
            throw new NullPointerException();
        }
        for (Account acc : this.accounts) {
            if (!acc.getId().equals(id)) continue;
            throw new IllegalArgumentException();
        }
        Account account = new Account(this, id, displayName, connectionData);
        account.serialize();
        this.accounts.add(account);
        return account;
    }

    public synchronized void delete(Account account) {
        for (Account acc : this.accounts) {
            if (!acc.getId().equals(account.getId())) continue;
            FileUtils.deleteDirectory(account.getRoot());
            this.accounts.remove(account);
            break;
        }
    }

    public final synchronized Collection<Account> getAccounts() {
        return this.accounts;
    }

    File getCacheRoot() {
        return this.root;
    }

    final Entry getLocalEntry(Account account, File file) {
        try {
            if (!file.getName().startsWith(FILE_PREFIX)) {
                return null;
            }
            String[] files = file.list();
            boolean ok = false;
            if (files != null) {
                for (String fileName : files) {
                    if (!this.isValidFile(fileName)) continue;
                    ok = true;
                    break;
                }
            }
            return ok ? new Entry(account, URLDecoder.decode(file.getName().substring(FILE_PREFIX.length()), UTF_8)) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public File getLocalFile(URI uri) {
        String[] files;
        String fileName;
        try {
            Entry entry = this.getEntry(uri);
            fileName = entry.getAccount().getRoot().getName() + "/" + FILE_PREFIX + URLEncoder.encode(entry.getDisplayName(), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        File cacheDirectory = new File(this.root, fileName);
        if (cacheDirectory.isFile()) {
            cacheDirectory.delete();
        }
        if (!cacheDirectory.exists()) {
            cacheDirectory.mkdirs();
        }
        if ((files = cacheDirectory.list()) == null || files.length == 0) {
            return new File(cacheDirectory, "cache.zip");
        }
        File result = null;
        for (String f : files) {
            File candidate = new File(cacheDirectory, f);
            if (this.isValidFile(f) && (result == null || candidate.lastModified() > result.lastModified())) {
                if (result != null) {
                    result.delete();
                }
                result = candidate;
                continue;
            }
            candidate.delete();
        }
        return result != null ? result : new File(cacheDirectory, "cache.zip");
    }

    private boolean isValidFile(String fileName) {
        return (fileName.startsWith(SYNCHRONIZED_CACHE_PREFIX) || fileName.startsWith(CACHE_PREFIX)) && fileName.endsWith(ZIP_SUFFIX);
    }

    public final File getLocalFileForWriting(URI uri) {
        File file = this.getLocalFile(uri);
        File parentFile = file.getParentFile();
        if (file.getName().startsWith(SYNCHRONIZED_CACHE_PREFIX)) {
            String name = file.getName().substring(SYNCHRONIZED_CACHE_PREFIX.length());
            file = new File(parentFile, CACHE_PREFIX + name);
        }
        if (parentFile.isFile()) {
            parentFile.delete();
        }
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return file;
    }

    public final String getLocalRevision(URI uri) {
        String name;
        if (this.local) {
            return this.getLocalFile(uri).exists() ? "1" : null;
        }
        File file = this.getLocalFile(uri);
        if (!file.exists()) {
            return null;
        }
        String revision = name.substring((name = file.getName()).startsWith(CACHE_PREFIX) ? CACHE_PREFIX.length() : SYNCHRONIZED_CACHE_PREFIX.length());
        revision = revision.substring(0, revision.length() - ZIP_SUFFIX.length());
        return revision.length() == 0 ? null : revision;
    }

    public final void setLocalRevision(URI uri, String revision) {
        File file = this.getLocalFile(uri);
        file.renameTo(new File(file.getParent(), SYNCHRONIZED_CACHE_PREFIX + revision + ZIP_SUFFIX));
    }

    public final boolean isSynchronized(URI uri) {
        return this.local || this.getLocalFile(uri).getName().startsWith(SYNCHRONIZED_CACHE_PREFIX);
    }

    public String getRemotePath(Entry entry) {
        return '/' + entry.getDisplayName() + ZIP_SUFFIX;
    }

    protected Entry getRemoteEntry(Account account, String remotePath) {
        if (!remotePath.endsWith(ZIP_SUFFIX)) {
            return null;
        }
        return new Entry(account, (remotePath = remotePath.substring(0, remotePath.length() - ZIP_SUFFIX.length())).charAt(0) == '/' ? remotePath.substring(1) : remotePath);
    }

    public final URI getURI(Entry entry) {
        try {
            return new URI(this.toString(entry, false));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDisplayable(URI uri) {
        return this.toString(this.getEntry(uri), true);
    }

    private String toString(Entry entry, boolean secret) {
        try {
            Account account = entry.getAccount();
            String path = entry.getDisplayName();
            StringBuilder builder = new StringBuilder();
            builder.append(this.getScheme());
            builder.append("://");
            if (!secret) {
                builder.append(URLEncoder.encode(account.getId(), UTF_8));
                builder.append(":");
                builder.append(this.getConnectionDataURIFragment(account.getConnectionData()));
                builder.append('@');
                builder.append(URI_DOMAIN);
                builder.append('/');
            }
            builder.append(URLEncoder.encode(account.getDisplayName(), UTF_8));
            builder.append('/');
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            builder.append(URLEncoder.encode(path, UTF_8));
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String getScheme();

    public abstract Entry getEntry(URI var1);

    public abstract Collection<Entry> getRemoteEntries(Account var1, Cancellable var2) throws JClopException;

    public abstract String getConnectionDataURIFragment(Serializable var1);

    public abstract Serializable getConnectionData(String var1);

    public abstract String getRemoteRevision(URI var1) throws JClopException;

    public abstract boolean download(URI var1, OutputStream var2, Cancellable var3, Locale var4) throws JClopException, IOException;

    public abstract boolean upload(InputStream var1, long var2, URI var4, Cancellable var5, Locale var6) throws JClopException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean download(URI uri, Cancellable task, Locale locale) throws JClopException, IOException {
        if (this.local) {
            return true;
        }
        File file = this.getLocalFile(uri);
        file.getParentFile().mkdirs();
        String revision = null;
        String downloadedRevision = "";
        File tmpFile = new File(file.getParent(), file.getName() + ".tmp");
        boolean done = true;
        while (done && !NullUtils.areEquals(revision, downloadedRevision)) {
            downloadedRevision = this.getRemoteRevision(uri);
            FileOutputStream out = new FileOutputStream(tmpFile);
            try {
                done = this.download(uri, out, task, locale);
            }
            finally {
                ((OutputStream)out).close();
            }
            revision = this.getRemoteRevision(uri);
        }
        if (done) {
            file.delete();
            tmpFile.renameTo(file);
            this.setLocalRevision(uri, revision);
        } else {
            tmpFile.delete();
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean upload(URI uri, Cancellable task, Locale locale) throws JClopException, IOException {
        if (this.local) {
            return true;
        }
        File file = this.getLocalFile(uri);
        long length = file.length();
        boolean done = false;
        FileInputStream stream = new FileInputStream(file);
        try {
            done = this.upload(stream, length, uri, task, locale);
        }
        finally {
            stream.close();
        }
        if (done) {
            this.setLocalRevision(uri, this.getRemoteRevision(uri));
        }
        return done;
    }

    public SynchronizationState synchronize(URI uri, Cancellable task, Locale locale) throws JClopException, IOException {
        String remoteRevision = this.getRemoteRevision(uri);
        String localRevision = this.getLocalRevision(uri);
        File file = this.getLocalFile(uri);
        if (remoteRevision == null) {
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            if (localRevision == null) {
                this.upload(uri, task, locale);
                return SynchronizationState.SYNCHRONIZED;
            }
            return SynchronizationState.REMOTE_DELETED;
        }
        if (remoteRevision.equals(localRevision)) {
            if (this.isSynchronized(uri)) {
                return SynchronizationState.SYNCHRONIZED;
            }
            this.upload(uri, task, locale);
            return SynchronizationState.SYNCHRONIZED;
        }
        if (!file.exists()) {
            this.download(uri, task, locale);
            return SynchronizationState.SYNCHRONIZED;
        }
        if (this.isSynchronized(uri)) {
            this.download(uri, task, locale);
            return SynchronizationState.SYNCHRONIZED;
        }
        return SynchronizationState.CONFLICT;
    }

    public String getMessage(String key, Locale locale) {
        return MessagePack.DEFAULT.getString(key, locale);
    }

    public void deleteLocal(URI uri) {
        FileUtils.deleteDirectory(this.getLocalFile(uri).getParentFile());
    }

    public synchronized Account getAccount(String id) {
        for (Account account : this.accounts) {
            if (!account.getId().equals(id)) continue;
            return account;
        }
        return null;
    }
}

