/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.swing;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.framework.Application;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.JTableListener;
import com.fathzer.soft.ajlib.swing.widget.ComboBox;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressFrame;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.jclop.Account;
import com.fathzer.soft.jclop.Entry;
import com.fathzer.soft.jclop.InvalidConnectionDataException;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.UnreachableHostException;
import com.fathzer.soft.jclop.swing.FilesTableModel;
import com.fathzer.soft.jclop.swing.IconPack;
import com.fathzer.soft.jclop.swing.MessagePack;
import com.fathzer.soft.jclop.swing.RemoteFileListWorker;
import com.fathzer.soft.jclop.swing.URIChooser;
import com.fathzer.soft.jclop.swing.URIChooserDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractURIChooserPanel
extends JPanel
implements URIChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractURIChooserPanel.class);
    private JPanel centerPanel;
    private javax.swing.JTable fileList;
    private JPanel filePanel;
    private JLabel lblFileName;
    private TextWidget fileNameField;
    private JLabel lblAccount;
    private JPanel northPanel;
    private JButton refreshButton;
    private JProgressBar progressBar;
    private FilesTableModel filesModel;
    private JScrollPane scrollPane;
    private JPanel panel;
    private ComboBox accountsCombo;
    private JButton newButton;
    private JButton deleteButton;
    private Service service;
    private String initedAccountId;
    private boolean linked;
    private IconPack icons;
    private URI selectedURI;
    private Entry pendingSelectedEntry;
    private boolean hasPendingSelected;
    private JLabel statusIcon;
    private JPanel panel1;

    public AbstractURIChooserPanel(Service service) {
        this.service = service;
        this.initedAccountId = null;
        this.linked = false;
        this.setIconPack(IconPack.DEFAULT);
        this.filesModel = new FilesTableModel();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    @Override
    public void setSaveType(boolean save) {
        this.getFilePanel().setVisible(save);
    }

    private boolean isSaveType() {
        return this.getFilePanel().isVisible();
    }

    public URI showOpenDialog(Component parent, String title) {
        this.setSaveType(false);
        return this.showDialog(parent, title);
    }

    public URI showSaveDialog(Component parent, String title) {
        this.setSaveType(true);
        return this.showDialog(parent, title);
    }

    public URI showDialog(Component parent, String title) {
        Window owner = Utils.getOwnerWindow(parent);
        URIChooserDialog dialog = new URIChooserDialog(owner, title, new URIChooser[]{this});
        dialog.setSaveDialog(this.getFilePanel().isVisible());
        return dialog.showDialog();
    }

    public void setIconPack(IconPack pack) {
        this.icons = pack;
        this.getNewButton().setIcon(this.getSizedIcon(this.icons.getNewAccount()));
        this.getDeleteButton().setIcon(this.getSizedIcon(this.icons.getDeleteAccount()));
        this.getRefreshButton().setIcon(this.getSizedIcon(this.icons.getSynchronize()));
        this.setStatusIcon();
    }

    private Icon getSizedIcon(Icon icon) {
        int DEFAULT_FONT_SIZE;
        Image img = ((ImageIcon)icon).getImage();
        int fontSize = this.getFont().getSize();
        if (fontSize != (DEFAULT_FONT_SIZE = 12)) {
            Image newimg = img.getScaledInstance(img.getWidth(this) * fontSize / DEFAULT_FONT_SIZE, img.getHeight(this) * fontSize / DEFAULT_FONT_SIZE, 4);
            icon = new ImageIcon(newimg);
        }
        return icon;
    }

    private void setStatusIcon() {
        this.getStatusIcon().setIcon(this.getSizedIcon(this.linked ? this.icons.getLinked() : this.icons.getNotLinked()));
    }

    public void refresh(boolean force) {
        String accountId;
        if (this.hasPendingSelected) {
            if (this.pendingSelectedEntry == null) {
                this.getFileNameField().setText("");
            } else {
                Entry entry = this.pendingSelectedEntry;
                Account account = this.getService().getAccount(entry.getAccount().getId());
                if (account == null || !account.equals(this.getAccountsCombo().getSelectedItem())) {
                    if (account == null) {
                        account = this.getService().newAccount(entry.getAccount().getId(), entry.getAccount().getDisplayName(), entry.getAccount().getConnectionData());
                        boolean old = this.getAccountsCombo().isActionEnabled();
                        this.getAccountsCombo().setActionEnabled(false);
                        this.getAccountsCombo().addItem(account);
                        this.getAccountsCombo().setActionEnabled(old);
                    }
                    this.getAccountsCombo().setSelectedItem(account);
                }
            }
        } else if (this.getService().getAccounts().isEmpty()) {
            this.doNewAccount();
            return;
        }
        Account account = (Account)this.getAccountsCombo().getSelectedItem();
        String string = accountId = account == null ? null : account.getId();
        if (force || this.hasPendingSelected || !NullUtils.areEquals(this.initedAccountId, accountId)) {
            this.initedAccountId = accountId;
            this.linked = false;
            TreeSet<Entry> entries = new TreeSet<Entry>();
            if (account != null) {
                entries.addAll(account.getLocalEntries());
                Window owner = Utils.getOwnerWindow(this);
                boolean eraseQuota = true;
                try {
                    RemoteFileListWorker worker = new RemoteFileListWorker(account);
                    worker.setPhase(this.service.getMessage("com.fathzer.soft.jclop.connecting", this.getLocale()), -1);
                    WorkInProgressFrame frame = new WorkInProgressFrame(owner, MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.GenericWait.title", this.getLocale()), Dialog.ModalityType.APPLICATION_MODAL, worker);
                    frame.setSize(300, frame.getSize().height);
                    frame.setLocationRelativeTo(owner);
                    frame.setVisible(true);
                    entries.addAll((Collection)worker.get());
                    this.linked = true;
                    this.setQuota(account);
                    eraseQuota = false;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof UnreachableHostException) {
                        this.getProgressBar().setValue(0);
                        this.getProgressBar().setString(this.service.getMessage("com.fathzer.soft.jclop.connectionFailed", this.getLocale()));
                        eraseQuota = false;
                    } else if (e.getCause() instanceof InvalidConnectionDataException) {
                        LOGGER.error("Communication data is invalid !", e);
                        System.out.println("Should do something, connetion data is invalid");
                    } else {
                        LOGGER.error("communication error", e);
                        AbstractURIChooserPanel.showError(owner, this.service.getMessage("com.fathzer.soft.jclop.communication.unexpectedError", this.getLocale()), this.getLocale());
                    }
                }
                catch (CancellationException e) {
                    // empty catch block
                }
                if (eraseQuota) {
                    this.setQuota(null);
                }
            }
            this.getStatusIcon().setVisible(account != null);
            this.getProgressBar().setVisible(account != null);
            this.filesModel.clear();
            for (Entry entry : entries) {
                Entry filtered = this.filter(entry);
                if (filtered == null) continue;
                this.filesModel.add(entry);
            }
            this.selectByFileName();
            this.setStatusIcon();
        }
        if (this.hasPendingSelected) {
            int index;
            this.hasPendingSelected = false;
            int n = index = this.isSaveType() ? 0 : this.filesModel.indexOf(this.pendingSelectedEntry);
            if (index >= 0) {
                this.getFileNameField().setText(this.pendingSelectedEntry.getDisplayName());
            }
        }
    }

    private void setQuota(Account account) {
        if (account != null && account.getQuota() > 0L && account.getUsed() >= 0L) {
            long percentUsed = 100L * account.getUsed() / account.getQuota();
            this.getProgressBar().setValue((int)percentUsed);
            double remaining = account.getQuota() - account.getUsed();
            String unit = MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Generic.data.unit.bytes", this.getLocale());
            if (remaining > 1024.0) {
                unit = MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Generic.data.unit.kBytes", this.getLocale());
                if ((remaining /= 1024.0) > 1024.0) {
                    unit = MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Generic.data.unit.MBytes", this.getLocale());
                    if ((remaining /= 1024.0) > 1024.0) {
                        unit = MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Generic.data.unit.GBytes", this.getLocale());
                        remaining /= 1024.0;
                    }
                }
            }
            this.getProgressBar().setString(Formatter.format(MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Chooser.freeSpace", this.getLocale()), new DecimalFormat("0.0").format(remaining), unit));
        } else {
            this.getProgressBar().setValue(0);
            this.getProgressBar().setString("?");
        }
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout(0, 0));
            this.centerPanel.add((Component)this.getScrollPane(), "Center");
            this.centerPanel.add((Component)this.getFilePanel(), "South");
        }
        return this.centerPanel;
    }

    private javax.swing.JTable getFileList() {
        if (this.fileList == null) {
            this.fileList = new JTable(this.filesModel);
            this.fileList.setSelectionMode(0);
            this.fileList.addMouseListener(new JTableListener(null, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractURIChooserPanel.this.firePropertyChange("uriApproved", false, true);
                }
            }));
            this.fileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && AbstractURIChooserPanel.this.getFileList().getSelectedRow() != -1) {
                        AbstractURIChooserPanel.this.getFileNameField().setText((String)AbstractURIChooserPanel.this.filesModel.getValueAt(AbstractURIChooserPanel.this.getFileList().getSelectedRow(), 0));
                    }
                }
            });
        }
        return this.fileList;
    }

    private JPanel getFilePanel() {
        if (this.filePanel == null) {
            this.filePanel = new JPanel();
            this.filePanel.setLayout(new BorderLayout(0, 0));
            this.filePanel.add((Component)this.getLblFileName(), "West");
            this.filePanel.add((Component)this.getFileNameField(), "Center");
        }
        return this.filePanel;
    }

    private JLabel getLblFileName() {
        if (this.lblFileName == null) {
            this.lblFileName = new JLabel(MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Chooser.fileName", this.getLocale()));
        }
        return this.lblFileName;
    }

    private TextWidget getFileNameField() {
        if (this.fileNameField == null) {
            this.fileNameField = new TextWidget();
            this.fileNameField.setEditable(false);
            this.fileNameField.addPropertyChangeListener("text", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int pos = AbstractURIChooserPanel.this.fileNameField.getCaretPosition();
                    AbstractURIChooserPanel.this.selectByFileName();
                    AbstractURIChooserPanel.this.updateSelectedURI();
                    pos = Math.min(pos, AbstractURIChooserPanel.this.fileNameField.getText().length());
                    AbstractURIChooserPanel.this.fileNameField.setCaretPosition(pos);
                }
            });
        }
        return this.fileNameField;
    }

    private JLabel getLblAccount() {
        if (this.lblAccount == null) {
            this.lblAccount = new JLabel(MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Chooser.account", this.getLocale()));
        }
        return this.lblAccount;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            GridBagLayout gblNorthPanel = new GridBagLayout();
            this.northPanel.setLayout(gblNorthPanel);
            GridBagConstraints gbcPanel = new GridBagConstraints();
            gbcPanel.weightx = 1.0;
            gbcPanel.fill = 1;
            gbcPanel.insets = new Insets(0, 0, 0, 5);
            gbcPanel.gridx = 0;
            gbcPanel.gridy = 0;
            this.northPanel.add((Component)this.getPanel(), gbcPanel);
            GridBagConstraints gbcRefreshButton = new GridBagConstraints();
            gbcRefreshButton.fill = 3;
            gbcRefreshButton.gridheight = 1;
            gbcRefreshButton.gridx = 1;
            gbcRefreshButton.gridy = 0;
            this.northPanel.add((Component)this.getRefreshButton(), gbcRefreshButton);
            GridBagConstraints gbcPanel1 = new GridBagConstraints();
            gbcPanel1.fill = 1;
            gbcPanel1.gridwidth = 2;
            gbcPanel1.gridx = 0;
            gbcPanel1.gridy = 1;
            this.northPanel.add((Component)this.getPanel1(), gbcPanel1);
        }
        return this.northPanel;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setToolTipText(this.service.getMessage("com.fathzer.soft.jclop.Chooser.refresh.tooltip", this.getLocale()));
            this.refreshButton.setEnabled(this.getAccountsCombo().getItemCount() != 0);
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractURIChooserPanel.this.refresh(true);
                }
            });
        }
        return this.refreshButton;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("?");
        }
        return this.progressBar;
    }

    protected Entry filter(Entry entry) {
        return entry;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getFileList());
            this.getFileList().setTableHeader(null);
            this.scrollPane.setColumnHeaderView(null);
        }
        return this.scrollPane;
    }

    @Override
    public URI getSelectedURI() {
        return this.selectedURI;
    }

    @Override
    public void setSelectedURI(URI uri) {
        this.pendingSelectedEntry = uri == null ? null : this.service.getEntry(uri);
        this.hasPendingSelected = true;
        if (this.isShowing()) {
            this.refresh(true);
        }
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gblPanel = new GridBagLayout();
            this.panel.setLayout(gblPanel);
            GridBagConstraints gbcLblAccount = new GridBagConstraints();
            gbcLblAccount.fill = 1;
            gbcLblAccount.anchor = 13;
            gbcLblAccount.gridx = 0;
            gbcLblAccount.gridy = 0;
            this.panel.add((Component)this.getLblAccount(), gbcLblAccount);
            GridBagConstraints gbcAccountsCombo = new GridBagConstraints();
            gbcAccountsCombo.weightx = 1.0;
            gbcAccountsCombo.fill = 1;
            gbcAccountsCombo.gridx = 1;
            gbcAccountsCombo.gridy = 0;
            this.panel.add((Component)this.getAccountsCombo(), gbcAccountsCombo);
            GridBagConstraints gbcBtnNewAccount = new GridBagConstraints();
            gbcBtnNewAccount.gridx = 2;
            gbcBtnNewAccount.gridy = 0;
            this.panel.add((Component)this.getNewButton(), gbcBtnNewAccount);
            GridBagConstraints gbcDeleteButton = new GridBagConstraints();
            gbcDeleteButton.gridx = 3;
            gbcDeleteButton.gridy = 0;
            this.panel.add((Component)this.getDeleteButton(), gbcDeleteButton);
        }
        return this.panel;
    }

    private ComboBox getAccountsCombo() {
        if (this.accountsCombo == null) {
            this.accountsCombo = new ComboBox();
            this.accountsCombo.setRenderer(new BasicComboBoxRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value != null) {
                        value = ((Account)value).getDisplayName();
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
            Collection<Account> accounts = this.getService().getAccounts();
            for (Account account : accounts) {
                this.accountsCombo.addItem(account);
            }
            this.accountsCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean oneIsSelected = AbstractURIChooserPanel.this.doAccountSelectionChanged();
                    AbstractURIChooserPanel.this.refresh(oneIsSelected);
                    String name = AbstractURIChooserPanel.this.getFileNameField().getText();
                    if (name.length() > 0 && (!oneIsSelected || !AbstractURIChooserPanel.this.isSaveType() && AbstractURIChooserPanel.this.selectByFileName() < 0)) {
                        AbstractURIChooserPanel.this.getFileNameField().setText("");
                    } else {
                        AbstractURIChooserPanel.this.updateSelectedURI();
                    }
                }
            });
            this.doAccountSelectionChanged();
        }
        return this.accountsCombo;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setToolTipText(MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Chooser.new.tooltip", this.getLocale()));
            int height = this.getAccountsCombo().getPreferredSize().height;
            this.newButton.setPreferredSize(new Dimension(height, height));
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AbstractURIChooserPanel.this.doNewAccount();
                }
            });
        }
        return this.newButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setEnabled(false);
            this.deleteButton.setToolTipText(this.service.getMessage("com.fathzer.soft.jclop.Chooser.delete.tooltip", this.getLocale()));
            int height = this.getAccountsCombo().getPreferredSize().height;
            this.deleteButton.setPreferredSize(new Dimension(height, height));
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean confirm;
                    boolean bl = confirm = JOptionPane.showOptionDialog(Utils.getOwnerWindow(AbstractURIChooserPanel.this.deleteButton), AbstractURIChooserPanel.this.service.getMessage("com.fathzer.soft.jclop.Chooser.delete.message", AbstractURIChooserPanel.this.getLocale()), MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Chooser.delete.message.title", AbstractURIChooserPanel.this.getLocale()), 2, 3, null, new String[]{AbstractURIChooserPanel.this.service.getMessage("com.fathzer.soft.jclop.Chooser.delete", AbstractURIChooserPanel.this.getLocale()), Application.getString("GenericButton.cancel", AbstractURIChooserPanel.this.getLocale())}, 1) == 0;
                    if (confirm) {
                        Account account = (Account)AbstractURIChooserPanel.this.getAccountsCombo().getSelectedItem();
                        AbstractURIChooserPanel.this.getAccountsCombo().removeItemAt(AbstractURIChooserPanel.this.getAccountsCombo().getSelectedIndex());
                        AbstractURIChooserPanel.this.getService().delete(account);
                        AbstractURIChooserPanel.this.getFileNameField().setEditable(AbstractURIChooserPanel.this.getAccountsCombo().getItemCount() > 0);
                    }
                }
            });
        }
        return this.deleteButton;
    }

    protected abstract Account createNewAccount();

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public String getScheme() {
        return this.service.getScheme();
    }

    @Override
    public String getTitle() {
        return this.getScheme();
    }

    @Override
    public void setUp() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractURIChooserPanel.this.refresh(false);
            }
        });
    }

    @Override
    public boolean isSelectedExist() {
        return this.getFileList().getSelectedRow() >= 0;
    }

    @Override
    public String getDisabledCause() {
        return null;
    }

    private int selectByFileName() {
        int index = -1;
        for (int rowIndex = 0; rowIndex < this.filesModel.getRowCount(); ++rowIndex) {
            if (!this.filesModel.getValueAt(rowIndex, 0).equals(this.fileNameField.getText())) continue;
            index = rowIndex;
            break;
        }
        ListSelectionModel selectionModel = this.getFileList().getSelectionModel();
        if (index < 0) {
            selectionModel.clearSelection();
        } else {
            selectionModel.setSelectionInterval(index, index);
        }
        return index;
    }

    private boolean doAccountSelectionChanged() {
        boolean oneIsSelected = this.getAccountsCombo().getSelectedIndex() >= 0;
        this.getDeleteButton().setEnabled(oneIsSelected);
        this.getRefreshButton().setEnabled(oneIsSelected);
        this.getFileNameField().setEditable(oneIsSelected);
        return oneIsSelected;
    }

    public static void showError(Window owner, String message, Locale locale) {
        JOptionPane.showMessageDialog(owner, message, MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.Error.title", locale), 0);
    }

    private JLabel getStatusIcon() {
        if (this.statusIcon == null) {
            this.statusIcon = new JLabel();
        }
        return this.statusIcon;
    }

    private JPanel getPanel1() {
        if (this.panel1 == null) {
            this.panel1 = new JPanel();
            this.panel1.setLayout(new BorderLayout(0, 0));
            this.panel1.add((Component)this.getStatusIcon(), "West");
            this.panel1.add(this.getProgressBar());
        }
        return this.panel1;
    }

    @Override
    public boolean updateSelectedURI() {
        URI old = this.selectedURI;
        String name = this.getFileNameField().getText();
        Account account = (Account)this.getAccountsCombo().getSelectedItem();
        URI uRI = this.selectedURI = account == null || name.length() == 0 ? null : this.getService().getURI(new Entry(account, name));
        if (!NullUtils.areEquals(this.selectedURI, old)) {
            this.firePropertyChange("selectedUri", old, this.getSelectedURI());
        }
        return true;
    }

    private void doNewAccount() {
        Account account = null;
        account = this.createNewAccount();
        if (account != null) {
            if (!this.getAccountsCombo().contains(account)) {
                boolean old = this.getAccountsCombo().isActionEnabled();
                this.getAccountsCombo().setActionEnabled(false);
                this.getAccountsCombo().addItem(account);
                this.getAccountsCombo().setActionEnabled(old);
            }
            this.getAccountsCombo().setSelectedItem(account);
        }
    }
}

