/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.currency;

import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.LoggerFactory;

public class CountryCurrencyMap {
    public static final CountryCurrencyMap INSTANCE = new CountryCurrencyMap();
    private Map<String, String> countryToCurrency = new HashMap<String, String>();
    private Map<String, Set<String>> currencyToCountries = new HashMap<String, Set<String>>();

    private CountryCurrencyMap() {
        String[] isoCountries;
        for (String isoCountry : isoCountries = Locale.getISOCountries()) {
            Currency currency = null;
            try {
                currency = Currency.getInstance(new Locale("", isoCountry));
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Fucking country returned by Locale.getISOCountries(): {}", (Object)isoCountry);
            }
            if (currency == null) {
                this.countryToCurrency.put(isoCountry, null);
                continue;
            }
            String code = currency.getCurrencyCode();
            this.countryToCurrency.put(isoCountry, code);
            Set<String> countries = this.currencyToCountries.get(code);
            if (countries == null) {
                countries = new TreeSet<String>();
                this.currencyToCountries.put(code, countries);
            }
            countries.add(isoCountry);
        }
    }

    public String getCurrency(String country) {
        return this.countryToCurrency.get(country);
    }

    public Set<String> getCountries(String currencyCode) {
        Set<String> set = this.currencyToCountries.get(currencyCode);
        return set == null ? set : Collections.unmodifiableSet(set);
    }

    public Set<String> getCountries() {
        return Collections.unmodifiableSet(this.countryToCurrency.keySet());
    }

    public Set<String> getCurrencies() {
        return Collections.unmodifiableSet(this.currencyToCountries.keySet());
    }
}

