/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.yapbam.data.Category;
import net.yapbam.data.FilteredData;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.CheckbookAddedEvent;
import net.yapbam.data.event.CheckbookPropertyChangedEvent;
import net.yapbam.data.event.CheckbookRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.DefaultListenable;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.ModeAddedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.ModeRemovedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.PasswordChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.data.event.URIChangedEvent;
import net.yapbam.util.DateUtils;

public class BudgetView
extends DefaultListenable {
    private FilteredData data;
    private boolean year;
    private boolean valueDate;
    private Map<Key, Double> values;
    private Calendar firstDate;
    private Calendar lastDate;
    private List<Category> categories;
    private Map<Category, Double> categoryToSum;
    private Map<Date, Double> dateToSum;
    private double sum;
    private boolean groupSubCategories;

    public BudgetView(FilteredData data, boolean year) {
        this.data = data;
        this.data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (!BudgetView.this.isNeutral(event)) {
                    BudgetView.this.update();
                }
            }
        });
        this.year = year;
        this.groupSubCategories = false;
        this.build();
    }

    private boolean isNeutral(DataEvent event) {
        return event instanceof NeedToBeSavedChangedEvent || event instanceof PasswordChangedEvent || event instanceof URIChangedEvent || event instanceof AccountAddedEvent || event instanceof AccountRemovedEvent || event instanceof AccountPropertyChangedEvent || event instanceof ModeAddedEvent || event instanceof ModeRemovedEvent || event instanceof ModePropertyChangedEvent || event instanceof CheckbookPropertyChangedEvent || event instanceof CheckbookAddedEvent || event instanceof CheckbookRemovedEvent || event instanceof PeriodicalTransactionsAddedEvent || event instanceof PeriodicalTransactionsRemovedEvent;
    }

    public void setGroupedSubCategories(boolean grouped) {
        if (grouped != this.groupSubCategories) {
            this.groupSubCategories = grouped;
            this.update();
        }
    }

    public boolean isYear() {
        return this.year;
    }

    public void setYear(boolean year) {
        if (year != this.year) {
            this.year = year;
            this.update();
        }
    }

    public void setValueDate(boolean valueDate) {
        if (valueDate != this.valueDate) {
            this.valueDate = valueDate;
            this.update();
        }
    }

    public int getCategoriesSize() {
        return this.categories.size();
    }

    public Category getCategory(int index) {
        return this.categories.get(index);
    }

    public int getDatesSize() {
        if (this.firstDate == null) {
            return 0;
        }
        return 1 + (this.year ? this.lastDate.get(1) - this.firstDate.get(1) : DateUtils.getMonthlyDistance(this.firstDate, this.lastDate));
    }

    public Date getDate(int index) {
        if (index >= this.getDatesSize()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Calendar c = (Calendar)this.firstDate.clone();
        if (this.year) {
            c.set(c.get(1) + index, 0, 1);
        } else {
            c.add(2, index);
        }
        return c.getTime();
    }

    public Date getLastDate(int index) {
        if (index >= this.getDatesSize()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Calendar c = (Calendar)this.firstDate.clone();
        if (this.year) {
            c.set(c.get(1) + index, 11, 31);
        } else {
            c.add(2, index);
            c.set(5, c.getActualMaximum(5));
        }
        return c.getTime();
    }

    public Double getAmount(Date date, Category category) {
        return this.values.get(new Key(date, category));
    }

    public double getSum(Date date) {
        Double result = this.dateToSum.get(date);
        return result == null ? 0.0 : result;
    }

    public double getSum(Category category) {
        Double result = this.categoryToSum.get(category);
        return result == null ? 0.0 : result;
    }

    public double getAverage(Category category) {
        if (this.getDatesSize() == 0) {
            return 0.0;
        }
        return this.getSum(category) / (double)this.getDatesSize();
    }

    private void update() {
        this.build();
        this.fireEvent(new EverythingChangedEvent(this));
    }

    private void build() {
        int i;
        this.values = new HashMap<Key, Double>();
        this.categoryToSum = new HashMap<Category, Double>();
        this.dateToSum = new HashMap<Date, Double>();
        this.firstDate = null;
        this.lastDate = null;
        this.categories = new LinkedList<Category>();
        this.sum = 0.0;
        HashMap<Category, Category> catMap = new HashMap<Category, Category>();
        for (i = 0; i < this.data.getGlobalData().getCategoriesNumber(); ++i) {
            Category cat = this.data.getGlobalData().getCategory(i);
            catMap.put(cat, this.groupSubCategories ? cat.getSuperCategory(this.data.getGlobalData().getSubCategorySeparator()) : cat);
        }
        for (i = 0; i < this.data.getTransactionsNumber(); ++i) {
            Transaction transaction = this.data.getTransaction(i);
            Date date = this.getNormalizedDate(this.valueDate ? transaction.getValueDate() : transaction.getDate());
            for (int j = 0; j < transaction.getSubTransactionSize(); ++j) {
                SubTransaction subTransaction = transaction.getSubTransaction(j);
                if (!this.data.getFilter().isOk(subTransaction)) continue;
                this.add(new Key(date, (Category)catMap.get(subTransaction.getCategory())), subTransaction.getAmount());
                this.sum += subTransaction.getAmount();
            }
            if (!this.data.getFilter().isComplementOk(transaction)) continue;
            this.add(new Key(date, (Category)catMap.get(transaction.getCategory())), transaction.getComplement());
            this.sum += transaction.getComplement();
        }
    }

    private void add(Key key, double amount) {
        if (amount != 0.0) {
            Double value;
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(key.date);
            if (this.firstDate == null) {
                this.lastDate = this.firstDate = c;
            } else if (DateUtils.getMonthlyDistance(this.firstDate, c) < 0) {
                this.firstDate = c;
            } else if (DateUtils.getMonthlyDistance(this.lastDate, c) > 0) {
                this.lastDate = c;
            }
            int index = Collections.binarySearch(this.categories, key.category);
            if (index < 0) {
                this.categories.add(-index - 1, key.category);
            }
            if ((value = this.values.get(key)) == null) {
                value = 0.0;
            }
            value = value + amount;
            this.values.put(key, value);
            value = this.categoryToSum.get(key.category);
            if (value == null) {
                value = 0.0;
            }
            value = value + amount;
            this.categoryToSum.put(key.category, value);
            value = this.dateToSum.get(key.date);
            if (value == null) {
                value = 0.0;
            }
            value = value + amount;
            this.dateToSum.put(key.date, value);
        }
    }

    private Date getNormalizedDate(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.set(5, 1);
        if (this.year) {
            c.set(2, 0);
        }
        return c.getTime();
    }

    public Double getSum() {
        return this.sum;
    }

    private static final class Key {
        Date date;
        Category category;

        Key(Date date, Category category) {
            this.date = date;
            this.category = category;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.date.equals(key.date) && this.category.equals(key.category);
        }

        public int hashCode() {
            return this.category.hashCode() + this.date.hashCode();
        }
    }
}

