/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.AbstractTransactionUpdater;
import net.yapbam.data.Account;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.Category;
import net.yapbam.data.Checkbook;
import net.yapbam.data.Filter;
import net.yapbam.data.Mode;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.CategoryAddedEvent;
import net.yapbam.data.event.CategoryPropertyChangedEvent;
import net.yapbam.data.event.CategoryRemovedEvent;
import net.yapbam.data.event.CheckbookAddedEvent;
import net.yapbam.data.event.CheckbookPropertyChangedEvent;
import net.yapbam.data.event.CheckbookRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DefaultListenable;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.FilterPropertyChangedEvent;
import net.yapbam.data.event.FiltersAddedEvent;
import net.yapbam.data.event.FiltersRemovedEvent;
import net.yapbam.data.event.IsArchivedChangedEvent;
import net.yapbam.data.event.IsLockedChangedEvent;
import net.yapbam.data.event.ModeAddedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.ModeRemovedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.PasswordChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.data.event.SubCategorySeparatorChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.data.event.URIChangedEvent;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.util.NullUtils;
import org.slf4j.LoggerFactory;

public class GlobalData
extends DefaultListenable {
    private static final char DEFAULT_CATEGORY_SEPARATOR = '.';
    private List<Account> accounts;
    private List<Category> categories;
    private List<PeriodicalTransaction> periodicals;
    private List<Transaction> transactions;
    private List<Filter> filters;
    private boolean archive;
    private boolean locked;
    private URI uri;
    private String password;
    private char subCategorySeparator;
    private transient boolean somethingChanged;
    private boolean eventsPending;
    private static Currency defaultCurrency;
    private static double defaultPrecision;
    private static final Comparator<Transaction> COMPARATOR;
    private static final Comparator<PeriodicalTransaction> PERIODICAL_COMPARATOR;
    public static final Comparator<Double> AMOUNT_COMPARATOR;
    private final Observer FILTER_OBSERVER = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            GlobalData.this.fireEvent(new FilterPropertyChangedEvent(GlobalData.this, (Filter)o));
            GlobalData.this.setChanged();
        }
    };

    public GlobalData() {
        this.clear();
    }

    public void setArchive(boolean isArchive) {
        if (isArchive != this.archive) {
            this.archive = isArchive;
            this.fireEvent(new IsArchivedChangedEvent(this));
            this.setChanged();
        }
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setLocked(boolean locked) {
        if (locked != this.locked) {
            this.locked = locked;
            this.fireEvent(new IsLockedChangedEvent(this));
            this.setChanged();
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static void setDefaultCurrency(Currency currency) {
        defaultCurrency = currency;
        defaultPrecision = Math.pow(10.0, -currency.getDefaultFractionDigits()) / 2.0;
    }

    public static Currency getDefaultCurrency() {
        return defaultCurrency;
    }

    public boolean isEmpty() {
        return this.accounts.isEmpty() && this.getCategoriesNumber() == 1 && this.getSubCategorySeparator() == '.';
    }

    public boolean somethingHasChanged() {
        return this.somethingChanged;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getPassword() {
        return this.password;
    }

    public void setURI(URI uri) {
        URI old = this.uri;
        this.uri = uri;
        if (!NullUtils.areEquals(this.uri, old)) {
            this.fireEvent(new URIChangedEvent(this));
        }
    }

    public void setPassword(String password) {
        if (password != null && password.length() == 0) {
            password = null;
        }
        if (!NullUtils.areEquals(this.password, password)) {
            String old = this.password;
            this.password = password;
            this.fireEvent(new PasswordChangedEvent(this, old, this.password));
            this.setChanged();
        }
    }

    @Override
    public void setEventsEnabled(boolean enabled) {
        if (this.isEventsEnabled()) {
            this.eventsPending = false;
        }
        super.setEventsEnabled(enabled);
        if (enabled && this.eventsPending) {
            this.fireEvent(new EverythingChangedEvent(this));
        }
    }

    @Override
    public boolean isEventsEnabled() {
        return super.isEventsEnabled();
    }

    @Override
    protected void fireEvent(DataEvent event) {
        if (this.isEventsEnabled()) {
            super.fireEvent(event);
        } else {
            this.eventsPending = true;
        }
    }

    public Account getAccount(String name) {
        for (Account account : this.accounts) {
            if (!account.getName().equalsIgnoreCase(name)) continue;
            return account;
        }
        return null;
    }

    public Account getAccount(int index) {
        return this.accounts.get(index);
    }

    public int getAccountsNumber() {
        return this.accounts.size();
    }

    public int indexOf(Account account) {
        return this.accounts.indexOf(account);
    }

    public void add(Account account) {
        if (this.getAccount(account.getName()) != null) {
            throw new IllegalArgumentException("Duplicate account name : " + account);
        }
        this.accounts.add(account);
        this.fireEvent(new AccountAddedEvent(this, account));
        this.setChanged();
    }

    public int getTransactionsNumber() {
        return this.transactions.size();
    }

    public Transaction getTransaction(int index) {
        return this.transactions.get(index);
    }

    public void add(Transaction[] transactions) {
        LoggerFactory.getLogger(this.getClass()).trace("start adding transactions to global data");
        if (transactions.length == 0) {
            return;
        }
        ArrayList accountTransactions = new ArrayList(this.getAccountsNumber());
        for (int i = 0; i < this.getAccountsNumber(); ++i) {
            accountTransactions.add(new ArrayList());
        }
        Transaction[] i = transactions;
        int n = i.length;
        for (int j = 0; j < n; ++j) {
            Transaction transaction = i[j];
            int accountIndex = this.indexOf(transaction.getAccount());
            if (accountIndex < 0) {
                throw new IllegalArgumentException("Unknown account: " + transaction.getAccount().getName());
            }
            ((Collection)accountTransactions.get(accountIndex)).add(transaction);
        }
        for (int i2 = 0; i2 < transactions.length; ++i2) {
            Transaction transaction = transactions[i2];
            int index = -this.indexOf(transaction) - 1;
            if (index < 0) {
                for (int j = i2 - 1; j >= 0; --j) {
                    this.transactions.remove(this.indexOf(transaction));
                }
                throw new IllegalArgumentException("Duplicated transaction");
            }
            this.transactions.add(index, transaction);
        }
        LoggerFactory.getLogger(this.getClass()).trace("start adding transactions to accounts");
        for (Collection collection : accountTransactions) {
            if (collection.isEmpty()) continue;
            Transaction[] addedAccountTransactions = collection.toArray(new Transaction[collection.size()]);
            addedAccountTransactions[0].getAccount().add(addedAccountTransactions);
        }
        this.fireEvent(new TransactionsAddedEvent(this, transactions));
        this.setChanged();
        LoggerFactory.getLogger(this.getClass()).trace("Start looking for checkbooks updates");
        block5: for (Transaction transaction : transactions) {
            String number;
            if (!transaction.getMode().isUseCheckBook() || !(transaction.getAmount() <= 0.0) || (number = transaction.getNumber()) == null) continue;
            Account account = transaction.getAccount();
            for (int j = 0; j < account.getCheckbooksNumber(); ++j) {
                Checkbook checkbook = account.getCheckbook(j);
                BigInteger shortNumber = checkbook.getNumber(number);
                if (checkbook.isEmpty() || shortNumber == null) continue;
                if (shortNumber.compareTo(checkbook.getNext()) < 0) continue block5;
                Checkbook newOne = new Checkbook(checkbook.getPrefix(), checkbook.getFirst(), checkbook.size(), shortNumber.equals(checkbook.getLast()) ? null : shortNumber.add(BigInteger.ONE));
                this.setCheckbook(account, checkbook, newOne);
                continue block5;
            }
        }
        LoggerFactory.getLogger(this.getClass()).trace("End adding transactions");
    }

    public void add(Transaction transaction) {
        this.add(new Transaction[]{transaction});
    }

    public void remove(Transaction[] transactions) {
        ArrayList<Transaction> removed = new ArrayList<Transaction>(transactions.length);
        ArrayList accountTransactions = new ArrayList(this.getAccountsNumber());
        for (int i = 0; i < this.getAccountsNumber(); ++i) {
            accountTransactions.add(new ArrayList());
        }
        for (Transaction transaction : transactions) {
            int index = this.indexOf(transaction);
            if (index < 0) continue;
            Transaction removedTransaction = this.transactions.remove(index);
            removed.add(removedTransaction);
            ((Collection)accountTransactions.get(this.indexOf(transaction.getAccount()))).add(removedTransaction);
        }
        if (!removed.isEmpty()) {
            for (Collection collection : accountTransactions) {
                if (collection.isEmpty()) continue;
                Transaction[] removedAccountTransactions = collection.toArray(new Transaction[collection.size()]);
                removedAccountTransactions[0].getAccount().remove(removedAccountTransactions);
            }
            this.fireEvent(new TransactionsRemovedEvent(this, removed.toArray(new Transaction[removed.size()])));
            this.setChanged();
        }
    }

    public void remove(Transaction transaction) {
        this.remove(new Transaction[]{transaction});
    }

    public int indexOf(Transaction transaction) {
        return Collections.binarySearch(this.transactions, transaction, COMPARATOR);
    }

    public int getCategoriesNumber() {
        return this.categories.size();
    }

    public Category getCategory(int index) {
        return this.categories.get(index);
    }

    public Category getCategory(String categoryName) {
        if (categoryName == null) {
            return Category.UNDEFINED;
        }
        int index = Collections.binarySearch(this.categories, new Category(categoryName));
        if (index < 0) {
            return null;
        }
        return this.categories.get(index);
    }

    public int indexOf(Category category) {
        return Collections.binarySearch(this.categories, category);
    }

    public void add(Category category) {
        if (category.getName() == null) {
            throw new IllegalArgumentException();
        }
        int index = -Collections.binarySearch(this.categories, category) - 1;
        this.categories.add(index, category);
        this.fireEvent(new CategoryAddedEvent(this, category));
        this.setChanged();
    }

    public char getSubCategorySeparator() {
        return this.subCategorySeparator;
    }

    public void setSubCategorySeparator(char separator) {
        if (separator != this.subCategorySeparator) {
            char old = this.subCategorySeparator;
            this.subCategorySeparator = separator;
            this.fireEvent(new SubCategorySeparatorChangedEvent(this, old, separator));
            this.setChanged();
        }
    }

    public void clear() {
        this.categories = new ArrayList<Category>();
        this.categories.add(Category.UNDEFINED);
        this.subCategorySeparator = (char)46;
        this.accounts = new ArrayList<Account>();
        this.periodicals = new ArrayList<PeriodicalTransaction>();
        this.transactions = new ArrayList<Transaction>();
        this.filters = new ArrayList<Filter>();
        this.uri = null;
        this.password = null;
        this.somethingChanged = false;
        this.fireEvent(new EverythingChangedEvent(this));
    }

    public void add(PeriodicalTransaction periodical) {
        int index = -Collections.binarySearch(this.periodicals, periodical, PERIODICAL_COMPARATOR) - 1;
        this.periodicals.add(index, periodical);
        this.fireEvent(new PeriodicalTransactionsAddedEvent(this, new PeriodicalTransaction[]{periodical}));
        this.setChanged();
    }

    public void add(PeriodicalTransaction[] transactions) {
        if (transactions.length == 0) {
            return;
        }
        for (PeriodicalTransaction transaction : transactions) {
            int index = -Collections.binarySearch(this.periodicals, transaction, PERIODICAL_COMPARATOR) - 1;
            this.periodicals.add(index, transaction);
        }
        this.fireEvent(new PeriodicalTransactionsAddedEvent(this, transactions));
        this.setChanged();
    }

    public int getPeriodicalTransactionsNumber() {
        return this.periodicals.size();
    }

    public PeriodicalTransaction getPeriodicalTransaction(int index) {
        return this.periodicals.get(index);
    }

    public void remove(PeriodicalTransaction[] periodicals) {
        int nb = 0;
        int[] indexes = new int[periodicals.length];
        for (PeriodicalTransaction transaction : periodicals) {
            indexes[nb] = Collections.binarySearch(this.periodicals, transaction, PERIODICAL_COMPARATOR);
            if (indexes[nb] < 0) continue;
            ++nb;
        }
        if (nb > 0) {
            PeriodicalTransaction[] removed = new PeriodicalTransaction[nb];
            int[] removedIndexes = nb == periodicals.length ? indexes : Arrays.copyOf(indexes, nb);
            Arrays.sort(removedIndexes);
            for (int i = removedIndexes.length - 1; i >= 0; --i) {
                removed[i] = this.periodicals.remove(removedIndexes[i]);
            }
            this.fireEvent(new PeriodicalTransactionsRemovedEvent(this, removedIndexes, removed));
            this.setChanged();
        }
    }

    public void remove(PeriodicalTransaction periodical) {
        int index = Collections.binarySearch(this.periodicals, periodical, PERIODICAL_COMPARATOR);
        if (index >= 0) {
            this.removePeriodicalTransaction(index);
        }
    }

    private void removePeriodicalTransaction(int index) {
        PeriodicalTransaction removed = this.periodicals.remove(index);
        this.fireEvent(new PeriodicalTransactionsRemovedEvent(this, new int[]{index}, new PeriodicalTransaction[]{removed}));
        this.setChanged();
    }

    public void setPeriodicalTransactionNextDate(PeriodicalTransaction[] transactions, Date[] dates) {
        ArrayList<PeriodicalTransaction> removed = new ArrayList<PeriodicalTransaction>(transactions.length);
        ArrayList<PeriodicalTransaction> updated = new ArrayList<PeriodicalTransaction>(transactions.length);
        for (int i = 0; i < dates.length; ++i) {
            PeriodicalTransaction pt = transactions[i];
            Date date = dates[i];
            Date nextDate = pt.getNextDate();
            if (nextDate == null) continue;
            DateStepper ds = pt.getNextDateBuilder();
            if (ds == null) {
                nextDate = date;
            } else {
                while (nextDate != null && nextDate.compareTo(date) <= 0) {
                    nextDate = ds.getNextStep(nextDate);
                }
            }
            removed.add(pt);
            updated.add(new PeriodicalTransaction(pt.getDescription(), pt.getComment(), pt.getAmount(), pt.getAccount(), pt.getMode(), pt.getCategory(), Arrays.asList(pt.getSubTransactions()), nextDate, pt.isEnabled() && nextDate != null, ds));
        }
        this.remove(removed.toArray(new PeriodicalTransaction[removed.size()]));
        this.add(updated.toArray(new PeriodicalTransaction[updated.size()]));
    }

    private void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean changed) {
        if (changed != this.somethingChanged) {
            this.somethingChanged = changed;
            this.fireEvent(new NeedToBeSavedChangedEvent(this));
        }
    }

    public void remove(Account account) {
        int index = this.accounts.indexOf(account);
        if (index >= 0) {
            ArrayList<AbstractTransaction> removed;
            if (account.getTransactionsNumber() != 0) {
                removed = new ArrayList(account.getTransactionsNumber());
                for (Transaction transaction : this.transactions) {
                    if (transaction.getAccount() != account) continue;
                    removed.add(transaction);
                }
                this.remove(removed.toArray(new Transaction[removed.size()]));
            }
            removed = new ArrayList<AbstractTransaction>();
            for (PeriodicalTransaction periodicalTransaction : this.periodicals) {
                if (periodicalTransaction.getAccount() != account) continue;
                removed.add(periodicalTransaction);
            }
            this.remove(removed.toArray(new PeriodicalTransaction[removed.size()]));
            for (Filter filter : this.filters) {
                List<Account> validAccounts = filter.getValidAccounts();
                if (validAccounts == null || !validAccounts.remove(account)) continue;
                filter.setValidAccounts(validAccounts.isEmpty() ? null : validAccounts);
            }
            this.accounts.remove(index);
            this.fireEvent(new AccountRemovedEvent(this, index, account));
            this.setChanged();
        }
    }

    public void setName(Account account, String value) {
        String old = account.getName();
        if (!old.equals(value)) {
            Account accountByName = this.getAccount(value);
            if (accountByName != null && accountByName != account) {
                throw new IllegalArgumentException("Account name already exists");
            }
            account.setName(value);
            this.fireEvent(new AccountPropertyChangedEvent(this, "name", account, old, value));
            this.setChanged();
        }
    }

    public void setInitialBalance(Account account, double value) {
        double old = account.getInitialBalance();
        if (old != value) {
            account.setInitialBalance(value);
            this.fireEvent(new AccountPropertyChangedEvent(this, "initialBalance", account, old, value));
            this.setChanged();
        }
    }

    public void setAlertThreshold(Account account, AlertThreshold threshold) {
        AlertThreshold old = account.getAlertThreshold();
        if (!old.equals(threshold)) {
            account.setAlertThreshold(threshold);
            this.fireEvent(new AccountPropertyChangedEvent(this, "alertThreshold", account, old, threshold));
            this.setChanged();
        }
    }

    public void setComment(Account account, String comment) {
        String old = account.getComment();
        if (!NullUtils.areEquals(old, comment)) {
            account.setComment(comment);
            this.fireEvent(new AccountPropertyChangedEvent(this, "comment", account, old, comment));
            this.setChanged();
        }
    }

    public void remove(Category category) {
        int index = this.categories.indexOf(category);
        if (index >= 0) {
            new CategoryUpdater(category, Category.UNDEFINED).doIt();
            this.categories.remove(index);
            for (Filter filter : this.filters) {
                List<Category> validCategories = filter.getValidCategories();
                if (validCategories == null || !validCategories.remove(category)) continue;
                filter.setValidCategories(validCategories.isEmpty() ? null : validCategories);
            }
            this.fireEvent(new CategoryRemovedEvent(this, index, category));
            this.setChanged();
        }
    }

    public void setName(Category category, String name) {
        String old = category.getName();
        if (!old.equals(name)) {
            if (this.getCategory(name) != null) {
                throw new IllegalArgumentException("Category name already exists");
            }
            this.categories.remove(this.indexOf(category));
            category.setName(name);
            int index = -Collections.binarySearch(this.categories, category) - 1;
            this.categories.add(index, category);
            this.fireEvent(new CategoryPropertyChangedEvent(this, "name", category, old, name));
            this.setChanged();
        }
    }

    public void add(Account account, Mode mode) {
        account.add(mode);
        this.fireEvent(new ModeAddedEvent(this, account, mode));
        this.setChanged();
    }

    public void remove(Account account, Mode mode) {
        int index = account.indexOf(mode);
        if (index >= 0) {
            new ModeUpdater(account, mode, Mode.UNDEFINED).doIt();
            account.remove(mode);
            for (Filter filter : this.filters) {
                List<String> validModes = filter.getValidModes();
                if (validModes == null || !validModes.remove(mode.getName()) || this.isUsedByFilteredAccounts(filter, mode)) continue;
                filter.setValidModes(validModes.isEmpty() ? null : validModes);
            }
            this.fireEvent(new ModeRemovedEvent(this, index, account, mode));
            this.setChanged();
        }
    }

    boolean isUsedByFilteredAccounts(Filter filter, Mode mode) {
        for (int i = 0; i < this.getAccountsNumber(); ++i) {
            Account account = this.getAccount(i);
            if (!filter.isOk(account) || account.getMode(mode.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public void setMode(Account account, Mode oldMode, Mode newMode) {
        if (oldMode.equals(Mode.UNDEFINED)) {
            throw new IllegalArgumentException("Undefined mode can't be modified");
        }
        ModePropertyChangedEvent event = new ModePropertyChangedEvent(this, account, oldMode, newMode);
        if (event.getChanges() != 0) {
            Mode oldVanished = new Mode(oldMode.getName(), oldMode.getReceiptVdc(), oldMode.getExpenseVdc(), oldMode.isUseCheckBook());
            account.replace(oldMode, newMode);
            event = new ModePropertyChangedEvent(this, account, oldVanished, oldMode);
            for (Filter filter : this.filters) {
                this.updateFilter(event, filter);
            }
            this.fireEvent(event);
            this.setChanged();
        }
    }

    void updateFilter(ModePropertyChangedEvent event, Filter filter) {
        if ((event.getChanges() & 1) != 0) {
            List<String> validModes = filter.getValidModes();
            Mode oldMode = event.getOldMode();
            if (validModes != null && validModes.contains(oldMode.getName()) && filter.isOk(event.getAccount())) {
                if (!validModes.contains(event.getNewMode().getName())) {
                    validModes.add(event.getNewMode().getName());
                }
                if (!this.isUsedByFilteredAccounts(filter, oldMode)) {
                    validModes.remove(oldMode.getName());
                }
                filter.setValidModes(validModes);
            }
        }
    }

    public void add(Account account, Checkbook book) {
        account.add(book);
        this.fireEvent(new CheckbookAddedEvent(this, account, book));
        this.setChanged();
    }

    public void remove(Account account, Checkbook book) {
        int index = account.indexOf(book);
        if (index >= 0) {
            account.remove(book);
            this.fireEvent(new CheckbookRemovedEvent(this, index, account, book));
            this.setChanged();
        }
    }

    public void setCheckbook(Account account, Checkbook old, Checkbook checkbook) {
        CheckbookPropertyChangedEvent event = new CheckbookPropertyChangedEvent(this, account, old, checkbook);
        if (event.getChanges() != 0) {
            Checkbook oldVanished = new Checkbook(old.getPrefix(), old.getFirst(), old.size(), old.getNext());
            old.copy(checkbook);
            event = new CheckbookPropertyChangedEvent(this, account, oldVanished, old);
            this.fireEvent(event);
            this.setChanged();
        }
    }

    public void copy(GlobalData src) {
        this.archive = src.archive;
        this.locked = src.isLocked();
        this.accounts = src.accounts;
        this.categories = src.categories;
        this.filters = new ArrayList<Filter>();
        for (Filter filter : src.filters) {
            Filter copy = new Filter();
            copy.copy(filter);
            this.filters.add(copy);
            copy.addObserver(this.FILTER_OBSERVER);
        }
        this.subCategorySeparator = src.subCategorySeparator;
        this.periodicals = src.periodicals;
        this.transactions = src.transactions;
        this.password = src.password;
        this.uri = src.uri;
        this.fireEvent(new EverythingChangedEvent(this));
        this.setChanged();
    }

    public boolean hasPendingPeriodicalTransactions(Date date) {
        for (int i = 0; i < this.getPeriodicalTransactionsNumber(); ++i) {
            if (!this.getPeriodicalTransaction(i).hasPendingTransactions(date)) continue;
            return true;
        }
        return false;
    }

    public void add(Filter filter) {
        if (filter.getName() == null) {
            throw new IllegalArgumentException("Filter should have a name");
        }
        if (this.getFilter(filter.getName()) != null) {
            throw new IllegalArgumentException("Filter " + filter.getName() + " already exists");
        }
        this.filters.add(filter);
        filter.addObserver(this.FILTER_OBSERVER);
        this.fireEvent(new FiltersAddedEvent(this, new Filter[]{filter}));
        this.setChanged();
    }

    public void remove(Filter filter) {
        if (this.filters.remove(filter)) {
            filter.deleteObserver(this.FILTER_OBSERVER);
            this.fireEvent(new FiltersRemovedEvent(this, new Filter[]{filter}));
            this.setChanged();
        }
    }

    public int getFiltersNumber() {
        return this.filters.size();
    }

    public Filter getFilter(int i) {
        return this.filters.get(i);
    }

    public Filter getFilter(String name) {
        if (name == null) {
            return null;
        }
        for (Filter filter : this.filters) {
            if (!name.equals(filter.getName())) continue;
            return filter;
        }
        return null;
    }

    static {
        GlobalData.setDefaultCurrency(Currency.getInstance(Locale.getDefault()));
        COMPARATOR = new Comparator<Transaction>(){

            @Override
            public int compare(Transaction o1, Transaction o2) {
                return Long.signum(o1.getId() - o2.getId());
            }
        };
        PERIODICAL_COMPARATOR = new Comparator<PeriodicalTransaction>(){

            @Override
            public int compare(PeriodicalTransaction o1, PeriodicalTransaction o2) {
                int result = o1.getDescription().compareToIgnoreCase(o2.getDescription());
                if (result == 0) {
                    result = Long.signum(o1.getId() - o2.getId());
                }
                return result;
            }
        };
        AMOUNT_COMPARATOR = new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                if (o1.equals(o2) || Math.abs(o1 - o2) < defaultPrecision) {
                    return 0;
                }
                return o1 < o2 ? -1 : 1;
            }
        };
    }

    class ModeUpdater
    extends AbstractTransactionUpdater {
        private Account account;
        private Mode oldMode;
        private Mode newMode;

        ModeUpdater(Account account, Mode oldMode, Mode newMode) {
            super(GlobalData.this);
            this.account = account;
            this.oldMode = oldMode;
            this.newMode = newMode;
        }

        @Override
        protected Transaction change(Transaction t) {
            return t.change(this.account, this.oldMode, this.newMode);
        }

        @Override
        protected PeriodicalTransaction change(PeriodicalTransaction t) {
            return t.change(this.account, this.oldMode, this.newMode);
        }
    }

    class CategoryUpdater
    extends AbstractTransactionUpdater {
        private Category oldCategory;
        private Category newCategory;

        CategoryUpdater(Category oldMode, Category newMode) {
            super(GlobalData.this);
            this.oldCategory = oldMode;
            this.newCategory = newMode;
        }

        @Override
        protected Transaction change(Transaction t) {
            return t.change(this.oldCategory, this.newCategory);
        }

        @Override
        protected PeriodicalTransaction change(PeriodicalTransaction t) {
            return t.change(this.oldCategory, this.newCategory);
        }
    }
}

