/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;
import net.yapbam.util.DateUtils;

public class Transaction
extends AbstractTransaction {
    private int date;
    private String number;
    private int valueDate;
    private String statementId;

    public Transaction(int date, String number, String description, String comment, double amount, Account account, Mode mode, Category category, int valueDate, String statementId, List<SubTransaction> subTransactions) {
        super(description, comment, amount, account, mode, category, subTransactions);
        this.date = date;
        this.number = number;
        if (number != null && number.trim().isEmpty()) {
            this.number = null;
        }
        this.valueDate = valueDate;
        this.statementId = statementId;
        if (statementId != null && statementId.trim().isEmpty()) {
            this.statementId = null;
        }
    }

    public Transaction(Date date, String number, String description, String comment, double amount, Account account, Mode mode, Category category, Date valueDate, String statementId, List<SubTransaction> subTransactions) {
        this(DateUtils.dateToInteger(date), number, description, comment, amount, account, mode, category, DateUtils.dateToInteger(valueDate), statementId, subTransactions);
    }

    public String getNumber() {
        return this.number;
    }

    public Date getDate() {
        return DateUtils.integerToDate(this.date);
    }

    public int getDateAsInteger() {
        return this.date;
    }

    public Date getValueDate() {
        return DateUtils.integerToDate(this.valueDate);
    }

    public int getValueDateAsInteger() {
        return this.valueDate;
    }

    public String getStatement() {
        return this.statementId;
    }

    public String toString() {
        return MessageFormat.format("({0} \"{1}\" {2,date,short}->{3,date,short}: {4,number,currency})", this.getAccount(), this.getDescription(), this.getDate(), this.getValueDate(), this.getAmount());
    }

    public boolean isChecked() {
        return this.statementId != null;
    }

    Transaction change(Category oldCategory, Category newCategory) {
        if (!this.hasCategory(oldCategory)) {
            return null;
        }
        List<SubTransaction> subTransactions = this.changeSubTransactions(oldCategory, newCategory);
        return new Transaction(this.getDate(), this.getNumber(), this.getDescription(), this.getComment(), this.getAmount(), this.getAccount(), this.getMode(), this.getCategory().equals(oldCategory) ? newCategory : this.getCategory(), this.getValueDate(), this.getStatement(), subTransactions);
    }

    Transaction change(Account account, Mode oldMode, Mode newMode) {
        if (this.getAccount().equals(account) && this.getMode().equals(oldMode)) {
            ArrayList<SubTransaction> subTransactionsClone = new ArrayList<SubTransaction>();
            for (int i = 0; i < this.getSubTransactionSize(); ++i) {
                subTransactionsClone.add(this.getSubTransaction(i));
            }
            return new Transaction(this.getDate(), this.getNumber(), this.getDescription(), this.getComment(), this.getAmount(), this.getAccount(), newMode, this.getCategory(), this.getValueDate(), this.getStatement(), subTransactionsClone);
        }
        return null;
    }
}

