/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.date.helpers;

import java.util.Date;
import java.util.GregorianCalendar;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.date.helpers.DeferredValueDateComputer;
import net.yapbam.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonthDateStepper
extends DateStepper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeferredValueDateComputer.class);
    private static final boolean DEBUG = false;
    private int period;
    private int day;
    private int lastDate;

    public MonthDateStepper(int nb, int day) {
        this(nb, day, null);
    }

    public MonthDateStepper(int nb, int day, Date timeLimit) {
        this.period = nb;
        this.day = day;
        this.lastDate = timeLimit == null ? Integer.MAX_VALUE : DateUtils.dateToInteger(timeLimit);
    }

    @Override
    public Date getNextStep(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.set(5, 1);
        gc.add(2, this.period);
        int max = gc.getActualMaximum(5);
        gc.set(5, Math.min(max, this.day));
        Date result = gc.getTime();
        if (DateUtils.dateToInteger(result) > this.lastDate) {
            result = null;
        }
        return result;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getDay() {
        return this.day;
    }

    @Override
    public Date getLastDate() {
        return this.lastDate == Integer.MAX_VALUE ? null : DateUtils.integerToDate(this.lastDate);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MonthDateStepper)) {
            return false;
        }
        return this.period == ((MonthDateStepper)obj).period && this.day == ((MonthDateStepper)obj).day && this.lastDate == ((MonthDateStepper)obj).lastDate;
    }

    public int hashCode() {
        return this.day + this.period + this.lastDate;
    }
}

