/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.widget.TabbedPane;

public class MainPanel
extends TabbedPane {
    public static final String SELECTED_PLUGIN_PROPERTY = "selectedPlugin";
    private List<AbstractPlugIn> paneledPlugins = new ArrayList<AbstractPlugIn>();
    private AbstractPlugIn selectedPlugin;

    public MainPanel(AbstractPlugIn[] plugins) {
        for (int i = 0; i < plugins.length; ++i) {
            if (plugins[i] == null) continue;
            JPanel pane = plugins[i].getPanel();
            if (pane != null) {
                this.paneledPlugins.add(plugins[i]);
                this.addTab(plugins[i].getPanelTitle(), null, pane, plugins[i].getPanelToolTip());
                if (plugins[i].getPanelIcon() != null) {
                    this.setIconAt(this.getTabCount() - 1, plugins[i].getPanelIcon());
                }
            }
            plugins[i].getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int tabIndex = MainPanel.this.paneledPlugins.indexOf(evt.getSource());
                    if (tabIndex >= 0) {
                        tabIndex = MainPanel.this.getIndexOf(tabIndex);
                        if (evt.getPropertyName().equals("panelIcon")) {
                            MainPanel.this.setIconAt(tabIndex, (Icon)evt.getNewValue());
                        } else if (evt.getPropertyName().equals("panelTitle")) {
                            MainPanel.this.setTitleAt(tabIndex, (String)evt.getNewValue());
                        } else if (evt.getPropertyName().equals("panelTooltip")) {
                            MainPanel.this.setToolTipTextAt(tabIndex, (String)evt.getNewValue());
                        }
                    }
                }
            });
        }
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainPanel.this.updateSelectedPlugin();
            }
        });
        this.updateSelectedPlugin();
    }

    private void updateSelectedPlugin() {
        int index = this.getSelectedIndex();
        AbstractPlugIn old = this.selectedPlugin;
        if (old != null) {
            old.setDisplayed(false);
        }
        AbstractPlugIn abstractPlugIn = this.selectedPlugin = index < 0 ? null : this.paneledPlugins.get(this.getId(index));
        if (this.selectedPlugin != null) {
            this.selectedPlugin.setDisplayed(true);
        }
        this.firePropertyChange(SELECTED_PLUGIN_PROPERTY, old, this.selectedPlugin);
    }

    public AbstractPlugIn getSelectedPlugIn() {
        return this.selectedPlugin;
    }
}

