/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.budget;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.dialog.FileChooser;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.RowHeaderRenderer;
import com.fathzer.soft.ajlib.swing.table.Table;
import com.fathzer.soft.ajlib.utilities.CSVWriter;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import net.yapbam.data.BudgetView;
import net.yapbam.data.Category;
import net.yapbam.data.Filter;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.budget.BudgetTableModel;

public class BudgetViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel topPanel = null;
    private JRadioButton month = null;
    private JRadioButton year = null;
    private JButton export = null;
    private Table budgetTable = null;
    private JButton filter = null;
    private BudgetView budget;
    private FilteredData data;
    private JCheckBox chckbxAddSumColumn;
    private JCheckBox chckbxAddSumLine;
    private JCheckBox groupSubCategories;
    private JRadioButton transactionDate;
    private JRadioButton valueDate;

    public BudgetViewPanel() {
        this(new FilteredData(new GlobalData()));
    }

    public BudgetViewPanel(FilteredData data) {
        this.budget = new BudgetView(data, false);
        this.data = data;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gbcBudgetTable = new GridBagConstraints();
        gbcBudgetTable.insets = new Insets(0, 0, 5, 0);
        gbcBudgetTable.fill = 1;
        gbcBudgetTable.gridy = 1;
        gbcBudgetTable.weightx = 1.0;
        gbcBudgetTable.weighty = 1.0;
        gbcBudgetTable.gridx = 0;
        GridBagConstraints gbcTopPanel = new GridBagConstraints();
        gbcTopPanel.insets = new Insets(0, 0, 5, 0);
        gbcTopPanel.gridx = 0;
        gbcTopPanel.fill = 2;
        gbcTopPanel.weightx = 1.0;
        gbcTopPanel.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTopPanel(), gbcTopPanel);
        this.add((Component)this.getTable(), gbcBudgetTable);
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 4;
            gridBagConstraints5.gridheight = 0;
            gridBagConstraints5.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 5;
            gridBagConstraints3.gridheight = 0;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 17;
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.add((Component)this.getMonth(), gridBagConstraints1);
            GridBagConstraints gbc_transactionDate = new GridBagConstraints();
            gbc_transactionDate.weightx = 1.0;
            gbc_transactionDate.anchor = 17;
            gbc_transactionDate.insets = new Insets(0, 0, 5, 5);
            gbc_transactionDate.gridx = 1;
            gbc_transactionDate.gridy = 0;
            this.topPanel.add((Component)this.getTransactionDate(), gbc_transactionDate);
            GridBagConstraints gbcChckbxAddSumLine = new GridBagConstraints();
            gbcChckbxAddSumLine.anchor = 17;
            gbcChckbxAddSumLine.weightx = 1.0;
            gbcChckbxAddSumLine.insets = new Insets(0, 0, 5, 5);
            gbcChckbxAddSumLine.gridx = 3;
            gbcChckbxAddSumLine.gridy = 0;
            this.topPanel.add((Component)this.getChckbxAddSumLine(), gbcChckbxAddSumLine);
            this.topPanel.add((Component)this.getYear(), gridBagConstraints2);
            this.topPanel.add((Component)this.getExport(), gridBagConstraints3);
            this.topPanel.add((Component)this.getFilter(), gridBagConstraints5);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getMonth());
            group.add(this.getYear());
            ButtonGroup group2 = new ButtonGroup();
            group2.add(this.getValueDate());
            group2.add(this.getTransactionDate());
            GridBagConstraints gbc_valueDate = new GridBagConstraints();
            gbc_valueDate.anchor = 17;
            gbc_valueDate.insets = new Insets(0, 0, 0, 5);
            gbc_valueDate.gridx = 1;
            gbc_valueDate.gridy = 1;
            this.topPanel.add((Component)this.getValueDate(), gbc_valueDate);
            GridBagConstraints gbcChckbxAddSumColumn = new GridBagConstraints();
            gbcChckbxAddSumColumn.anchor = 17;
            gbcChckbxAddSumColumn.insets = new Insets(0, 0, 0, 5);
            gbcChckbxAddSumColumn.gridx = 3;
            gbcChckbxAddSumColumn.gridy = 1;
            this.topPanel.add((Component)this.getChckbxAddSumColumn(), gbcChckbxAddSumColumn);
            GridBagConstraints gbcGroupSubCategories = new GridBagConstraints();
            gbcGroupSubCategories.weightx = 1.0;
            gbcGroupSubCategories.insets = new Insets(0, 0, 5, 5);
            gbcGroupSubCategories.anchor = 17;
            gbcGroupSubCategories.gridx = 2;
            gbcGroupSubCategories.gridy = 0;
            this.topPanel.add((Component)this.getGroupSubCategories(), gbcGroupSubCategories);
        }
        return this.topPanel;
    }

    JRadioButton getMonth() {
        if (this.month == null) {
            this.month = new JRadioButton();
            this.month.setText(LocalizationData.get("BudgetPanel.perMonth"));
            this.month.setSelected(true);
            this.month.setToolTipText(LocalizationData.get("BudgetPanel.perMonth.tooltip"));
        }
        return this.month;
    }

    JRadioButton getYear() {
        if (this.year == null) {
            this.year = new JRadioButton();
            this.year.setToolTipText(LocalizationData.get("BudgetPanel.perYear.tooltip"));
            this.year.setText(LocalizationData.get("BudgetPanel.perYear"));
            this.year.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BudgetViewPanel.this.budget.setYear(BudgetViewPanel.this.year.isSelected());
                }
            });
        }
        return this.year;
    }

    private JButton getExport() {
        if (this.export == null) {
            this.export = new JButton();
            this.export.setText(LocalizationData.get("BudgetPanel.export"));
            this.export.setToolTipText(LocalizationData.get("BudgetPanel.export.toolTip"));
            this.export.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File result;
                    FileChooser chooser = new FileChooser();
                    chooser.setLocale(new Locale(LocalizationData.getLocale().getLanguage()));
                    File file = result = chooser.showSaveDialog(Utils.getOwnerWindow(BudgetViewPanel.this.export)) == 0 ? ((JFileChooser)chooser).getSelectedFile() : null;
                    if (result != null) {
                        try {
                            result = FileUtils.getCanonical(result);
                            String sumColumnName = BudgetViewPanel.this.getChckbxAddSumColumn().isSelected() ? LocalizationData.get("BudgetPanel.sum") : null;
                            String sumLineName = BudgetViewPanel.this.getChckbxAddSumLine().isSelected() ? LocalizationData.get("BudgetPanel.sum") : null;
                            BudgetViewPanel.this.export(result, '\t', LocalizationData.getLocale(), sumLineName, sumColumnName);
                        }
                        catch (IOException e1) {
                            ErrorManager.INSTANCE.display(BudgetViewPanel.this, e1);
                        }
                    }
                }
            });
        }
        return this.export;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(File file, char columnSeparator, Locale locale, String dateSumWording, String categorySumWording) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            CSVWriter out = new CSVWriter(fileWriter);
            out.setSeparator(columnSeparator);
            DateFormat dateFormater = SimpleDateFormat.getDateInstance(3, locale);
            out.writeCell("");
            for (int i = 0; i < this.budget.getDatesSize(); ++i) {
                out.writeCell(dateFormater.format(this.budget.getDate(i)));
            }
            if (categorySumWording != null) {
                out.writeCell(categorySumWording);
            }
            NumberFormat currencyFormatter = CSVWriter.getDecimalFormater(locale);
            for (int i = 0; i < this.budget.getCategoriesSize(); ++i) {
                Category category = this.budget.getCategory(i);
                out.newLine();
                out.writeCell(category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName());
                for (int j = 0; j < this.budget.getDatesSize(); ++j) {
                    Double value = this.budget.getAmount(this.budget.getDate(j), category);
                    out.writeCell(value != null ? currencyFormatter.format(value) : "");
                }
                if (categorySumWording == null) continue;
                double value = this.budget.getSum(category);
                out.writeCell(currencyFormatter.format(value));
            }
            if (dateSumWording != null) {
                out.newLine();
                out.writeCell(dateSumWording);
                for (int j = 0; j < this.budget.getDatesSize(); ++j) {
                    double value = this.budget.getSum(this.budget.getDate(j));
                    out.writeCell(currencyFormatter.format(value));
                }
                if (categorySumWording != null) {
                    Double value = this.budget.getSum();
                    out.writeCell(value != null ? currencyFormatter.format(value) : "");
                }
            }
            out.flush();
        }
        finally {
            fileWriter.close();
        }
    }

    private Table getTable() {
        if (this.budgetTable == null) {
            this.budgetTable = new Table();
            BudgetTableModel model = new BudgetTableModel(this.budget);
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    Utils.packColumns(BudgetViewPanel.this.getJTable(), 2);
                }
            });
            JTable jTable = this.budgetTable.getJTable();
            jTable.setAutoResizeMode(0);
            jTable.getTableHeader().setReorderingAllowed(false);
            jTable.getTableHeader().setDefaultRenderer(new HeaderRenderer(true));
            jTable.setCellSelectionEnabled(true);
            jTable.setDefaultRenderer(Object.class, new CellRenderer());
            this.budgetTable.setModel(model);
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        BudgetViewPanel.this.selectionChanged();
                    }
                }
            });
            jTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        BudgetViewPanel.this.selectionChanged();
                    }
                }
            });
            this.budgetTable.getRowJTable().setDefaultRenderer(Object.class, new HeaderRenderer(false));
        }
        return this.budgetTable;
    }

    private javax.swing.JTable getJTable() {
        return this.getTable().getJTable();
    }

    private JButton getFilter() {
        if (this.filter == null) {
            this.filter = new JButton();
            this.filter.setText(LocalizationData.get("BudgetPanel.filter"));
            this.filter.setEnabled(false);
            this.filter.setToolTipText(LocalizationData.get("BudgetPanel.filter.tooltip"));
            this.filter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns;
                    int[] selectedRows = BudgetViewPanel.this.filterSelected(BudgetViewPanel.this.getJTable().getSelectedRows(), BudgetViewPanel.this.budget.getCategoriesSize());
                    Filter theFilter = BudgetViewPanel.this.data.getFilter();
                    theFilter.setSuspended(true);
                    if (selectedRows.length != BudgetViewPanel.this.budget.getCategoriesSize()) {
                        if (selectedRows.length == BudgetViewPanel.this.data.getGlobalData().getCategoriesNumber()) {
                            theFilter.setValidCategories(null);
                        } else {
                            ArrayList<Category> categories = new ArrayList<Category>(selectedRows.length);
                            for (int i = 0; i < selectedRows.length; ++i) {
                                Category category = BudgetViewPanel.this.budget.getCategory(selectedRows[i]);
                                categories.addAll(BudgetViewPanel.this.getDataCategories(category));
                            }
                            theFilter.setValidCategories(categories);
                        }
                    }
                    if ((selectedColumns = BudgetViewPanel.this.filterSelected(BudgetViewPanel.this.getJTable().getSelectedColumns(), BudgetViewPanel.this.budget.getDatesSize())).length != BudgetViewPanel.this.budget.getDatesSize()) {
                        Date from = BudgetViewPanel.this.budget.getDate(selectedColumns[0]);
                        Date to = BudgetViewPanel.this.budget.getLastDate(selectedColumns[selectedColumns.length - 1]);
                        if (BudgetViewPanel.this.getValueDate().isSelected()) {
                            theFilter.setValueDateFilter(from, to);
                        } else {
                            theFilter.setDateFilter(from, to);
                        }
                    }
                    theFilter.setSuspended(false);
                }
            });
        }
        return this.filter;
    }

    private List<Category> getDataCategories(Category category) {
        ArrayList<Category> result = new ArrayList<Category>();
        if (category.equals(Category.UNDEFINED) || !this.getGroupSubCategories().isSelected()) {
            result.add(category);
        } else {
            GlobalData globalData = this.data.getGlobalData();
            for (int i = 0; i < globalData.getCategoriesNumber(); ++i) {
                Category cat = globalData.getCategory(i);
                if (!cat.getSuperCategory(globalData.getSubCategorySeparator()).equals(category)) continue;
                result.add(cat);
            }
        }
        return result;
    }

    private int[] filterSelected(int[] selected, int maxValue) {
        if (selected.length == 0 || selected[selected.length - 1] != maxValue) {
            return selected;
        }
        int[] result = new int[selected.length - 1];
        System.arraycopy(selected, 0, result, 0, result.length);
        return result;
    }

    JCheckBox getChckbxAddSumColumn() {
        if (this.chckbxAddSumColumn == null) {
            this.chckbxAddSumColumn = new JCheckBox(LocalizationData.get("BudgetPanel.sumColumn.checkBox"));
            this.chckbxAddSumColumn.setSelected(false);
            this.chckbxAddSumColumn.setToolTipText(LocalizationData.get("BudgetPanel.sumColumn.checkBox.tooltip"));
            this.chckbxAddSumColumn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean selected = BudgetViewPanel.this.chckbxAddSumColumn.isSelected();
                    ((BudgetTableModel)BudgetViewPanel.this.getJTable().getModel()).setHasSumColumn(selected);
                }
            });
        }
        return this.chckbxAddSumColumn;
    }

    JCheckBox getChckbxAddSumLine() {
        if (this.chckbxAddSumLine == null) {
            this.chckbxAddSumLine = new JCheckBox(LocalizationData.get("BudgetPanel.sumLine.checkBox"));
            this.chckbxAddSumLine.setSelected(false);
            this.chckbxAddSumLine.setToolTipText(LocalizationData.get("BudgetPanel.sumLine.checkBox.tooltip"));
            this.chckbxAddSumLine.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean selected = BudgetViewPanel.this.chckbxAddSumLine.isSelected();
                    ((BudgetTableModel)BudgetViewPanel.this.getJTable().getModel()).setHasSumLine(selected);
                }
            });
        }
        return this.chckbxAddSumLine;
    }

    JCheckBox getGroupSubCategories() {
        if (this.groupSubCategories == null) {
            this.groupSubCategories = new JCheckBox(LocalizationData.get("Subcategories.groupButton.title"));
            this.groupSubCategories.setToolTipText(LocalizationData.get("Subcategories.groupButton.tooltip"));
            this.groupSubCategories.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BudgetViewPanel.this.budget.setGroupedSubCategories(BudgetViewPanel.this.getGroupSubCategories().isSelected());
                }
            });
        }
        return this.groupSubCategories;
    }

    private void selectionChanged() {
        int[] rows = this.getJTable().getSelectedRows();
        int[] columns = this.getJTable().getSelectedColumns();
        int[] fRows = this.filterSelected(rows, this.budget.getCategoriesSize());
        int[] fColumns = this.filterSelected(columns, this.budget.getDatesSize());
        this.getFilter().setEnabled(fRows.length > 0 && fColumns.length > 0);
    }

    private JRadioButton getTransactionDate() {
        if (this.transactionDate == null) {
            this.transactionDate = new JRadioButton(LocalizationData.get("BudgetPanel.perTransactionDate"));
            this.transactionDate.setToolTipText(LocalizationData.get("BudgetPanel.perTransactionDate.tooltip"));
            this.transactionDate.setSelected(true);
        }
        return this.transactionDate;
    }

    JRadioButton getValueDate() {
        if (this.valueDate == null) {
            this.valueDate = new JRadioButton(LocalizationData.get("Transaction.valueDate"));
            this.valueDate.setToolTipText(LocalizationData.get("BudgetPanel.perValueDate.tooltip"));
            this.valueDate.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BudgetViewPanel.this.budget.setValueDate(BudgetViewPanel.this.valueDate.isSelected());
                }
            });
        }
        return this.valueDate;
    }

    private final class HeaderRenderer
    extends RowHeaderRenderer {
        private boolean centered;

        HeaderRenderer(boolean centered) {
            this.centered = centered;
        }

        @Override
        public Component getTableCellRendererComponent(javax.swing.JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == BudgetViewPanel.this.budget.getDatesSize() || row == BudgetViewPanel.this.budget.getCategoriesSize()) {
                value = "<html><b>" + value.toString() + "</b></html>";
            }
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.centered && result instanceof JLabel) {
                ((JLabel)result).setHorizontalAlignment(0);
            }
            return result;
        }
    }

    private final class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        Font bold;
        Font plain = new Font(this.getFont().getName(), 0, this.getFont().getSize());

        CellRenderer() {
            this.bold = new Font(this.getFont().getName(), 1, this.getFont().getSize());
        }

        @Override
        public Component getTableCellRendererComponent(javax.swing.JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean extra;
            boolean bl = extra = column == BudgetViewPanel.this.budget.getDatesSize() || row == BudgetViewPanel.this.budget.getCategoriesSize();
            if (extra) {
                isSelected = false;
            }
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            Font font = extra ? this.bold : this.plain;
            result.setFont(font);
            return result;
        }
    }
}

